/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsky.image.ImageChangeEvent;
import jsky.image.ImageProcessor;
import jsky.image.gui.DivaMainImageDisplay;
import jsky.image.gui.ImageDisplayMenuBar;
import jsky.image.gui.MainImageDisplay;

public class ImageHistoryItem
extends AbstractAction
implements ChangeListener,
Serializable {
    protected String title;
    protected double ra;
    protected double dec;
    protected URL url;
    protected String filename;
    protected String cmap;
    protected String itt;
    protected double hcut;
    protected double lcut;
    protected boolean userSetCutLevels;
    protected int scaleAlg;
    protected float scale;

    public ImageHistoryItem(MainImageDisplay imageDisplay, double ra, double dec, String title, URL url, String filename) {
        super(title);
        this.ra = ra;
        this.dec = dec;
        this.title = title;
        this.filename = new File(filename).getAbsolutePath();
        this.url = url;
        this.scale = imageDisplay.getScale();
        ImageProcessor imageProcessor = imageDisplay.getImageProcessor();
        this.cmap = imageProcessor.getColorLookupTableName();
        this.itt = imageProcessor.getIntensityLookupTableName();
        this.hcut = imageProcessor.getHighCut();
        this.lcut = imageProcessor.getLowCut();
        this.userSetCutLevels = imageProcessor.isUserSetCutLevels();
        this.scaleAlg = imageProcessor.getScaleAlgorithm();
    }

    public boolean match(double ra, double dec) {
        if (Double.isNaN(this.ra) || Double.isNaN(this.dec)) {
            return false;
        }
        double range = 0.03333333333333333;
        double diff = Math.abs(ra - this.ra);
        if (diff > range) {
            if (ra > 360.0 - range) {
                ra -= 360.0;
            } else if (ra < range) {
                ra += 360.0;
            } else {
                return false;
            }
            diff = Math.abs(ra - this.ra);
            if (diff > range) {
                return false;
            }
        }
        return !((diff = Math.abs(dec - this.dec)) > range);
    }

    public void actionPerformed(ActionEvent evt) {
        DivaMainImageDisplay imageDisplay = ImageDisplayMenuBar.getCurrentImageDisplay();
        if (this.filename != null && new File(this.filename).exists()) {
            imageDisplay.addChangeListener(this);
            imageDisplay.setFilename(this.filename, this.url);
        } else if (this.url != null) {
            imageDisplay.addChangeListener(this);
            imageDisplay.setURL(this.url);
        } else {
            System.out.println("XXX ImageHistoryItem.actionPerformed: no file and no URL");
        }
    }

    public void stateChanged(ChangeEvent ce) {
        ImageChangeEvent e = (ImageChangeEvent)ce;
        if (e.isNewImage() && !e.isBefore()) {
            DivaMainImageDisplay imageDisplay = (DivaMainImageDisplay)e.getSource();
            ImageProcessor imageProcessor = imageDisplay.getImageProcessor();
            imageDisplay.removeChangeListener(this);
            imageProcessor.setColorLookupTable(this.cmap);
            imageProcessor.setIntensityLookupTable(this.itt);
            imageProcessor.setScaleAlgorithm(this.scaleAlg);
            imageProcessor.setCutLevels(this.lcut, this.hcut, this.userSetCutLevels);
            imageDisplay.setScale(this.scale);
            imageProcessor.update();
        }
    }
}

