/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsky.coords.WorldCoords;
import jsky.image.ImageChangeEvent;
import jsky.image.ImageProcessor;
import jsky.image.gui.ImageDisplayMenuBar;
import jsky.image.gui.MainImageDisplay;
import jsky.util.I18N;
import jsky.util.Resources;

public class ImageDisplayStatusPanel
extends JPanel
implements MouseMotionListener {
    private static final I18N _I18N = I18N.getInstance(class$jsky$image$gui$ImageDisplayStatusPanel == null ? (class$jsky$image$gui$ImageDisplayStatusPanel = ImageDisplayStatusPanel.class$("jsky.image.gui.ImageDisplayStatusPanel")) : class$jsky$image$gui$ImageDisplayStatusPanel);
    protected JTextField zoomTextField;
    protected JTextField imageCoordsTextField;
    protected JTextField pixelValueTextField;
    protected JTextField worldCoordsTextField;
    protected MainImageDisplay imageDisplay;
    protected static NumberFormat nf = NumberFormat.getInstance(Locale.US);
    static /* synthetic */ Class class$jsky$image$gui$ImageDisplayStatusPanel;

    public ImageDisplayStatusPanel() {
        Color bgColor = this.getBackground();
        this.setLayout(new BoxLayout(this, 0));
        JButton zoomIn = new JButton(Resources.getIcon("ZoomIn24.gif"));
        zoomIn.setToolTipText(_I18N.getString("zoomIn"));
        zoomIn.setFocusPainted(false);
        zoomIn.setPreferredSize(new Dimension(26, 24));
        zoomIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageDisplayStatusPanel.this.zoom(true);
            }
        });
        this.add(zoomIn);
        JButton zoomOut = new JButton(Resources.getIcon("ZoomOut24.gif"));
        zoomOut.setToolTipText(_I18N.getString("zoomOut"));
        zoomOut.setFocusPainted(false);
        zoomOut.setPreferredSize(new Dimension(26, 24));
        zoomOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageDisplayStatusPanel.this.zoom(false);
            }
        });
        this.add(zoomOut);
        JButton zoomFit = new JButton(Resources.getIcon("AlignCenter24.gif"));
        zoomFit.setToolTipText(_I18N.getString("zoomFit"));
        zoomFit.setFocusPainted(false);
        zoomFit.setPreferredSize(new Dimension(26, 24));
        zoomFit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageDisplayStatusPanel.this.zoomFit();
            }
        });
        this.add(zoomFit);
        JButton zoomNormal = new JButton(Resources.getIcon("Zoom24.gif"));
        zoomNormal.setToolTipText(_I18N.getString("zoomNormal"));
        zoomNormal.setFocusPainted(false);
        zoomNormal.setPreferredSize(new Dimension(26, 24));
        zoomNormal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageDisplayStatusPanel.this.zoomNormal();
            }
        });
        this.add(zoomNormal);
        this.zoomTextField = new JTextField(0);
        this.zoomTextField.setEditable(false);
        this.zoomTextField.setToolTipText(_I18N.getString("currentMagnification"));
        this.zoomTextField.setHorizontalAlignment(0);
        this.zoomTextField.setBackground(bgColor);
        this.zoomTextField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.zoomTextField.setText("1x");
        this.add(this.zoomTextField);
        this.imageCoordsTextField = new JTextField(6);
        this.imageCoordsTextField.setEditable(false);
        this.imageCoordsTextField.setToolTipText(_I18N.getString("imagePixelCoordsAtMousePos"));
        this.imageCoordsTextField.setHorizontalAlignment(0);
        this.imageCoordsTextField.setBackground(bgColor);
        this.imageCoordsTextField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add(this.imageCoordsTextField);
        this.pixelValueTextField = new JTextField(6);
        this.pixelValueTextField.setEditable(false);
        this.pixelValueTextField.setToolTipText(_I18N.getString("imagePixelValueAtMousePos"));
        this.pixelValueTextField.setBackground(bgColor);
        this.pixelValueTextField.setHorizontalAlignment(0);
        this.pixelValueTextField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add(this.pixelValueTextField);
        this.worldCoordsTextField = new JTextField(17);
        this.worldCoordsTextField.setEditable(false);
        this.worldCoordsTextField.setToolTipText(_I18N.getString("worldCoordsAtMousePos"));
        this.worldCoordsTextField.setHorizontalAlignment(0);
        this.worldCoordsTextField.setBackground(bgColor);
        this.worldCoordsTextField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add(this.worldCoordsTextField);
    }

    public ImageDisplayStatusPanel(MainImageDisplay imageDisplay) {
        this();
        this.setImageDisplay(imageDisplay);
    }

    public void setImageDisplay(MainImageDisplay target) {
        this.imageDisplay = target;
        ((Component)((Object)this.imageDisplay)).addMouseMotionListener(this);
        this.imageDisplay.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                ImageChangeEvent e = (ImageChangeEvent)ce;
                if (e.isNewScale() || e.isNewImage()) {
                    ImageDisplayStatusPanel.this.zoomTextField.setText(ImageDisplayMenuBar.getScaleLabel(ImageDisplayStatusPanel.this.imageDisplay.getScale()));
                }
            }
        });
    }

    public MainImageDisplay getImageDisplay() {
        return this.imageDisplay;
    }

    protected void zoom(boolean in) {
        float zoomFactor = this.imageDisplay.getScale();
        if (in) {
            if ((double)zoomFactor < 1.0) {
                int i = Math.round(1.0f / zoomFactor) - 1;
                zoomFactor = 1.0f / (float)i;
            } else {
                zoomFactor += 1.0f;
            }
        } else if ((double)zoomFactor <= 1.0) {
            int i = Math.round(1.0f / zoomFactor) + 1;
            zoomFactor = 1.0f / (float)i;
        } else {
            zoomFactor -= 1.0f;
        }
        if (zoomFactor < 0.05f || zoomFactor > 20.0f) {
            return;
        }
        this.imageDisplay.setScale(zoomFactor);
        this.imageDisplay.updateImage();
    }

    protected void zoomFit() {
        this.imageDisplay.scaleToFit();
        this.imageDisplay.updateImage();
    }

    protected void zoomNormal() {
        this.imageDisplay.setScale(1.0f);
        this.imageDisplay.updateImage();
    }

    public void mouseDragged(MouseEvent e) {
        this.update(e);
    }

    public void mouseMoved(MouseEvent e) {
        this.update(e);
    }

    protected void update(MouseEvent e) {
        Point2D.Double p;
        if (this.imageDisplay == null) {
            return;
        }
        try {
            p = new Point2D.Double(e.getX(), e.getY());
            this.imageDisplay.getCoordinateConverter().screenToImageCoords(p, false);
            this.imageCoordsTextField.setText(nf.format(p.getX()) + ", " + nf.format(p.getY()));
            this.worldCoordsTextField.setText("");
            if (this.imageDisplay.isWCS()) {
                this.imageDisplay.getCoordinateConverter().imageToWorldCoords(p, false);
                double equinox = this.imageDisplay.getWCS().getEquinox();
                WorldCoords wcs = new WorldCoords(p.getX(), p.getY(), equinox);
                this.worldCoordsTextField.setText(wcs.toString());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.pixelValueTextField.setText("");
            p = new Point2D.Double(e.getX(), e.getY());
            this.imageDisplay.getCoordinateConverter().screenToUserCoords(p, false);
            float pixel = this.imageDisplay.getPixelValue(p, 0);
            ImageProcessor imageProcessor = this.imageDisplay.getImageProcessor();
            if (pixel == imageProcessor.getBlank()) {
                this.pixelValueTextField.setText(_I18N.getString("blank"));
            } else {
                this.pixelValueTextField.setText(String.valueOf(pixel));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        nf.setMaximumFractionDigits(1);
        nf.setGroupingUsed(false);
    }
}

