/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.image.SampleModel;
import java.text.NumberFormat;
import java.util.Locale;
import javax.media.jai.PlanarImage;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsky.coords.WorldCoords;
import jsky.image.ImageChangeEvent;
import jsky.image.ImageProcessor;
import jsky.image.fits.codec.FITSImage;
import jsky.image.gui.MainImageDisplay;
import jsky.util.Resources;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.GridBagUtil;

public class ImageDisplayPanel
extends JPanel
implements MouseMotionListener {
    protected ImageProcessor imageProcessor;
    protected MainImageDisplay imageDisplay;
    protected GridBagUtil layout;
    protected JLabel objectLabel;
    protected JLabel objectValue;
    protected JLabel xLabel;
    protected JLabel xValue;
    protected JLabel yLabel;
    protected JLabel yValue;
    protected JLabel valueLabel;
    protected JLabel valueValue;
    protected JLabel raLabel;
    protected JLabel raValue;
    protected JLabel decLabel;
    protected JLabel decValue;
    protected JLabel equinoxLabel;
    protected JLabel equinoxValue;
    protected JLabel minLabel;
    protected JLabel minValue;
    protected JLabel maxLabel;
    protected JLabel maxValue;
    protected JLabel bitpixLabel;
    protected JLabel bitpixValue;
    protected JLabel lowLabel;
    protected JTextField lowValue;
    protected JLabel highLabel;
    protected JTextField highValue;
    protected JButton autocutButton;
    protected JLabel scaleLabel;
    protected JMenuBar scaleMenuBar;
    protected JMenu scaleMenu;
    protected JButton zoomInButton;
    protected JButton zoomOutButton;
    protected static final int minScale = -10;
    protected static final int maxScale = 20;
    protected int orient;
    protected int bitpix;
    protected static NumberFormat nf = NumberFormat.getInstance(Locale.US);

    public ImageDisplayPanel(MainImageDisplay imageDisplay, int orient) {
        this.orient = orient;
        this.setImageDisplay(imageDisplay);
        this.makePanelItems();
        this.setLayout(new GridBagLayout());
        this.layout = new GridBagUtil(this, (GridBagLayout)this.getLayout());
        if (orient == 0) {
            this.horizontalPanelLayout();
        } else {
            this.verticalPanelLayout();
        }
        this.updateValues();
    }

    public ImageDisplayPanel(MainImageDisplay imageDisplay) {
        this(imageDisplay, 1);
    }

    public ImageDisplayPanel() {
        this((MainImageDisplay)null);
    }

    public void setImageDisplay(MainImageDisplay imageDisplay) {
        this.imageDisplay = imageDisplay;
        this.imageProcessor = imageDisplay.getImageProcessor();
        ((Component)((Object)imageDisplay)).addMouseMotionListener(this);
    }

    public MainImageDisplay getImageDisplay() {
        return this.imageDisplay;
    }

    protected void makePanelItems() {
        int right = 4;
        int left = 2;
        this.objectLabel = new JLabel("Object:", 4);
        this.objectValue = new JLabel("", 2);
        this.xLabel = new JLabel("X:", 4);
        this.xValue = new JLabel("", 2);
        this.yLabel = new JLabel("Y:", 4);
        this.yValue = new JLabel("", 2);
        this.valueLabel = new JLabel("Value:", 4);
        this.valueValue = new JLabel("", 2);
        this.raLabel = new JLabel("RA:", 4);
        this.raValue = new JLabel("", 2);
        this.decLabel = new JLabel("DEC:", 4);
        this.decValue = new JLabel("", 2);
        this.equinoxLabel = new JLabel("Equinox:", 4);
        this.equinoxValue = new JLabel("2000", 2);
        this.minLabel = new JLabel("Min:", 4);
        this.minValue = new JLabel("", 2);
        this.maxLabel = new JLabel("Max:", 4);
        this.maxValue = new JLabel("", 2);
        this.bitpixLabel = new JLabel("Bitpix:", 4);
        this.bitpixValue = new JLabel("", 2);
        this.lowLabel = new JLabel("Low:", 4);
        this.lowValue = new JTextField(6);
        this.lowValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ImageDisplayPanel.this.setCutLevels();
            }
        });
        this.highLabel = new JLabel("High:", 4);
        this.highValue = new JTextField(6);
        this.highValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ImageDisplayPanel.this.setCutLevels();
            }
        });
        this.autocutButton = new JButton("Auto Set Cutlevels");
        this.autocutButton.setToolTipText("Set the image cut levels using median filtering");
        this.autocutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ImageDisplayPanel.this.autoSetCutLevels();
            }
        });
        this.scaleLabel = new JLabel("Scale:", 4);
        this.makeScaleMenu();
        this.makeZoomButtons();
        this.imageProcessor.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                ImageDisplayPanel.this.updateValues();
            }
        });
    }

    protected void makeScaleMenu() {
        String s;
        int i;
        this.scaleMenuBar = new JMenuBar();
        this.scaleMenu = new JMenu("1x");
        this.scaleMenuBar.add(this.scaleMenu);
        ButtonGroup group = new ButtonGroup();
        for (i = -10; i <= -2; ++i) {
            s = "1/" + -i + "x";
            this.addScaleMenuItem(group, s, -1.0f / (float)i);
        }
        for (i = 1; i <= 20; ++i) {
            s = Integer.toString(i) + "x";
            this.addScaleMenuItem(group, s, i);
        }
        this.imageDisplay.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                ImageChangeEvent e = (ImageChangeEvent)ce;
                if (e.isNewScale()) {
                    String s = ImageDisplayPanel.this.getScaleLabel(ImageDisplayPanel.this.imageDisplay.getScale());
                    ImageDisplayPanel.this.scaleMenu.setText(s);
                    int n = ImageDisplayPanel.this.scaleMenu.getItemCount();
                    for (int i = 0; i < n; ++i) {
                        JRadioButtonMenuItem b = (JRadioButtonMenuItem)ImageDisplayPanel.this.scaleMenu.getItem(i);
                        if (!b.getText().equals(s)) continue;
                        b.setSelected(true);
                    }
                }
            }
        });
    }

    protected void addScaleMenuItem(ButtonGroup group, String label, float value) {
        JRadioButtonMenuItem b = new JRadioButtonMenuItem(label);
        b.setActionCommand(Float.toString(value));
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageDisplayPanel.this.setScale(Float.parseFloat(e.getActionCommand()));
            }
        });
        group.add(b);
        this.scaleMenu.add(b);
    }

    public void setScale(float value) {
        this.imageDisplay.setScale(value);
        this.imageDisplay.updateImage();
        this.scaleMenu.setText(this.getScaleLabel(value));
    }

    public String getScaleLabel(float value) {
        int factor = (double)value < 1.0 ? Math.round(-1.0f / value) : Math.round(value);
        if (factor < 0) {
            return "1/" + -factor + "x";
        }
        return Integer.toString(factor) + "x";
    }

    public void incScale(boolean zoomIn) {
        float scale = this.imageDisplay.getScale();
        int factor = (double)scale < 1.0 ? Math.round(-1.0f / scale) : Math.round(scale);
        if (zoomIn) {
            if (++factor == -1 || factor == 0) {
                factor = 1;
            }
        } else if (--factor == -1 || factor == 0) {
            factor = -2;
        }
        if (factor < -10) {
            factor = -10;
        }
        if (factor > 20) {
            factor = 20;
        }
        scale = factor < 0 ? -1.0f / (float)factor : (float)factor;
        this.setScale(scale);
    }

    protected void makeZoomButtons() {
        this.zoomInButton = new JButton(Resources.getIcon("magnify.xbm"));
        this.zoomInButton.setToolTipText("Zoom in");
        this.zoomInButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ImageDisplayPanel.this.incScale(true);
            }
        });
        this.zoomOutButton = new JButton(Resources.getIcon("shrink.xbm"));
        this.zoomInButton.setToolTipText("Zoom out");
        this.zoomOutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ImageDisplayPanel.this.incScale(false);
            }
        });
    }

    protected void horizontalPanelLayout() {
        int east = 13;
        int west = 17;
        int none = 0;
        int horizontal = 2;
        int r = 0;
        this.layout.add(this.objectLabel, 0, r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.objectValue, 1, r, 5, 1, 1.0, 0.0, horizontal, west);
        this.layout.add(this.xLabel, 0, ++r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.xValue, 1, r, 1, 1, 1.0, 0.0, horizontal, west);
        this.layout.add(this.yLabel, 2, r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.yValue, 3, r, 1, 1, 1.0, 0.0, horizontal, west);
        this.layout.add(this.valueLabel, 4, r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.valueValue, 5, r, 1, 1, 1.0, 0.0, horizontal, west);
        this.layout.add(this.raLabel, 0, ++r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.raValue, 1, r, 1, 1, 1.0, 0.0, horizontal, west);
        this.layout.add(this.decLabel, 2, r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.decValue, 3, r, 1, 1, 1.0, 0.0, horizontal, west);
        this.layout.add(this.equinoxLabel, 4, r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.equinoxValue, 5, r, 1, 1, 1.0, 0.0, horizontal, west);
        this.layout.add(this.minLabel, 0, ++r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.minValue, 1, r, 1, 1, 1.0, 0.0, horizontal, west);
        this.layout.add(this.maxLabel, 2, r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.maxValue, 3, r, 1, 1, 1.0, 0.0, horizontal, west);
        this.layout.add(this.bitpixLabel, 4, r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.bitpixValue, 5, r, 1, 1, 1.0, 0.0, horizontal, west);
        this.layout.add(this.lowLabel, 0, ++r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.lowValue, 1, r, 1, 1, 1.0, 0.0, horizontal, west);
        this.layout.add(this.highLabel, 2, r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.highValue, 3, r, 1, 1, 1.0, 0.0, horizontal, west);
        this.layout.add(this.autocutButton, 4, r, 2, 1, 0.0, 0.0, none, west);
        this.layout.add(this.scaleLabel, 0, ++r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.scaleMenuBar, 1, r, 1, 1, 0.0, 0.0, none, west);
        JPanel panel = new JPanel();
        panel.add(this.zoomInButton);
        panel.add(this.zoomOutButton);
        this.layout.add(panel, 2, r, 4, 1, 1.0, 0.0, none, west);
    }

    protected void verticalPanelLayout() {
        int east = 13;
        int west = 17;
        int none = 0;
        int horizontal = 2;
        int r = 0;
        this.layout.add(this.objectLabel, 0, r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.objectValue, 1, r, 1, 1, 0.0, 0.0, horizontal, west);
        this.layout.add(this.xLabel, 0, ++r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.xValue, 1, r, 1, 1, 1.0, 0.0, horizontal, west);
        this.layout.add(this.yLabel, 0, ++r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.yValue, 1, r, 1, 1, 1.0, 0.0, horizontal, west);
        this.layout.add(this.valueLabel, 0, ++r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.valueValue, 1, r, 1, 1, 1.0, 0.0, horizontal, west);
        this.layout.add(this.raLabel, 0, ++r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.raValue, 1, r, 1, 1, 1.0, 0.0, horizontal, west);
        this.layout.add(this.decLabel, 0, ++r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.decValue, 1, r, 1, 1, 1.0, 0.0, horizontal, west);
        this.layout.add(this.equinoxLabel, 0, ++r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.equinoxValue, 1, r, 1, 1, 1.0, 0.0, horizontal, west);
        this.layout.add(this.minLabel, 0, ++r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.minValue, 1, r, 1, 1, 1.0, 0.0, horizontal, west);
        this.layout.add(this.maxLabel, 0, ++r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.maxValue, 1, r, 1, 1, 1.0, 0.0, horizontal, west);
        this.layout.add(this.bitpixLabel, 0, ++r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.bitpixValue, 1, r, 1, 1, 1.0, 0.0, horizontal, west);
        this.layout.add(this.lowLabel, 0, ++r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.lowValue, 1, r, 1, 1, 1.0, 0.0, horizontal, west);
        this.layout.add(this.highLabel, 0, ++r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.highValue, 1, r, 1, 1, 1.0, 0.0, horizontal, west);
        this.layout.add(this.autocutButton, 0, ++r, 2, 1, 0.0, 0.0, horizontal, west);
        this.layout.add(this.scaleLabel, 0, ++r, 1, 1, 0.0, 0.0, horizontal, east);
        this.layout.add(this.scaleMenuBar, 1, r, 1, 1, 0.0, 0.0, none, west);
        this.layout.add(this.zoomInButton, 0, ++r, 1, 1, 0.0, 0.0, none, west);
        this.layout.add(this.zoomOutButton, 1, r, 1, 1, 0.0, 0.0, none, west);
    }

    protected void updateValues() {
        SampleModel sampleModel;
        PlanarImage im = this.imageProcessor.getRescaledSourceImage();
        if (im != null && (sampleModel = im.getSampleModel()) != null) {
            int dataType = sampleModel.getDataType();
            if (dataType == 4 || dataType == 5) {
                this.lowValue.setText(String.valueOf((float)this.imageProcessor.getLowCut()));
                this.highValue.setText(String.valueOf((float)this.imageProcessor.getHighCut()));
                this.minValue.setText(String.valueOf((float)this.imageProcessor.getMinValue()));
                this.maxValue.setText(String.valueOf((float)this.imageProcessor.getMaxValue()));
            } else {
                this.lowValue.setText(String.valueOf((int)this.imageProcessor.getLowCut()));
                this.highValue.setText(String.valueOf((int)this.imageProcessor.getHighCut()));
                this.minValue.setText(String.valueOf((int)this.imageProcessor.getMinValue()));
                this.maxValue.setText(String.valueOf((int)this.imageProcessor.getMaxValue()));
            }
            this.objectValue.setText(this.getObjectName());
            this.bitpix = this.getBitsPerPixel();
            this.bitpixValue.setText(this.bitpix != 0 ? Integer.toString(this.bitpix) : "");
        }
    }

    public String getObjectName() {
        Object prop;
        FITSImage fitsImage = this.imageDisplay.getFitsImage();
        if (fitsImage != null && (prop = fitsImage.getProperty("OBJECT")) instanceof String) {
            return (String)prop;
        }
        return "";
    }

    public int getBitsPerPixel() {
        PlanarImage im = this.imageProcessor.getSourceImage();
        if (im != null) {
            SampleModel sm = im.getSampleModel();
            int dataType = sm.getDataType();
            int bitpix = sm.getSampleSize(0);
            if (dataType == 4 || dataType == 5) {
                return -bitpix;
            }
            return bitpix;
        }
        return 0;
    }

    protected void setCutLevels() {
        double high;
        double low;
        try {
            low = Double.parseDouble(this.lowValue.getText());
            high = Double.parseDouble(this.highValue.getText());
        }
        catch (NumberFormatException e) {
            DialogUtil.error("Please type in a number for the low or high pixel value");
            return;
        }
        this.imageProcessor.setCutLevels(low, high);
        this.imageProcessor.update();
    }

    protected void autoSetCutLevels() {
        this.imageProcessor.autoSetCutLevels(this.imageDisplay.getVisibleArea());
        this.imageProcessor.update();
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        Point2D.Double p;
        if (this.imageDisplay == null) {
            return;
        }
        try {
            p = new Point2D.Double(e.getX(), e.getY());
            this.imageDisplay.getCoordinateConverter().screenToImageCoords(p, false);
            this.xValue.setText(nf.format(p.getX()));
            this.yValue.setText(nf.format(p.getY()));
            if (this.imageDisplay.isWCS()) {
                this.imageDisplay.getCoordinateConverter().imageToWorldCoords(p, false);
                double equinox = this.imageDisplay.getWCS().getEquinox();
                WorldCoords wcs = new WorldCoords(p.getX(), p.getY(), equinox);
                String[] ar = wcs.format(equinox);
                this.raValue.setText(ar[0]);
                this.decValue.setText(ar[1]);
            } else {
                this.raValue.setText("");
                this.decValue.setText("");
                this.equinoxValue.setText("");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            SampleModel sampleModel;
            p = new Point2D.Double(e.getX(), e.getY());
            this.imageDisplay.getCoordinateConverter().screenToUserCoords(p, false);
            float pixel = this.imageDisplay.getPixelValue(p, 0);
            PlanarImage im = this.imageProcessor.getRescaledSourceImage();
            if (im != null && (sampleModel = im.getSampleModel()) != null) {
                int dataType = sampleModel.getDataType();
                if (pixel == this.imageProcessor.getBlank()) {
                    this.valueValue.setText("blank");
                } else {
                    this.valueValue.setText(String.valueOf(pixel));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        nf.setMaximumFractionDigits(1);
    }
}

