/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import jsky.image.gui.DivaMainImageDisplay;
import jsky.image.gui.ImageDisplayControl;
import jsky.image.gui.ImageDisplayMenuBar;
import jsky.image.gui.ImageDisplayToolBar;
import jsky.util.I18N;
import jsky.util.Preferences;

public class ImageDisplayControlFrame
extends JFrame {
    private static final I18N _I18N = I18N.getInstance(class$jsky$image$gui$ImageDisplayControlFrame == null ? (class$jsky$image$gui$ImageDisplayControlFrame = ImageDisplayControlFrame.class$("jsky.image.gui.ImageDisplayControlFrame")) : class$jsky$image$gui$ImageDisplayControlFrame);
    protected ImageDisplayToolBar toolBar;
    protected ImageDisplayControl imageDisplayControl;
    private static int openFrameCount = 0;
    static /* synthetic */ Class class$jsky$image$gui$ImageDisplayControlFrame;

    public ImageDisplayControlFrame(int size) {
        super(_I18N.getString("imageDisplay"));
        this.imageDisplayControl = this.makeImageDisplayControl(size);
        final DivaMainImageDisplay mainImageDisplay = this.imageDisplayControl.getImageDisplay();
        this.toolBar = this.makeToolBar(mainImageDisplay);
        this.setJMenuBar(this.makeMenuBar(mainImageDisplay, this.toolBar));
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.toolBar, "North");
        contentPane.add((Component)this.imageDisplayControl, "Center");
        this.imageDisplayControl.setBorder(BorderFactory.createEtchedBorder());
        Preferences.manageSize(this.imageDisplayControl, new Dimension(650, 700));
        Preferences.manageLocation(this);
        ++openFrameCount;
        this.pack();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                mainImageDisplay.close();
            }

            public void windowClosed(WindowEvent e) {
                if (--openFrameCount == 0 && mainImageDisplay.isMainWindow()) {
                    mainImageDisplay.exit();
                }
            }
        });
    }

    public ImageDisplayControlFrame() {
        this(152);
    }

    public ImageDisplayControlFrame(int size, String fileOrUrl) {
        this(size);
        if (fileOrUrl != null) {
            this.imageDisplayControl.getImageDisplay().setFilename(fileOrUrl);
        } else {
            this.imageDisplayControl.getImageDisplay().blankImage(0.0, 0.0);
        }
    }

    public ImageDisplayControlFrame(String fileOrUrl) {
        this(152, fileOrUrl);
    }

    public ImageDisplayControl getImageDisplayControl() {
        return this.imageDisplayControl;
    }

    protected ImageDisplayToolBar makeToolBar(DivaMainImageDisplay mainImageDisplay) {
        return new ImageDisplayToolBar(mainImageDisplay);
    }

    protected ImageDisplayMenuBar makeMenuBar(DivaMainImageDisplay mainImageDisplay, ImageDisplayToolBar toolBar) {
        return new ImageDisplayMenuBar(mainImageDisplay, toolBar);
    }

    protected ImageDisplayControl makeImageDisplayControl(int size) {
        return new ImageDisplayControl((Component)this, size);
    }

    public static void main(String[] args) {
        String fileOrUrl = null;
        int size = 152;
        if (args.length >= 1) {
            fileOrUrl = args[0];
        }
        ImageDisplayControlFrame frame = new ImageDisplayControlFrame(size, fileOrUrl);
        frame.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

