/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicArrowButton;
import jsky.image.gui.DivaMainImageDisplay;
import jsky.image.gui.ImageColorbar;
import jsky.image.gui.ImageDisplayStatusPanel;
import jsky.image.gui.ImagePanner;
import jsky.image.gui.ImageZoom;
import jsky.util.I18N;

public class ImageDisplayControl
extends JPanel {
    private static final I18N _I18N = I18N.getInstance(class$jsky$image$gui$ImageDisplayControl == null ? (class$jsky$image$gui$ImageDisplayControl = ImageDisplayControl.class$("jsky.image.gui.ImageDisplayControl")) : class$jsky$image$gui$ImageDisplayControl);
    protected Component parent;
    protected ImagePanner imagePanner;
    protected JPanel panZoomPanel;
    protected ImageZoom imageZoom;
    protected DivaMainImageDisplay imageDisplay;
    protected ImageColorbar colorbar;
    protected ImageDisplayStatusPanel imageDisplayStatusPanel;
    protected String filename = "";
    protected BasicArrowButton panZoomToggleButton;
    static /* synthetic */ Class class$jsky$image$gui$ImageDisplayControl;

    public ImageDisplayControl(Component parent, int size) {
        this.parent = parent;
        this.imageDisplay = this.makeImageDisplay();
        this.imagePanner = this.makePanWindow(size);
        this.imageZoom = this.makeZoomWindow(size);
        this.panZoomToggleButton = this.makePanZoomToggleButton();
        this.panZoomPanel = new JPanel(){

            public synchronized void paintComponent(Graphics g) {
                super.paintComponent(g);
                ImageDisplayControl.this.panZoomToggleButton.repaint();
            }
        };
        this.colorbar = this.makeColorbar();
        this.imageDisplayStatusPanel = this.makeStatusPanel();
        this.imageDisplayStatusPanel.setImageDisplay(this.imageDisplay);
        this.makeLayout(size);
    }

    public ImageDisplayControl(Component parent) {
        this(parent, 152);
    }

    public ImageDisplayControl(Component parent, URL url) {
        this(parent);
        this.imageDisplay.setURL(url);
    }

    public ImageDisplayControl(Component parent, String filename) {
        this(parent);
        this.imageDisplay.setFilename(filename);
    }

    protected DivaMainImageDisplay makeImageDisplay() {
        return new DivaMainImageDisplay(this.parent);
    }

    protected ImagePanner makePanWindow(int size) {
        return new ImagePanner(this.imageDisplay, size, size);
    }

    protected ImageZoom makeZoomWindow(int size) {
        return new ImageZoom(this.imageDisplay, size, size, 4.0f);
    }

    protected BasicArrowButton makePanZoomToggleButton() {
        final BasicArrowButton b = new BasicArrowButton(1);
        b.setToolTipText(_I18N.getString("panZoomToggleTip"));
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ImageDisplayControl.this.panZoomPanel.isVisible()) {
                    ImageDisplayControl.this.panZoomPanel.setVisible(false);
                    ImageDisplayControl.this.imageZoom.setActive(false);
                    b.setDirection(5);
                } else {
                    ImageDisplayControl.this.panZoomPanel.setVisible(true);
                    ImageDisplayControl.this.imageZoom.setActive(true);
                    b.setDirection(1);
                }
            }
        });
        return b;
    }

    protected ImageColorbar makeColorbar() {
        return new ImageColorbar(this.imageDisplay);
    }

    protected ImageDisplayStatusPanel makeStatusPanel() {
        return new ImageDisplayStatusPanel();
    }

    protected void makeLayout(int size) {
        this.setLayout(new BorderLayout());
        this.colorbar.setBorder(BorderFactory.createEtchedBorder());
        this.colorbar.setPreferredSize(new Dimension(0, 20));
        JPanel imagePanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        imagePanel.setLayout(layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 10;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        layout.setConstraints((Component)((Object)this.imageDisplay), gbc);
        this.panZoomPanel.setLayout(new BoxLayout(this.panZoomPanel, 1));
        this.imagePanner.setBorder(new LineBorder(this.getBackground(), 1));
        this.panZoomPanel.add(this.imagePanner);
        this.imageZoom.setBorder(new LineBorder(this.getBackground(), 1));
        this.panZoomPanel.add(this.imageZoom);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 12;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        layout.setConstraints(this.panZoomPanel, gbc);
        layout.setConstraints(this.panZoomToggleButton, gbc);
        imagePanel.add(this.panZoomToggleButton);
        imagePanel.add(this.panZoomPanel);
        imagePanel.add((Component)((Object)this.imageDisplay));
        this.add((Component)imagePanel, "Center");
        JPanel bot = new JPanel();
        bot.setLayout(new BorderLayout());
        bot.add((Component)this.colorbar, "North");
        bot.add((Component)this.imageDisplayStatusPanel, "South");
        this.add((Component)bot, "South");
    }

    public DivaMainImageDisplay getImageDisplay() {
        return this.imageDisplay;
    }

    public ImagePanner getImagePanner() {
        return this.imagePanner;
    }

    public ImageZoom getImageZoom() {
        return this.imageZoom;
    }

    public ImageDisplayStatusPanel getImageDisplayStatusPanel() {
        return this.imageDisplayStatusPanel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

