/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.graphics;

import diva.canvas.Figure;
import diva.canvas.FigureDecorator;
import diva.canvas.FigureLayer;
import diva.canvas.GeometricSet;
import diva.canvas.GraphicsPane;
import diva.canvas.OverlayLayer;
import diva.canvas.event.EventLayer;
import diva.canvas.event.LayerEvent;
import diva.canvas.event.LayerListener;
import diva.canvas.event.MouseFilter;
import diva.canvas.interactor.DragInteractor;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.SelectionInteractor;
import diva.util.CompoundIterator;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class SelectionDragger
extends DragInteractor {
    private OverlayLayer _overlayLayer;
    private EventLayer _eventLayer;
    private FigureLayer _figureLayer;
    private ArrayList _selectionInteractors = new ArrayList();
    private Rectangle2D _rubberBand = null;
    private GeometricSet _intersectedFigures;
    private HashSet _currentFigures;
    private HashSet _holdovers;
    private double _originX;
    private double _originY;
    private MouseFilter _selectionFilter = MouseFilter.selectionFilter;
    private MouseFilter _toggleFilter = MouseFilter.alternateSelectionFilter;
    private boolean _isSelecting;
    private boolean _isToggling;

    public SelectionDragger() {
    }

    public SelectionDragger(GraphicsPane gpane) {
        this.setOverlayLayer(gpane.getOverlayLayer());
        this.setEventLayer(gpane.getBackgroundEventLayer());
        this.setFigureLayer(gpane.getForegroundLayer());
    }

    public void addSelectionInteractor(SelectionInteractor i) {
        if (!this._selectionInteractors.contains(i)) {
            this._selectionInteractors.add(i);
        }
    }

    public void clearSelection() {
        Iterator is = this._selectionInteractors.iterator();
        while (is.hasNext()) {
            SelectionInteractor i = (SelectionInteractor)is.next();
            i.getSelectionModel().clearSelection();
        }
    }

    public void contractSelection(SelectionInteractor i, Figure figure) {
        if (i.getSelectionModel().containsSelection((Object)figure)) {
            i.getSelectionModel().removeSelection((Object)figure);
        }
    }

    public void expandSelection(SelectionInteractor i, Figure figure) {
        if (!i.getSelectionModel().containsSelection((Object)figure)) {
            i.getSelectionModel().addSelection((Object)figure);
        }
    }

    public OverlayLayer getOverlayLayer() {
        return this._overlayLayer;
    }

    public EventLayer getEventLayer() {
        return this._eventLayer;
    }

    public FigureLayer getFigureLayer() {
        return this._figureLayer;
    }

    public MouseFilter getSelectionFilter() {
        return this._selectionFilter;
    }

    public MouseFilter getToggleFilter() {
        return this._toggleFilter;
    }

    public void mouseDragged(LayerEvent event) {
        Figure f;
        double h;
        double w;
        if (!this.isEnabled()) {
            return;
        }
        if (!this._isToggling && !this._isSelecting) {
            return;
        }
        double x = event.getLayerX();
        double y = event.getLayerY();
        this._overlayLayer.repaint(this._rubberBand);
        if (x < this._originX) {
            w = this._originX - x;
        } else {
            w = x - this._originX;
            x = this._originX;
        }
        if (y < this._originY) {
            h = this._originY - y;
        } else {
            h = y - this._originY;
            y = this._originY;
        }
        this._rubberBand.setFrame(x, y, w, h);
        this._overlayLayer.repaint(this._rubberBand);
        this._intersectedFigures.setGeometry((Shape)this._rubberBand);
        HashSet<Figure> freshFigures = new HashSet<Figure>();
        Iterator i = this._intersectedFigures.figures();
        while (i.hasNext()) {
            f = (Figure)i.next();
            if (f instanceof FigureDecorator) {
                f = ((FigureDecorator)f).getDecoratedFigure();
            }
            if (f.hit(this._rubberBand)) {
                freshFigures.add(f);
                continue;
            }
            this._holdovers.add(f);
        }
        i = ((HashSet)this._holdovers.clone()).iterator();
        while (i.hasNext()) {
            f = (Figure)i.next();
            if (!f.hit(this._rubberBand)) continue;
            freshFigures.add(f);
            this._holdovers.remove(f);
        }
        HashSet staleFigures = (HashSet)this._currentFigures.clone();
        staleFigures.removeAll(freshFigures);
        HashSet temp = (HashSet)freshFigures.clone();
        freshFigures.removeAll(this._currentFigures);
        this._currentFigures = temp;
        if (this._isSelecting) {
            Interactor r;
            Figure f2;
            Iterator i2 = freshFigures.iterator();
            while (i2.hasNext()) {
                f2 = (Figure)i2.next();
                r = f2.getInteractor();
                if (r == null || !(r instanceof SelectionInteractor) || !this._selectionInteractors.contains(r)) continue;
                this.expandSelection((SelectionInteractor)r, f2);
            }
            i2 = staleFigures.iterator();
            while (i2.hasNext()) {
                f2 = (Figure)i2.next();
                r = f2.getInteractor();
                if (r == null || !(r instanceof SelectionInteractor) || !this._selectionInteractors.contains(r)) continue;
                this.contractSelection((SelectionInteractor)r, f2);
            }
        } else {
            CompoundIterator i3 = new CompoundIterator(freshFigures.iterator(), staleFigures.iterator());
            while (i3.hasNext()) {
                Figure f3 = (Figure)i3.next();
                Interactor r = f3.getInteractor();
                if (r == null || !(r instanceof SelectionInteractor) || !this._selectionInteractors.contains(r)) continue;
                SelectionInteractor s = (SelectionInteractor)r;
                if (s.getSelectionModel().containsSelection((Object)f3)) {
                    this.contractSelection(s, f3);
                    continue;
                }
                this.expandSelection(s, f3);
            }
        }
        if (this.isConsuming()) {
            event.consume();
        }
    }

    public void mousePressed(LayerEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        this._isSelecting = this._selectionFilter.accept((MouseEvent)event);
        this._isToggling = this._toggleFilter.accept((MouseEvent)event);
        if (!this._isToggling && !this._isSelecting) {
            return;
        }
        this._originX = event.getLayerX();
        this._originY = event.getLayerY();
        this._rubberBand = new Rectangle2D.Double(this._originX, this._originY, 0.0, 0.0);
        this._overlayLayer.add((Shape)this._rubberBand);
        this._overlayLayer.repaint(this._rubberBand);
        this._intersectedFigures = this._figureLayer.getFigures().getIntersectedFigures(this._rubberBand);
        this._currentFigures = new HashSet();
        this._holdovers = new HashSet();
        if (this._isSelecting) {
            this.clearSelection();
        }
        if (this.isConsuming()) {
            event.consume();
        }
    }

    public void mouseReleased(LayerEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        this.terminateDragSelection();
        if (this.isConsuming()) {
            event.consume();
        }
    }

    public void removeSelectionInteractor(SelectionInteractor i) {
        if (this._selectionInteractors.contains(i)) {
            this._selectionInteractors.remove(i);
        }
    }

    public Iterator selectionInteractors() {
        return this._selectionInteractors.iterator();
    }

    public void setOverlayLayer(OverlayLayer l) {
        this._overlayLayer = l;
    }

    public void setEventLayer(EventLayer l) {
        if (this._eventLayer != null) {
            this._eventLayer.removeLayerListener((LayerListener)this);
        }
        this._eventLayer = l;
        this._eventLayer.addLayerListener((LayerListener)this);
    }

    public void setFigureLayer(FigureLayer l) {
        this._figureLayer = l;
    }

    public void setSelectionFilter(MouseFilter f) {
        this._selectionFilter = f;
    }

    public void setToggleFilter(MouseFilter f) {
        this._toggleFilter = f;
    }

    public void terminateDragSelection() {
        if (!this._isToggling && !this._isSelecting) {
            return;
        }
        this._overlayLayer.repaint(this._rubberBand);
        this._overlayLayer.remove((Shape)this._rubberBand);
        this._currentFigures = null;
        this._holdovers = null;
    }

    public Rectangle2D getSelectedArea() {
        return this._rubberBand;
    }

    public void setEnabled(boolean enabled) {
        if (this._eventLayer != null) {
            this._eventLayer.removeLayerListener((LayerListener)this);
        }
        if (enabled) {
            this._eventLayer.addLayerListener((LayerListener)this);
        }
    }
}

