/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.fits.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.RenderedImage;
import javax.media.jai.PlanarImage;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import jsky.image.fits.codec.FITSImage;
import jsky.image.gui.MainImageDisplay;
import jsky.util.gui.BusyWin;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.SwingUtil;
import nom.tam.fits.AsciiTableHDU;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.ImageHDU;

public class FITSHDUChooser
extends JPanel {
    private Component _parent;
    private MainImageDisplay _imageDisplay;
    private JTable _table;
    private FITSImage _fitsImage;
    private static final String[] COLUMN_NAMES = new String[]{"HDU", "Type", "EXTNAME", "NAXIS", "NAXIS1", "NAXIS2", "NAXIS3", "CRPIX1", "CRPIX2"};
    private static final Class[] COLUMN_CLASSES = new Class[]{class$java$lang$Integer == null ? (class$java$lang$Integer = FITSHDUChooser.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$String == null ? (class$java$lang$String = FITSHDUChooser.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = FITSHDUChooser.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = FITSHDUChooser.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = FITSHDUChooser.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = FITSHDUChooser.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = FITSHDUChooser.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Double == null ? (class$java$lang$Double = FITSHDUChooser.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$Double == null ? (class$java$lang$Double = FITSHDUChooser.class$("java.lang.Double")) : class$java$lang$Double};
    private static final int[] COLUMN_WIDTHS = new int[]{50, 70, 200, 60, 60, 60, 60, 70, 70};
    private int _numRows;
    private static final int NUM_COLS = COLUMN_NAMES.length;
    private Object[][] _tableData;
    private JButton _deleteButton;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;

    public FITSHDUChooser(Component parent, MainImageDisplay imageDisplay, FITSImage fitsImage) {
        this._parent = parent;
        this._imageDisplay = imageDisplay;
        this.setLayout(new BorderLayout());
        this.add((Component)this._makeTablePane(), "Center");
        this.add((Component)this._makeButtonPanel(), "South");
        this.updateDisplay(fitsImage);
    }

    private JScrollPane _makeTablePane() {
        this._table = new JTable();
        this._table.setCellSelectionEnabled(false);
        this._table.setAutoResizeMode(4);
        this._table.setRowSelectionAllowed(true);
        this._table.setColumnSelectionAllowed(false);
        this._table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Point pt = evt.getPoint();
                int row = FITSHDUChooser.this._table.rowAtPoint(pt);
                FITSHDUChooser.this._deleteButton.setEnabled(row > 0);
                if (evt.getClickCount() == 2) {
                    FITSHDUChooser.this._selectTableRow(row);
                }
            }
        });
        this._table.setPreferredScrollableViewportSize(new Dimension(450, 90));
        return new JScrollPane(this._table);
    }

    public void updateDisplay(FITSImage fitsImage) {
        this._fitsImage = fitsImage;
        this._numRows = this._fitsImage.getNumHDUs();
        this._tableData = new Object[this._numRows][NUM_COLS];
        for (int row = 0; row < this._numRows; ++row) {
            BasicHDU hdu = this._fitsImage.getHDU(row);
            Header header = hdu.getHeader();
            int col = 0;
            this._tableData[row][col++] = new Integer(row);
            this._tableData[row][col++] = this._getHDUType(hdu);
            this._tableData[row][col++] = header.getStringValue("EXTNAME");
            this._tableData[row][col++] = new Integer(header.getIntValue("NAXIS"));
            this._tableData[row][col++] = new Integer(header.getIntValue("NAXIS1"));
            this._tableData[row][col++] = new Integer(header.getIntValue("NAXIS2"));
            this._tableData[row][col++] = new Integer(header.getIntValue("NAXIS3"));
            this._tableData[row][col++] = new Double(header.getDoubleValue("CRPIX1"));
            this._tableData[row][col++] = new Double(header.getDoubleValue("CRPIX2"));
        }
        this._table.setModel(new AbstractTableModel(){

            public int getColumnCount() {
                return NUM_COLS;
            }

            public String getColumnName(int i) {
                return COLUMN_NAMES[i];
            }

            public Class getColumnClass(int i) {
                return COLUMN_CLASSES[i];
            }

            public int getRowCount() {
                return FITSHDUChooser.this._numRows;
            }

            public Object getValueAt(int row, int col) {
                return FITSHDUChooser.this._tableData[row][col];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        });
        for (int i = 0; i < NUM_COLS; ++i) {
            this._table.getColumn(COLUMN_NAMES[i]).setPreferredWidth(COLUMN_WIDTHS[i]);
        }
    }

    private String _getHDUType(BasicHDU hdu) {
        if (hdu instanceof ImageHDU) {
            return "image";
        }
        if (hdu instanceof BinaryTableHDU) {
            return "binary";
        }
        if (hdu instanceof AsciiTableHDU) {
            return "ascii";
        }
        return "unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _selectTableRow(int rowIndex) {
        if (rowIndex != -1) {
            BusyWin.setBusy(true);
            try {
                TableModel model = this._table.getModel();
                int hdu = (Integer)model.getValueAt(rowIndex, 0);
                String type = (String)model.getValueAt(rowIndex, 1);
                if (type.equals("image")) {
                    this.selectImage(hdu);
                } else if (type.equals("binary") || type.equals("ascii")) {
                    this._imageDisplay.displayFITSTable(hdu);
                }
            }
            finally {
                BusyWin.setBusy(false);
            }
        }
    }

    public void selectImage(int hdu) {
        try {
            this._fitsImage.setHDU(hdu);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't select FIT HDU# " + hdu + ": " + e.getMessage());
        }
        this._imageDisplay.setImage(PlanarImage.wrapRenderedImage((RenderedImage)this._fitsImage));
    }

    public JTable getTable() {
        return this._table;
    }

    private JPanel _makeButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        JButton openButton = new JButton("Open");
        openButton.setToolTipText("Open and display the selected FITS HDU (header/data unit)");
        panel.add(openButton);
        openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                FITSHDUChooser.this._open();
            }
        });
        this._deleteButton = new JButton("Delete");
        this._deleteButton.setToolTipText("Delete the selected FITS HDU");
        panel.add(this._deleteButton);
        this._deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                FITSHDUChooser.this._delete();
            }
        });
        JButton closeButton = new JButton("Close");
        closeButton.setToolTipText("Hide this window");
        panel.add(closeButton);
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                FITSHDUChooser.this._close();
            }
        });
        return panel;
    }

    private void _open() {
        this._selectTableRow(this._table.getSelectedRow());
    }

    private void _delete() {
        int hdu = this._table.getSelectedRow();
        if (hdu > 0 && hdu < this._fitsImage.getNumHDUs()) {
            try {
                this._fitsImage.getFits().deleteHDU(hdu);
                this._imageDisplay.setSaveNeeded(true);
            }
            catch (FitsException e) {
                DialogUtil.error((Exception)((Object)e));
                return;
            }
            this.updateDisplay(this._fitsImage);
        }
    }

    private void _close() {
        if (this._parent != null) {
            this._parent.setVisible(false);
        }
    }

    public void clear() {
        this._table.setModel(new DefaultTableModel());
        this._fitsImage = null;
    }

    public void setShow(boolean show) {
        this._parent.setVisible(show);
        if (show) {
            int hdu = this._fitsImage.getCurrentHDUIndex();
            this._table.getSelectionModel().setSelectionInterval(hdu, hdu);
            SwingUtil.showFrame(this._parent);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

