/*
 * Decompiled with CFR 0.152.
 */
package jsky.image;

import javax.media.jai.LookupTableJAI;
import jsky.image.ImageColorITTs;
import jsky.image.ImageColorLUTs;

public class ImageColormap
implements Cloneable {
    protected LookupTableJAI colorLookupTable;
    protected String colorLookupTableName = "Ramp";
    protected byte[][] colorLut;
    protected float[] intensityLookupTable;
    protected String intensityLookupTableName = "Ramp";
    public static final String DEFAULT_COLOR_LUT = "Real";
    protected static final int NUM_COLORS = 256;

    public ImageColormap() {
        this.setColorLookupTable(DEFAULT_COLOR_LUT);
    }

    public void setColorLookupTable(String name) {
        this.colorLookupTableName = name;
        int maxLut = 255;
        byte[][] blut = new byte[3][256];
        float[][] flut = ImageColorLUTs.getLUT(name);
        if (this.intensityLookupTable == null || this.intensityLookupTableName.equals("Ramp")) {
            for (int i = 0; i < 256; ++i) {
                blut[0][i] = (byte)(flut[i][0] * (float)maxLut);
                blut[1][i] = (byte)(flut[i][1] * (float)maxLut);
                blut[2][i] = (byte)(flut[i][2] * (float)maxLut);
            }
        } else {
            for (int i = 0; i < 256; ++i) {
                int index = (int)((double)(this.intensityLookupTable[i] * (float)maxLut) + 0.5);
                blut[0][i] = (byte)(flut[index][0] * (float)maxLut);
                blut[1][i] = (byte)(flut[index][1] * (float)maxLut);
                blut[2][i] = (byte)(flut[index][2] * (float)maxLut);
            }
        }
        this.colorLut = (byte[][])blut.clone();
        this.colorLookupTable = new LookupTableJAI(blut, 0);
    }

    public void setIntensityLookupTable(String name) {
        this.intensityLookupTableName = name;
        this.intensityLookupTable = ImageColorITTs.getITT(name);
        this.setColorLookupTable(this.colorLookupTableName);
    }

    public void saveColormap() {
        this.colorLut = (byte[][])this.colorLookupTable.getByteData().clone();
    }

    public void rotateColormap(int amount) {
        byte[][] newLut = new byte[3][256];
        for (int i = 0; i < 256; ++i) {
            int index = (i - amount) % 256;
            if (index < 0) {
                index += 256;
            }
            newLut[0][i] = this.colorLut[0][index];
            newLut[1][i] = this.colorLut[1][index];
            newLut[2][i] = this.colorLut[2][index];
        }
        this.colorLut = (byte[][])newLut.clone();
        this.colorLookupTable = new LookupTableJAI(newLut, 0);
    }

    public void shiftColormap(int amount) {
        byte[][] newLut = new byte[3][256];
        for (int i = 0; i < 256; ++i) {
            int index = i - amount;
            if (index < 0) {
                index = 0;
            } else if (index >= 256) {
                index = 255;
            }
            newLut[0][i] = this.colorLut[0][index];
            newLut[1][i] = this.colorLut[1][index];
            newLut[2][i] = this.colorLut[2][index];
        }
        this.colorLookupTable = new LookupTableJAI(newLut, 0);
    }

    public void scaleColormap(int amount) {
        byte[][] newLut = new byte[3][256];
        int n = 255;
        int index = 0;
        boolean value = false;
        int start = Math.min(amount, 128);
        int end = 256 - start;
        if (end <= start) {
            end = start + 1;
        }
        int dist = end - start + 1;
        for (int i = 0; i < 256; ++i) {
            if (i >= start && i <= end) {
                index = (i - start) * n / dist;
                if (index < 0) {
                    index = 0;
                } else if (index > n) {
                    index = n;
                }
            } else {
                index = i < start ? 0 : n;
            }
            index = this.intensityLookupTable == null ? (byte)((double)index / 256.0 * (double)n) & 0xFF : (byte)(this.intensityLookupTable[index] * (float)n) & 0xFF;
            newLut[0][i] = this.colorLut[0][index];
            newLut[1][i] = this.colorLut[1][index];
            newLut[2][i] = this.colorLut[2][index];
        }
        this.colorLookupTable = new LookupTableJAI(newLut, 0);
    }

    public void setDefaultColormap() {
        this.intensityLookupTableName = "Ramp";
        this.setColorLookupTable(DEFAULT_COLOR_LUT);
    }

    public void resetColormap() {
        this.setColorLookupTable(this.colorLookupTableName);
    }

    public LookupTableJAI getColorLookupTable() {
        return this.colorLookupTable;
    }

    public String getColorLookupTableName() {
        return this.colorLookupTableName;
    }

    public String getIntensityLookupTableName() {
        return this.intensityLookupTableName;
    }

    public boolean equals(ImageColormap colormap) {
        return this.colorLookupTable == colormap.colorLookupTable && this.colorLookupTableName == colormap.colorLookupTableName && this.colorLut == colormap.colorLut && this.intensityLookupTable == colormap.intensityLookupTable && this.intensityLookupTableName == colormap.intensityLookupTableName;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }
}

