/*
 * Decompiled with CFR 0.152.
 */
package jsky.coords;

import java.awt.geom.Point2D;
import jsky.coords.WCSTransform;

public class worldpos {
    public static Point2D.Double getPosition(double xpix, double ypix, WCSTransform wcs) {
        double ra0;
        double dec0;
        double tx;
        double dect = 0.0;
        double rat = 0.0;
        double cond2r = 0.01745329252;
        double twopi = 6.28318530717959;
        double deps = 1.0E-5;
        int itype = wcs.pcode;
        double xpos = 0.0;
        double ypos = 0.0;
        double xref = wcs.xref;
        double yref = wcs.yref;
        double xrefpix = wcs.xrefpix;
        double yrefpix = wcs.yrefpix;
        double xinc = wcs.xinc;
        double yinc = wcs.yinc;
        double rot = WCSTransform.degrad(wcs.rot);
        double cosr = Math.cos(rot);
        double sinr = Math.sin(rot);
        double dx = xpix - xrefpix;
        double dy = ypix - yrefpix;
        if (wcs.rotmat > 0) {
            tx = dx * wcs.cd11 + dy * wcs.cd12;
            dy = dx * wcs.cd21 + dy * wcs.cd22;
            dx = tx;
        } else {
            if (xinc == 0.0 || yinc == 0.0) {
                return null;
            }
            dx *= xinc;
            dy *= yinc;
            if (rot != 0.0) {
                tx = dx * cosr - dy * sinr;
                dy = dx * sinr + dy * cosr;
                dx = tx;
            }
        }
        xpos = xref + dx;
        ypos = yref + dy;
        if (itype < 0) {
            return new Point2D.Double(xpos, ypos);
        }
        if (wcs.coorflip > 0) {
            dec0 = WCSTransform.degrad(xref);
            ra0 = WCSTransform.degrad(yref);
            tx = dx;
            dx = dy;
            dy = tx;
        } else {
            ra0 = WCSTransform.degrad(xref);
            dec0 = WCSTransform.degrad(yref);
        }
        double l = WCSTransform.degrad(dx);
        double m = WCSTransform.degrad(dy);
        double sins = l * l + m * m;
        double decout = 0.0;
        double raout = 0.0;
        double cos0 = Math.cos(dec0);
        double sin0 = Math.sin(dec0);
        switch (itype) {
            case -1: 
            case 0: {
                rat = ra0 + l;
                dect = dec0 + m;
                break;
            }
            case 1: {
                if (sins > 1.0) {
                    return null;
                }
                double coss = Math.sqrt(1.0 - sins);
                double dt = sin0 * coss + cos0 * m;
                if (dt > 1.0 || dt < -1.0) {
                    return null;
                }
                dect = Math.asin(dt);
                rat = cos0 * coss - sin0 * m;
                if (rat == 0.0 && l == 0.0) {
                    return null;
                }
                rat = Math.atan2(l, rat) + ra0;
                break;
            }
            case 2: {
                if (sins > 1.0) {
                    return null;
                }
                dect = cos0 - m * sin0;
                if (dect == 0.0) {
                    return null;
                }
                rat = ra0 + Math.atan2(l, dect);
                dect = Math.atan(Math.cos(rat - ra0) * (m * cos0 + sin0) / dect);
                break;
            }
            case 3: {
                double coss;
                if (sins >= twopi * twopi / 4.0) {
                    return null;
                }
                sins = Math.sqrt(sins);
                double dt = m * cos0 * (sins = sins != 0.0 ? Math.sin(sins) / sins : 1.0) + sin0 * (coss = Math.cos(sins));
                if (dt > 1.0 || dt < -1.0) {
                    return null;
                }
                dect = Math.asin(dt);
                double da = coss - dt * sin0;
                dt = l * sins * cos0;
                if (da == 0.0 && dt == 0.0) {
                    return null;
                }
                rat = ra0 + Math.atan2(dt, da);
                break;
            }
            case 4: {
                dect = cos0 - m * sin0;
                if (dect == 0.0) {
                    return null;
                }
                rat = ra0 + Math.atan2(l, dect);
                double dt = Math.cos(rat - ra0);
                if (dt == 0.0) {
                    return null;
                }
                if ((dect /= dt) > 1.0 || dect < -1.0) {
                    return null;
                }
                dect = Math.acos(dect);
                if (!(dec0 < 0.0)) break;
                dect = -dect;
                break;
            }
            case 5: {
                dect = dec0 + m;
                if (Math.abs(dect) > twopi / 4.0) {
                    return null;
                }
                double coss = Math.cos(dect);
                if (Math.abs(l) > twopi * coss / 2.0) {
                    return null;
                }
                rat = ra0;
                if (!(coss > deps)) break;
                rat += l / coss;
                break;
            }
            case 6: {
                double dt = yinc * cosr + xinc * sinr;
                if (dt == 0.0) {
                    dt = 1.0;
                }
                dy = WCSTransform.degrad(yref / 2.0 + 45.0);
                dx = dy + dt / 2.0 * cond2r;
                dy = Math.log(Math.tan(dy));
                dx = Math.log(Math.tan(dx));
                double geo2 = WCSTransform.degrad(dt) / (dx - dy);
                double geo3 = geo2 * dy;
                double geo1 = Math.cos(WCSTransform.degrad(yref));
                if (geo1 <= 0.0) {
                    geo1 = 1.0;
                }
                if (Math.abs((rat = l / geo1 + ra0) - ra0) > twopi) {
                    return null;
                }
                dt = 0.0;
                if (geo2 != 0.0) {
                    dt = (m + geo3) / geo2;
                }
                dt = Math.exp(dt);
                dect = 2.0 * Math.atan(dt) - twopi / 4.0;
                break;
            }
            case 7: {
                double dt = yinc * cosr + xinc * sinr;
                if (dt == 0.0) {
                    dt = 1.0;
                }
                dt = WCSTransform.degrad(dt);
                dy = WCSTransform.degrad(yref);
                dx = Math.sin(dy + dt) / Math.sqrt((1.0 + Math.cos(dy + dt)) / 2.0) - Math.sin(dy) / Math.sqrt((1.0 + Math.cos(dy)) / 2.0);
                if (dx == 0.0) {
                    dx = 1.0;
                }
                double geo2 = dt / dx;
                dt = xinc * cosr - yinc * sinr;
                if (dt == 0.0) {
                    dt = 1.0;
                }
                dt = WCSTransform.degrad(dt);
                dx = 2.0 * Math.cos(dy) * Math.sin(dt / 2.0);
                if (dx == 0.0) {
                    dx = 1.0;
                }
                double geo1 = dt * Math.sqrt((1.0 + Math.cos(dy) * Math.cos(dt / 2.0)) / 2.0) / dx;
                double geo3 = geo2 * Math.sin(dy) / Math.sqrt((1.0 + Math.cos(dy)) / 2.0);
                rat = ra0;
                dect = dec0;
                if (l == 0.0 && m == 0.0) break;
                double dz = 4.0 - l * l / (4.0 * geo1 * geo1) - (m + geo3) / geo2 * ((m + geo3) / geo2);
                if (dz > 4.0 || dz < 2.0) {
                    return null;
                }
                double dd = (m + geo3) * (dz = 0.5 * Math.sqrt(dz)) / geo2;
                if (Math.abs(dd) > 1.0) {
                    return null;
                }
                if (Math.abs(Math.cos(dd = Math.asin(dd))) < deps) {
                    return null;
                }
                double da = l * dz / (2.0 * geo1 * Math.cos(dd));
                if (Math.abs(da) > 1.0) {
                    return null;
                }
                da = Math.asin(da);
                rat = ra0 + 2.0 * da;
                dect = dd;
                break;
            }
            case 8: {
                double dz = (4.0 - sins) / (4.0 + sins);
                if (Math.abs(dz) > 1.0) {
                    return null;
                }
                dect = dz * sin0 + m * cos0 * (1.0 + dz) / 2.0;
                if (Math.abs(dect) > 1.0) {
                    return null;
                }
                rat = Math.cos(dect = Math.asin(dect));
                if (Math.abs(rat) < deps) {
                    return null;
                }
                if (Math.abs(rat = l * (1.0 + dz) / (2.0 * rat)) > 1.0) {
                    return null;
                }
                rat = Math.asin(rat);
                double mg = 1.0 + Math.sin(dect) * sin0 + Math.cos(dect) * cos0 * Math.cos(rat);
                if (Math.abs(mg) < deps) {
                    return null;
                }
                mg = 2.0 * (Math.sin(dect) * cos0 - Math.cos(dect) * sin0 * Math.cos(rat)) / mg;
                if (Math.abs(mg - m) > deps) {
                    rat = twopi / 2.0 - rat;
                }
                rat = ra0 + rat;
            }
        }
        raout = rat;
        decout = dect;
        if (raout - ra0 > twopi / 2.0) {
            raout -= twopi;
        }
        if (raout - ra0 < -twopi / 2.0) {
            raout += twopi;
        }
        if (raout < 0.0) {
            raout += twopi;
        }
        xpos = WCSTransform.raddeg(raout);
        ypos = WCSTransform.raddeg(decout);
        return new Point2D.Double(xpos, ypos);
    }

    public static Point2D.Double getPixels(double xpos, double ypos, WCSTransform wcs) {
        double tx;
        double dx = 0.0;
        double dy = 0.0;
        double ra0 = 0.0;
        double dec0 = 0.0;
        double ra = 0.0;
        double dec = 0.0;
        double coss = 0.0;
        double sins = 0.0;
        double dt = 0.0;
        double da = 0.0;
        double dd = 0.0;
        double sint = 0.0;
        double l = 0.0;
        double m = 0.0;
        double cond2r = 0.01745329252;
        double deps = 1.0E-5;
        double twopi = 6.28318530717959;
        double xref = wcs.xref;
        double yref = wcs.yref;
        double xrefpix = wcs.xrefpix;
        double yrefpix = wcs.yrefpix;
        double xinc = wcs.xinc;
        double yinc = wcs.yinc;
        double rot = WCSTransform.degrad(wcs.rot);
        double cosr = Math.cos(rot);
        double sinr = Math.sin(rot);
        int itype = wcs.pcode;
        if (itype > 0 && itype < 9) {
            if (wcs.coorflip > 0) {
                dec0 = WCSTransform.degrad(xref);
                ra0 = WCSTransform.degrad(yref);
                dt = xpos - yref;
            } else {
                ra0 = WCSTransform.degrad(xref);
                dec0 = WCSTransform.degrad(yref);
                dt = xpos - xref;
            }
            if (itype >= 0) {
                if (dt > 180.0) {
                    xpos -= 360.0;
                }
                if (dt < -180.0) {
                    xpos += 360.0;
                }
            }
            ra = WCSTransform.degrad(xpos);
            dec = WCSTransform.degrad(ypos);
            coss = Math.cos(dec);
            sins = Math.sin(dec);
            l = Math.sin(ra - ra0) * coss;
            sint = sins * Math.sin(dec0) + coss * Math.cos(dec0) * Math.cos(ra - ra0);
        }
        switch (itype) {
            case 1: {
                if (sint < 0.0) {
                    return null;
                }
                m = sins * Math.cos(dec0) - coss * Math.sin(dec0) * Math.cos(ra - ra0);
                break;
            }
            case 2: {
                if (sint <= 0.0) {
                    return null;
                }
                m = sins * Math.sin(dec0) + coss * Math.cos(dec0) * Math.cos(ra - ra0);
                l /= m;
                m = (sins * Math.cos(dec0) - coss * Math.sin(dec0) * Math.cos(ra - ra0)) / m;
                break;
            }
            case 3: {
                m = sins * Math.sin(dec0) + coss * Math.cos(dec0) * Math.cos(ra - ra0);
                if (m < -1.0) {
                    m = -1.0;
                }
                if (m > 1.0) {
                    m = 1.0;
                }
                m = (m = Math.acos(m)) != 0.0 ? (m /= Math.sin(m)) : 1.0;
                l *= m;
                m = (sins * Math.cos(dec0) - coss * Math.sin(dec0) * Math.cos(ra - ra0)) * m;
                break;
            }
            case 4: {
                if (dec0 == 0.0) {
                    return null;
                }
                m = (Math.cos(dec0) - coss * Math.cos(ra - ra0)) / Math.sin(dec0);
                break;
            }
            case 5: {
                dt = ra - ra0;
                if (Math.abs(dec) > twopi / 4.0) {
                    return null;
                }
                if (Math.abs(dec0) > twopi / 4.0) {
                    return null;
                }
                m = dec - dec0;
                l = dt * coss;
                break;
            }
            case 6: {
                dt = yinc * cosr + xinc * sinr;
                if (dt == 0.0) {
                    dt = 1.0;
                }
                dy = WCSTransform.degrad(yref / 2.0 + 45.0);
                dx = dy + dt / 2.0 * cond2r;
                dy = Math.log(Math.tan(dy));
                dx = Math.log(Math.tan(dx));
                double geo2 = WCSTransform.degrad(dt) / (dx - dy);
                double geo3 = geo2 * dy;
                double geo1 = Math.cos(WCSTransform.degrad(yref));
                if (geo1 <= 0.0) {
                    geo1 = 1.0;
                }
                dt = ra - ra0;
                l = geo1 * dt;
                dt = dec / 2.0 + twopi / 8.0;
                if ((dt = Math.tan(dt)) < deps) {
                    return null;
                }
                m = geo2 * Math.log(dt) - geo3;
                break;
            }
            case 7: {
                l = 0.0;
                m = 0.0;
                da = (ra - ra0) / 2.0;
                if (Math.abs(da) > twopi / 4.0) {
                    return null;
                }
                dt = yinc * cosr + xinc * sinr;
                if (dt == 0.0) {
                    dt = 1.0;
                }
                dt = WCSTransform.degrad(dt);
                dy = WCSTransform.degrad(yref);
                dx = Math.sin(dy + dt) / Math.sqrt((1.0 + Math.cos(dy + dt)) / 2.0) - Math.sin(dy) / Math.sqrt((1.0 + Math.cos(dy)) / 2.0);
                if (dx == 0.0) {
                    dx = 1.0;
                }
                double geo2 = dt / dx;
                dt = xinc * cosr - yinc * sinr;
                if (dt == 0.0) {
                    dt = 1.0;
                }
                dt = WCSTransform.degrad(dt);
                dx = 2.0 * Math.cos(dy) * Math.sin(dt / 2.0);
                if (dx == 0.0) {
                    dx = 1.0;
                }
                double geo1 = dt * Math.sqrt((1.0 + Math.cos(dy) * Math.cos(dt / 2.0)) / 2.0) / dx;
                double geo3 = geo2 * Math.sin(dy) / Math.sqrt((1.0 + Math.cos(dy)) / 2.0);
                dt = Math.sqrt((1.0 + Math.cos(dec) * Math.cos(da)) / 2.0);
                if (Math.abs(dt) < deps) {
                    return null;
                }
                l = 2.0 * geo1 * Math.cos(dec) * Math.sin(da) / dt;
                m = geo2 * Math.sin(dec) / dt - geo3;
                break;
            }
            case 8: {
                da = ra - ra0;
                if (Math.abs(dec) > twopi / 4.0) {
                    return null;
                }
                dd = 1.0 + sins * Math.sin(dec0) + coss * Math.cos(dec0) * Math.cos(da);
                if (Math.abs(dd) < deps) {
                    return null;
                }
                dd = 2.0 / dd;
                l *= dd;
                m = dd * (sins * Math.cos(dec0) - coss * Math.sin(dec0) * Math.cos(da));
            }
        }
        if (itype > 0 && itype < 9) {
            dx = WCSTransform.raddeg(l);
            dy = WCSTransform.raddeg(m);
        } else {
            dx = xpos - xref;
            dy = ypos - yref;
        }
        if (wcs.coorflip > 0) {
            tx = dx;
            dx = dy;
            dy = tx;
        }
        if (wcs.rotmat > 0) {
            tx = dx * wcs.dc11 + dy * wcs.dc12;
            dy = dx * wcs.dc21 + dy * wcs.dc22;
            dx = tx;
        } else {
            if (rot != 0.0) {
                tx = dx * cosr + dy * sinr;
                dy = dy * cosr - dx * sinr;
                dx = tx;
            }
            if (xinc != 0.0) {
                dx /= xinc;
            }
            if (yinc != 0.0) {
                dy /= yinc;
            }
        }
        double xpix = dx + xrefpix;
        double ypix = dy + yrefpix;
        return new Point2D.Double(xpix, ypix);
    }
}

