/*
 * Decompiled with CFR 0.152.
 */
package jsky.coords;

import java.awt.geom.Point2D;
import jsky.coords.WCSTransform;
import jsky.coords.slasubs;

public class wcscon {
    static double[] a = new double[]{-1.62557E-6, -3.1919E-7, -1.3843E-7};
    static double[] ad = new double[]{0.001245, -0.00158, -6.59E-4};
    static double[][] emi = new double[][]{{0.99992567949991, -0.011181482788805, -0.004859004008828, -5.41640798032E-4, -0.237963047085011, 0.436218238658637}, {0.011181482840782, 0.999937484898031, -2.7155744957E-5, 0.237912530551179, -0.00266070648897, -0.008537588719453}, {0.004859003889183, -2.7177143501E-5, 0.999988194601879, -0.436101961325347, 0.012258830424865, 0.002119065556992}, {-2.423898405E-6, 2.7105439E-8, 1.1777422E-8, 0.999904322043106, -0.011181451601069, -0.004858519608686}, {-2.7105439E-8, -2.423927017E-6, 6.5851E-11, 0.011181451608968, 0.999916125340107, -2.7162614355E-5}, {-1.1777422E-8, 6.5846E-11, -2.424049954E-6, 0.004858519590501, -2.7165866691E-5, 0.999966838131419}};
    static double[][] em = new double[][]{{0.999925678186902, 0.011182059571766, 0.004857946721186, -5.41652366951E-4, 0.237917612131583, -0.43611127603927}, {-0.011182059642247, 0.999937478448132, -2.7147426498E-5, -0.237968129744288, -0.002660763319071, 0.012259092261564}, {-0.00485794655896, -2.7176441185E-5, 0.99998819973877, 0.436227555856097, -0.008537771074048, 0.002119110818172}, {2.423950176E-6, 2.7106627E-8, 1.1776559E-8, 0.999947035154614, 0.011182506007242, 0.00485766994865}, {-2.7106627E-8, 2.423978783E-6, -6.5816E-11, -0.011182506121805, 0.999958833818833, -2.7137309539E-5}, {-1.1776558E-8, -6.5874E-11, 2.424101735E-6, -0.004857669684959, -2.7184471371E-5, 1.000009560363559}};
    static int idg = 0;
    static double[][] bgal = new double[][]{{-0.066988739415, -0.872755765852, -0.483538914632}, {0.492728466075, -0.45034695802, 0.744584633283}, {-0.867600811151, -0.188374601723, 0.460199784784}};
    static double[][] jgal = new double[][]{{-0.054875539726, -0.87343710801, -0.483834985808}, {0.494109453312, -0.444829589425, 0.74698225181}, {-0.867666135858, -0.198076386122, 0.455983795705}};
    public static final double DAS2R = 4.84813681109536E-6;

    public static Point2D.Double fk524(Point2D.Double input) {
        Point2D.Double pm = new Point2D.Double(0.0, 0.0);
        return wcscon.fk524m(input, pm);
    }

    public static Point2D.Double fk524e(Point2D.Double input, double epoch) {
        Point2D.Double pm = new Point2D.Double(0.0, 0.0);
        Point2D.Double output = wcscon.fk524m(input, pm);
        output.x += pm.x * (epoch - 1950.0);
        output.y += pm.y * (epoch - 1950.0);
        return output;
    }

    public static Point2D.Double fk524m(Point2D.Double input, Point2D.Double pm) {
        double r1950;
        double[] v1 = new double[6];
        double[] v2 = new double[6];
        int diag = 0;
        double d2pi = Math.PI * 2;
        double tiny = 1.0E-30;
        double zero = 0.0;
        double pmf = 1.296E8 / d2pi;
        double r2000 = WCSTransform.degrad(input.x);
        double d2000 = WCSTransform.degrad(input.y);
        double dr2000 = WCSTransform.degrad(pm.x);
        double dd2000 = WCSTransform.degrad(pm.y);
        double ur = dr2000 * pmf;
        double ud = dd2000 * pmf;
        double sr = Math.sin(r2000);
        double cr = Math.cos(r2000);
        double sd = Math.sin(d2000);
        double cd = Math.cos(d2000);
        double x = cr * cd;
        double y = sr * cd;
        double z = sd;
        v1[0] = x;
        v1[1] = y;
        v1[2] = z;
        if (ur != zero || ud != zero) {
            v1[3] = -(ur * y) - cr * sd * ud;
            v1[4] = ur * x - sr * sd * ud;
            v1[5] = cd * ud;
        } else {
            v1[3] = zero;
            v1[4] = zero;
            v1[5] = zero;
        }
        for (int i = 0; i < 6; ++i) {
            double w = zero;
            for (int j = 0; j < 6; ++j) {
                w += emi[j][i] * v1[j];
            }
            v2[i] = w;
        }
        x = v2[0];
        y = v2[1];
        z = v2[2];
        double xd = v2[3];
        double yd = v2[4];
        double zd = v2[5];
        double rxyz = Math.sqrt(x * x + y * y + z * z);
        z += a[2] * rxyz;
        xd += ad[0] * rxyz;
        yd += ad[1] * rxyz;
        zd += ad[2] * rxyz;
        double rxysq = (x += a[0] * rxyz) * x + (y += a[1] * rxyz) * y;
        double rxy = Math.sqrt(rxysq);
        if (x == zero && y == zero) {
            r1950 = zero;
        } else {
            r1950 = Math.atan2(y, x);
            if (r1950 < zero) {
                r1950 += d2pi;
            }
        }
        double d1950 = Math.atan2(z, rxy);
        if (rxy > tiny) {
            ur = (x * yd - y * xd) / rxysq;
            ud = (zd * rxysq - z * (x * xd + y * yd)) / ((rxysq + z * z) * rxy);
        }
        double dr1950 = ur / pmf;
        double dd1950 = ud / pmf;
        input.x = WCSTransform.raddeg(r1950);
        input.y = WCSTransform.raddeg(d1950);
        pm.x = WCSTransform.raddeg(dr1950);
        pm.y = WCSTransform.raddeg(dd1950);
        if (diag > 0) {
            double scon = WCSTransform.raddeg(3600.0);
            double tcon = WCSTransform.raddeg(240.0);
            double dra = tcon * (r1950 - r2000);
            double ddec = scon * (d1950 - d2000);
        }
        return input;
    }

    public static Point2D.Double fk425(Point2D.Double input) {
        Point2D.Double pm = new Point2D.Double(0.0, 0.0);
        return wcscon.fk425m(input, pm);
    }

    public static Point2D.Double fk425e(Point2D.Double input, double epoch) {
        Point2D.Double pm = new Point2D.Double(0.0, 0.0);
        Point2D.Double output = wcscon.fk425m(input, pm);
        output.x += pm.x * (epoch - 2000.0);
        output.y += pm.y * (epoch - 2000.0);
        return output;
    }

    public static Point2D.Double fk425m(Point2D.Double input, Point2D.Double pm) {
        double r2000;
        int i;
        int diag = 0;
        double[] r0 = new double[3];
        double[] r1 = new double[3];
        double[] v1 = new double[6];
        double[] v2 = new double[6];
        double d2pi = Math.PI * 2;
        double tiny = 1.0E-30;
        double zero = 0.0;
        double pmf = 1.296E8 / d2pi;
        double r1950 = WCSTransform.degrad(input.x);
        double d1950 = WCSTransform.degrad(input.y);
        double dr1950 = WCSTransform.degrad(pm.x);
        double dd1950 = WCSTransform.degrad(pm.y);
        double ur = dr1950 * pmf;
        double ud = dd1950 * pmf;
        double sr = Math.sin(r1950);
        double cr = Math.cos(r1950);
        double sd = Math.sin(d1950);
        double cd = Math.cos(d1950);
        r0[0] = cr * cd;
        r0[1] = sr * cd;
        r0[2] = sd;
        r1[0] = -sr * cd * ur - cr * sd * ud;
        r1[1] = cr * cd * ur - sr * sd * ud;
        r1[2] = cd * ud;
        double w = r0[0] * a[0] + r0[1] * a[1] + r0[2] * a[2];
        double wd = r0[0] * ad[0] + r0[1] * ad[1] + r0[2] * ad[2];
        for (i = 0; i < 3; ++i) {
            v1[i] = r0[i] - a[i] + w * r0[i];
            v1[i + 3] = r1[i] - ad[i] + wd * r0[i];
        }
        for (i = 0; i < 6; ++i) {
            w = zero;
            for (int j = 0; j < 6; ++j) {
                w += em[j][i] * v1[j];
            }
            v2[i] = w;
        }
        double x = v2[0];
        double y = v2[1];
        double z = v2[2];
        double xd = v2[3];
        double yd = v2[4];
        double zd = v2[5];
        double rxysq = x * x + y * y;
        double rxyzsq = rxysq + z * z;
        double rxy = Math.sqrt(rxysq);
        double spxy = x * xd + y * yd;
        if (x == zero && y == zero) {
            r2000 = zero;
        } else {
            r2000 = Math.atan2(y, x);
            if (r2000 < zero) {
                r2000 += d2pi;
            }
        }
        double d2000 = Math.atan2(z, rxy);
        if (rxy > tiny) {
            ur = (x * yd - y * xd) / rxysq;
            ud = (zd * rxysq - z * spxy) / (rxyzsq * rxy);
        }
        double dr2000 = ur / pmf;
        double dd2000 = ud / pmf;
        input.x = WCSTransform.raddeg(r2000);
        input.y = WCSTransform.raddeg(d2000);
        pm.x = WCSTransform.raddeg(dr2000);
        pm.y = WCSTransform.raddeg(dd2000);
        if (diag > 0) {
            double scon = WCSTransform.raddeg(3600.0);
            double tcon = WCSTransform.raddeg(240.0);
            double dra = tcon * (r2000 - r1950);
            double ddec = scon * (d2000 - d1950);
        }
        return input;
    }

    public static Point2D.Double fk42gal(Point2D.Double input) {
        double[] pos = new double[3];
        double[] pos1 = new double[3];
        double dra = input.x;
        double ddec = input.y;
        double rra = WCSTransform.degrad(dra);
        double rdec = WCSTransform.degrad(ddec);
        Point2D.Double pos0 = new Point2D.Double();
        Point2D.Double pos2 = new Point2D.Double();
        wcscon.jpcop(rra, rdec, 1.0, pos0, pos2);
        pos[0] = pos0.x;
        pos[1] = pos0.y;
        pos[2] = pos2.x;
        for (int i = 0; i < 3; ++i) {
            pos1[i] = pos[0] * bgal[i][0] + pos[1] * bgal[i][1] + pos[2] * bgal[i][2];
        }
        Point2D.Double rPos = new Point2D.Double();
        Point2D.Double r = new Point2D.Double();
        wcscon.jpcon(pos1, rPos, r);
        double dl = WCSTransform.raddeg(rPos.x);
        double db = WCSTransform.raddeg(rPos.y);
        input.x = dl;
        input.y = db;
        if (idg > 0) {
            // empty if block
        }
        return input;
    }

    public static Point2D.Double gal2fk4(Point2D.Double input) {
        double[] pos = new double[3];
        double[] pos1 = new double[3];
        double dl = input.x;
        double db = input.y;
        double rl = WCSTransform.degrad(dl);
        double rb = WCSTransform.degrad(db);
        Point2D.Double pos0 = new Point2D.Double();
        Point2D.Double pos2 = new Point2D.Double();
        wcscon.jpcop(rl, rb, 1.0, pos0, pos2);
        pos[0] = pos0.x;
        pos[1] = pos0.y;
        pos[2] = pos2.x;
        for (int i = 0; i < 3; ++i) {
            pos1[i] = pos[0] * bgal[0][i] + pos[1] * bgal[1][i] + pos[2] * bgal[2][i];
        }
        Point2D.Double rPos = new Point2D.Double();
        Point2D.Double r = new Point2D.Double();
        wcscon.jpcon(pos1, rPos, r);
        double dra = WCSTransform.raddeg(rPos.x);
        double ddec = WCSTransform.raddeg(rPos.y);
        input.x = dra;
        input.y = ddec;
        if (idg > 0) {
            // empty if block
        }
        return input;
    }

    public static Point2D.Double fk52gal(Point2D.Double input) {
        double[] pos = new double[3];
        double[] pos1 = new double[3];
        double dra = input.x;
        double ddec = input.y;
        double rra = WCSTransform.degrad(dra);
        double rdec = WCSTransform.degrad(ddec);
        Point2D.Double pos0 = new Point2D.Double();
        Point2D.Double pos2 = new Point2D.Double();
        wcscon.jpcop(rra, rdec, 1.0, pos0, pos2);
        pos[0] = pos0.x;
        pos[1] = pos0.y;
        pos[2] = pos2.x;
        for (int i = 0; i < 3; ++i) {
            pos1[i] = pos[0] * jgal[i][0] + pos[1] * jgal[i][1] + pos[2] * jgal[i][2];
        }
        Point2D.Double rPos = new Point2D.Double();
        Point2D.Double r = new Point2D.Double();
        wcscon.jpcon(pos1, rPos, r);
        double dl = WCSTransform.raddeg(rPos.x);
        double db = WCSTransform.raddeg(rPos.y);
        input.x = dl;
        input.y = db;
        if (idg > 0) {
            // empty if block
        }
        return input;
    }

    public static Point2D.Double gal2fk5(Point2D.Double input) {
        double[] pos = new double[3];
        double[] pos1 = new double[3];
        double dl = input.x;
        double db = input.y;
        double rl = WCSTransform.degrad(dl);
        double rb = WCSTransform.degrad(db);
        Point2D.Double pos0 = new Point2D.Double();
        Point2D.Double pos2 = new Point2D.Double();
        wcscon.jpcop(rl, rb, 1.0, pos0, pos2);
        pos[0] = pos0.x;
        pos[1] = pos0.y;
        pos[2] = pos2.x;
        for (int i = 0; i < 3; ++i) {
            pos1[i] = pos[0] * jgal[0][i] + pos[1] * jgal[1][i] + pos[2] * jgal[2][i];
        }
        Point2D.Double rPos = new Point2D.Double();
        Point2D.Double r = new Point2D.Double();
        wcscon.jpcon(pos1, rPos, r);
        double dra = WCSTransform.raddeg(rPos.x);
        double ddec = WCSTransform.raddeg(rPos.y);
        input.x = dra;
        input.y = ddec;
        if (idg > 0) {
            // empty if block
        }
        return input;
    }

    protected static void jpcon(double[] pos, Point2D.Double rPos, Point2D.Double r) {
        double x = pos[0];
        double y = pos[1];
        double z = pos[2];
        rPos.x = Math.atan2(y, x);
        if (rPos.x < 0.0) {
            rPos.x += Math.PI * 2;
        }
        double rxy2 = x * x + y * y;
        double rxy = Math.sqrt(rxy2);
        rPos.y = Math.atan2(z, rxy);
        double z2 = z * z;
        r.x = Math.sqrt(rxy2 + z2);
    }

    protected static void jpcop(double rra, double rdec, double r, Point2D.Double result0, Point2D.Double result2) {
        result0.x = r * Math.cos(rra) * Math.cos(rdec);
        result0.y = r * Math.sin(rra) * Math.cos(rdec);
        result2.x = r * Math.sin(rdec);
    }

    public static Point2D.Double fk4prec(double ep0, double ep1, Point2D.Double input) {
        double rra = WCSTransform.degrad(input.x);
        double rdec = WCSTransform.degrad(input.y);
        double[][] pm = wcscon.mprecfk4(ep0, ep1);
        double[] v1 = slasubs.slaDcs2c(rra, rdec);
        double[] v2 = slasubs.slaDmxv(pm, v1);
        Point2D.Double rPoint = slasubs.slaDcc2s(v2);
        rra = rPoint.x;
        rdec = rPoint.y;
        rra = slasubs.slaDranrm(rra);
        input.x = WCSTransform.raddeg(rra);
        input.y = WCSTransform.raddeg(rdec);
        return input;
    }

    public static Point2D.Double fk5prec(double ep0, double ep1, Point2D.Double input) {
        double rra = WCSTransform.degrad(input.x);
        double rdec = WCSTransform.degrad(input.y);
        double[][] pm = wcscon.mprecfk5(ep0, ep1);
        double[] v1 = slasubs.slaDcs2c(rra, rdec);
        double[] v2 = slasubs.slaDmxv(pm, v1);
        Point2D.Double rPoint = slasubs.slaDcc2s(v2);
        rra = rPoint.x;
        rdec = rPoint.y;
        rra = slasubs.slaDranrm(rra);
        input.x = WCSTransform.raddeg(rra);
        input.y = WCSTransform.raddeg(rdec);
        return input;
    }

    public static double[][] mprecfk4(double bep0, double bep1) {
        double bigt = (bep0 - 1850.0) / 100.0;
        double t = (bep1 - bep0) / 100.0;
        double tas2r = t * 4.84813681109536E-6;
        double w = 2303.5548 + (1.3972 + 5.9E-5 * bigt) * bigt;
        double zeta = (w + (0.30242 - 2.69E-4 * bigt + 0.017996 * t) * t) * tas2r;
        double z = (w + (1.09478 + 3.87E-4 * bigt + 0.018324 * t) * t) * tas2r;
        double theta = (2005.1125 + (-0.85294 - 3.65E-4 * bigt) * bigt + (-0.42647 - 3.65E-4 * bigt - 0.041802 * t) * t) * tas2r;
        return slasubs.slaDeuler("ZYZ", -zeta, theta, -z);
    }

    public static double[][] mprecfk5(double ep0, double ep1) {
        double t0 = (ep0 - 2000.0) / 100.0;
        double t = (ep1 - ep0) / 100.0;
        double tas2r = t * 4.84813681109536E-6;
        double w = 2306.2181 + (1.39656 - 1.39E-4 * t0) * t0;
        double zeta = (w + (0.30188 - 3.44E-4 * t0 + 0.017998 * t) * t) * tas2r;
        double z = (w + (1.09468 + 6.6E-5 * t0 + 0.018203 * t) * t) * tas2r;
        double theta = (2004.3109 + (-0.8533 - 2.17E-4 * t0) * t0 + (-0.42665 - 2.17E-4 * t0 - 0.041833 * t) * t) * tas2r;
        return slasubs.slaDeuler("ZYZ", -zeta, theta, -z);
    }
}

