#!/bin/tcsh

#
# This script will generate the JavaHelp index information for the files in
# this directory.  The results will be stored in the JavaHelpSearch 
# subdirectory.
#
# The script assumes the location of the JavaHelp installation is
# /usr/local/jh2.0.  If it is somewhere else, then set the JAVAHELP_HOME
# environment variable to that location before running the script.
#

if (! ${?JAVAHELP_HOME}) then
   setenv JAVAHELP_HOME /usr/local/jh2.0/
endif


if (-e $JAVAHELP_HOME/javahelp/bin/jhindexer) then

   rm JavaHelpSearch/* >& /dev/null
   $JAVAHELP_HOME/javahelp/bin/jhindexer .

else

   echo
   echo "Error:"
   echo "Please define JAVAHELP_HOME to be the location of the JavaHelp installation."
   echo "(E.g., /cygdrive/c/jh2.0/)"
   exit 1

endif
