% -------------------------------------------------------------------------
%
%     saltproposal.cls
%
%     a LaTeX2e document class for creating the scientific/technical
%     rationale for a SALT Phase 1 proposal
%
%     Keith Smith (Nottingham)
%     Christian Hettlage (SAAO)
%     Bruno Letarte (SAAO)
%     Steve Crawford (SAAO)
%
%     Any questions and comments should be directed to
%     salthelp@saao.ac.za.
%
%     History:
%     v. 0.1 (1 July 2011): initial attempt
%     v. 0.2 (17 December 2013): added box for completion requirements
%     v. 0.3 (2 July 2014): added support for partnership proposals
%
% -------------------------------------------------------------------------

%  ---------------------------- identification  ---------------------------
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{saltproposal}[2014/07/02 LaTeX2e class for creating the scientific/technical rationale for SALT Phase 1 proposals]

% --------------------------- processing options --------------------------
\DeclareOption* {\PassOptionsToClass{\CurrentOption}{article}}
\PassOptionsToClass{a4paper}{article}
\ProcessOptions \relax

% -------------------------- extend article class -------------------------
\LoadClass{article}

% ------------------------------- main code -------------------------------
\usepackage{framed}

\pagestyle{empty}

% Set some lengths.
% Please don't change these values.
\textwidth16.4cm
\FrameSep0.3cm
\oddsidemargin-0.24cm
\textheight23.6cm
\topmargin-1.8cm
\parindent0mm

\newlength{\PageTextwidth}
\setlength{\PageTextwidth}{\textwidth}
	
\newlength{\ReferenceColumnWidth}
\setlength{\ReferenceColumnWidth}{7.5cm}
	
\newlength{\ReferenceColumnGap}
\setlength{\ReferenceColumnGap}{\PageTextwidth}
\addtolength{\ReferenceColumnGap}{-2\FrameSep}
\addtolength{\ReferenceColumnGap}{-2\ReferenceColumnWidth}

% A pair of references.
\newcommand{\ReferencePair}[2]
	{
		\noindent\parbox[t]{\ReferenceColumnWidth}{#1}\hspace{\ReferenceColumnGap}\parbox[t]{\ReferenceColumnWidth}{#2}
	}
	
% A fancy framed box containing a section.
\newenvironment{SectionBox}[2]
	{
		\begin{framed}
			\hspace*{1mm}\\[-1.7ex]
			\noindent\textbf{\theSectionBoxCounter\stepcounter{SectionBoxCounter}.\hspace{1cm}#1}\\
			{\em #2}\\[-1ex]
			\hspace*{-\FrameSep}\rule[0pt]{\PageTextwidth}{0.4pt}\\[0.3ex]
			\noindent
	}
	{
		\end{framed}
	}
	
% Counter for the section boxes.
\newcounter{SectionBoxCounter}
\setcounter{SectionBoxCounter}{15}

% A framed boxed containing an introduction.
\newcommand{\Introduction}
	{
		\begin{framed}
			\hspace*{1mm}\\[-1.7ex]
			\noindent\textbf{The following sections have been generated by the PI. The total page limit for these sections is 4 $\times$ A4 pages (6 $\times$ A4 pages for Partnership Proposals). Font size should not be less than 10 points.}\\[-3ex]	
		\end{framed}
	}

% A framed box containing the scientific rationale.
\newcommand{\ScientificRationale}[1]
	{
		\begin{SectionBox}
			{SCIENTIFIC RATIONALE}
			{This section needs to discuss the scientific background and aims of the proposal and why you want to make these observations. This section should not exceed 1000 words (2000 words for Partnership Proposals). Figures and graphics can be included, or appended in Section 21.}
			{#1}
		\end{SectionBox}
	}

% A framed box containing the immediate objectives.
\newcommand{\ImmediateObjectives}[1]
	{
		\begin{SectionBox}
			{IMMEDIATE OBJECTIVES}
			{This section needs to present the plan of how you will use the data you will gather to achieve the science goals set out above. There is a 250 word limit.}
			{#1}
		\end{SectionBox}
	}

% A framed box containing the immediate objectives.
\newcommand{\ManagementPlan}[1]
        {
                \begin{SectionBox}
                        {MANAGEMENT PLAN}
                        {This section needs to present the plan of how you will use the data you will gather to achieve the science goals set out above. This should include a detailed schedule and how different members will contribute to the program.}
                        {#1}
                \end{SectionBox}
        }


% A framed box containing the immediate objectives.
\newcommand{\CompletionRequirements}[1]
	{
		\begin{SectionBox}
			{DATA REQUIREMENTS FOR PROPOSAL COMPLETION}
			{This section should explain what (if any) other observations are needed to complete the science objectives. If time is requested for more than one semester, the justification should be here. There is a 100 word limit.}
			{#1}
		\end{SectionBox}
	}

% A framed box containing the technical justification.
\newcommand{\TechnicalJustification}[1]
	{
		\begin{SectionBox}
			{TECHNICAL JUSTIFICATION}
			{This section should be limited to 500 words (1000 words for Partnership
Proposals)  and needs to clearly demonstrate that you have used the SALT instrument simulation tools to find a configuration which makes sense and matches your science goals, including the S/N required. It needs to verbalize the overall observing strategy and to demonstrate that you understand the overheads involved in the observations and hence a justification of the total time requested.}
			{#1}
		\end{SectionBox}
	}

% A framed box containing the technical justification.
\newcommand{\SALTImpact}[1]
        {
                \begin{SectionBox}
                        {GREATER IMPACT}
                        {This section should state the wider impact this program will have.  This includes the uniqueness of the program, contributions to SALT, and contributions to the greater community. There is a 500 word limit.}
                        {#1}
                \end{SectionBox}
        }

	
% A framed box containing the summary of previous proposals.
\newcommand{\PreviousProposals}[1]
	{
		\begin{SectionBox}
			{SUMMARY OF PREVIOUS SALT RESULTS}
			{This section should discuss previous time allocations by SALT to this PI and related proposals. Please include the relevant proposal codes, times and priorities awarded, times realized and a summary of the results and/or publications. If you request time from the South African TAC, please also include the same information for all Co-Investigators.}
			{#1}
		\end{SectionBox}
	}
	
% A framed box containing the role of the proposal.
\newcommand{\RoleOfPI}[1]
	{
		\begin{SectionBox}
			{ROLE OF THE PI}
			{This section, which is only required if you request time from the South African TAC, should describe the role the PI will have in the project other than proposing and being a co-author on the proposal and the published paper.}
			{#1}
		\end{SectionBox}
	}

% A framed box containing the references.
\newcommand{\References}[1]
	{
		\begin{SectionBox}
			{REFERENCES}
			{A list of all relevant references.}
			{#1}
		\end{SectionBox}
	}

% A framed box containing any additional figures and graphics.
\newcommand{\AdditionalFigures}[1]
	{
		\begin{SectionBox}
			{ADDITIONAL RELEVANT FIGURES AND GRAPHICS}
			{Any additional figures or graphics not already inserted in the text boxes can be placed here, provided the 4 page limit (or 6 page limit for Partnership Proposals) is maintained.}
			{#1}
		\end{SectionBox}
	}
	
% Output the introduction.
\AtBeginDocument{\Introduction}
