% ------------------------------------------------------
%
% SALT Phase I Proposal Template
%
% This templates uses the saltproposal document class.
% You will need the "framed" LaTeX package to use it.
%
% Please email salthelp@saao.ac.za if you
% have any questions about this template.
%
% ------------------------------------------------------

% Do not change these options
\documentclass[10pt]{saltproposal}

\usepackage{lmodern}
\usepackage[T1]{fontenc}

\usepackage{graphicx}
\usepackage{epstopdf}

\begin{document}
	
	%
	% IMPORTANT:
	%
	% You cannot use floating environments such as the figure or
	% table environment.
	%
	%
	% In order to see what details are expected in the various
	% sections, have a look at the PDF output.
	%
	
	% Scientific rationale.
	\ScientificRationale{
		% Insert your scientific rationale here.
According to the present paradigm acting within the LCDM cosmological model,
galaxies form hierarchically, from dwarfs to giants, by consequent mergers.
Morphological differences between spheroidal (elliptical, following Hubble's
classification scheme) and disk (spiral and lenticular) galaxies are explained
in the frame of this paradigm by episodes of smooth pristine gas accretion from 
their own galactic halos, occuring between the merging events; disk galaxies are
those which are caught during these quiescent periods of their lifes. However,
in the frame of this classical scenario the giant elliptical galaxies must
be the youngest, and dwarf galaxies must be the oldest. In reality, observations
demonstrate the opposite trend: the giant early-type galaxies have the oldest
stellar populations and have been completely shaped at the epoch before $z=1$, 
while the low-luminosity galaxies continues their star formation to the present
epoch.

There is common opinion that lenticular galaxies have formed from spirals
by quenching star formation in their disks under the environmental influence.
The so called Butcher-Oemler (1978) effect -- an appearance of blue disk galaxies
at the redshift of 0.4 in rich clusters which lack such blue galaxies at $z=0$ --
is treated now as an observational evidence of a rather recent epoch of
S0 formation. Since blue (spiral?) disk galaxies are replaced in clusters 
by red (S0) disk galaxies at $z=0.4$ (Fasano et al. 2000), or only 4 Gyr ago 
according to the cosmological timescale in the frame of LCDM model, then the stellar 
population of the large-scale disks of S0s in present-day clusters must be of intermediate
age. Also in the frame of this paradigm we would expect solar magnesium-to-iron
ratio in stars of the disks because during 10 Gyr before the transformation
continuous star formation in the disks would produce just the solar chemical
composition, if we refer to the disks of nearby spiral galaxies.

{\bf Dating of morphological transformations of S0s.} One possible way to
trace the evolution of galaxies is to study in detail the properties of
stellar populations in nearby galaxies which can be observed with a very high
accuracy. Concerning the problem under consideration, we can determine the
present ages of the large-scale stellar disks in nearby S0s and so to date
the epoch of star formation quenching, if any took place. We have undertaken deep long-slit
spectroscopy of a small sample of nearby S0s over diverse types of environments
at the Russian 6m telescope. We have found that 60\%$\pm$13\%\ of the sample
S0s have very old outer disks (see left panel of Fig.1),
with the quenching epoch of at least 10 Gyr ago
and in addition to that are magnesium-overabundant and were therefore formed 
over a short period of time (Sil'chenko et al. 2012).
Though the sample was very small, only 20 galaxies, we have had a hint on an
environmental tendecy in our results: field S0s may have rather young stellar
disks, $T_{SSP}\approx 8$~Gyr, while all the galaxies in dense environments, in Virgo
cluster and in rich groups, have very old large-scale stellar disks.
Similar results were obtained in the frame of multi-band photometry approach 
by Prochaska Chamberlain et al. (2011) and Roediger et al. (2011). This fact
is in contradiction with the scenario according to which S0s were born in clusters
at $z=0.4$. Following these results, the epoch of S0 formation must be put at
$z>2$, and had therefore to be very short. Keeping it in mind, we would rather prefer
to accept the following sequence of evolutionary stages for massive disk galaxies 
which is indeed observed at high redshifts:
brief effective star formation in gas-rich clumpy disks at $z\approx 2$ (Bournaud et al. 
2007) and more quiescent secular evolution including bar effects and gas redistribution
between the disk and the bulge area at $z<1$ (Kraljic et al. 2012). 
By accepting the described
evolutionary scenario for disk galaxies, we would expect a dominance of S0-galaxies
among disk galaxies between $z=2$ and $z=1$, after finishing the epoch of star-forming
clumpy disks, and their subsequent morphological evolution completely depending 
on the external gas accretion regime. If this accretion is smooth and persistent,
we would obtain a spiral galaxy with the cold, thin stellar disk and a continuous
star formation. If, due to some obstacles, the accretion is absent or sporadic,
we would obtain a lenticular galaxy with a smooth, old stellar disk and without regular 
star formation. Obviously, clusters of galaxies, with their tidal perturbances and hot intracluster
medium, are the worst place to sustain smooth accretion of the outer
cold gas, which would cause the S0 galaxies, with old stellar disks, to dominate in the clusters at our epoch.
 
{\bf Environmental effect.} It is very important to verify whether the age of S0 disks
correlates with the environmental density. The present-day paradigm relates S0
formation by SF quenching in spiral disks to environment effects which are
effective only in clusters and rich groups: ram pressure by X-ray gas, gravitational
tides from neighboring galaxies and from the cluster/group potential which are
thought to be main agents of gas removal and SF quenching, all act only
in dense environments. According to the hierarchical paradigm of the modern
cosmology, the clusters and massive groups are the last to assemble their content,
so the disks of S0s in clusters must be {\bf the youngest}. If the relation is opposite,
as our recent results imply, the scenario must be revisited. Presently, we
have two S0 samples studied: (1) a sample of $\sim$20 nearby S0s mostly in loose groups, where
two thirds of the disks are older than 10~Gyr, and (2) a sample of 19 completely
isolated S0s mostly observed with SALT during three semesters (Katkov, Kniazev, Silchenko 2014),
where the ages of the disks cover homogeneously the range of 1--15~Gyr (see right panel of Fig.1).
Now is \underline{\bf the time} to probe another extremity
of the environment -- S0s in clusters.
	}
	
	% Immediate objectives.
	\ImmediateObjectives{
		% Insert your immediate objectives here.
By using {\bf the same method as for the sample of completely isolated SOs}, we plan to obtain
long-slit spectra for a sample of nearby S0 galaxies in clusters:
in the full spectral
range (3700--6900~\AA) with medium spectral resolution ($R\sim 1000$).
The spectra will be used to derive stellar population ages, metallicities,
and magnesium-to-iron ratios by (1) calculating Lick indices along the slit, (see right panel of Fig.2),
the method for RSS with this grating and slit which was calibrated by Kniazev \& Silchenko (2012)
and
(2) to perform full spectral fitting of the observed spectra,
using {IDL}-based package \textsc{NBursts} (see left panel of Fig.2)
from Chilingarian et al. (2007).
The exposures must be deep enough to reach the outermost disk
regions. The proposed sample of the galaxies includes members of 8 southern
rich clusters. We have selected 4--7 S0 (according to NED) galaxies in every cluster, 
taking them from the range of absolute magnitudes of $M_B=-18 - -20.5$, therewith making sure that they
are not dwarfs, while at the same time not relating to very luminous S0s which may have
quite particular origin beyond the common evolutionary paths of disk galaxies
(Van den Bergh 1990, Barway et al. 2009).
	}
	
    % Completion requirements.
    \CompletionRequirements {
        % Insert your data requirements for completing the proposal here.
As it was written above, (1) a sample of nearby S0s mostly in loose groups
consists of 15 galaxies (Sil'chenko et al. 2012);
(2) a sample of completely isolated S0s consists of 19 galaxies
(Katkov, Kniazev, Silchenko 2014).
For that reason, we would finally like to have the same level of statistic and
plan to have deep long-slit data for $\sim$20 S0s in clusters from our total sample
of 48 galaxies in the submitted list.
    } 
	
	% Technical justification.
	\TechnicalJustification{
		% Insert your technical justification here.
For the accurate derivation of stellar population ages and metallicities (see Fig.2)
we need {\bf (1)} to cover a spectral range 4700--5600~\AA\ with a high
signal-to-noise (S/N) ratio;
{\bf (2)} to have the highest medium spectral resolution ($R > 1000$)
to estimate velocity dispersion;
and {\bf (3)} to reach a reasonable S/N ratio during a reasonable amount of
integration time. All these requirements can be met with the RSS spectrograph
at the SALT, using grating GR900 and slit 1.25 arcsec width.

For the accurate derivation of gas kinematics, metallicities and densities
we need to cover a spectral range 4300--6750~\AA\ with a high signal-to-noise ratio (see Fig.2).

The RSS simulator allows us to estimate the final S/N$\sim$15 at $\lambda$5500 \AA\
for the level $\mu(V) \sim 22.0$~mag/sq.arcsec (some outer part of the disk)
with dark moon conditions, seeing about 2.0--3.0 arcsec, slit width of 1.25 arcsec
and exposure times $6\times 1400$sec.
We also require observations of spectrophotometric standards, 
as minimum once per observational set, and a reference spectrum together with
flat-fields once per track.

All our previously taken SALT data proves that our selected spectral region
and spectral resolution are
enough to study the kinematic of stars and gas separately (Fig.2).
To derive a statistically significant result we plan to collect data for the sample
consisting of 20 galaxies from nearest clusters.
All our clusters with the exception of Abell S0805 have coordinates where the REAL track length
is ABOUT 3600s.
With one hour track ($\sim$3600s) we can observe each galaxy for about $2\times 1400$sec
and therefore we need 3 tracks to reach the requested S/N.
For that reason we apply for a total of 216000sec of dark time for this project.

All clusters are located in the range of RA = 01h--19h leading to our application
for this program as {\bf a long-term program}, where we plan to split the total
requested time into two semesters with 108000sec each.
	}
	
	% Role of the PI.
	\RoleOfPI{
		% Insert the role of the PI here.
This project is a result of long-term collaboration between PI and Prof. Olga Sil'chenko.
All spectral data reduction will be done by PI.
Lick index measurements and analysis will be done by Prof. Sil'chenko
and \textsc{NBursts} analysis will be done with help of her team.
The PI is involved in the subsequent data analysis and discussions.
	}

	% References.
	\References{
		% Insert your references here.
		% References are added in pairs:
		%
		% \ReferencePair{A}{B}
		%
		% A appears in the left column, B in the right column.
		%
		% Examples:
		% \ReferencePair
		%    {Binette et al. 1994, A\&A, 292, 13}
		%    {Finkelman et al. 209, MNRAS, 390,  969}
		% \ReferencePair
		%    {de Zeeuw \& Merritt, 1989, ApJ, 343, 617}
		%    {}
\ReferencePair
{F. Bournaud, B.C. Elmegreen, D.M. Elmegreen, 2007, ApJ, 670, 237}
{K. Kraljic, F. Bournaud, M. Martig, 2012, ApJ, 757, Aid60}
\ReferencePair
{S. Barway, Y. Wadadekar, A.K. Kembhavi, Y.D. Mayya, 2009, MNRAS, 394, 1991}
{S. van den Bergh, 1990, ApJ, 348, 57}
\ReferencePair
{H. Butcher, A. Oemler Jr., 1978, ApJ, 219, 18}
{H. Butcher, A. Oemler Jr., 1978, ApJ, 226, 559}
\ReferencePair
{L.C. Prochaska Chamberlain, et al., 2011, MNRAS, 412, 423}
{J.C. Roediger, S. Courteau, L.A. MacArthur, M. McDonald, 2011,
MNRAS, 416, 1996}
\ReferencePair
{ G. Fasano, et al., 2000, ApJ,  542,  673}
{O.K. Sil'chenko, I.S. Proshina, A.P. Shulga, S.E. Koposov, 2012, MNRAS, 427, 790}
\ReferencePair
{Kniazev et al. 2005, AJ, 130, 1558}
{Kniazev et al. 2008, MNRAS, 388, 1667}
\ReferencePair
{Kniazev et al. 2004b, ApJS, 153, 429}
{Katkov, Kniazev, Silchenko 2014, in preparation}
\ReferencePair
{Chilingarian et al. 2007, IAU Symposium, V.241, 175-176}
{Kniazev \& Sil'chenko, 2012, SALT report 2202AA0001}
	}
	
	\AdditionalFigures{
		% Insert any additional figures and graphics here.
		%
		% Allowable file types are:
		% If you are compiling using PDFLaTeX: JPG, PNG, PDF, EPS
		% If you are compiling with plain LaTeX: EPS only
		%
		% Example:
		% \includegraphics[height=200px]{Filename.eps}
\vbox{
\begin{center}
    \includegraphics[clip=,angle=-0,width=7.0cm]{F9.medium.ps}
    \includegraphics[clip=,angle=-0,width=8.0cm]{plot_ages.ps}

{{\bf Fig\,1:}
The comparison of the obtained SSP-equivalent ages of the discs and bulges in our samples of S0s.
The equality straight line is plotted for the reference.
{\it Left panel:} Results from Sil'chenko et al. (2012) for a sample of nearby
S0s in loose groups;
{\it Right panel:} Results from Katkov, Kniazev \& Sil'chenko (2014) for a sample
of completely isolated S0s.
}
\end{center}
}

\vbox{
\begin{center}
    \includegraphics[clip=,angle=-0,width=4.5cm]{n4240_average_full.ps}
    \includegraphics[clip=,angle=-0,width=6.0cm]{n4240_mgfe.eps}

{{\bf Fig\,2:}
Example of SALT data analysis for galaxy NGC\,4240 from Katkov, Kniazev \& Silchenko (2014).
{\it Left panel:} Package \textsc{NBursts}: black dots are for stars and red dots
are for gas.
{\it Right panel:} Lick indices -- the diagnostic $<Fe>$ versus Mgb diagram.
The SSP models by Thomas, Maraston \& Bender (2003) for three different magnesium-to-iron ratios
and three different ages are plotted as reference.
The small signs along the model curves mark the metallicities.
}
\end{center}
}
	}
	
\end{document}