/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.auth.ssl;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;

public class BasicX509KeyManager
implements X509KeyManager {
    private X509KeyManager keyManager;
    private String alias;

    public BasicX509KeyManager(X509KeyManager km, String alias) {
        this.keyManager = km;
        this.alias = alias;
    }

    @Override
    public String chooseClientAlias(String[] strings, Principal[] prncpls, Socket socket) {
        String ret = this.keyManager.chooseClientAlias(strings, prncpls, socket);
        if (ret == null) {
            ret = this.alias;
        }
        return ret;
    }

    @Override
    public String chooseServerAlias(String string, Principal[] prncpls, Socket socket) {
        String ret = this.keyManager.chooseServerAlias(string, prncpls, socket);
        return ret;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        X509Certificate[] ret = this.keyManager.getCertificateChain(alias);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] prncpls) {
        String[] ret = this.keyManager.getClientAliases(keyType, prncpls);
        return ret;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        PrivateKey pk = this.keyManager.getPrivateKey(alias);
        return pk;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] prncpls) {
        String[] ret = this.keyManager.getServerAliases(keyType, prncpls);
        return ret;
    }
}

