/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.auth;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import uk.ac.starlink.auth.AuthUtil;
import uk.ac.starlink.auth.UserPass;

public abstract class UserInterface {
    private Component parent_;
    public static final UserInterface CLI = UserInterface.createCli();
    public static final UserInterface GUI = UserInterface.createGui();
    public static final UserInterface NO_AUTH = UserInterface.createNone();
    public static final String USERNAME_PROP = "auth.username";
    public static final String PASSWORD_PROP = "auth.password";
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.auth");

    public abstract UserPass readUserPassword(String[] var1);

    public abstract void message(String[] var1);

    public abstract boolean canRetry();

    public void setParent(Component parent) {
        this.parent_ = parent;
    }

    public Component getParent() {
        return this.parent_;
    }

    private static UserInterface createGui() {
        String winTitle = "Authentication";
        return new UserInterface(){

            @Override
            public boolean canRetry() {
                return true;
            }

            @Override
            public void message(String[] lines) {
                JOptionPane.showMessageDialog(this.getParent(), lines, "Authentication", 1);
            }

            @Override
            public UserPass readUserPassword(String[] msgLines) {
                JTextField userField = new JTextField();
                JPasswordField passField = new JPasswordField();
                JComponent authPanel = 1.createAuthPanel(msgLines, userField, passField);
                UserInterface.setGrabFocusInDialog(userField);
                Object[] options = new String[]{"Authenticate", "Anonymous"};
                int response = JOptionPane.showOptionDialog(this.getParent(), authPanel, "Authentication", -1, 3, null, options, options[0]);
                if (response == 0) {
                    String user = userField.getText();
                    return user != null && user.trim().length() > 0 ? new UserPass(user, passField.getPassword()) : null;
                }
                return null;
            }
        };
    }

    public static UserInterface createFixed(String username, String password) {
        return UserInterface.createFixed(new UserPass(username, password.toCharArray()));
    }

    public static UserInterface createFixed(final UserPass userpass) {
        return new UserInterface(){

            @Override
            public boolean canRetry() {
                return false;
            }

            @Override
            public void message(String[] lines) {
                logger_.info("Auth message: " + String.join((CharSequence)"; ", lines));
            }

            @Override
            public UserPass readUserPassword(String[] msgLines) {
                String line = String.join((CharSequence)"; ", msgLines);
                if (userpass != null) {
                    logger_.warning("Auth: " + line);
                    logger_.warning("Auth: supplied credentials for user " + userpass.getUsername());
                } else {
                    logger_.info("Auth: " + line);
                    logger_.info("Auth: no credentials");
                }
                return userpass;
            }
        };
    }

    public static UserInterface getPropertiesUi() {
        return UserInterface.getPropertiesUi(USERNAME_PROP, PASSWORD_PROP);
    }

    public static UserInterface getPropertiesUi(String userProp, String passProp) {
        String user = UserInterface.readPropertyText(userProp);
        String pass = UserInterface.readPropertyText(passProp);
        return user != null && pass != null ? UserInterface.createFixed(user, pass) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readPropertyText(String propName) {
        String propval = System.getProperty(propName);
        if (propval == null) {
            return null;
        }
        if (propval.length() > 0 && propval.charAt(0) == '@') {
            File f = new File(propval.substring(1));
            if (f.exists()) {
                BufferedReader rdr = null;
                try {
                    rdr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), AuthUtil.UTF8));
                    String line = rdr.readLine();
                    logger_.config("Read credential from file " + f);
                    String string = line;
                    return string;
                }
                catch (IOException e) {
                    logger_.log(Level.WARNING, "Error reading credential file " + f, e);
                    String string = null;
                    return string;
                }
                finally {
                    if (rdr != null) {
                        try {
                            rdr.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            logger_.warning("No such credential file " + f);
            return null;
        }
        return propval;
    }

    private static UserInterface createCli() {
        return new UserInterface(){

            @Override
            public boolean canRetry() {
                return true;
            }

            @Override
            public void message(String[] lines) {
                for (String line : lines) {
                    System.console().writer().println(line);
                }
            }

            @Override
            public UserPass readUserPassword(String[] msgLines) {
                Console console = System.console();
                PrintWriter writer = console.writer();
                for (String line : msgLines) {
                    console.writer().println(line);
                }
                String user = console.readLine("Username: ", new Object[0]);
                char[] pass = console.readPassword("Password: ", new Object[0]);
                return !(user != null && user.trim().length() != 0 || pass != null && pass.length != 0) ? null : new UserPass(user, pass);
            }
        };
    }

    private static UserInterface createNone() {
        return new UserInterface(){

            @Override
            public boolean canRetry() {
                return false;
            }

            @Override
            public void message(String[] lines) {
                logger_.info("Auth: " + String.join((CharSequence)"; ", lines));
            }

            @Override
            public UserPass readUserPassword(String[] msgLines) {
                logger_.warning("Auth: " + String.join((CharSequence)"; ", msgLines));
                logger_.warning("Auth: user interaction declined");
                return null;
            }
        };
    }

    public static JComponent createAuthPanel(String[] msgLines, JTextField userField, JPasswordField passField) {
        GridBagLayout layer = new GridBagLayout();
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 17;
        gc.weightx = 0.0;
        gc.gridy = 0;
        gc.fill = 2;
        JPanel panel = new JPanel(layer);
        for (String line : msgLines) {
            JLabel txtLabel = new JLabel(line);
            gc.gridwidth = 0;
            gc.insets = new Insets(0, 0, 3, 0);
            layer.setConstraints(txtLabel, gc);
            panel.add(txtLabel);
            ++gc.gridy;
        }
        gc.gridwidth = 1;
        JLabel userLabel = new JLabel("User: ");
        gc.insets = new Insets(5, 0, 5, 0);
        gc.gridx = 0;
        layer.setConstraints(userLabel, gc);
        panel.add(userLabel);
        gc.gridx = 1;
        gc.weightx = 1.0;
        layer.setConstraints(userField, gc);
        panel.add(userField);
        gc.weightx = 0.0;
        ++gc.gridy;
        JLabel passLabel = new JLabel("Password: ");
        gc.insets = new Insets(0, 0, 0, 0);
        gc.gridx = 0;
        layer.setConstraints(passLabel, gc);
        panel.add(passLabel);
        gc.gridx = 1;
        gc.weightx = 1.0;
        layer.setConstraints(passField, gc);
        panel.add(passField);
        gc.weightx = 0.0;
        ++gc.gridy;
        return panel;
    }

    private static void setGrabFocusInDialog(JComponent component) {
        component.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent evt) {
                final Component c = evt.getComponent();
                if (c.isShowing() && (evt.getChangeFlags() & 4L) != 0L) {
                    Window toplevel = SwingUtilities.getWindowAncestor(c);
                    toplevel.addWindowFocusListener(new WindowAdapter(){

                        @Override
                        public void windowGainedFocus(WindowEvent evt2) {
                            c.requestFocus();
                        }
                    });
                }
            }
        });
    }
}

