/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.auth;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public abstract class Redirector {
    private static final String LOCATION_HEADER = "Location";
    public static final Redirector DEFAULT = Redirector.createStandardInstance(new int[]{301, 302, 303, 307, 308});
    public static final Redirector NO_REDIRECT = Redirector.createStandardInstance(new int[0]);

    public abstract boolean isRedirect(int var1);

    public abstract boolean willRedirect(String var1, String var2);

    public URL getRedirectUrl(URLConnection conn) throws IOException {
        HttpURLConnection hconn;
        int hcode;
        if (conn instanceof HttpURLConnection && this.isRedirect(hcode = (hconn = (HttpURLConnection)conn).getResponseCode())) {
            URL url1;
            URL url0 = hconn.getURL();
            String loc1 = hconn.getHeaderField(LOCATION_HEADER);
            if (loc1 == null || loc1.trim().length() == 0) {
                throw new IOException("No Location field for " + hcode + " response (" + url0 + ")");
            }
            try {
                url1 = new URL(loc1);
            }
            catch (MalformedURLException e) {
                throw (IOException)new IOException("Bad Location field for " + hcode + " response: " + loc1).initCause(e);
            }
            String proto0 = url0.getProtocol().toLowerCase();
            String proto1 = url1.getProtocol().toLowerCase();
            if (!this.willRedirect(proto0, proto1)) {
                throw new IOException("Refuse to redirect " + proto0 + " URL to " + proto1);
            }
            return url1;
        }
        return null;
    }

    public static Redirector createStandardInstance(int[] redirectCodes) {
        final int[] rcodes = (int[])redirectCodes.clone();
        return new Redirector(){

            @Override
            public boolean isRedirect(int responseCode) {
                for (int redirCode : rcodes) {
                    if (responseCode != redirCode) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean willRedirect(String fromProto, String toProto) {
                return !"https".equalsIgnoreCase(fromProto) || "https".equalsIgnoreCase(toProto);
            }
        };
    }
}

