/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.auth;

import java.io.IOException;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.starlink.auth.AuthContext;
import uk.ac.starlink.auth.AuthScheme;
import uk.ac.starlink.auth.AuthUtil;
import uk.ac.starlink.auth.BadChallengeException;
import uk.ac.starlink.auth.Challenge;
import uk.ac.starlink.auth.ContextFactory;
import uk.ac.starlink.auth.IvoaAuthScheme;
import uk.ac.starlink.auth.LoginProtocol;
import uk.ac.starlink.auth.UserInterface;

public class CookieIvoaAuthScheme
extends IvoaAuthScheme {
    public static final CookieIvoaAuthScheme INSTANCE = new CookieIvoaAuthScheme();
    public static final String SCHEME_NAME = "ivoa_cookie";
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.auth");

    private CookieIvoaAuthScheme() {
        super(SCHEME_NAME);
    }

    @Override
    public ContextFactory createContextFactory(final LoginProtocol loginProto, final URL loginUrl, URL challengeUrl) {
        return new ContextFactory(){

            @Override
            public AuthContext createContext(UserInterface ui) {
                CookieManager cookieManager = IvoaAuthScheme.readAuth(loginProto, CookieIvoaAuthScheme.this, loginUrl, ui, x$0 -> CookieIvoaAuthScheme.readCookies(x$0));
                return cookieManager == null ? null : this.createCookieContext(cookieManager);
            }

            @Override
            public AuthContext createUnauthContext() {
                return this.createCookieContext(null);
            }

            private AuthContext createCookieContext(CookieManager cookMan) {
                return new CookieContext(CookieIvoaAuthScheme.this, loginUrl, cookMan);
            }
        };
    }

    private static CookieManager readCookies(HttpURLConnection conn) throws IOException {
        URL url = conn.getURL();
        CookieManager cookieManager = new CookieManager();
        try {
            URI uri = url.toURI();
            cookieManager.put(uri, conn.getHeaderFields());
        }
        catch (URISyntaxException uri) {
            // empty catch block
        }
        conn.getInputStream().close();
        List<HttpCookie> cookies = cookieManager.getCookieStore().getCookies();
        int ncookie = cookies.size();
        if (ncookie > 0) {
            StringBuffer sbuf = new StringBuffer();
            if (ncookie == 1) {
                HttpCookie cookie = cookies.get(0);
                sbuf.append("Acquired cookie: ").append(AuthUtil.cookieLogText(cookie));
            } else {
                sbuf.append("Acquired cookies:");
                for (HttpCookie cookie : cookies) {
                    sbuf.append(' ').append(AuthUtil.cookieLogText(cookie));
                }
            }
            logger_.info(sbuf.toString());
            return cookieManager;
        }
        throw new IOException("No cookie aquired from " + url);
    }

    private static class CookieContext
    implements AuthContext {
        private final CookieIvoaAuthScheme scheme_;
        private final String loginUrl_;
        private final CookieManager cookieManager_;

        CookieContext(CookieIvoaAuthScheme scheme, URL loginUrl, CookieManager cookieManager) {
            this.scheme_ = scheme;
            this.loginUrl_ = loginUrl.toString();
            this.cookieManager_ = cookieManager;
        }

        @Override
        public AuthScheme getScheme() {
            return this.scheme_;
        }

        @Override
        public boolean hasCredentials() {
            return this.cookieManager_ != null;
        }

        @Override
        public void configureConnection(HttpURLConnection connection) throws IOException {
            if (this.cookieManager_ != null) {
                URI uri;
                try {
                    uri = connection.getURL().toURI();
                }
                catch (URISyntaxException e) {
                    assert (false);
                    return;
                }
                Map<String, List<String>> cookieProps = this.cookieManager_.get(uri, connection.getRequestProperties());
                for (Map.Entry<String, List<String>> entry : cookieProps.entrySet()) {
                    String cookieKey = entry.getKey();
                    for (String cookieValue : entry.getValue()) {
                        connection.addRequestProperty(cookieKey, cookieValue);
                    }
                }
            }
        }

        @Override
        public String[] getCurlArgs(URL url, boolean showSecret) {
            Map<String, List<String>> cookieProps;
            URI uri;
            if (this.cookieManager_ == null) {
                return new String[0];
            }
            try {
                uri = url.toURI();
            }
            catch (URISyntaxException e) {
                return new String[0];
            }
            try {
                cookieProps = this.cookieManager_.get(uri, new HashMap<String, List<String>>());
            }
            catch (IOException e) {
                return new String[0];
            }
            ArrayList<String> args = new ArrayList<String>();
            for (Map.Entry<String, List<String>> entry : cookieProps.entrySet()) {
                String cookieKey = entry.getKey();
                for (String cookieValue : entry.getValue()) {
                    args.add("--header");
                    args.add(cookieKey + ": " + cookieValue);
                }
            }
            return args.toArray(new String[0]);
        }

        @Override
        public boolean isUrlDomain(URL url) {
            URI uri;
            try {
                uri = url.toURI();
            }
            catch (URISyntaxException e) {
                return false;
            }
            return this.cookieManager_ != null && this.cookieManager_.getCookieStore().get(uri).size() > 0;
        }

        @Override
        public boolean isChallengeDomain(Challenge challenge, URL url) {
            try {
                return this.scheme_.createContextFactory(challenge, url) != null && this.loginUrl_.equals(challenge.getParams().get("access_url"));
            }
            catch (BadChallengeException e) {
                return false;
            }
        }

        @Override
        public boolean isExpired() {
            return this.cookieManager_ != null && this.cookieManager_.getCookieStore().getCookies().size() == 0;
        }
    }
}

