/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.auth;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import uk.ac.starlink.auth.AuthContext;
import uk.ac.starlink.auth.AuthScheme;
import uk.ac.starlink.auth.AuthUtil;
import uk.ac.starlink.auth.BadChallengeException;
import uk.ac.starlink.auth.Challenge;
import uk.ac.starlink.auth.ContextFactory;
import uk.ac.starlink.auth.ProtectionSpace;
import uk.ac.starlink.auth.UserInterface;
import uk.ac.starlink.auth.UserPass;

public class BasicAuthScheme
implements AuthScheme {
    public static final BasicAuthScheme INSTANCE = new BasicAuthScheme();

    private BasicAuthScheme() {
    }

    @Override
    public String getName() {
        return "Basic";
    }

    @Override
    public ContextFactory createContextFactory(Challenge challenge, URL url) throws BadChallengeException {
        if ("Basic".equalsIgnoreCase(challenge.getSchemeName())) {
            String realm = challenge.getRequiredRealm();
            return new BasicContextFactory(this, url, realm);
        }
        return null;
    }

    public static String encodeUserPass(String user, char[] pass) {
        int nc = user.length() + 1 + pass.length;
        char[] chrs = new char[nc];
        int ichr = 0;
        for (char c : user.toCharArray()) {
            chrs[ichr++] = c;
        }
        chrs[ichr++] = 58;
        for (char c : pass) {
            chrs[ichr++] = c;
        }
        assert (ichr == nc);
        byte[] bbuf = new String(chrs).getBytes(AuthUtil.UTF8);
        byte[] bb64 = Base64.getEncoder().encode(bbuf);
        return new String(bb64, AuthUtil.UTF8);
    }

    private static class BasicAuthContext
    implements AuthContext {
        private final BasicAuthScheme scheme_;
        private final String urlTxt_;
        private final String realm_;
        private final UserPass userpass_;
        private final ProtectionSpace pspace_;
        private final String scope_;

        public BasicAuthContext(BasicAuthScheme scheme, URL url, String realm, UserPass userpass) {
            this.scheme_ = scheme;
            this.urlTxt_ = url.toString();
            this.realm_ = realm;
            this.userpass_ = userpass;
            this.pspace_ = new ProtectionSpace(url, realm);
            this.scope_ = url.toString().replaceFirst("/[^/]+$", "/");
        }

        @Override
        public AuthScheme getScheme() {
            return this.scheme_;
        }

        @Override
        public boolean hasCredentials() {
            return this.userpass_ != null;
        }

        @Override
        public boolean isUrlDomain(URL url) {
            return url.toString().startsWith(this.scope_);
        }

        @Override
        public boolean isChallengeDomain(Challenge challenge, URL url) {
            try {
                return this.scheme_.createContextFactory(challenge, url) != null && new ProtectionSpace(url, challenge.getRealm()).equals(this.pspace_);
            }
            catch (BadChallengeException e) {
                return false;
            }
        }

        @Override
        public boolean isExpired() {
            return false;
        }

        @Override
        public void configureConnection(HttpURLConnection connection) throws IOException {
            if (this.userpass_ != null) {
                String userpass64 = BasicAuthScheme.encodeUserPass(this.userpass_.getUsername(), this.userpass_.getPassword());
                connection.setRequestProperty("Authorization", "Basic " + userpass64);
            }
        }

        @Override
        public String[] getCurlArgs(URL url, boolean showSecrets) {
            if (this.userpass_ == null) {
                return new String[0];
            }
            return new String[]{"--basic", "--user", this.userpass_.getUsername() + ":" + (showSecrets ? new String(this.userpass_.getPassword()) : "[PASSWORD]")};
        }
    }

    private static class BasicContextFactory
    implements ContextFactory {
        private final BasicAuthScheme scheme_;
        private final String realm_;
        private final URL url_;

        BasicContextFactory(BasicAuthScheme scheme, URL url, String realm) {
            this.scheme_ = scheme;
            this.realm_ = realm;
            this.url_ = url;
        }

        @Override
        public AuthContext createContext(UserInterface ui) {
            String[] msg = new String[]{"Login URL: " + this.url_, "HTTP Basic Authentication (Realm: " + this.realm_ + ")"};
            UserPass userpass = ui.readUserPassword(msg);
            return userpass == null ? null : new BasicAuthContext(this.scheme_, this.url_, this.realm_, userpass);
        }

        @Override
        public AuthContext createUnauthContext() {
            return new BasicAuthContext(this.scheme_, this.url_, this.realm_, null);
        }
    }
}

