/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.web;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.httpd.HttpServer;
import org.astrogrid.samp.web.AuthResourceBundle;
import org.astrogrid.samp.web.ClientAuthorizers;
import org.astrogrid.samp.web.CredentialPresenter;

public class WebCredentialPresenter
implements CredentialPresenter {
    public static final WebCredentialPresenter INSTANCE = new WebCredentialPresenter();
    public static final String ORIGIN_HDR = "Origin";
    public static final String REFERER_HDR = "Referer";
    private static final Logger logger_ = Logger.getLogger(WebCredentialPresenter.class.getName());

    private WebCredentialPresenter() {
    }

    public CredentialPresenter.Presentation createPresentation(HttpServer.Request request, Map securityMap, AuthResourceBundle.Content authContent) throws SampException {
        Object[] lines;
        String appName = ClientAuthorizers.getAppName(securityMap);
        Map headerMap = request.getHeaderMap();
        String origin = HttpServer.getHeader(headerMap, ORIGIN_HDR);
        String referer = HttpServer.getHeader(headerMap, REFERER_HDR);
        final LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(authContent.nameWord(), appName);
        map.put(authContent.originWord(), origin);
        map.put("URL", referer);
        if (referer != null && origin != null && !origin.equals(this.getOrigin(referer))) {
            logger_.warning("Origin/Referer header mismatch: \"" + origin + "\" != \"" + this.getOrigin(referer) + "\"");
            lines = new Object[]{"WARNING: Origin/Referer header mismatch!", "WARNING: This looks suspicious."};
        } else {
            lines = new Object[]{};
        }
        return new CredentialPresenter.Presentation(){

            public Map getAuthEntries() {
                return map;
            }

            public Object[] getAuthLines() {
                return lines;
            }
        };
    }

    private String getOrigin(String uri) {
        URL url;
        if (uri == null) {
            return null;
        }
        try {
            url = new URL(uri);
        }
        catch (MalformedURLException e) {
            return null;
        }
        String scheme = url.getProtocol();
        String host = url.getHost();
        int portnum = url.getPort();
        StringBuffer sbuf = new StringBuffer().append(scheme).append("://").append(host);
        if (portnum >= 0 && portnum != url.getDefaultPort()) {
            sbuf.append(":").append(Integer.toString(portnum));
        }
        return sbuf.toString().toLowerCase();
    }
}

