/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.astrogrid.samp.Message;

public abstract class ResourceType {
    private final String name_;
    private final String mtype_;
    private final String[] ctypes_;
    public static final ResourceType RTYPE_VOTABLE = ResourceType.createVOTableResourceType();
    public static final ResourceType RTYPE_FITS;
    public static final ResourceType RTYPE_CDF;
    private static final ResourceType[] RESOURCE_TYPES;
    private static final int MAGIC_SIZE = 1024;
    private static final Logger logger_;

    public ResourceType(String name, String mtype, String[] ctypes) {
        this.name_ = name;
        this.mtype_ = mtype;
        this.ctypes_ = ctypes;
    }

    public String getMType() {
        return this.mtype_;
    }

    public Message createMessage(URL url) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("url", url.toString());
        return new Message(this.mtype_, params);
    }

    public boolean isContentType(String ctype) {
        ctype = ctype.replaceAll(" *;.*", "").replaceAll("\\s+", "").toLowerCase();
        for (int ic = 0; ic < this.ctypes_.length; ++ic) {
            if (!ctype.startsWith(this.ctypes_[ic])) continue;
            return true;
        }
        return false;
    }

    public abstract boolean isMagic(byte[] var1);

    public String getName() {
        return this.name_;
    }

    public String toString() {
        return this.name_;
    }

    public static ResourceType[] getKnownResourceTypes() {
        return (ResourceType[])RESOURCE_TYPES.clone();
    }

    public static ResourceType readHeadResourceType(URL url) {
        try {
            URLConnection uconn = url.openConnection();
            if (uconn instanceof HttpURLConnection) {
                logger_.info("HEAD " + url);
                HttpURLConnection hconn = (HttpURLConnection)uconn;
                hconn.setInstanceFollowRedirects(true);
                hconn.setRequestMethod("HEAD");
                hconn.connect();
                int code = hconn.getResponseCode();
                if (code == 200) {
                    String ctype = hconn.getContentType();
                    logger_.info("HEAD Content-Type: " + ctype);
                    return ResourceType.getMimeResourceType(ctype);
                }
                logger_.warning("HEAD response code " + code);
                return null;
            }
            return null;
        }
        catch (IOException e) {
            logger_.log(Level.WARNING, "HEAD failed", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ResourceType readContentResourceType(URL url) {
        byte[] buf = new byte[1024];
        InputStream in = null;
        logger_.info("GET " + url);
        try {
            URLConnection uconn = url.openConnection();
            if (uconn instanceof HttpURLConnection) {
                HttpURLConnection hconn = (HttpURLConnection)uconn;
                hconn.setInstanceFollowRedirects(true);
                hconn.connect();
                int code = hconn.getResponseCode();
                if (code != 200) {
                    logger_.warning("GET response code " + code);
                    ResourceType resourceType = null;
                    return resourceType;
                }
                String ctype = hconn.getContentType();
                ResourceType rtype = ResourceType.getMimeResourceType(ctype);
                if (rtype != null) {
                    logger_.info("GET Content-Type: " + ctype);
                    ResourceType resourceType = rtype;
                    return resourceType;
                }
            } else {
                uconn.connect();
            }
            in = uconn.getInputStream();
            int off = 0;
            while (off < 1024) {
                int nr = in.read(buf, off, 1024 - off);
                if (nr <= 0) return ResourceType.getMagicResourceType(buf);
                off += nr;
            }
            return ResourceType.getMagicResourceType(buf);
        }
        catch (IOException e) {
            logger_.log(Level.WARNING, "GET failed", e);
            return ResourceType.getMagicResourceType(buf);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static ResourceType getMimeResourceType(String contentType) {
        if (contentType != null) {
            for (int i = 0; i < RESOURCE_TYPES.length; ++i) {
                ResourceType rtype = RESOURCE_TYPES[i];
                if (!rtype.isContentType(contentType)) continue;
                return rtype;
            }
        }
        return null;
    }

    private static ResourceType getMagicResourceType(byte[] magic) {
        for (int i = 0; i < RESOURCE_TYPES.length; ++i) {
            ResourceType rtype = RESOURCE_TYPES[i];
            if (!rtype.isMagic(magic)) continue;
            logger_.info("GET magic number looks like " + rtype);
            return rtype;
        }
        return null;
    }

    private static ResourceType createVOTableResourceType() {
        return new ResourceType("VOTable", "table.load.votable", new String[]{"application/x-votable+xml", "text/xml"}){

            public boolean isMagic(byte[] buf) {
                String txt;
                try {
                    txt = new String(buf, "US-ASCII");
                }
                catch (UnsupportedEncodingException e) {
                    return false;
                }
                return txt.contains("<VOTABLE") || txt.contains("<\u0000V\u0000O\u0000T\u0000A\u0000B\u0000L\u0000E");
            }
        };
    }

    private static ResourceType createFitsImageResourceType() {
        return new ResourceType("FITS", "image.load.fits", new String[]{"image/fits", "application/fits"}){

            public boolean isMagic(byte[] buf) {
                return buf.length >= 9 && (char)buf[0] == 'S' && (char)buf[1] == 'I' && (char)buf[2] == 'M' && (char)buf[3] == 'P' && (char)buf[4] == 'L' && (char)buf[5] == 'E' && (char)buf[6] == ' ' && (char)buf[7] == ' ' && (char)buf[8] == '=';
            }
        };
    }

    private static ResourceType createCdfTableResourceType() {
        return new ResourceType("CDF", "table.load.cdf", new String[0]){

            public boolean isMagic(byte[] buf) {
                if (buf.length >= 8) {
                    int m1 = (buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | (buf[3] & 0xFF) << 0;
                    int m2 = (buf[4] & 0xFF) << 24 | (buf[5] & 0xFF) << 16 | (buf[6] & 0xFF) << 8 | (buf[7] & 0xFF) << 0;
                    return !(m1 != -839712767 && m1 != -839753726 || m2 != 65535 && m2 != -859045887);
                }
                return false;
            }
        };
    }

    static {
        RESOURCE_TYPES = new ResourceType[]{RTYPE_VOTABLE, RTYPE_FITS = ResourceType.createFitsImageResourceType(), RTYPE_CDF = ResourceType.createCdfTableResourceType()};
        logger_ = Logger.getLogger(ResourceType.class.getName());
    }
}

