/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.astrogrid.samp.ErrInfo;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.client.DefaultClientProfile;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.MessageHandler;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.gui.GuiHubConnector;
import org.astrogrid.samp.gui.MessageTrackerHubConnector;
import org.astrogrid.samp.httpd.UtilServer;

public class HubMonitor
extends JPanel {
    private final GuiHubConnector connector_;
    private static Logger logger_;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$astrogrid$samp$Metadata;

    public HubMonitor(ClientProfile profile, boolean trackMessages, int autoSec) {
        super(new BorderLayout());
        this.connector_ = trackMessages ? new MessageTrackerHubConnector(profile) : new GuiHubConnector(profile);
        this.connector_.declareSubscriptions(this.connector_.computeSubscriptions());
        Metadata meta = new Metadata();
        meta.setName("HubMonitor");
        meta.setDescriptionText("GUI hub monitor utility");
        try {
            meta.setIconUrl(UtilServer.getInstance().exportResource("/org/astrogrid/samp/images/eye.gif").toString());
        }
        catch (IOException e) {
            logger_.warning("Can't set icon");
        }
        meta.put("author", "Mark Taylor");
        this.connector_.declareMetadata(meta);
        this.add((Component)this.connector_.createMonitorPanel(), "Center");
        JPanel infoBox = new JPanel(new BorderLayout());
        this.add((Component)infoBox, "South");
        JPanel connectBox = new JPanel(new BorderLayout());
        connectBox.add((Component)new JButton(this.connector_.createToggleRegisterAction()), "Center");
        connectBox.add((Component)this.connector_.createConnectionIndicator(), "East");
        infoBox.add((Component)connectBox, "East");
        Box statusBox = Box.createHorizontalBox();
        statusBox.add(this.connector_.createClientBox(false, 24));
        if (this.connector_ instanceof MessageTrackerHubConnector) {
            statusBox.add(((MessageTrackerHubConnector)this.connector_).createMessageBox(24));
        }
        infoBox.add((Component)statusBox, "Center");
        this.connector_.setActive(true);
        this.connector_.setAutoconnect(autoSec);
    }

    public GuiHubConnector getHubConnector() {
        return this.connector_;
    }

    public static int runMain(String[] args) {
        String usage = "\n   Usage:" + "\n      " + HubMonitor.class.getName() + "\n           " + " [-help]" + " [+/-verbose]" + "\n           " + " [-auto <secs>]" + " [-nomsg]" + " [-nogui]" + "\n           " + " [-mtype <pattern>]" + "\n";
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        int verbAdjust = 0;
        boolean gui = true;
        boolean trackMsgs = true;
        int autoSec = 3;
        Subscriptions subs = new Subscriptions();
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.startsWith("-auto") && it.hasNext()) {
                it.remove();
                String sauto = (String)it.next();
                it.remove();
                autoSec = Integer.parseInt(sauto);
                continue;
            }
            if (arg.equals("-gui")) {
                it.remove();
                gui = true;
                continue;
            }
            if (arg.equals("-nogui")) {
                it.remove();
                gui = false;
                continue;
            }
            if (arg.equals("-msg")) {
                it.remove();
                trackMsgs = true;
                continue;
            }
            if (arg.equals("-nomsg")) {
                it.remove();
                trackMsgs = false;
                continue;
            }
            if (arg.startsWith("-mtype") && it.hasNext()) {
                it.remove();
                String mpat = (String)it.next();
                it.remove();
                subs.addMType(mpat);
                continue;
            }
            if (arg.startsWith("-v")) {
                it.remove();
                --verbAdjust;
                continue;
            }
            if (arg.startsWith("+v")) {
                it.remove();
                ++verbAdjust;
                continue;
            }
            if (arg.startsWith("-h")) {
                it.remove();
                System.out.println(usage);
                return 0;
            }
            it.remove();
            System.err.println(usage);
            return 1;
        }
        if (!$assertionsDisabled && !argList.isEmpty()) {
            throw new AssertionError();
        }
        int logLevel = Level.WARNING.intValue() + 100 * verbAdjust;
        Logger.getLogger("org.astrogrid.samp").setLevel(Level.parse(Integer.toString(logLevel)));
        ClientProfile profile = DefaultClientProfile.getProfile();
        final HubMonitor monitor = new HubMonitor(profile, trackMsgs, autoSec);
        if (!subs.isEmpty()) {
            final Subscriptions extraSubs = subs;
            GuiHubConnector connector = monitor.getHubConnector();
            final Response dummyResponse = new Response();
            dummyResponse.setStatus("samp.warning");
            dummyResponse.setResult(new HashMap());
            dummyResponse.setErrInfo(new ErrInfo("Message logged, no other action taken"));
            connector.addMessageHandler(new MessageHandler(){

                public Map getSubscriptions() {
                    return extraSubs;
                }

                public void receiveNotification(HubConnection connection, String senderId, Message msg) {
                }

                public void receiveCall(HubConnection connection, String senderId, String msgId, Message msg) throws SampException {
                    connection.reply(msgId, dummyResponse);
                }
            });
            connector.declareSubscriptions(connector.computeSubscriptions());
        }
        final boolean isVisible = gui;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame frame = new JFrame("SAMP HubMonitor");
                frame.getContentPane().add(monitor);
                frame.setIconImage(new ImageIcon((class$org$astrogrid$samp$Metadata == null ? (class$org$astrogrid$samp$Metadata = HubMonitor.class$("org.astrogrid.samp.Metadata")) : class$org$astrogrid$samp$Metadata).getResource("images/eye.gif")).getImage());
                frame.pack();
                frame.setVisible(isVisible);
                frame.setDefaultCloseOperation(3);
            }
        });
        return 0;
    }

    public static void main(String[] args) {
        int status = HubMonitor.runMain(args);
        if (status != 0) {
            System.exit(status);
        }
    }

    static {
        $assertionsDisabled = !HubMonitor.class.desiredAssertionStatus();
        logger_ = Logger.getLogger(HubMonitor.class.getName());
    }
}

