/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.bridge;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.astrogrid.samp.httpd.UtilServer;

class UrlExporter {
    private final String host_;
    private final boolean exportFiles_;
    private static final Logger logger_ = Logger.getLogger(UrlExporter.class.getName());
    private static final Pattern LOCALHOST_REGEX = Pattern.compile("(http://|ftp://)(127\\.0\\.0\\.1|localhost)([:/].*)");
    private static final Pattern FILE_REGEX = Pattern.compile("(file://)([^/]*)/.*");

    public UrlExporter(String host, boolean exportFiles) {
        this.host_ = host;
        this.exportFiles_ = exportFiles;
    }

    public String exportString(String text) {
        String t2 = this.doExportString(text);
        if (t2 != null && !t2.equals(text)) {
            logger_.info("Exported string \"" + text + "\" -> \"" + t2 + '\"');
        }
        return t2;
    }

    private String doExportString(String text) {
        Matcher localMatcher = LOCALHOST_REGEX.matcher(text);
        if (localMatcher.matches()) {
            return localMatcher.group(1) + this.host_ + localMatcher.group(3);
        }
        if (this.exportFiles_ && FILE_REGEX.matcher(text).matches()) {
            try {
                URL expUrl;
                File file;
                URL fileUrl = new URL(text);
                String path = fileUrl.getPath();
                if (File.separatorChar != '/') {
                    path = path.replace('/', File.separatorChar);
                }
                if ((file = new File(path)).canRead() && !file.isDirectory() && (expUrl = UtilServer.getInstance().getMapperHandler().addLocalUrl(fileUrl)) != null) {
                    return expUrl.toString();
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return text;
        }
        return text;
    }

    public void exportList(List list) {
        ListIterator<String> it = list.listIterator();
        while (it.hasNext()) {
            Object value = it.next();
            if (value instanceof String) {
                it.set(this.exportString((String)value));
                continue;
            }
            if (value instanceof List) {
                this.exportList((List)value);
                continue;
            }
            if (!(value instanceof Map)) continue;
            this.exportMap((Map)value);
        }
    }

    public void exportMap(Map map) {
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object value = entry.getValue();
            if (value instanceof String) {
                entry.setValue(this.exportString((String)value));
                continue;
            }
            if (value instanceof List) {
                this.exportList((List)value);
                continue;
            }
            if (!(value instanceof Map)) continue;
            this.exportMap((Map)value);
        }
    }
}

