/*
 * Decompiled with CFR 0.152.
 */
package cds.xml;

import cds.aladin.Aladin;
import cds.aladin.MyInputStream;
import cds.aladin.TapManager;
import cds.xml.XMLConsumer;
import cds.xml.XMLParser;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;

public class VOSICapabilitiesReader
implements XMLConsumer {
    private boolean inTableAccessCapabilityTag = false;
    private int readHardUploadLimit = -1;
    private int readHardOutputLimit = -1;
    private boolean uploadAllowed = false;
    private long uploadHardLimit = -1L;
    private boolean tabledataFormatAllowed = false;
    private long hardOutputLimit = -1L;
    private boolean inOutPutFormat = false;
    private boolean inOutputFormatMime = false;

    public boolean load(URL capabilitiesUrl) {
        XMLParser xmlParser = new XMLParser(this);
        boolean result = false;
        MyInputStream inputStream = null;
        this.resetFlags();
        try {
            long startTime = TapManager.getTimeToLog();
            inputStream = new MyInputStream(capabilitiesUrl.openStream());
            long time = TapManager.getTimeToLog();
            if (Aladin.levelTrace >= 4) {
                System.out.println("getTapCapabilities got inputstream: " + time + " total time taken: " + (time - startTime));
            }
            startTime = TapManager.getTimeToLog();
            result = xmlParser.parse(inputStream);
            time = TapManager.getTimeToLog();
            if (Aladin.levelTrace >= 4) {
                System.out.println("getTapCapabilities parsed: " + time + " total time taken: " + (time - startTime));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private void resetFlags() {
        this.inTableAccessCapabilityTag = false;
        this.readHardUploadLimit = -1;
    }

    @Override
    public void startElement(String name, Hashtable atts) {
        if (name.equalsIgnoreCase("outputFormat")) {
            this.inOutPutFormat = true;
            if (atts.containsKey("ivo-id") && atts.get("ivo-id").equals("ivo://ivoa.net/std/TAPRegExt#output-votable-td")) {
                this.tabledataFormatAllowed = true;
            }
        } else if (this.inOutPutFormat && name.equalsIgnoreCase("mime")) {
            this.inOutputFormatMime = true;
        } else if (name.equals("capability")) {
            if (atts.containsKey("standardid") && atts.get("standardid").equals("ivo://ivoa.net/std/TAP") && atts.containsKey("xsi:type") && atts.get("xsi:type").equals("tr:TableAccess")) {
                this.inTableAccessCapabilityTag = true;
            }
        } else if (this.inTableAccessCapabilityTag) {
            if (name.equals("uploadMethod")) {
                this.uploadAllowed = true;
            } else if (name.equals("uploadLimit")) {
                ++this.readHardUploadLimit;
            } else if (name.equals("hard") && this.readHardUploadLimit == 0) {
                ++this.readHardUploadLimit;
            } else if (name.equals("outputLimit")) {
                ++this.readHardOutputLimit;
            } else if (name.equals("hard") && this.readHardOutputLimit == 0) {
                ++this.readHardOutputLimit;
            }
        }
    }

    @Override
    public void endElement(String name) {
        if (name.equals("outputFormat")) {
            this.inOutPutFormat = false;
        } else if (name.equals("mime")) {
            this.inOutputFormatMime = false;
        } else if (this.inTableAccessCapabilityTag && name.equals("capability")) {
            this.inTableAccessCapabilityTag = false;
        } else if (name.equals("uploadLimit")) {
            this.readHardUploadLimit = -1;
        } else if (name.equals("outputLimit")) {
            this.readHardOutputLimit = -1;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws Exception {
        String data = new String(ch, start, length);
        if (this.inTableAccessCapabilityTag && this.readHardUploadLimit == 1) {
            this.uploadHardLimit = Long.parseLong(data);
        } else if (this.inTableAccessCapabilityTag && this.readHardOutputLimit == 1) {
            this.hardOutputLimit = Long.parseLong(data);
        } else if (this.inOutputFormatMime && data.equalsIgnoreCase("application/x-votable+xml;serialization=TABLEDATA")) {
            this.tabledataFormatAllowed = true;
        }
    }

    public boolean isUploadAllowed() {
        return this.uploadAllowed;
    }

    public void setUploadAllowed(boolean uploadAllowed) {
        this.uploadAllowed = uploadAllowed;
    }

    public long getUploadHardLimit() {
        return this.uploadHardLimit;
    }

    public void setUploadHardLimit(long uploadHardLimit) {
        this.uploadHardLimit = uploadHardLimit;
    }

    public long getHardOuputLimit() {
        return this.hardOutputLimit;
    }

    public void setUpHardOuputLimit(long hardOutputLimit) {
        this.hardOutputLimit = hardOutputLimit;
    }

    public boolean tabledataFormatAllowed() {
        return this.tabledataFormatAllowed;
    }
}

