/*
 * Decompiled with CFR 0.152.
 */
package cds.xml;

import cds.aladin.Aladin;
import cds.aladin.MyInputStream;
import cds.aladin.Pcat;
import cds.aladin.Save;
import cds.astro.Astrocoo;
import cds.astro.Astroframe;
import cds.astro.Astropos;
import cds.astro.Astrotime;
import cds.astro.ICRS;
import cds.astro.Unit;
import cds.fits.HeaderFits;
import cds.tools.Astrodate;
import cds.tools.Util;
import cds.xml.Field;
import cds.xml.TableParserConsumer;
import cds.xml.XMLConsumer;
import cds.xml.XMLParser;
import java.io.EOFException;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class TableParser
implements XMLConsumer {
    static final Astroframe AF_FK4 = Astroframe.create("FK4");
    static final Astroframe AF_FK5 = Astroframe.create("FK5");
    static final Astroframe AF_GAL = Astroframe.create("Galactic");
    static final Astroframe AF_SGAL = Astroframe.create("Supergalactic");
    static final Astroframe AF_ICRS = Astroframe.create("ICRS");
    static final Astroframe AF_ECLI = Astroframe.create("Ecliptic");
    public static final int FMT_UNKNOWN = 0;
    public static final int FMT_DECIMAL = 1;
    public static final int FMT_SEXAGESIMAL = 2;
    public static final int FMT_NSEW = 4;
    public static final int UNIT_UNKNOWN = 0;
    public static final int UNIT_DEGREES = 1;
    public static final int UNIT_RADIANS = 2;
    public static final int TIME_UNKNOWN = 0;
    public static final int JD = 13;
    public static final int MJD = 14;
    public static final int ISOTIME = 15;
    public static final int YEARS = 16;
    public static final int YMD = 17;
    private TableParserConsumer consumer;
    private XMLParser xmlparser;
    private int nField;
    private int nRecord;
    private int nRA;
    private int nDEC;
    private int nRAmax;
    private int nDECmax;
    private int nPMRA;
    private int nPMDEC;
    private int nX;
    private int nY;
    private int nTime;
    private int nRADEC;
    private int formatx = -1;
    private String sFreq;
    private String sFlux;
    private String sFluxErr;
    private String sSedId;
    private int nFreq;
    private int nFlux;
    private int nFluxErr;
    private int nSedId;
    private int qualRA;
    private int qualDEC;
    private int qualPMRA;
    private int qualPMDEC;
    private int qualX;
    private int qualY;
    private int qualTime;
    private Field f;
    private Vector<Field> memoField;
    private Field[] tsvField;
    private String fieldSub = null;
    private String tableSub = null;
    private String resourceSub = null;
    private boolean inCSV = false;
    private boolean flagTSV;
    private boolean inError;
    private boolean inLinkField = false;
    private boolean inFieldDesc = false;
    private boolean inEncode64 = false;
    private boolean inBinary = false;
    private boolean inBinary2 = false;
    private boolean inFits = false;
    private boolean inGroup = false;
    private int fitsExtNum;
    private boolean inTD;
    private boolean valueInTD;
    private int ngroup;
    private String colsep;
    private String recsep;
    private String headlines;
    private String error;
    private String filename;
    private int format;
    private int unit;
    private String unitPMRA;
    private String unitPMDEC;
    private double timeOffset = 0.0;
    private boolean flagXY;
    private boolean flagNOCOO;
    private String[] record;
    private Vector<String> vRecord;
    private int row;
    private boolean flagNewTable;
    private boolean flagSkip;
    private long typeFmt;
    private Hashtable<String, String> coosys;
    private Hashtable<String, String> cooepoch;
    private Hashtable<String, String> cooequinox;
    private Hashtable<String, String> cooFieldref;
    private boolean inAstroCoords;
    private boolean inVODML;
    private String astroCoordsID;
    private Astroframe srcAstroFrame = null;
    private Astrotime srcAstroTime = null;
    private Astroframe trgAstroFrame = AF_ICRS;
    private Astropos c = new Astropos();
    private String filter;
    private boolean inSEDGroup;
    private Hashtable<String, String> timescale;
    private Hashtable<String, String> timeorigin;
    private Hashtable<String, String> refposition;
    private TimeFrame srcTimeFrame = null;
    private int timeFormat = -1;
    private Field timeField;
    private boolean first = true;
    private boolean flagInterrupt = false;
    private boolean firstResourceInfo = true;
    private HeaderFits headerFits;
    private Aladin aladin;
    private char[] type = null;
    private int[] pos = null;
    private int[] len = null;
    private int[] prec = null;
    private int sizeRecord = 0;
    private int nbField = 0;
    private byte[] memoB = null;
    private byte[] nullMask = null;
    private boolean maskRead = false;
    static final int[] MASK = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    private static int MAXVECT = 4096;
    private static Charset utf16 = Charset.forName("UTF-16");
    static final char BLC = ' ';
    static final char TABC = '\t';
    static final byte BLB = 32;
    static final byte TABB = 9;
    private static int ASTROID = 1;
    private boolean flagPosChooser = false;
    private static final String DEFAULT = "Default";
    private Astroframe lastCoordSys = null;
    private TimeFrame lastTimeSys = null;
    private static String[] UCDTIME = new String[]{"time.epoch", "time.start", "time.end", "time.release", "time.creation", "time.processing"};
    static double J2000 = Double.NaN;

    public TableParser(Aladin aladin, TableParserConsumer consumer, long type) {
        this.aladin = aladin;
        this.consumer = consumer;
        this.typeFmt = type;
    }

    public TableParser(Aladin aladin, TableParserConsumer consumer, HeaderFits headerFits, boolean flagSkip) {
        this.aladin = aladin;
        this.consumer = consumer;
        this.headerFits = headerFits;
        this.flagSkip = flagSkip;
    }

    public void setFileName(String file) {
        this.filename = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hrefCall(String uri) throws Exception {
        try (MyInputStream in = null;){
            in = Util.openAnyStream(uri);
            if (this.inBinary || this.inBinary2) {
                this.consumer.tableParserInfo("\nParsing VOTable data from an external" + (this.inBinary2 ? " BINARY2" : " BINARY") + " stream:\n => " + uri);
                byte[] buf = in.readFully();
                this.parseBin(buf, 0, buf.length, this.inBinary2);
            } else if (this.inFits) {
                this.aladin.calque.seekFitsExt(in, this.fitsExtNum);
                this.consumer.tableParserInfo("\nParsing VOTable data from a FITS stream:\n => " + uri + (this.fitsExtNum > 0 ? " (ext=" + this.fitsExtNum + ")" : ""));
                in.resetType();
                in.getType();
                this.headerFits = new HeaderFits(in);
                this.parseFits(in, true);
            }
        }
    }

    private void parseBase64(char[] ch, int pos, int len, boolean inBinary2) throws Exception {
        if (this.memoField != null) {
            this.consumer.tableParserInfo("\nParsing VOTable data from a" + (inBinary2 ? " BINARY2" : " BINARY") + " base64 stream");
        }
        byte[] b = new byte[len];
        int offset = 0;
        if (this.memoB != null) {
            b = new byte[len + this.memoB.length];
            offset = this.memoB.length;
            System.arraycopy(this.memoB, 0, b, 0, offset);
            this.memoB = null;
        } else {
            b = new byte[len];
        }
        int n = Save.get64(b, offset, ch, pos, len);
        this.parseBin(b, 0, n, inBinary2);
    }

    private boolean parseBin(byte[] b, int offset, int length, boolean inBinary2) throws Exception {
        if (this.memoField != null) {
            this.nbField = this.memoField.size();
            this.type = new char[this.nbField];
            this.pos = new int[this.nbField];
            this.len = new int[this.nbField];
            this.prec = new int[this.nbField];
            if (inBinary2) {
                this.nullMask = new byte[(this.nbField + 7) / 8];
            }
            this.nRecord = 0;
            this.nField = 0;
            boolean variableField = false;
            for (int i = 0; i < this.nbField; ++i) {
                Field f = this.memoField.elementAt(i);
                String t = Field.typeVOTable2Fits(f.datatype);
                if (t == null) {
                    throw new Exception("Missing definition for field " + i + ". Parsing aborted");
                }
                this.type[i] = t.charAt(0);
                this.len[i] = 1;
                if (f.arraysize != null && f.arraysize.indexOf(42) >= 0) {
                    this.len[i] = -1;
                    this.sizeRecord = -1;
                    variableField = true;
                } else {
                    try {
                        this.len[i] = Integer.parseInt(f.arraysize);
                    }
                    catch (Exception e) {
                        this.len[i] = 1;
                    }
                }
                if (!variableField) {
                    if (i < this.nbField - 1) {
                        this.pos[i + 1] = this.pos[i] + this.binSizeOf(this.type[i], this.len[i]);
                    } else {
                        this.sizeRecord = this.pos[i] + this.binSizeOf(this.type[i], this.len[i]);
                    }
                } else {
                    this.pos[i] = -1;
                }
                this.prec[i] = 6;
                try {
                    this.prec[i] = Integer.parseInt(f.precision);
                    continue;
                }
                catch (Exception e) {
                    this.prec[i] = 6;
                }
            }
            this.pos[0] = 0;
            this.memoField = null;
        }
        int position = offset;
        while (position < length) {
            if (this.nField == this.nbField) {
                this.nField = 0;
            }
            if (inBinary2 && this.nField == 0 && !this.maskRead) {
                int n = length - position;
                if (n < this.nullMask.length) {
                    this.memoB = new byte[n];
                    System.arraycopy(b, position, this.memoB, 0, n);
                    return true;
                }
                position += this.nullMask.length;
                this.maskRead = true;
            } else {
                this.maskRead = false;
            }
            int nbBytes = this.len[this.nField] == -1 ? -1 : this.binSizeOf(this.type[this.nField], this.len[this.nField]);
            int lenv = 0;
            if (nbBytes == -1) {
                int n = length - position;
                if (n < 4) {
                    this.memoB = new byte[n];
                    System.arraycopy(b, position, this.memoB, 0, n);
                    return true;
                }
                lenv = this.getInt(b, position);
                nbBytes = this.binSizeOf(this.type[this.nField], lenv);
                position += 4;
            } else if (nbBytes == 0) {
                return true;
            }
            int nextPosition = position + nbBytes;
            if (nextPosition > length) {
                if (this.len[this.nField] == -1) {
                    position -= 4;
                }
                int n = length - position;
                this.memoB = new byte[n];
                System.arraycopy(b, position, this.memoB, 0, n);
                return true;
            }
            this.record[this.nField] = inBinary2 && this.isNull(this.nullMask, this.nField) ? "null" : this.getBinField(b, position, this.len[this.nField] == -1 ? lenv : this.len[this.nField], this.type[this.nField], this.prec[this.nField], 0.0, 1.0, false, 0);
            position = nextPosition;
            ++this.nField;
            if (this.nField != this.nbField) continue;
            this.consumeRecord(this.record, this.nRecord++);
            if (!this.flagInterrupt) continue;
            break;
        }
        return true;
    }

    private boolean isNull(byte[] nullMask, int nField) {
        int nByte = nField / 8;
        int nBit = nField % 8;
        return (0xFF & nullMask[nByte] & MASK[nBit]) != 0;
    }

    private boolean parseFits(MyInputStream in, boolean hrefVotable) {
        block73: {
            this.error = null;
            if (!hrefVotable) {
                this.initTable();
                this.coosys = new Hashtable(10);
                this.cooepoch = new Hashtable(10);
                this.cooequinox = new Hashtable(10);
                this.cooFieldref = new Hashtable(10);
                this.timeorigin = new Hashtable(10);
                this.timescale = new Hashtable(10);
                this.refposition = new Hashtable(10);
            }
            try {
                int offset;
                int k;
                String s;
                boolean flagBin;
                boolean bl = flagBin = (in.getType() & 0x1000000L) != 0L;
                if (!hrefVotable) {
                    this.consumer.tableParserInfo("FITS " + (flagBin ? "BINTABLE" : "TABLE") + " format");
                    this.consumer.startResource("RESOURCE-FITS");
                    try {
                        s = this.headerFits.getStringFromHeader("EXTNAME");
                        this.consumer.setResourceInfo("NAME", s);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.consumer.startTable("TABLE-FITS");
                int nRecord = this.headerFits.getIntFromHeader("NAXIS2");
                int sizeRecord = this.headerFits.getIntFromHeader("NAXIS1");
                this.nField = this.headerFits.getIntFromHeader("TFIELDS");
                char[] type = null;
                int[] pos = new int[this.nField];
                int[] len = new int[this.nField];
                boolean flagTzeroTscal = false;
                double[] tzero = new double[this.nField];
                double[] tscal = new double[this.nField];
                String[] tnull = new String[this.nField];
                int[] tinull = new int[this.nField];
                int[] prec = new int[this.nField];
                for (k = 0; k < this.nField; ++k) {
                    prec[k] = -1;
                }
                for (k = 0; k < this.nField; ++k) {
                    tscal[k] = 1.0;
                }
                if (flagBin) {
                    type = new char[this.nField];
                }
                for (int i = 0; i < this.nField; ++i) {
                    s = null;
                    try {
                        s = this.headerFits.getStringFromHeader("TTYPE" + (i + 1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (s == null) {
                        s = "Col-" + (i + 1);
                    }
                    Field f = new Field(s);
                    s = null;
                    try {
                        s = this.headerFits.getStringFromHeader("TUNIT" + (i + 1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (s != null) {
                        f.unit = s;
                    }
                    s = null;
                    try {
                        s = this.headerFits.getStringFromHeader("TCOMM" + (i + 1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (s != null) {
                        f.description = s;
                    }
                    double x = 0.0;
                    try {
                        x = this.headerFits.getDoubleFromHeader("TZERO" + (i + 1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (x != 0.0) {
                        tzero[i] = x;
                        flagTzeroTscal = true;
                    }
                    x = 0.0;
                    try {
                        x = this.headerFits.getDoubleFromHeader("TSCAL" + (i + 1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (x != 0.0) {
                        tscal[i] = x;
                        flagTzeroTscal = true;
                    }
                    s = null;
                    try {
                        s = this.headerFits.getStringFromHeader("TNULL" + (i + 1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (s != null) {
                        tnull[i] = s.trim();
                        if (flagBin) {
                            try {
                                tinull[i] = this.headerFits.getIntFromHeader("TNULL" + (i + 1));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    s = null;
                    try {
                        s = this.headerFits.getStringFromHeader("TUCD" + (i + 1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (s != null) {
                        f.ucd = s;
                    }
                    s = null;
                    try {
                        s = this.headerFits.getStringFromHeader("TFORM" + (i + 1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (s != null) {
                        if (!flagBin) {
                            char code = s.charAt(0);
                            if (code == 'E' || code == 'F') {
                                code = 'D';
                            }
                            f.datatype = code + "";
                            int k2 = s.indexOf(46);
                            if (k2 < 0) {
                                k2 = s.length();
                            }
                            if (k2 > 1) {
                                f.width = s.substring(1, k2);
                                f.computeColumnSize();
                            }
                            if ((k2 = s.indexOf(46)) > 0) {
                                prec[i] = 0;
                                ++k2;
                                while (k2 < s.length() && Character.isDigit(s.charAt(k2))) {
                                    prec[i] = prec[i] * 10 + (s.charAt(k2) - 48);
                                    ++k2;
                                }
                                f.precision = prec[i] + "";
                            }
                        } else {
                            int k3;
                            len[i] = 0;
                            for (k3 = 0; k3 < s.length() && Character.isDigit(s.charAt(k3)); ++k3) {
                                len[i] = len[i] * 10 + (s.charAt(k3) - 48);
                            }
                            if (k3 == 0) {
                                len[i] = 1;
                            } else {
                                f.arraysize = len[i] + "";
                            }
                            type[i] = s.charAt(k3);
                            int n = pos[i] = i == 0 ? 0 : pos[i - 1] + this.binSizeOf(type[i - 1], len[i - 1]);
                        }
                    }
                    if (flagBin && f.datatype == null) {
                        f.datatype = type[i] + "";
                    }
                    s = null;
                    try {
                        s = this.headerFits.getStringFromHeader("TDISP" + (i + 1));
                    }
                    catch (Exception k3) {
                        // empty catch block
                    }
                    if (s != null) {
                        int k4 = s.indexOf(46);
                        if (k4 < 0) {
                            k4 = s.length();
                        }
                        if (k4 > 1) {
                            f.width = s.substring(1, k4);
                            f.computeColumnSize();
                        }
                        if ((k4 = s.indexOf(46)) > 0) {
                            prec[i] = 0;
                            ++k4;
                            while (k4 < s.length() && Character.isDigit(s.charAt(k4))) {
                                prec[i] = prec[i] * 10 + (s.charAt(k4) - 48);
                                ++k4;
                            }
                            f.precision = prec[i] + "";
                        }
                    }
                    if (!flagBin) {
                        pos[i] = this.headerFits.getIntFromHeader("TBCOL" + (i + 1));
                        int p = sizeRecord;
                        try {
                            p = this.headerFits.getIntFromHeader("TBCOL" + (i + 2));
                        }
                        catch (Exception k2) {
                            // empty catch block
                        }
                        len[i] = p - pos[i];
                        int n = i;
                        pos[n] = pos[n] - 1;
                        f.width = len[i] + "";
                    }
                    this.detectPosField(f, i);
                    if (hrefVotable) continue;
                    this.consumer.setField(f);
                }
                if (!hrefVotable) {
                    this.posChooser();
                }
                if (this.flagSkip) {
                    in.skip(nRecord * sizeRecord);
                } else {
                    byte[] buf = new byte[(nRecord < 1000 ? nRecord : 1000) * sizeRecord];
                    this.record = new String[this.nField];
                    offset = buf.length;
                    int i = 0;
                    while (i < nRecord) {
                        if (offset == buf.length) {
                            try {
                                in.readFully(buf);
                            }
                            catch (EOFException p) {
                                // empty catch block
                            }
                            offset = 0;
                        }
                        for (int j = 0; j < this.nField; ++j) {
                            if (!flagBin) {
                                this.record[j] = TableParser.getStringTrim(buf, offset + pos[j], len[j]);
                                if (tnull[j] != null && this.record[j].equals(tnull[j])) {
                                    this.record[j] = "";
                                    continue;
                                }
                                if (!flagTzeroTscal && prec[j] < 0) continue;
                                try {
                                    this.record[j] = this.fmt(Double.valueOf(this.record[j]), prec[j], tzero[j], tscal[j]);
                                }
                                catch (Exception e) {
                                    this.record[j] = "[?X?]";
                                }
                                continue;
                            }
                            this.record[j] = this.getBinField(buf, offset + pos[j], len[j], type[j], prec[j], flagTzeroTscal ? tzero[j] : 0.0, flagTzeroTscal ? tscal[j] : 1.0, tnull[j] != null, tinull[j]);
                        }
                        this.consumeRecord(this.record, i);
                        if (this.flagInterrupt) break;
                        ++i;
                        offset += sizeRecord;
                    }
                }
                if (hrefVotable) break block73;
                this.consumer.endTable();
                this.consumer.endResource();
                if (this.flagInterrupt) break block73;
                try {
                    offset = this.headerFits.getIntFromHeader("PCOUNT");
                    if (offset != 0) {
                        in.skip(offset);
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error = e.getMessage();
            }
        }
        return this.error == null;
    }

    protected final int binSizeOf(char type, int n) {
        int sizeOf;
        if (type == 'X') {
            return n / 8 + (n % 8 > 0 ? 1 : 0);
        }
        int n2 = type == 'L' ? 1 : (type == 'B' ? 1 : (type == 'I' ? 2 : (type == 'J' ? 4 : (type == 'K' ? 8 : (type == 'A' ? 1 : (type == 'E' ? 4 : (type == 'D' ? 8 : (type == 'C' ? 8 : (type == 'M' ? 16 : (type == 'P' ? 8 : (sizeOf = type == 'U' ? 2 : 0)))))))))));
        if (sizeOf == 0) {
            sizeOf = 1;
            if (Aladin.levelTrace >= 3) {
                System.err.println("TableParser warning: unknown field datatype [" + type + "] => assuming 1 byte");
            }
        }
        return sizeOf * n;
    }

    private final String getBinField(byte[] t, int i, int n, char type, int prec, double tzero, double tscale, boolean hasNull, int tnull) {
        if (n == 0) {
            return "";
        }
        if (type == 'A') {
            return TableParser.getStringTrim(t, i, n);
        }
        if (n == 1) {
            return this.getBinField(t, i, type, prec, tzero, tscale, hasNull, tnull);
        }
        StringBuilder a = null;
        boolean tooLong = false;
        if (n > MAXVECT) {
            tooLong = true;
            n = MAXVECT;
        }
        for (int j = 0; j < n; ++j) {
            if (j == 0) {
                a = new StringBuilder();
            } else if (type != 'U') {
                a.append(' ');
            }
            a.append(this.getBinField(t, i + this.binSizeOf(type, j), type, prec, tzero, tscale, hasNull, tnull));
        }
        return a + (tooLong ? "... (too long)" : "");
    }

    private final String getBinField(byte[] t, int i, char type, int prec, double tzero, double tscale, boolean hasNull, int n) {
        switch (type) {
            case 'L': {
                return t[i] != 0 ? "T" : "F";
            }
            case 'B': {
                return this.fmtInt(t[i] & 0xFF, prec, tzero, tscale, hasNull, n);
            }
            case 'I': {
                return this.fmtInt(this.getShort(t, i), prec, tzero, tscale, hasNull, n);
            }
            case 'J': {
                return this.fmtInt(this.getInt(t, i), prec, tzero, tscale, hasNull, n);
            }
            case 'K': {
                long a = (long)this.getInt(t, i) << 32 | (long)this.getInt(t, i + 4) & 0xFFFFFFFFL;
                return this.fmtLong(a, prec, tzero, tscale, hasNull, n);
            }
            case 'E': {
                return this.fmt(Float.intBitsToFloat(this.getInt(t, i)), prec, tzero, tscale);
            }
            case 'D': {
                long a = (long)this.getInt(t, i) << 32 | (long)this.getInt(t, i + 4) & 0xFFFFFFFFL;
                return this.fmt(Double.longBitsToDouble(a), prec, tzero, tscale);
            }
            case 'C': {
                int c = this.getInt(t, i + 4);
                return this.fmt(Float.intBitsToFloat(this.getInt(t, i)), prec, tzero, tscale) + (c >= 0 ? "+" : "-") + this.fmt(Float.intBitsToFloat(c), prec, tzero, tscale) + "i";
            }
            case 'M': {
                long a = (long)this.getInt(t, i) << 32 | (long)this.getInt(t, i + 4) & 0xFFFFFFFFL;
                long b = (long)this.getInt(t, i + 8) << 32 | (long)this.getInt(t, i + 12) & 0xFFFFFFFFL;
                return this.fmt(Double.longBitsToDouble(a), prec, tzero, tscale) + (b >= 0L ? "+" : "-") + this.fmt(Double.longBitsToDouble(b), prec, tzero, tscale) + "i";
            }
            case 'U': {
                try {
                    return new String(t, i, 2, utf16);
                }
                catch (Exception e) {
                    return "[??]";
                }
            }
            case 'A': {
                return "" + (char)t[i];
            }
        }
        return "[???]";
    }

    private final String fmtInt(long x, int prec, double tzero, double tscale, boolean hasNull, int tnull) {
        if (hasNull && (long)tnull == x) {
            return "";
        }
        double y = x;
        if (tscale != 1.0) {
            y *= tscale;
        }
        if (tzero != 0.0) {
            y += tzero;
        }
        if (prec >= 0) {
            y = Util.round(y, prec);
        }
        if (y != (double)x) {
            return y + "";
        }
        return x + "";
    }

    private final String fmtLong(long x, int prec, double tzero, double tscale, boolean hasNull, int tnull) {
        if (hasNull && (long)tnull == x) {
            return "";
        }
        if (tscale == 1.0 && tzero == 0.0) {
            return x + "";
        }
        if ((double)((long)tscale) == tscale && (double)((long)tzero) == tzero) {
            long y = x;
            if (tscale != 1.0) {
                y *= (long)tscale;
            }
            if (tzero != 0.0) {
                y += (long)tzero;
            }
            return y + "";
        }
        double y = x;
        if (tscale != 1.0) {
            y *= tscale;
        }
        if (tzero != 0.0) {
            y += tzero;
        }
        if (prec >= 0) {
            y = Util.round(y, prec);
        }
        if (y != (double)x) {
            return y + "";
        }
        return x + "";
    }

    private final String fmt(double x, int prec, double tzero, double tscale) {
        if (Double.isNaN(x)) {
            return "";
        }
        if (tscale != 1.0) {
            x *= tscale;
        }
        if (tzero != 0.0) {
            x += tzero;
        }
        return x + "";
    }

    private final int getInt(byte[] t, int i) {
        return t[i] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF;
    }

    private final int getShort(byte[] t, int i) {
        return t[i] << 8 | t[i + 1] & 0xFF;
    }

    public static final String getStringTrim(byte[] s, int offset, int len) {
        if (len < 0 || offset + len > s.length) {
            System.err.println("problem s.length=" + s.length + " offset=" + offset + " len=" + len + " !!");
            return new String(s, offset, s.length - offset);
        }
        return new String(s, offset, len).trim();
    }

    public static final String getStringTrim(char[] s, int offset, int len) {
        return new String(s, offset, len).trim();
    }

    public TableParser(Aladin aladin, TableParserConsumer consumer) {
        this(aladin, consumer, null);
    }

    public TableParser(Aladin aladin, TableParserConsumer consumer, String colsep) {
        this.aladin = aladin;
        this.consumer = consumer;
        if (colsep != null) {
            this.colsep = colsep;
        }
        this.xmlparser = new XMLParser(this);
    }

    public boolean parse(MyInputStream dis) throws Exception {
        if (this.headerFits != null) {
            return this.parseFits(dis, false);
        }
        return this.parse(dis, null);
    }

    public boolean parse(MyInputStream dis, String endTag) throws Exception {
        this.initTable();
        this.error = null;
        this.flagTSV = true;
        this.inError = false;
        this.ngroup = 0;
        this.coosys = new Hashtable(10);
        this.cooepoch = new Hashtable(10);
        this.cooequinox = new Hashtable(10);
        this.cooFieldref = new Hashtable(10);
        this.timeorigin = new Hashtable(10);
        this.timescale = new Hashtable(10);
        this.refposition = new Hashtable(10);
        this.typeFmt = dis.getType();
        return this.xmlparser.parse(dis, endTag) && this.error == null;
    }

    public void interrupt() throws Exception {
        this.flagInterrupt = true;
    }

    public byte[] getUnreadBuffer() {
        return this.xmlparser.getUnreadBuffer();
    }

    private void initTable() {
        this.nTime = -1;
        this.nRADEC = -1;
        this.nY = -1;
        this.nX = -1;
        this.nPMDEC = -1;
        this.nPMRA = -1;
        this.nDEC = -1;
        this.nRA = -1;
        this.nDECmax = -1;
        this.nRAmax = -1;
        this.qualTime = 1000;
        this.qualPMDEC = 1000;
        this.qualPMRA = 1000;
        this.qualY = 1000;
        this.qualX = 1000;
        this.qualDEC = 1000;
        this.qualRA = 1000;
        this.qualDEC = 1000;
        this.qualRA = 1000;
        this.timeFormat = -1;
        this.timeField = null;
        this.timeOffset = 0.0;
        this.formatx = 0;
        this.format = 0;
        this.unit = 0;
        this.nField = 0;
        this.record = null;
        this.vRecord = null;
        this.flagNewTable = true;
        this.astroCoordsID = null;
        this.inAstroCoords = false;
        this.inSEDGroup = false;
        this.inVODML = false;
    }

    public String getError() {
        return this.error != null ? this.error : this.xmlparser.getError();
    }

    private void memoStartGroup(String name, Hashtable atts) {
        StringBuffer s = new StringBuffer("<" + name);
        Enumeration e = atts.keys();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            s.append(" " + k + "=\"" + atts.get(k) + "\"");
        }
        s.append(">\n");
        this.consumer.setTableInfo("GROUP", s.toString());
    }

    private void memoEndGroup(String name) {
        this.consumer.setTableInfo("GROUP", "</" + name + ">\n");
    }

    private void memoInGroup(char[] s, int offset, int length) {
        this.consumer.setTableInfo("GROUP", new String(s, offset, length));
    }

    private void resetGroup() {
        System.err.println("TableParser.resetGroupe => FIELD GROUP not yet supported => remove all GROUP definition !");
        this.consumer.setTableInfo("GROUP", null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void startElement(String name, Hashtable atts) {
        depth = this.xmlparser.getDepth();
        if (this.inGroup) {
            this.memoStartGroup(name, atts);
        }
        if (name.charAt(0) == 'G' && depth >= 1 && name.equalsIgnoreCase("GROUP")) {
            ++this.ngroup;
            if (!this.inGroup) {
                this.memoStartGroup(name, atts);
            }
            this.inGroup = true;
            att = (String)atts.get("utype");
            id = (String)atts.get("ID");
            if (att != null && (att.equalsIgnoreCase("stc:AstroCoords") || att.equalsIgnoreCase("stc:AstroCoordSystem") || att.equalsIgnoreCase("stc:CatalogEntryLocation"))) {
                this.inAstroCoords = true;
                this.astroCoordsID = (String)atts.get("ID");
                v = (String)atts.get("ref");
                if (v != null && this.astroCoordsID != null) {
                    this.coosys.put(this.astroCoordsID, v);
                }
            } else if (att != null && att.equalsIgnoreCase("spec:PhotometryPoint") || id != null && id.equals("gsed")) {
                this.inSEDGroup = true;
            }
            return;
        }
        depth -= this.ngroup;
        if (this.inSEDGroup && name.equalsIgnoreCase("FIELDref") && (att = (String)atts.get("utype")) != null) {
            if (att.equalsIgnoreCase("photdm:PhotometryFilter.SpectralAxis.Coverage.Location.Value")) {
                this.sFreq = (String)atts.get("ref");
            } else if (att.equalsIgnoreCase("spec:PhotometryPoint")) {
                this.sFlux = (String)atts.get("ref");
            } else if (att.equalsIgnoreCase("spec:PhotoMetryPointError")) {
                this.sFluxErr = (String)atts.get("ref");
            } else if (att.equalsIgnoreCase("photdm:PhotometryFilter.identifier")) {
                this.sSedId = (String)atts.get("ref");
            }
        }
        if (this.inAstroCoords) {
            if (this.astroCoordsID == null) {
                this.astroCoordsID = "_DEFAULTID_" + TableParser.ASTROID++;
            }
            if (name.equalsIgnoreCase("PARAM")) {
                att = (String)atts.get("utype");
                if (att != null && (att.equalsIgnoreCase("stc:AstroCoords.coord_sys_id") || att.equalsIgnoreCase("stc:AstroCoords.coord_system_id") || att.equalsIgnoreCase("stc:AstroCoordSystem.href") || att.equalsIgnoreCase("stc:AstroCoordSystem.SpaceFrame.CoordRefFrame"))) {
                    v = (String)atts.get("value");
                    if (v != null) {
                        this.coosys.put(this.astroCoordsID, v);
                    }
                } else if (att != null && (Util.matchMaskIgnoreCase("stc:Astrocoords.Position?D.Epoch", att) || att.equalsIgnoreCase("stc:AstroCoords.SpaceFrame.Epoch"))) {
                    v = (String)atts.get("value");
                    if (v != null) {
                        if (!Character.isDigit(v.charAt(0)) && (s = this.cooepoch.get(this.astroCoordsID)) != null && s.length() == 1) {
                            v = s + v;
                        }
                        this.cooepoch.put(this.astroCoordsID, v);
                    }
                } else if (att != null && Util.matchMaskIgnoreCase("stc:Astrocoords.Position?D.Epoch.yearDef", att)) {
                    v = (String)atts.get("value");
                    if (v != null) {
                        s = this.cooepoch.get(this.astroCoordsID);
                        if (s != null && Character.isDigit(s.charAt(0))) {
                            v = v + s;
                        }
                        this.cooepoch.put(this.astroCoordsID, v);
                    }
                } else if (att != null && att.equalsIgnoreCase("stc:AstroCoordSystem.SpaceFrame.CoordRefFrame.Equinox")) {
                    v = (String)atts.get("value");
                    if (v != null) {
                        if (!Character.isDigit(v.charAt(0)) && (s = this.cooequinox.get(this.astroCoordsID)) != null && s.length() == 1) {
                            v = s + v;
                        }
                        this.cooequinox.put(this.astroCoordsID, v);
                    }
                } else if (att != null && att.equalsIgnoreCase("stc:AstroCoordSystem.SpaceFrame.CoordRefFrame.Equinox.yearDef")) {
                    v = (String)atts.get("value");
                    if (v != null) {
                        s = this.cooequinox.get(this.astroCoordsID);
                        if (s != null && Character.isDigit(s.charAt(0))) {
                            v = v + s;
                        }
                        this.cooequinox.put(this.astroCoordsID, v);
                    }
                } else if (att != null) {
                    this.consumer.tableParserInfo("      *** AstroCoord PARAM utype unknown => ignored: [" + att + "]");
                }
            } else if (name.equalsIgnoreCase("FIELDref")) {
                att = (String)atts.get("utype");
                if (att != null && Util.matchMaskIgnoreCase("stc:Astrocoords.Position?D.Value*", att)) {
                    v = (String)atts.get("ref");
                    if (v != null) {
                        this.cooFieldref.put(v, this.astroCoordsID);
                    }
                } else if (att != null) {
                    this.consumer.tableParserInfo("      *** AstroCoord FIELDref utype unknown => ignored: [" + att + "]");
                }
            }
        }
        if (this.inVODML) {
            if (name.equalsIgnoreCase("INSTANCE")) {
                dmtype = (String)atts.get("dmtype");
                if (dmtype != null && dmtype.equals("coords:SpaceSys")) {
                    this.astroCoordsID = (String)atts.get("dmid");
                }
            } else if (name.equalsIgnoreCase("REFERENCE")) {
                dmrole = (String)atts.get("dmrole");
                if (dmrole != null && dmrole.equals("coords:Coordinate.coosys")) {
                    this.astroCoordsID = (String)atts.get("dmref");
                }
            } else if (name.equalsIgnoreCase("ATTRIBUTE") && (dmrole = (String)atts.get("dmrole")) != null) {
                if (dmrole.equals("coords:SpaceFrame.spaceRefFrame")) {
                    if (this.astroCoordsID != null && (att = (String)atts.get("value")) != null) {
                        this.coosys.put(this.astroCoordsID, att);
                    }
                } else if (dmrole.equals("coords:SpaceFrame.equinox")) {
                    if (this.astroCoordsID != null && (att = (String)atts.get("value")) != null) {
                        this.cooequinox.put(this.astroCoordsID, att);
                        this.consumer.tableParserInfo(" ." + dmrole + ": " + att + " -> dmid:" + this.astroCoordsID);
                    }
                } else if (dmrole.startsWith("mango:EpochPosition.")) {
                    if (dmrole.equals("mango:EpochPosition.epoch") && (att = (String)atts.get("value")) != null) {
                        this.cooepoch.put(this.astroCoordsID, att);
                        this.consumer.tableParserInfo(" ." + dmrole + "=" + att + " -> " + this.astroCoordsID);
                    }
                    if ((v = (String)atts.get("ref")) != null && this.astroCoordsID != null) {
                        this.cooFieldref.put(v, this.astroCoordsID);
                        this.consumer.tableParserInfo(" ." + dmrole + " (" + v + ") -> " + this.astroCoordsID);
                    }
                }
            }
        }
        if (depth < 5) {
            if (name.equals("INFO")) {
                att = (String)atts.get("name");
                if (att != null && att.equals("AladinFilter")) {
                    this.filter = "";
                    att = (String)atts.get("value");
                    if (att != null) {
                        this.filter = "#" + att + "\n";
                    }
                    if ((att = (String)atts.get("ID")) != null) {
                        this.filter = this.filter + "filter " + att + " {\n";
                    }
                } else if (att != null && att.equals("QUERY_STATUS")) {
                    att = (String)atts.get("value");
                    if (att.equals("OVERFLOW")) {
                        this.consumer.tableParserWarning("!!! Truncated result (server OVERFLOW)");
                    } else if (att.equals("ERROR")) {
                        this.inError = true;
                        this.consumer.tableParserWarning("!!! Result error (server ERROR)");
                    }
                } else {
                    infoID = (String)atts.get("ID");
                    value = (String)atts.get("value");
                    if (infoID != null && value != null) {
                        if (this.firstResourceInfo) {
                            this.firstResourceInfo = false;
                            this.consumer.tableParserInfo("\n.Resource information:");
                        }
                        this.consumer.tableParserInfo("   ." + infoID + ": " + value);
                    }
                }
            } else if (name.equalsIgnoreCase("COOSYS")) {
                id = (String)atts.get("ID");
                if (id != null) {
                    att = (String)atts.get("system");
                    if (att != null) {
                        this.coosys.put(id, att);
                    }
                    if ((att = (String)atts.get("epoch")) != null) {
                        this.cooepoch.put(id, att);
                    }
                    if ((att = (String)atts.get("equinox")) != null) {
                        this.cooequinox.put(id, att);
                    }
                }
            } else if (name.equalsIgnoreCase("TIMESYS")) {
                id = (String)atts.get("ID");
                if (id != null) {
                    att = (String)atts.get("timescale");
                    if (att != null) {
                        this.timescale.put(id, att);
                    }
                    if ((att = (String)atts.get("timeorigin")) != null) {
                        this.timeorigin.put(id, att);
                    }
                    if ((att = (String)atts.get("refposition")) != null) {
                        this.refposition.put(id, att);
                    }
                }
            } else if (name.equalsIgnoreCase("VODML")) {
                this.inVODML = true;
                System.out.println("inVODML=true");
                this.consumer.tableParserInfo("VODML report:");
            }
        }
        switch (depth) {
            case 6: {
                if (name.equalsIgnoreCase("TR")) {
                    this.row = 0;
                    break;
                }
                if (!name.equalsIgnoreCase("STREAM")) break;
                att = (String)atts.get("encoding");
                if (att != null && att.equalsIgnoreCase("base64")) {
                    this.inEncode64 = true;
                    break;
                }
                att = (String)atts.get("href");
                try {
                    this.hrefCall(att);
                    break;
                }
                catch (Exception e) {
                    this.inError = true;
                    this.error = "VOTable external reference error [" + att + "]";
                    if (Aladin.levelTrace >= 3) {
                        e.printStackTrace();
                    }
                    return;
                }
            }
            case 7: {
                if (!name.equalsIgnoreCase("TD")) break;
                this.inTD = true;
                break;
            }
            case 1: {
                if (!name.equalsIgnoreCase("ASTRO")) ** GOTO lbl214
                this.consumer.tableParserInfo("Astrores format");
                this.flagTSV = false;
                ** GOTO lbl217
lbl214:
                // 1 sources

                if (name.equalsIgnoreCase("VOTABLE")) {
                    this.consumer.tableParserInfo("VOTable format");
                    this.flagTSV = false;
                }
            }
lbl217:
            // 5 sources

            case 2: {
                if (name.equalsIgnoreCase("INFO")) {
                    att = (String)atts.get("name");
                    if (att != null && (att.equalsIgnoreCase("ERRORS") || att.equalsIgnoreCase("ERROR"))) {
                        att = (String)atts.get("value");
                        this.error = att == null ? "Unknown VOTable error" : att;
                        return;
                    }
                    att = (String)atts.get("ID");
                    if (att == null || !att.equals("Target") || (att = (String)atts.get("value")) == null) break;
                    this.consumer.setTarget(att);
                    break;
                }
                if (!name.equalsIgnoreCase("RESOURCE")) break;
                att = (String)atts.get("ID");
                if (att != null) {
                    this.consumer.startResource(att);
                } else {
                    this.consumer.startResource((String)atts.get("name"));
                }
                this.firstResourceInfo = true;
                break;
            }
            case 3: {
                if (name.equalsIgnoreCase("INFO")) {
                    att = (String)atts.get("name");
                    if (att == null || !att.equals("QUERY_STATUS") || (att = (String)atts.get("value")) == null || !att.equalsIgnoreCase("ERROR")) break;
                    this.error = "QUERY_STATUS error returned";
                    this.inError = true;
                    return;
                }
                if (!name.equalsIgnoreCase("TABLE")) break;
                this.initTable();
                att = (String)atts.get("name");
                if (att != null) {
                    this.consumer.startTable(att);
                } else {
                    att = (String)atts.get("ID");
                    this.consumer.startTable(att);
                }
                this.consumer.tableParserInfo("\n.Table " + att);
                att = (String)atts.get("name");
                if (att == null) break;
                this.consumer.setTableInfo("name", att);
                break;
            }
            case 4: {
                if (name.equalsIgnoreCase("FIELD")) {
                    if (this.inGroup) {
                        this.resetGroup();
                        this.inGroup = false;
                    }
                    this.f = new Field(atts);
                    break;
                }
                if (name.equalsIgnoreCase("PARAM")) {
                    this.f = new Field(atts);
                    break;
                }
                if (!name.equalsIgnoreCase("DATA")) break;
                this.record = new String[this.nField];
                this.posChooser();
                break;
            }
            case 5: {
                if (name.equalsIgnoreCase("LINK")) {
                    this.f.addInfo("href", (String)atts.get("href"));
                    this.f.addInfo("gref", (String)atts.get("gref"));
                    contentRole = (String)atts.get("content-role");
                    if (contentRole == null || contentRole.equalsIgnoreCase("doc")) {
                        this.f.addInfo("refValue", (String)atts.get("content-type"));
                    }
                    this.f.addInfo("refText", (String)atts.get("title"));
                    this.inLinkField = true;
                    break;
                }
                if (name.equalsIgnoreCase("VALUES")) {
                    this.f.nullValue = (String)atts.get("null");
                    break;
                }
                if (name.equalsIgnoreCase("DESCRIPTION")) {
                    this.inFieldDesc = true;
                    break;
                }
                if (name.equalsIgnoreCase("CSV")) {
                    this.inCSV = true;
                    this.colsep = (String)atts.get("colsep");
                    this.recsep = (String)atts.get("recsep");
                    this.headlines = (String)atts.get("headlines");
                    break;
                }
                if (name.equalsIgnoreCase("BINARY")) {
                    this.inBinary = true;
                    break;
                }
                if (name.equalsIgnoreCase("BINARY2")) {
                    this.inBinary2 = true;
                    break;
                }
                if (!name.equalsIgnoreCase("FITS")) break;
                this.inFits = true;
                att = (String)atts.get("extnum");
                this.fitsExtNum = att != null ? Integer.parseInt(att) : 1;
            }
        }
        if (depth > 4) {
            this.fieldSub = name;
        } else if (depth > 3) {
            this.tableSub = name;
        } else if (depth > 2) {
            this.resourceSub = name;
        }
    }

    private void posChooser() {
        block59: {
            block58: {
                this.flagPosChooser = true;
                this.inAstroCoords = false;
                if (this.inSEDGroup) {
                    this.consumer.tableParserInfo("   -SED system found:");
                    if (this.sFreq != null) {
                        this.consumer.tableParserInfo("      .frequence col #" + this.nFreq + 1);
                    }
                    if (this.sFlux != null) {
                        this.consumer.tableParserInfo("      .flux col      #" + this.nFlux + 1);
                    }
                    if (this.sFluxErr != null) {
                        this.consumer.tableParserInfo("      .fluxError col #" + this.nFluxErr + 1);
                    }
                    if (this.sSedId != null) {
                        this.consumer.tableParserInfo("      .SEDid col     #" + this.nSedId + 1);
                    }
                    this.inSEDGroup = false;
                }
                if ((this.typeFmt & 0x800000000000L) != 0L) {
                    this.consumer.tableParserInfo("   -EPNTAP VOTABLE => barycenter c1min..c1max,c2min..c2max used as longitude,latitude");
                    for (int i = 0; i < this.memoField.size() && (this.nRAmax == -1 || this.nDECmax == -1); ++i) {
                        Field f = this.memoField.get(i);
                        if ("c1max".equals(f.name)) {
                            this.nRAmax = i;
                            continue;
                        }
                        if (!"c2max".equals(f.name)) continue;
                        this.nDECmax = i;
                    }
                }
                this.srcAstroFrame = null;
                this.srcAstroTime = null;
                this.srcTimeFrame = null;
                if ((this.nRA < 0 || this.nDEC < 0) && this.nRADEC >= 0) {
                    this.nRA = this.nDEC = this.nRADEC;
                    this.format = this.formatx;
                }
                if (this.nRA < 0 || this.nDEC < 0) {
                    if (this.nX >= 0 && this.nY >= 0) {
                        this.flagXY = true;
                        this.consumer.setTableInfo("__XYPOS", "true");
                    } else if (this.flagTSV) {
                        this.nRA = 0;
                        this.nDEC = 1;
                    } else {
                        this.nDEC = -1;
                        this.nRA = -1;
                        this.flagNOCOO = true;
                        this.consumer.setTableInfo("__NOCOO", "true");
                    }
                }
                if (this.coosys != null && this.nRA != -1 && !this.flagTSV) {
                    Field f = this.memoField.elementAt(this.nRA);
                    if (f.ref != null) {
                        Field f1;
                        boolean flagDec = false;
                        boolean flagPmra = false;
                        boolean flagPmdec = false;
                        boolean ok = false;
                        if (this.nDEC >= 0) {
                            f1 = this.memoField.elementAt(this.nDEC);
                            ok = f.ref.equals(f1.ref);
                        }
                        flagDec = !ok;
                        ok = false;
                        if (this.nPMRA >= 0) {
                            f1 = this.memoField.elementAt(this.nPMRA);
                            ok = f.ref.equals(f1.ref);
                        }
                        flagPmra = !ok;
                        flagPmra = true;
                        ok = false;
                        if (this.nPMDEC >= 0) {
                            f1 = this.memoField.elementAt(this.nPMDEC);
                            ok = f.ref.equals(f1.ref);
                        }
                        boolean bl = flagPmdec = !ok;
                        if (flagDec || flagPmra || flagPmdec) {
                            Enumeration<Field> e = this.memoField.elements();
                            int i = 0;
                            while (e.hasMoreElements()) {
                                f1 = e.nextElement();
                                if (f1.ref != null && f1.ref.equals(f.ref)) {
                                    if (flagDec && this.qualDEC >= 0 && f.cooPossibleSignature == 2) {
                                        this.nDEC = i;
                                        this.qualDEC -= 1000;
                                    } else if (flagPmra && this.qualPMRA >= 0 && f.cooPossibleSignature == 3) {
                                        this.nPMRA = i;
                                        this.qualPMRA -= 1000;
                                    } else if (flagPmdec && this.qualPMDEC >= 0 && f.cooPossibleSignature == 4) {
                                        this.nPMDEC = i;
                                        this.qualPMDEC -= 1000;
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                }
                this.consumer.setTableRaDecXYIndex(this.nRA, this.nDEC, this.nPMRA, this.nPMDEC, this.nX, this.nY, this.flagNOCOO || (this.qualRA == 1000 || this.qualDEC == 1000) && (this.nX == 1000 || this.nY == 1000));
                if (this.nTime >= 0) {
                    this.consumer.tableParserInfo("   -assuming Time column " + (this.nTime + 1) + " " + TableParser.proba(this.qualTime));
                }
                if (this.flagXY) {
                    this.consumer.tableParserInfo("   -assuming XY positions column " + (this.nX + 1) + " for X and " + (this.nY + 1) + " for Y");
                } else if (this.flagNOCOO) {
                    this.consumer.tableParserInfo("   -assuming table without position");
                } else if (this.nRA >= 0 && this.nDEC >= 0) {
                    this.consumer.tableParserInfo("   -assuming RADEC" + (this.format == 0 ? " " : (this.format == 2 ? " in sexagesimal" : (this.unit == 2 ? " in radians" : " in degrees"))) + " column " + (this.nRA + 1) + " for RA and " + (this.nDEC + 1) + " for DEC");
                    if (this.nPMRA >= 0) {
                        this.consumer.tableParserInfo("   -Proper motion fields found column " + (this.nPMRA + 1) + " for PMRA and " + (this.nPMDEC + 1) + " for PMDEC");
                    }
                }
                if (!this.flagNOCOO) {
                    this.consumer.tableParserInfo("      [RA=" + this.nRA + " " + TableParser.proba(this.qualRA) + " DE=" + this.nDEC + " " + TableParser.proba(this.qualDEC) + " PMRA=" + this.nPMRA + " " + TableParser.proba(this.qualPMRA) + " PMDEC=" + this.nPMDEC + " " + TableParser.proba(this.qualPMDEC) + " X=" + this.nX + " " + TableParser.proba(this.qualX) + " Y=" + this.nY + " " + TableParser.proba(this.qualY) + "]");
                }
                if (this.coosys != null && this.coosys.size() > 0) {
                    this.consumer.tableParserInfo("   -Coordinate system references found:");
                    Enumeration<String> ce = this.coosys.keys();
                    while (ce.hasMoreElements()) {
                        String k = ce.nextElement();
                        String epoch = this.cooepoch.get(k);
                        String equinox = this.cooequinox.get(k);
                        String s = "      ID=\"" + k + "\" => " + this.coosys.get(k) + (equinox == null ? "" : " Eq=" + equinox) + (epoch == null ? "" : " Ep=" + epoch);
                        this.consumer.tableParserInfo(s);
                    }
                    try {
                        Field f = this.memoField.elementAt(this.nRA);
                        if (f.ref != null) {
                            this.setSourceAstroFrame(f.ref, null, null, 0);
                            break block58;
                        }
                        String coosysID = this.cooFieldref.get(f.ID);
                        if (coosysID != null) {
                            this.setSourceAstroFrame(coosysID, null, null, 0);
                            break block58;
                        }
                        throw new Exception();
                    }
                    catch (Exception e) {
                        if (Aladin.levelTrace >= 3) {
                            e.printStackTrace();
                        }
                        if (this.coosys.size() == 1) {
                            try {
                                this.setSourceAstroFrame(this.coosys.keys().nextElement(), null, null, 0);
                            }
                            catch (Exception coosysID) {}
                            break block58;
                        }
                        this.consumer.tableParserInfo("!!! Coordinate system assignation error... assuming ICRS");
                    }
                } else if (!this.flagNOCOO) {
                    this.consumer.tableParserInfo("   -No coordinate system reference found... assuming ICRS");
                }
            }
            if (this.timescale != null && this.timescale.size() > 0) {
                this.consumer.tableParserInfo("   -Time system references found:");
                Enumeration<String> ce = this.timescale.keys();
                while (ce.hasMoreElements()) {
                    String k = ce.nextElement();
                    String origin = this.timeorigin.get(k);
                    String scale = this.timescale.get(k);
                    String refpos = this.refposition.get(k);
                    String s = "      ID=\"" + k + "\" => " + (origin == null ? "" : " timeorigin=" + origin) + (scale == null ? "" : " timescale=" + scale) + (refpos == null ? "" : " refposition=" + refpos);
                    this.consumer.tableParserInfo(s);
                }
                try {
                    Field f = this.memoField.elementAt(this.nTime);
                    if (f.ref != null && this.timescale.get(f.ref) != null) {
                        this.setSourceTimeFrame(f.ref, f.unit, 0);
                    }
                }
                catch (Exception e) {
                    if (this.timescale.size() == 1) {
                        try {
                            this.setSourceTimeFrame(this.timescale.keys().nextElement(), this.f.unit, 0);
                        }
                        catch (Exception exception) {}
                        break block59;
                    }
                    if (Aladin.levelTrace >= 3) {
                        e.printStackTrace();
                    }
                    this.consumer.tableParserInfo("!!! Time system assignation error... assuming TCB/BARYCENTER");
                }
            } else if (this.nTime >= 0) {
                this.consumer.tableParserInfo("   -No time system reference found... TCB/BARYCENTER");
            }
        }
    }

    private static String proba(int qual) {
        return "(proba=" + (100.0 - (double)qual / 10.0) + "%)";
    }

    private void setSourceTimeFrame(String ref, String unit, int timeSystem) {
        String scale = this.timescale.get(ref);
        String refpos = this.refposition.get(ref);
        double origin = 0.0;
        String s = this.timeorigin.get(ref);
        if (s != null) {
            origin = Double.parseDouble(s);
        }
        this.srcTimeFrame = new TimeFrame(scale, refpos, origin, unit, timeSystem);
        this.srcTimeFrame.id = ref;
    }

    private void setSourceAstroFrame(String ref, String eq, String ep, int n) throws Exception {
        if (n > 4) {
            throw new Exception();
        }
        String body = "sky";
        String sys = this.coosys.get(ref);
        if (ep == null) {
            ep = this.cooepoch.get(ref);
        }
        if (eq == null) {
            eq = this.cooequinox.get(ref);
        }
        char letter = 'J';
        if (sys.indexOf("FK4") >= 0 || sys.indexOf("B1950") >= 0) {
            letter = 'B';
        }
        if (ep != null && ep.length() > 1 && Character.isDigit(ep.charAt(0))) {
            ep = letter + ep;
        }
        if (eq != null && eq.length() > 1 && Character.isDigit(eq.charAt(0))) {
            eq = letter + eq;
        }
        if (sys.indexOf("FK4") >= 0) {
            this.srcAstroFrame = eq == null ? AF_FK4 : Astroframe.create("FK4(B" + new Astrotime(eq).getByr() + ")");
            if (ep != null) {
                this.srcAstroTime = new Astrotime(ep);
                this.srcAstroFrame.setFrameEpoch(this.srcAstroTime.getByr());
            }
        } else if (sys.indexOf("B1950") >= 0) {
            this.srcAstroFrame = AF_FK4;
        } else if (sys.indexOf("FK5") >= 0) {
            this.srcAstroFrame = eq == null ? AF_FK5 : Astroframe.create("FK5(J" + new Astrotime(eq).getJyr() + ")");
            if (ep != null) {
                this.srcAstroTime = new Astrotime(ep);
                this.srcAstroFrame.setFrameEpoch(this.srcAstroTime.getJyr());
            }
        } else if (sys.indexOf("J2000") >= 0) {
            this.srcAstroFrame = AF_FK5;
        } else if (sys.indexOf("ECLIPTIC") >= 0 || sys.indexOf("ECL") >= 0) {
            this.srcAstroFrame = eq == null ? AF_ECLI : Astroframe.create("Ecliptic(J" + new Astrotime(eq).getJyr() + ")");
            if (ep != null) {
                this.srcAstroTime = new Astrotime(ep);
                this.srcAstroFrame.setFrameEpoch(this.srcAstroTime.getJyr());
            }
        } else if (sys.indexOf("SUPER_GALACTIC") >= 0 || sys.indexOf("SGAL") >= 0) {
            this.srcAstroFrame = AF_SGAL;
        } else if (sys.indexOf("GALACTIC") >= 0 || sys.indexOf("GAL") >= 0) {
            this.srcAstroFrame = AF_GAL;
        } else if (sys.indexOf("ICRS") >= 0) {
            if (ep != null) {
                this.srcAstroTime = new Astrotime(ep);
                this.srcAstroFrame = new ICRS(this.srcAstroTime.getJyr());
            }
        } else {
            String sref = this.coosys.get(sys);
            body = sys;
            this.consumer.tableParserInfo("      => Body of the coordinate system: \"" + body + "\"");
            if (sref != null) {
                this.setSourceAstroFrame(sys, eq, ep, n + 1);
                return;
            }
            this.consumer.tableParserInfo("      !!! Coordinate system unknown... assuming ICRS");
        }
        this.consumer.tableParserWarning("!!! BODY=" + body);
        if ((this.srcAstroFrame + "").equals("ICRS") && (this.srcAstroTime == null || this.srcAstroTime.getJyr() == 2000.0)) {
            this.srcAstroFrame = null;
        }
        if (ref == null) {
            ref = "null";
        }
        if (this.srcAstroFrame != null) {
            if (!(this.srcAstroFrame != AF_FK5 && !(this.srcAstroFrame + "").equals("FK5(J2000.0)") || this.srcAstroTime != null && this.srcAstroTime.getJyr() != 2000.0)) {
                this.consumer.tableParserInfo("      => RA/DEC coordinate conversion not required: ref=\"" + ref + "\" => " + this.srcAstroFrame + " to " + this.trgAstroFrame);
                this.srcAstroFrame = null;
            } else {
                this.c = new Astropos(this.srcAstroFrame);
                this.c.setEpoch(this.srcAstroTime.getJyr());
                this.consumer.tableParserInfo("      => RA/DEC coordinate conversion: ref=\"" + ref + "\" => " + this.srcAstroFrame + "/ep:" + this.srcAstroTime.getJyr() + " to " + this.trgAstroFrame);
            }
        } else {
            this.consumer.tableParserInfo("      => RA/DEC coordinate system used: ref=\"" + ref + "\" => " + this.trgAstroFrame);
        }
        if (this.srcAstroFrame != null && this.consumer instanceof Pcat) {
            ((Pcat)this.consumer).setOriginalEpoch(this.srcAstroTime.getJyr() + "");
        }
    }

    private void setDefaultField() {
        this.tsvField = new Field[this.nField];
        for (int i = 0; i < this.nField; ++i) {
            Field f = this.tsvField[i] = new Field("C" + (i + 1));
            f.datatype = "D";
            this.consumer.setField(f);
        }
    }

    public static int getRaDec(Astrocoo c, String ra, String dec, int format, int unit) throws Exception {
        block18: {
            double signDec;
            double signRa;
            block17: {
                signRa = 1.0;
                signDec = 1.0;
                if (ra == null || dec == null) {
                    c.set(Double.NaN, Double.NaN);
                    return format;
                }
                if (format == 0) {
                    String ra1 = ra;
                    String dec1 = dec;
                    if (TableParser.isNSEW(ra)) {
                        ra1 = ra.substring(0, ra.length() - 1);
                        dec1 = dec.substring(0, dec.length() - 1);
                        format = 4;
                    }
                    try {
                        char ss = dec.charAt(0);
                        format |= TableParser.isSexa(ra1 + (ss != '-' && ss != '+' ? " +" : " ") + dec1) ? 2 : 1;
                    }
                    catch (Exception e) {
                        c.set(Double.NaN, Double.NaN);
                        if (Aladin.levelTrace <= 3) break block17;
                        e.printStackTrace();
                    }
                }
            }
            if ((format & 4) != 0) {
                int n = ra.length() - 1;
                signRa = ra.charAt(n) == 'W' ? -1.0 : 1.0;
                ra = ra.substring(0, n);
                n = dec.length() - 1;
                signDec = dec.charAt(n) == 'S' ? -1.0 : 1.0;
                dec = dec.substring(0, n);
                format = 4;
            }
            if ((format & 2) != 0) {
                try {
                    int ss = dec.charAt(0);
                    if ((format & 4) != 0) {
                        if (signDec == -1.0) {
                            int n = ss = ss == 45 ? 43 : 45;
                        }
                        if (signRa == -1.0) {
                            ra = "-" + ra;
                        }
                    }
                    String s = ss == 45 || ss == 43 ? ra + " " + dec : ra + " +" + dec;
                    c.set(s);
                }
                catch (Exception e) {
                    c.set(Double.NaN, Double.NaN);
                    if (Aladin.levelTrace > 3) {
                        e.printStackTrace();
                    }
                    break block18;
                }
            }
            try {
                double rax = Double.parseDouble(ra);
                double dex = Double.parseDouble(dec);
                if ((format & 4) != 0) {
                    rax *= signRa;
                    dex *= signDec;
                }
                if (unit == 2) {
                    rax = Math.toDegrees(rax);
                    dex = Math.toDegrees(dex);
                }
                c.set(rax, dex);
            }
            catch (Exception e) {
                c.set(Double.NaN, Double.NaN);
            }
        }
        return format;
    }

    private static boolean isSexa(String s) {
        int n = s.length();
        int nbb = 0;
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c == ':' || c == ' ' || c == '\t') {
                ++nbb;
            }
            if (nbb <= 1) continue;
            return true;
        }
        return false;
    }

    private static boolean isNSEW(String s) {
        int n = s.length();
        if (n < 2) {
            return false;
        }
        char c = s.charAt(n - 1);
        return c == 'N' || c == 'S' || c == 'E' || c == 'W';
    }

    private int timeName(String s) {
        if ((s = s.toLowerCase()).equals("epoch")) {
            return 0;
        }
        if (s.equals("date")) {
            return 1;
        }
        if (s.equals("date_obs")) {
            return 2;
        }
        if (s.equals("t_min")) {
            return 3;
        }
        if (s.equals("t_max")) {
            return 4;
        }
        return -1;
    }

    private int timeSubName(String s) {
        if ((s = s.toLowerCase()).startsWith("epoch")) {
            return 0;
        }
        if (s.startsWith("jd")) {
            return 1;
        }
        if (s.startsWith("mjd")) {
            return 2;
        }
        if (s.startsWith("hjd")) {
            return 3;
        }
        if (s.startsWith("date")) {
            return 4;
        }
        if (s.startsWith("utc")) {
            return 5;
        }
        return -1;
    }

    private int raName(String s) {
        if (s.equalsIgnoreCase("elonavg")) {
            this.setEq();
            return 0;
        }
        if (s.equalsIgnoreCase("_RAJ2000")) {
            this.setEq();
            return 0;
        }
        if (s.equalsIgnoreCase("RAJ2000")) {
            this.setEq();
            return 1;
        }
        if (s.equalsIgnoreCase("_RA")) {
            this.setEq();
            return 2;
        }
        if (s.equalsIgnoreCase("RA(ICRS)")) {
            this.setEq();
            return 3;
        }
        if (s.equalsIgnoreCase("RA")) {
            this.setEq();
            return 4;
        }
        if (s.equalsIgnoreCase("LON")) {
            this.setEq();
            return 5;
        }
        if (s.equalsIgnoreCase("LONG")) {
            this.setEq();
            return 5;
        }
        if (s.equalsIgnoreCase("ALPHA_J2000")) {
            this.setEq();
            return 5;
        }
        if (s.equalsIgnoreCase("GLON")) {
            this.setGal();
            return 6;
        }
        if (s.equalsIgnoreCase("SGLON")) {
            this.setSGal();
            return 6;
        }
        if (s.equalsIgnoreCase("SLON")) {
            this.setSGal();
            return 6;
        }
        if (s.equalsIgnoreCase("ELON")) {
            this.setEcl();
            return 6;
        }
        return -1;
    }

    private int raSubName(String s) {
        if ((s = s.toLowerCase()).indexOf("radius") >= 0) {
            this.setEq();
            return -1;
        }
        if (s.startsWith("_ra")) {
            this.setEq();
            return 0;
        }
        if (s.endsWith("_ra")) {
            this.setEq();
            return 1;
        }
        if (s.startsWith("ra")) {
            this.setEq();
            return 1;
        }
        if (s.startsWith("alpha")) {
            this.setEq();
            return 2;
        }
        if (s.startsWith("lon")) {
            this.setEq();
            return 3;
        }
        if (s.startsWith("glon")) {
            this.setGal();
            return 4;
        }
        if (s.startsWith("sglon")) {
            this.setSGal();
            return 4;
        }
        if (s.startsWith("slon")) {
            this.setSGal();
            return 4;
        }
        if (s.startsWith("elon")) {
            this.setEcl();
            return 4;
        }
        return -1;
    }

    private int deName(String s) {
        if (s.equalsIgnoreCase("elatavg")) {
            this.setEq();
            return 0;
        }
        if (s.equalsIgnoreCase("_DEJ2000")) {
            this.setEq();
            return 0;
        }
        if (s.equalsIgnoreCase("_DECJ2000")) {
            this.setEq();
            return 1;
        }
        if (s.equalsIgnoreCase("DEJ2000")) {
            this.setEq();
            return 2;
        }
        if (s.equalsIgnoreCase("DECJ2000")) {
            this.setEq();
            return 3;
        }
        if (s.equalsIgnoreCase("_DE")) {
            this.setEq();
            return 4;
        }
        if (s.equalsIgnoreCase("_DEC")) {
            this.setEq();
            return 5;
        }
        if (s.equalsIgnoreCase("DE(ICRS)")) {
            this.setEq();
            return 6;
        }
        if (s.equalsIgnoreCase("DEC(ICRS)")) {
            this.setEq();
            return 6;
        }
        if (s.equalsIgnoreCase("DEC")) {
            this.setEq();
            return 7;
        }
        if (s.equalsIgnoreCase("DE")) {
            this.setEq();
            return 8;
        }
        if (s.equalsIgnoreCase("DELTA_J2000")) {
            this.setEq();
            return 8;
        }
        if (s.equalsIgnoreCase("LAT")) {
            this.setEq();
            return 8;
        }
        if (s.equalsIgnoreCase("GLAT")) {
            this.setGal();
            return 9;
        }
        if (s.equalsIgnoreCase("SGLAT")) {
            this.setSGal();
            return 9;
        }
        if (s.equalsIgnoreCase("SLAT")) {
            this.setSGal();
            return 9;
        }
        if (s.equalsIgnoreCase("ELAT")) {
            this.setEcl();
            return 9;
        }
        return -1;
    }

    private int deSubName(String s) {
        if ((s = s.toLowerCase()).startsWith("_dec")) {
            this.setEq();
            return 0;
        }
        if (s.startsWith("_de")) {
            this.setEq();
            return 1;
        }
        if (s.endsWith("_de")) {
            this.setEq();
            return 1;
        }
        if (s.endsWith("_dec")) {
            this.setEq();
            return 1;
        }
        if (s.startsWith("dec")) {
            this.setEq();
            return 2;
        }
        if (s.startsWith("de")) {
            this.setEq();
            return 3;
        }
        if (s.indexOf("de") > 0) {
            this.setEq();
            return 4;
        }
        if (s.startsWith("delta")) {
            this.setEq();
            return 5;
        }
        if (s.startsWith("lat")) {
            this.setEq();
            return 6;
        }
        if (s.startsWith("glat")) {
            this.setGal();
            return 6;
        }
        if (s.startsWith("sglat")) {
            this.setSGal();
            return 6;
        }
        if (s.startsWith("slat")) {
            this.setSGal();
            return 6;
        }
        if (s.startsWith("elat")) {
            this.setEcl();
            return 6;
        }
        return -1;
    }

    private void validLastCoordSys() {
        this.srcAstroFrame = this.lastCoordSys;
        if (this.srcAstroFrame == AF_GAL) {
            this.coosys.put(DEFAULT, "GAL");
        } else if (this.srcAstroFrame == AF_SGAL) {
            this.coosys.put(DEFAULT, "SGAL");
        } else if (this.srcAstroFrame == AF_SGAL) {
            this.coosys.put(DEFAULT, "ECL");
        } else {
            this.coosys.remove(DEFAULT);
        }
    }

    private void validLastTimeSys() {
        this.srcTimeFrame = this.lastTimeSys;
    }

    private void setGal() {
        this.lastCoordSys = AF_GAL;
    }

    private void setSGal() {
        this.lastCoordSys = AF_SGAL;
    }

    private void setEcl() {
        this.lastCoordSys = AF_ECLI;
    }

    private void setEq() {
        this.lastCoordSys = null;
    }

    private int timeUcd(String s) {
        int n;
        int i = s.indexOf(59);
        if (i > 0) {
            s = s.substring(0, i);
        }
        if ((n = Util.indexInArrayOf(s, UCDTIME)) >= 0 && s.endsWith("meta.main")) {
            n -= 10;
        }
        return n;
    }

    private int useTimeSys(Field f, String ucd) {
        if (this.timescale == null) {
            return -1;
        }
        if (f.ref == null) {
            return -1;
        }
        if (this.timescale.get(f.ref) != null) {
            return ucd != null && Util.indexOfIgnoreCase(ucd, "main") >= 0 ? 50 : 0;
        }
        return -1;
    }

    private int pmraName(String s) {
        if (s.equalsIgnoreCase("PMRA")) {
            return 0;
        }
        return -1;
    }

    private int pmraSubName(String s) {
        if ((s = s.toLowerCase()).startsWith("pmra")) {
            return 0;
        }
        return -1;
    }

    private int pmdecName(String s) {
        if (s.equalsIgnoreCase("PMDE")) {
            return 0;
        }
        if (s.equalsIgnoreCase("PMDEC")) {
            return 1;
        }
        return -1;
    }

    private int pmdecSubName(String s) {
        if ((s = s.toLowerCase()).startsWith("pmde")) {
            return 0;
        }
        return -1;
    }

    private int xName(String s) {
        if (s.equalsIgnoreCase("XPOS")) {
            return 0;
        }
        if (s.equalsIgnoreCase("XPIX")) {
            return 1;
        }
        if (s.equalsIgnoreCase("X")) {
            return 2;
        }
        if (s.equalsIgnoreCase("POSX")) {
            return 3;
        }
        if (s.equalsIgnoreCase("X_IMAGE")) {
            return 4;
        }
        return -1;
    }

    private int xSubName(String s) {
        if (s.startsWith("XPOS") || s.startsWith("Xpos")) {
            return 0;
        }
        if (s.startsWith("XPIX") || s.startsWith("Xpix")) {
            return 1;
        }
        if (s.indexOf("XPOS") >= 0 || s.indexOf("Xpos") >= 0 || s.indexOf("XPIX") >= 0 || s.indexOf("Xpix") >= 0) {
            return 2;
        }
        if ((s.startsWith("X") || s.startsWith("x")) && !Character.isLetterOrDigit(s.charAt(1))) {
            return 3;
        }
        return -1;
    }

    private int yName(String s) {
        if (s.equalsIgnoreCase("YPOS")) {
            return 0;
        }
        if (s.equalsIgnoreCase("YPIX")) {
            return 1;
        }
        if (s.equalsIgnoreCase("Y")) {
            return 2;
        }
        if (s.equalsIgnoreCase("POSY")) {
            return 3;
        }
        if (s.equalsIgnoreCase("Y_IMAGE")) {
            return 4;
        }
        return -1;
    }

    private int ySubName(String s) {
        if (s.startsWith("YPOS") || s.startsWith("Ypos")) {
            return 0;
        }
        if (s.startsWith("YPIX") || s.startsWith("Ypix")) {
            return 1;
        }
        if (s.indexOf("YPOS") >= 0 || s.indexOf("Ypos") >= 0 || s.indexOf("YPIX") >= 0 || s.indexOf("Ypix") >= 0) {
            return 2;
        }
        if ((s.startsWith("Y") || s.startsWith("y")) && !Character.isLetterOrDigit(s.charAt(1))) {
            return 3;
        }
        return -1;
    }

    private void detectSEDField(Field f, int nField) {
        String name;
        String string = name = f.ID != null ? f.ID : f.name;
        if (name == null) {
            return;
        }
        if (this.sFreq != null && name.equals(this.sFreq)) {
            f.sed = 1;
            this.nFreq = nField;
        } else if (this.sFlux != null && name.equals(this.sFlux)) {
            f.sed = 2;
            this.nFlux = nField;
        } else if (this.sFluxErr != null && name.equals(this.sFluxErr)) {
            f.sed = 3;
            this.nFluxErr = nField;
        } else if (this.sSedId != null && name.equals(this.sSedId)) {
            f.sed = 4;
            this.nSedId = nField;
        } else if (nField == this.nTime) {
            f.sed = 5;
        } else {
            return;
        }
    }

    private boolean scanTimeOffset(String s) {
        boolean rep = this.scanTimeOffset(s, '-');
        if (!rep) {
            this.scanTimeOffset(s, '+');
        }
        return rep;
    }

    private boolean scanTimeOffset(String s, char signe) {
        if (s == null) {
            return false;
        }
        int m = s.lastIndexOf(signe);
        int p = s.indexOf(41, m);
        if (p == -1) {
            p = s.length();
        }
        if (m != -1) {
            try {
                double x;
                this.timeOffset = x = Double.parseDouble(s.substring(m + 1, p));
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private void detectPosField(Field f, int nField) {
        String name = f.name == null ? "" : f.name;
        String ucd = f.ucd == null ? "" : f.ucd;
        String unit = f.unit == null ? "" : f.unit;
        String ID = f.ID == null ? "" : f.ID;
        boolean numeric = f.isNumDataType();
        if (this.memoField == null) {
            this.memoField = new Vector();
        }
        this.memoField.addElement(f);
        int qual = -1;
        int n = this.useTimeSys(f, ucd);
        if (n >= 0) {
            qual = 0 + n;
        } else {
            n = this.timeUcd(ucd);
            if (n >= 0) {
                qual = 100 + n;
            } else if (unit.indexOf("H:") >= 0 || unit.indexOf("M:") >= 0) {
                qual = 300;
            } else {
                n = this.timeName(name);
                if (n >= 0) {
                    qual = 400 + n;
                } else {
                    n = this.timeSubName(name);
                    if (n >= 0) {
                        qual = 500 + n;
                    }
                }
            }
        }
        if (qual >= 0 && this.qualTime > qual) {
            this.nTime = nField;
            this.qualTime = qual;
            this.timeField = f;
            if (!this.scanTimeOffset(name)) {
                this.scanTimeOffset(f.description);
            }
            this.validLastTimeSys();
        }
        qual = -1;
        if (ucd.equals("POS_EQ_RA_MAIN") || ucd.equals("pos.eq.ra;meta.main")) {
            qual = 0;
        } else if ((this.typeFmt & 0x800000000000L) != 0L && ID.equals("c1min")) {
            qual = 50;
        } else if (ucd.startsWith("POS_EQ_RA") || ucd.startsWith("pos.eq.ra")) {
            qual = 100;
        } else {
            n = this.raName(name);
            if (n >= 0) {
                qual = unit.indexOf("h:m:s") >= 0 ? 200 + n : (unit.indexOf("deg") >= 0 ? 200 + n : (numeric ? 200 + n : 400 + n));
            } else {
                n = this.raSubName(name);
                if (n >= 0) {
                    qual = unit.indexOf("h:m:s") >= 0 ? 300 + n : (unit.indexOf("deg") >= 0 ? 300 + n : (numeric ? 300 + n : 450 + n));
                }
            }
        }
        if (qual >= 0 && this.qualRA > qual) {
            this.nRA = nField;
            this.qualRA = qual;
            f.cooPossibleSignature = 1;
            this.unit = TableParser.getUnit(unit);
            this.format = unit.length() == 0 ? 0 : (unit.indexOf("h") >= 0 && unit.indexOf("m") >= 0 && unit.indexOf("s") >= 0 ? 2 : 1);
            this.validLastCoordSys();
        }
        qual = -1;
        if (ucd.equals("POS_EQ_DEC_MAIN") || ucd.equals("pos.eq.dec;meta.main")) {
            qual = 0;
        } else if ((this.typeFmt & 0x800000000000L) != 0L && ID.equals("c2min")) {
            qual = 50;
        } else if (ucd.startsWith("POS_EQ_DEC") || ucd.startsWith("pos.eq.dec")) {
            qual = 100;
        } else {
            n = this.deName(name);
            if (n >= 0) {
                qual = unit.indexOf("d:m:s") >= 0 ? 200 + n : (unit.startsWith("deg") ? 200 + n : (numeric ? 200 + n : 400 + n));
            } else {
                n = this.deSubName(name);
                if (n >= 0) {
                    qual = unit.indexOf("d:m:s") >= 0 ? 300 + n : (unit.startsWith("deg") ? 300 + n : (numeric ? 300 + n : 450 + n));
                }
            }
        }
        if (qual > 0 && this.nRA == nField - 1 && this.nRA >= 0) {
            --qual;
        }
        if (qual >= 0 && this.qualDEC > qual) {
            this.nDEC = nField;
            this.qualDEC = qual;
            f.cooPossibleSignature = 2;
        }
        qual = -1;
        if (ucd.equals("POS_PMRA_MAIN") || ucd.equals("pos.pm;pos.eq.ra;meta.main")) {
            try {
                new Unit(unit).convertTo(new Unit("mas/yr"));
                qual = 0;
            }
            catch (Exception e) {
                qual = 1;
            }
        } else if (ucd.equals("POS_PMRA") || ucd.equals("pos.pm;pos.eq.ra")) {
            try {
                new Unit(unit).convertTo(new Unit("mas/yr"));
                qual = 100;
            }
            catch (Exception e) {
                try {
                    new Unit(unit).convertTo(new Unit("ms/yr"));
                    qual = 100;
                }
                catch (Exception e1) {
                    qual = 101;
                }
            }
        } else {
            n = this.pmraName(name);
            if (n >= 0) {
                if (ucd.startsWith("pos.pm")) {
                    qual = 200 + n;
                } else {
                    try {
                        new Unit(unit).convertTo(new Unit("mas/yr"));
                        qual = 300 + n;
                    }
                    catch (Exception e) {
                        try {
                            new Unit(unit).convertTo(new Unit("ms/yr"));
                            qual = 300 + n;
                        }
                        catch (Exception e1) {
                            qual = 600 + n;
                        }
                    }
                }
            } else {
                n = this.pmraSubName(name);
                if (n >= 0) {
                    if (ucd.startsWith("pos.pm")) {
                        qual = 400 + n;
                    } else {
                        try {
                            new Unit(unit).convertTo(new Unit("mas/yr"));
                            qual = 500 + n;
                        }
                        catch (Exception e) {
                            try {
                                new Unit(unit).convertTo(new Unit("ms/yr"));
                                qual = 500 + n;
                            }
                            catch (Exception e1) {
                                qual = 700 + n;
                            }
                        }
                    }
                }
            }
        }
        if (qual >= 0 && this.qualPMRA > qual) {
            this.nPMRA = nField;
            this.qualPMRA = qual;
            this.unitPMRA = Util.adjustFoxUnit(unit);
            f.cooPossibleSignature = 3;
        }
        qual = -1;
        if (ucd.equals("POS_PMDE_MAIN") || ucd.equals("pos.pm;pos.eq.dec;meta.main")) {
            qual = 0;
        } else if (ucd.equals("POS_PMDE") || ucd.equals("pos.pm;pos.eq.dec")) {
            qual = 100;
        } else {
            n = this.pmdecName(name);
            if (n >= 0) {
                if (ucd.startsWith("pos.pm")) {
                    qual = 200 + n;
                }
                try {
                    new Unit(unit).convertTo(new Unit("mas/yr"));
                    qual = 300 + n;
                }
                catch (Exception e) {
                    qual = 600 + n;
                }
            } else {
                n = this.pmdecSubName(name);
                if (n >= 0) {
                    if (ucd.startsWith("pos.pm")) {
                        qual = 400 + n;
                    } else {
                        try {
                            new Unit(unit).convertTo(new Unit("mas/yr"));
                            qual = 500 + n;
                        }
                        catch (Exception e) {
                            qual = 700 + n;
                        }
                    }
                }
            }
        }
        if (qual >= 0 && this.qualPMDEC > qual) {
            this.nPMDEC = nField;
            this.qualPMDEC = qual;
            this.unitPMDEC = Util.adjustFoxUnit(unit);
            f.cooPossibleSignature = 4;
        }
        qual = -1;
        if (ucd.equals("POS_CCD_X") || ucd.equals("pos.cartesian.x;instr.det")) {
            qual = 0;
        } else if (ucd.startsWith("pos.cartesian.x")) {
            qual = 100;
        } else {
            n = this.xName(name);
            if (n >= 0) {
                qual = ucd.startsWith("pos.det") ? 200 + n : (unit.equals("pix") || unit.equals("mm") ? 300 + n : 600 + n);
            } else {
                n = this.xSubName(name);
                if (n >= 0) {
                    qual = ucd.startsWith("pos.det") ? 400 + n : (unit.equals("pix") || unit.equals("mm") ? 500 + n : 700 + n);
                }
            }
        }
        if (qual >= 0 && this.qualX > qual) {
            this.nX = nField;
            this.qualX = qual;
        }
        qual = -1;
        if (ucd.equals("POS_CCD_Y") || ucd.equals("pos.cartesian.y;instr.det")) {
            qual = 0;
        } else if (ucd.startsWith("pos.cartesian.y")) {
            qual = 100;
        } else {
            n = this.yName(name);
            if (n >= 0) {
                qual = ucd.startsWith("pos.det") ? 200 + n : (unit.equals("pix") || unit.equals("mm") ? 300 + n : 600 + n);
            } else {
                n = this.ySubName(name);
                if (n >= 0) {
                    qual = ucd.startsWith("pos.det") ? 400 + n : (unit.equals("pix") || unit.equals("mm") ? 500 + n : 700 + n);
                }
            }
        }
        if (qual >= 0 && this.qualY > qual) {
            this.nY = nField;
            this.qualY = qual;
        }
        if (this.nRA == -1 && (ucd.equals("pos.eq") || ucd.equals("pos.eq;meta.main"))) {
            this.nRADEC = nField;
            this.unit = TableParser.getUnit(unit);
            this.formatx = unit.length() == 0 ? 0 : (unit.indexOf("h") >= 0 && unit.indexOf("m") >= 0 && unit.indexOf("s") >= 0 ? 2 : 1);
            this.validLastCoordSys();
            return;
        }
    }

    @Override
    public void endElement(String name) {
        if (this.inError) {
            this.inError = false;
        }
        int depth = this.xmlparser.getDepth() + 1;
        if (name.length() == 0) {
            return;
        }
        if (this.inGroup) {
            this.memoEndGroup(name);
        }
        if (name.charAt(0) == 'G' && depth >= 1 && name.equalsIgnoreCase("GROUP")) {
            --this.ngroup;
            this.inGroup = false;
            return;
        }
        if ((depth -= this.ngroup) == 7 && name.equalsIgnoreCase("TD")) {
            this.inTD = false;
            if (!this.valueInTD) {
                this.record[this.row] = null;
            }
            this.valueInTD = false;
            ++this.row;
        } else if (depth == 6 && name.equalsIgnoreCase("TR")) {
            this.consumeRecord(this.record, -1);
        } else if (depth == 6 && name.equalsIgnoreCase("STREAM")) {
            this.inEncode64 = false;
        } else if (depth == 3 && name.equalsIgnoreCase("TABLE")) {
            if (!this.flagPosChooser) {
                this.posChooser();
            }
            this.tableSub = null;
            this.fieldSub = null;
            this.consumer.endTable();
        } else if (depth == 2 && name.equalsIgnoreCase("RESOURCE")) {
            this.resourceSub = null;
            this.tableSub = null;
            this.fieldSub = null;
            this.consumer.endResource();
        } else if (name.equalsIgnoreCase("DESCRIPTION")) {
            this.inFieldDesc = false;
        } else if (depth == 5 && name.equalsIgnoreCase("LINK")) {
            this.inLinkField = false;
        } else if (depth == 5 && name.equalsIgnoreCase("CSV")) {
            this.inCSV = false;
        } else if (depth == 5 && name.equalsIgnoreCase("BINARY")) {
            this.inBinary = false;
        } else if (depth == 5 && name.equalsIgnoreCase("BINARY2")) {
            this.inBinary2 = false;
        } else if (depth == 5 && name.equalsIgnoreCase("FITS")) {
            this.inFits = false;
        } else if (depth == 4 && name.equalsIgnoreCase("FIELD")) {
            this.fieldSub = null;
            if (this.f.name == null) {
                this.f.name = this.f.ID;
            }
            this.detectPosField(this.f, this.nField);
            this.detectSEDField(this.f, this.nField);
            ++this.nField;
            this.consumer.setField(this.f);
        } else if (depth != 4 || name.equalsIgnoreCase("PARAM")) {
            // empty if block
        }
    }

    private boolean isEmpty(char[] ch, int start, int length) {
        for (int i = 0; i < length; ++i) {
            if (Character.isSpace(ch[i + start])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws Exception {
        try {
            if (this.inGroup) {
                this.memoInGroup(ch, start, length);
                return;
            }
            if (this.inEncode64) {
                this.parseBase64(ch, start, length, this.inBinary2);
                return;
            }
            if (this.isEmpty(ch, start, length)) {
                return;
            }
            if (this.inLinkField) {
                if (this.f.refText == null) {
                    this.f.addInfo("refText", TableParser.getStringTrim(ch, start, length));
                }
            } else if (this.inFieldDesc) {
                if (this.f != null) {
                    this.f.addInfo("DESCRIPTION", TableParser.getStringTrim(ch, start, length));
                }
            } else if (this.inCSV || this.flagTSV) {
                this.dataParse(ch, start, length);
            } else if (this.inTD) {
                if (this.row >= this.record.length) {
                    this.error = "VOTable error: too many TD elements compared to FIELDs definition";
                    this.valueInTD = true;
                } else {
                    this.record[this.row] = TableParser.getStringTrim(ch, start, length);
                    this.valueInTD = length > 0;
                }
            } else if (this.inError) {
                this.error = TableParser.getStringTrim(ch, start, length);
            } else if (this.f != null && this.fieldSub != null) {
                this.f.addInfo(this.fieldSub, TableParser.getStringTrim(ch, start, length));
            } else if (this.filter != null) {
                this.consumeFilter(TableParser.getStringTrim(ch, start, length));
            } else if (this.tableSub != null) {
                this.consumer.setTableInfo(this.tableSub, TableParser.getStringTrim(ch, start, length));
            } else if (this.resourceSub != null) {
                this.consumer.setResourceInfo(this.resourceSub, TableParser.getStringTrim(ch, start, length));
            }
        }
        catch (Exception e) {
            if (Aladin.levelTrace == 4) {
                System.err.println("TableParser.character() exception: table line " + this.xmlparser.getCurrentLine());
            }
            if (Aladin.levelTrace > 4) {
                e.printStackTrace();
            }
            throw e;
        }
    }

    private void consumeFilter(String filterRule) {
        this.consumer.setFilter(this.filter + filterRule + (this.filter.length() > 0 ? "\n}\n" : ""));
        this.filter = null;
    }

    public static int getUnit(String s) {
        if (s == null) {
            return 0;
        }
        if (Util.indexOfIgnoreCase(s, "RAD") >= 0) {
            return 2;
        }
        if (Util.indexOfIgnoreCase(s, "DEG") >= 0) {
            return 1;
        }
        return 0;
    }

    private boolean hasSomething(String s) {
        return s != null && s.trim().length() > 0;
    }

    private void consumeRecord(String[] rec, int nbRecord) {
        block59: {
            double jdTime = Double.NaN;
            boolean timeValue = false;
            if (this.nTime >= 0 && (timeValue = this.hasSomething(rec[this.nTime]))) {
                if (this.timeFormat == -1) {
                    boolean numeric = false;
                    double t = Double.NaN;
                    if (this.timeField.unit != null) {
                        if (this.timeField.unit.equalsIgnoreCase("JD")) {
                            this.timeFormat = 13;
                        } else if (this.timeField.unit.equalsIgnoreCase("MJD")) {
                            this.timeFormat = 14;
                        }
                    }
                    if (this.timeFormat == -1) {
                        String s = rec[this.nTime].trim();
                        if (s.length() > 0) {
                            try {
                                t = Double.parseDouble(s);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (!Double.isNaN(t)) {
                                numeric = true;
                            } else if (this.timeField.datatype != null && this.timeField.isNumDataType()) {
                                this.consumer.tableParserInfo("   -Dubious time field data type [numerical] => ignored");
                            }
                        }
                        if (numeric) {
                            boolean flagYear;
                            if (this.timeOffset > 0.0) {
                                t += this.timeOffset;
                            }
                            boolean bl = flagYear = this.timeField.unit != null && (this.timeField.unit.indexOf("y") >= 0 || this.timeField.unit.indexOf("a") >= 0);
                            this.timeFormat = flagYear ? 16 : (t < 100000.0 ? 14 : 13);
                        } else {
                            this.timeFormat = rec[this.nTime].indexOf(84) > 0 ? 15 : 17;
                        }
                    }
                    this.timeField.coo = this.timeFormat;
                    if (this.srcTimeFrame == null) {
                        this.srcTimeFrame = new TimeFrame("TCB", "BARYCENTER", this.timeOffset, this.timeField.unit, this.timeFormat);
                        if (this.timeOffset != 0.0 && this.timeField.unit != null) {
                            try {
                                String u = this.cleanUnitPrefix(this.timeField.unit);
                                this.srcTimeFrame.setTimeOrigin(this.timeOffset, u);
                            }
                            catch (Exception e) {
                                if (Aladin.levelTrace >= 3) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    } else {
                        this.srcTimeFrame.setTimeFormat(this.timeFormat);
                    }
                    this.consumer.tableParserInfo("   -Ref time system:" + this.srcTimeFrame);
                }
                if (timeValue) {
                    String valTime = rec[this.nTime];
                    try {
                        jdTime = this.srcTimeFrame.getJDTime(valTime);
                    }
                    catch (Exception e) {
                        System.err.println("Table time parsing error " + (nbRecord != -1 ? "(record " + (nbRecord + 1) + ")" : "") + ": " + e);
                    }
                }
            }
            try {
                if (Double.isNaN(J2000)) {
                    J2000 = new Astrotime("J2000").getJyr();
                }
                if (this.flagNOCOO) {
                    this.consumer.setRecord(0.0, 0.0, jdTime, rec);
                } else if (this.flagXY) {
                    double x = Double.parseDouble(rec[this.nX]);
                    double y = Double.parseDouble(rec[this.nY]);
                    this.consumer.setRecord(x, y, jdTime, rec);
                } else {
                    String dec;
                    String ra;
                    if (this.nRA != this.nDEC) {
                        ra = rec[this.nRA];
                        dec = rec[this.nDEC];
                    } else {
                        int i;
                        String s = rec[this.nRA];
                        int j = i = s.indexOf(43);
                        if (i < 0) {
                            i = j = s.indexOf(45);
                        }
                        if (i < 0 && (i = (j = s.indexOf(44))) > 0) {
                            ++i;
                        }
                        if (i < 0) {
                            i = j = s.indexOf(32);
                        }
                        if (i < 0) {
                            throw new Exception("Unsupported syntax for coordinates expressed as an unique field");
                        }
                        ra = s.substring(0, j).trim();
                        dec = s.substring(i).trim();
                    }
                    if (this.nRAmax != -1) {
                        try {
                            double raMin = Double.parseDouble(rec[this.nRA]);
                            double deMin = Double.parseDouble(rec[this.nDEC]);
                            double raMax = Double.parseDouble(rec[this.nRAmax]);
                            double deMax = Double.parseDouble(rec[this.nDECmax]);
                            ra = "" + (raMin + raMax) / 2.0;
                            dec = "" + (deMin + deMax) / 2.0;
                        }
                        catch (Exception raMin) {
                            // empty catch block
                        }
                    }
                    this.format = TableParser.getRaDec(this.c, ra, dec, this.format, this.unit);
                    if (this.srcAstroFrame != null) {
                        double pmra = 0.0;
                        double pmdec = 0.0;
                        if (this.nPMRA != -1 && this.nPMDEC != -1) {
                            String sPMRA = rec[this.nPMRA];
                            String sPMDEC = rec[this.nPMDEC];
                            if (sPMRA != null && sPMDEC != null) {
                                Unit mu1 = new Unit();
                                try {
                                    mu1.setUnit(this.unitPMRA);
                                    mu1.setValue(sPMRA);
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                }
                                Unit mu2 = new Unit();
                                try {
                                    mu2.setUnit(this.unitPMDEC);
                                    mu2.setValue(sPMDEC);
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                }
                                if (mu1.getValue() != 0.0 || mu2.getValue() != 0.0) {
                                    try {
                                        mu1.convertTo(new Unit("mas/yr"));
                                    }
                                    catch (Exception e) {
                                        mu1.setUnit(sPMRA);
                                        mu1.setValue(rec[this.nPMRA]);
                                        mu1.convertTo(new Unit("ms/yr"));
                                        double v = 15.0 * mu1.getValue() * Math.cos(this.c.getLat() * Math.PI / 180.0);
                                        mu1 = new Unit(v + "mas/yr");
                                    }
                                    try {
                                        pmra = mu1.getValue();
                                        mu2.convertTo(new Unit("mas/yr"));
                                        pmdec = mu2.getValue();
                                    }
                                    catch (Exception e2) {
                                        System.err.println("Table PM converting error " + (nbRecord != -1 ? "(record " + (nbRecord + 1) + ")" : "") + ": " + e2);
                                        if (Aladin.levelTrace >= 3) {
                                            e2.printStackTrace();
                                        }
                                        this.consumer.setRecord(this.c.getLon(), this.c.getLat(), jdTime, rec);
                                        return;
                                    }
                                }
                            }
                        }
                        Astropos targetCoo = new Astropos(this.srcAstroFrame);
                        if (this.srcAstroTime != null) {
                            targetCoo.setEpoch(this.srcAstroTime.getJyr());
                        }
                        targetCoo.set(this.c.getLon(), this.c.getLat(), pmra, pmdec);
                        targetCoo.toEpoch(this.trgAstroFrame.getEpoch());
                        targetCoo.convertTo(this.trgAstroFrame);
                        this.consumer.setRecord(targetCoo.getLon(), targetCoo.getLat(), jdTime, rec);
                    } else {
                        this.consumer.setRecord(this.c.getLon(), this.c.getLat(), jdTime, rec);
                    }
                }
                if (this.flagInterrupt) {
                    this.consumer.tableParserWarning("!!! Truncated result (OVERFLOW by interrupt)");
                    if (this.xmlparser != null) {
                        this.xmlparser.interrupt();
                    }
                }
            }
            catch (Exception e1) {
                System.err.println("Table coordinate parsing error " + (nbRecord != -1 ? "(record " + (nbRecord + 1) + ")" : "") + ": " + e1);
                if (Aladin.levelTrace < 3) break block59;
                e1.printStackTrace();
            }
        }
    }

    private String cleanUnitPrefix(String unit) {
        char c;
        int i = 0;
        while (Character.isDigit(c = unit.charAt(i)) || c == '-' || c == '+' || c == '.') {
            ++i;
        }
        return unit.substring(i);
    }

    private static final char isColSep(char c, char[] cs) {
        for (int i = 0; i < cs.length; ++i) {
            if (c != cs[i]) continue;
            return c;
        }
        return '\u0000';
    }

    public static int countColumn(String s, char[] cs) {
        char[] ch = s.toCharArray();
        int cur = 0;
        int end = ch.length;
        int sep = 0;
        int ncol = 0;
        while (cur < end) {
            while (cur < end) {
                char c = TableParser.isColSep(ch[cur], cs);
                sep = c;
                if (c != '\u0000') break;
                ++cur;
            }
            ++ncol;
            if (sep == 32) {
                while (cur < end && ch[cur] == ' ') {
                    ++cur;
                }
                continue;
            }
            ++cur;
        }
        return ncol;
    }

    private int getField(char[] ch, int cur, int end, char rs, char[] cs, int nbRecord) throws Exception {
        String value;
        boolean excelCSV;
        int start = cur;
        char sep = '\u0000';
        boolean bl = excelCSV = cs.length > 0 && cs[0] == ',';
        if (excelCSV) {
            boolean inQuote = false;
            while (cur < end) {
                if (ch[cur] == '\"') {
                    boolean bl2 = inQuote = !inQuote;
                }
                if (!inQuote && ((sep = TableParser.isColSep(ch[cur], cs)) != '\u0000' || ch[cur] == rs)) break;
                ++cur;
            }
            if (inQuote) {
                throw new Exception("Bad CSV: Excel quote delimiters not balanced (record " + (nbRecord + 1) + " field[" + this.row + "]=[" + TableParser.getStringTrim(ch, start, cur - start) + "])");
            }
        } else {
            while (cur < end && (sep = TableParser.isColSep(ch[cur], cs)) == '\u0000' && ch[cur] != rs) {
                ++cur;
            }
        }
        int plusUn = 0;
        if (excelCSV) {
            value = cur - start > 1 && ch[start] == '\"' && ch[cur - 1] == '\"' ? TableParser.getStringTrim(ch, start + 1, cur - start - 2) : TableParser.getStringTrim(ch, start, cur - start + plusUn);
        } else {
            if (sep == ' ') {
                ++cur;
                while (cur < end && ch[cur] == ' ' && ch[cur] != rs) {
                    ++cur;
                }
                --cur;
            }
            value = TableParser.getStringTrim(ch, start, cur - start + plusUn);
        }
        if (sep == ' ' && this.row == 0 && value.length() == 0) {
            return cur;
        }
        if (this.record != null) {
            if (this.row >= this.record.length) {
                String s = "Not aligned CSV catalog (record=" + (nbRecord + 1) + " extra row value=\"" + value + "\") => ignored\n";
                this.aladin.command.printConsole(s);
            } else {
                this.record[this.row] = value;
            }
        } else {
            if (this.vRecord == null) {
                this.vRecord = new Vector();
            }
            this.vRecord.addElement(value);
        }
        ++this.row;
        return cur;
    }

    private int getRecord(char[] ch, int cur, int end, char rs, char[] cs, int nbRecord) throws Exception {
        this.row = 0;
        int un = 0;
        while (cur < end && ch[cur] != rs) {
            cur = this.getField(ch, cur + un, end, rs, cs, nbRecord);
            un = 1;
        }
        if (this.record != null && this.row == this.record.length - 1 && cur == end && cur > 0 && ch[cur - 1] != rs) {
            this.record[this.row++] = "";
        }
        if (!(this.record == null || this.row >= this.record.length || this.row == 1 && this.record[0].equals("[EOD]"))) {
            String s = "Not aligned CSV catalog (record=" + (nbRecord + 1) + " missing rows nbRow=" + this.row + "/" + this.record.length + ") => ignored" + (this.filename != null ? this.filename : "");
            this.aladin.command.printConsole(s);
        }
        return cur;
    }

    protected static int skipRecSep(char[] ch, int cur, char rs) {
        if (cur < ch.length && ch[cur] == rs) {
            cur = rs == '\n' && cur < ch.length - 1 && ch[cur + 1] == '\r' ? (cur += 2) : ++cur;
        }
        return cur;
    }

    protected static int skipRec(char[] ch, int cur, char rs) {
        while (cur < ch.length - 1 && ch[cur] != rs) {
            ++cur;
        }
        return TableParser.skipRecSep(ch, cur, rs);
    }

    private boolean vide(char[] ch, int cur, int end, char rs) {
        if (ch[cur] == '#') {
            return true;
        }
        while (cur < end && (ch[cur] == ' ' || ch[cur] == '\t' || ch[cur] == '\r')) {
            ++cur;
        }
        return ch[cur] == rs;
    }

    private boolean isSimpleDahsLine(char[] ch, int cur, int end, char rs) {
        while (cur < end && ch[cur] == '-') {
            ++cur;
        }
        return ch[cur] == rs;
    }

    private String colSepInfo(char[] cs) {
        String s = null;
        for (int i = 0; i < cs.length; ++i) {
            String s1;
            switch (cs[i]) {
                case '\t': {
                    s1 = "Tab";
                    break;
                }
                case '|': {
                    s1 = "Pipe (|)";
                    break;
                }
                case ';': {
                    s1 = "Semi-column (;)";
                    break;
                }
                case ',': {
                    s1 = "Comma (,)";
                    break;
                }
                case ' ': {
                    s1 = "One or several spaces";
                    break;
                }
                default: {
                    s1 = cs[i] + "";
                }
            }
            s = i == 0 ? s1 : s + ", " + s1;
        }
        return s;
    }

    private void dataParse(char[] ch, int start, int length) throws Exception {
        int i;
        char rs = '\n';
        char[] cs = "\t".toCharArray();
        int cur = start;
        int end = start + length;
        int n = 0;
        int nbRecord = 0;
        if (this.recsep != null) {
            rs = this.recsep.charAt(0);
        }
        if (this.colsep != null) {
            cs = this.colsep.toCharArray();
        }
        int h = this.headlines == null ? 0 : Integer.parseInt(this.headlines);
        this.headlines = null;
        n = 0;
        boolean flagHeader = false;
        boolean dashLine = false;
        boolean flagDejaLu = false;
        if (this.flagNewTable) {
            if (this.flagTSV) {
                this.consumer.tableParserInfo("CSV format [" + this.colSepInfo(cs) + "]");
            } else {
                this.consumer.tableParserInfo("   -found CSV DATA (field sep=" + this.colSepInfo(cs) + " record sep=" + (rs == '\n' ? "\\n" : "[" + (byte)rs + "]") + ")");
                if (h == 0) {
                    this.consumer.tableParserInfo("   -No CSV header");
                }
            }
            this.flagNewTable = false;
        }
        for (n = 0; cur < end && (this.flagTSV || n < h); ++n) {
            int j;
            if (this.vide(ch, cur, end, rs) || n == 1 && this.isSimpleDahsLine(ch, cur, end, rs)) {
                --n;
                cur = TableParser.skipRec(ch, cur, rs);
                continue;
            }
            cur = this.getRecord(ch, cur, end, rs, cs, nbRecord);
            if (this.record == null) {
                this.nField = this.vRecord.size();
                this.consumer.tableParserInfo("   -found CSV DATA (" + this.nField + " fields record sep=" + (rs == '\n' ? "\\n" : "[" + (byte)rs + "])") + ")");
                this.record = new String[this.nField];
                Enumeration<String> e = this.vRecord.elements();
                for (i = 0; i < this.nField; ++i) {
                    this.record[i] = e.nextElement();
                }
            }
            dashLine = true;
            for (i = 0; i < this.nField && dashLine; ++i) {
                char[] a = this.record[i].toCharArray();
                for (j = 0; j < a.length && a[j] == '-'; ++j) {
                }
                if (j >= a.length) continue;
                dashLine = false;
                break;
            }
            if (dashLine) {
                this.consumer.tableParserInfo("   -Found " + (n + 1) + " lines CVS header with dash separator");
                cur = TableParser.skipRecSep(ch, cur, rs);
                break;
            }
            if (!this.flagTSV) continue;
            if (n == 0 || n == 1 && (this.qualRA < 500 && this.qualDEC < 500 || this.qualX < 700 && this.qualY < 700)) {
                int p = 0;
                int r = 1;
                if (n == 1) {
                    if (this.qualRA < 500) {
                        p = this.nRA;
                        r = this.nDEC;
                    } else {
                        p = this.nX;
                        r = this.nY;
                    }
                }
                flagHeader = false;
                for (i = 0; i < 2; ++i) {
                    char q;
                    int k;
                    int n2 = k = i == 0 ? p : r;
                    if (k >= this.nField) {
                        flagHeader = true;
                        break;
                    }
                    char[] a = this.record[k].toCharArray();
                    for (j = 0; j < a.length && ((q = a[j]) >= '0' && q <= '9' || q == '.' || q == '+' || q == 'e' || q == 'E' || q == '-' || q == ':' || q == ' '); ++j) {
                    }
                    if (j != 0 && j >= a.length) continue;
                    flagHeader = true;
                    break;
                }
                if (!flagHeader) {
                    flagDejaLu = true;
                    if (n == 0) {
                        this.consumer.tableParserInfo("   -No CSV header found!");
                        this.setDefaultField();
                    } else {
                        this.consumer.tableParserInfo("   -Found one line CVS header");
                    }
                    this.posChooser();
                    break;
                }
            } else {
                flagDejaLu = true;
                break;
            }
            if (flagHeader && n == 0 && (this.nRA < 0 || this.flagTSV)) {
                this.tsvField = new Field[this.nField];
                for (i = 0; i < this.nField; ++i) {
                    Field f = this.tsvField[i] = new Field(this.record[i]);
                    f.datatype = "D";
                    this.detectPosField(f, i);
                    if (!this.flagTSV) continue;
                    this.consumer.setField(f);
                }
                this.posChooser();
            }
            cur = TableParser.skipRecSep(ch, cur, rs);
        }
        while (cur < end || flagDejaLu) {
            if (!flagDejaLu) {
                if (this.vide(ch, cur, end, rs)) {
                    cur = TableParser.skipRec(ch, cur, rs);
                    continue;
                }
                cur = this.getRecord(ch, cur, end, rs, cs, nbRecord);
            } else {
                flagDejaLu = false;
            }
            ++nbRecord;
            if (this.row == 1 && this.record[0].equals("[EOD]")) {
                this.consumer.tableParserInfo("   -Stop parsing at SkyCat [EOD] tag");
                cur = end;
                break;
            }
            while (this.row < this.nField) {
                this.record[this.row++] = "???";
            }
            if (this.tsvField != null) {
                for (i = 0; i < this.tsvField.length; ++i) {
                    if (this.tsvField[i].datatype == null || !this.tsvField[i].datatype.equals("D")) continue;
                    try {
                        String s1 = this.record[i].trim();
                        if (s1.length() <= 0 || s1.equals("-") || s1.equalsIgnoreCase("null")) continue;
                        Double.parseDouble(s1);
                        continue;
                    }
                    catch (Exception e) {
                        this.tsvField[i].datatype = null;
                    }
                }
            }
            this.consumeRecord(this.record, nbRecord);
            cur = TableParser.skipRecSep(ch, cur, rs);
        }
        if (nbRecord == 0) {
            String s = TableParser.getStringTrim(ch, start, length > 200 ? 200 : length);
            throw new Exception("Data parsing error (no record found):\n \n[" + s + "...]");
        }
    }

    class TimeFrame {
        String id = null;
        String timeScale = null;
        String refPosition = null;
        double timeOrigin;
        int timeFormat = 0;
        String unit;

        TimeFrame(String timescale, String refposition, double timeOrigin, String unit, int timeFormat) {
            this.timeScale = timescale;
            this.refPosition = refposition;
            this.timeOrigin = timeOrigin;
            this.unit = unit;
            this.timeFormat = timeFormat;
        }

        void setTimeOrigin(double timeOrigin, String unit) throws Exception {
            if (unit != null && !unit.equals("d")) {
                timeOrigin = Astrodate.convert(timeOrigin, unit, "d");
            }
            this.timeOrigin = timeOrigin;
        }

        double getJDTime(String date) throws Exception {
            double t;
            String valTime = date;
            if (this.timeFormat == 16 && this.unit != null && !this.unit.equals("yr")) {
                t = Double.parseDouble(valTime);
                t = Astrodate.convert(t, this.unit, "yr");
                valTime = t + "";
            } else if (!(this.timeFormat != 13 && this.timeFormat != 14 || this.unit == null || this.unit.equals("d"))) {
                t = Double.parseDouble(valTime);
                t = Astrodate.convert(t, this.unit, "d");
                valTime = t + "";
            }
            double jdTime = Astrodate.parseTime(valTime, this.timeFormat);
            boolean flagError = false;
            if (this.timeScale != null && this.refPosition != null) {
                try {
                    jdTime = Astrodate.getTCBTime(jdTime, this.timeScale, this.refPosition);
                }
                catch (Exception e) {
                    if (TableParser.this.first && Aladin.levelTrace >= 3) {
                        e.printStackTrace();
                    }
                    flagError = true;
                }
            }
            if (TableParser.this.first && flagError) {
                TableParser.this.first = false;
                TableParser.this.consumer.tableParserInfo("      Ephemerids unknown for this time system.\n      => assuming TCB (approximations +/- 15mn)");
            }
            return jdTime += this.timeOrigin;
        }

        void setTimeFormat(int timeFormat) {
            this.timeFormat = timeFormat;
            if (timeFormat == 14) {
                this.timeOrigin -= 2400000.5;
            }
        }

        public String toString() {
            return (this.id != null ? "ID=" + this.id : "") + " format=" + Field.COOSIGN[this.timeFormat] + (this.unit != null ? " unit=" + this.unit : "") + (this.timeOrigin != 0.0 ? " timeOffset=" + this.timeOrigin : "") + (this.timeScale != null ? " timescale=" + this.timeScale : "") + (this.refPosition != null ? " refposition=" + this.refPosition : "");
        }
    }
}

