/*
 * Decompiled with CFR 0.152.
 */
package cds.tools.pixtools;

import cds.aladin.Coord;
import cds.hipsgen.BuilderPack;
import cds.tools.pixtools.Addr;
import cds.tools.pixtools.CDSHealpix;
import java.io.File;
import java.io.RandomAccessFile;

public class Util {
    public static final int DIRSIZE = 10000;
    public static final int DIRZSIZE = 10;
    public static final String FS = cds.tools.Util.FS;
    public static final String CR = cds.tools.Util.CR;
    private static double twothird = 0.6666666666666666;
    static final int INDEX_LEN = 8;
    static final int INDEX_SIZE = 80000;
    static int[] HPX1024XY = new int[0x100001];
    private static final long UN = Long.MIN_VALUE;

    public static Coord[] getCorners(int order, long npix) throws Exception {
        return Util.getCorners(null, order, npix);
    }

    public static Coord[] getCorners(Coord[] corners, int order, long npix) throws Exception {
        double[][] x = CDSHealpix.corners(order, npix);
        if (corners == null) {
            corners = new Coord[4];
        }
        for (int i = 0; i < 4; ++i) {
            corners[i] = new Coord(x[i][0], x[i][1]);
        }
        return corners;
    }

    public static String getFilePath(String survey, int order, long npix, int forder, long fpix) {
        String prefix = survey != null && survey.length() > 0 ? survey : "";
        String suffix = Util.getFilePath(order, npix, forder, fpix);
        return cds.tools.Util.concatDir(prefix, suffix);
    }

    public static String getFilePath(int order, long npix, int forder, long fpix) {
        return Util.getFilePathNew(order, npix, forder, fpix);
    }

    public static String getFilePathOld(int order, long npix, int forder, long fpix) {
        return "Norder" + order + "_" + forder + "/Dir" + npix / 10000L * 10000L + "/Npix" + npix + "_" + fpix;
    }

    public static String getFilePathNew(int order, long npix, int forder, long fpix) {
        return "Norder" + order + "_" + forder + "/Dir" + npix / 10000L * 10000L + "_" + fpix / 10L * 10L + "/Npix" + npix + "_" + fpix;
    }

    public static String getFilePath(String survey, Addr addr) {
        String prefix = survey != null && survey.length() > 0 ? survey : "";
        String suffix = Util.getFilePath(addr);
        return cds.tools.Util.concatDir(prefix, suffix);
    }

    public static String getFilePath(Addr addr) {
        if (addr.orderZ != -1) {
            return Util.getFilePath(addr.order, addr.npix, addr.orderZ, addr.npixZ);
        }
        return Util.getFilePath(addr.order, addr.npix, addr.z);
    }

    public static String getFilePath(String survey, int order, long npix) {
        return Util.getFilePath(survey, order, npix, 0);
    }

    public static String getFilePath(String survey, int order, long npix, int z) {
        String prefix = survey != null && survey.length() > 0 ? survey : "";
        String suffix = Util.getFilePath(order, npix, z);
        return cds.tools.Util.concatDir(prefix, suffix);
    }

    public static String getFilePath(int order, long npix) {
        return Util.getFilePath(order, npix, 0);
    }

    public static String getFilePath(int order, long npix, int z) {
        return "Norder" + order + "/Dir" + npix / 10000L * 10000L + "/Npix" + npix + (z <= 0 ? "" : "_" + z);
    }

    public static String getFileDir(String survey, int order, long npix) {
        String suffix = "Norder" + order + "/Dir" + npix / 10000L * 10000L;
        return cds.tools.Util.concatDir(survey, suffix);
    }

    public static int getOrderFromPath(String filename) {
        int fromIndex = filename.lastIndexOf("Norder");
        if (fromIndex == -1) {
            return -1;
        }
        int lastIndex = filename.indexOf(FS, fromIndex);
        if (lastIndex == -1) {
            lastIndex = filename.length();
        }
        return Integer.parseInt(filename.substring(fromIndex + 6, lastIndex));
    }

    public static long getNpixFromPath(String filename) {
        int fromIndex = filename.lastIndexOf("Npix");
        if (fromIndex < 0) {
            return -1L;
        }
        int lastIndex = filename.indexOf(95, fromIndex);
        if (lastIndex < 0) {
            lastIndex = filename.indexOf(46, fromIndex);
        }
        if (lastIndex < 0) {
            lastIndex = filename.length();
        }
        return Long.parseLong(filename.substring(fromIndex + 4, lastIndex));
    }

    public static long getFpixFromPath(String filename) {
        int fromIndex = filename.lastIndexOf("Npix");
        if (fromIndex < 0) {
            return -1L;
        }
        if ((fromIndex = filename.indexOf(95, fromIndex)) < 0) {
            return -1L;
        }
        int lastIndex = filename.indexOf(46, fromIndex);
        if (lastIndex < 0) {
            lastIndex = filename.length();
        }
        return Long.parseLong(filename.substring(fromIndex + 1, lastIndex));
    }

    public static int getDepthFromPath(String filename) {
        int fromIndex = filename.lastIndexOf("Npix");
        if (fromIndex < 0) {
            return -1;
        }
        if ((fromIndex = filename.indexOf(95, fromIndex)) < 0) {
            return 0;
        }
        int lastIndex = filename.indexOf(46, fromIndex);
        if (lastIndex < 0) {
            lastIndex = filename.length();
        }
        return Integer.parseInt(filename.substring(fromIndex + 1, lastIndex));
    }

    public static long getNDirFromPath(String filename) {
        int fromIndex = filename.lastIndexOf("Dir");
        if (fromIndex == -1) {
            return -1L;
        }
        int lastIndex = filename.indexOf("_", fromIndex);
        if (lastIndex == -1) {
            lastIndex = filename.indexOf("-", fromIndex);
        }
        if (lastIndex == -1) {
            lastIndex = filename.indexOf(".", fromIndex);
        }
        if (lastIndex == -1) {
            lastIndex = filename.indexOf(FS, fromIndex);
        }
        if (lastIndex == -1) {
            lastIndex = filename.length();
        }
        return Long.parseLong(filename.substring(fromIndex + 3, lastIndex));
    }

    public static String getExtFromPath(String filename) {
        int fromIndex = filename.lastIndexOf(46);
        if (fromIndex < 0) {
            return "";
        }
        int i = filename.lastIndexOf(FS, fromIndex);
        if (fromIndex < i) {
            return "";
        }
        return filename.substring(fromIndex + 1);
    }

    public static int getMaxOrderByPath(String path) {
        return Util.getMaxOrderByPath1(path)[0];
    }

    public static int getMaxOrderFreqByPath(String path) {
        return Util.getMaxOrderByPath1(path)[1];
    }

    private static int[] getMaxOrderByPath1(String path) {
        int maxOrder = -1;
        int maxOrderFreq = -1;
        File f = new File(path);
        File[] sf = f.listFiles();
        if (sf != null) {
            for (int i = 0; i < sf.length; ++i) {
                int n2;
                int last;
                String name;
                if (!sf[i].isDirectory() || !(name = sf[i].getName()).startsWith("Norder")) continue;
                int orderFreqOff = name.indexOf(95);
                last = orderFreqOff < 0 ? (last = name.length()) : orderFreqOff;
                try {
                    n2 = Integer.parseInt(name.substring(6, last));
                    if (n2 > maxOrder) {
                        maxOrder = n2;
                    }
                }
                catch (NumberFormatException n2) {
                    // empty catch block
                }
                if (orderFreqOff <= 0) continue;
                try {
                    n2 = Integer.parseInt(name.substring(orderFreqOff + 1));
                    if (n2 <= maxOrderFreq) continue;
                    maxOrderFreq = n2;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return new int[]{maxOrder, maxOrderFreq};
    }

    public static byte[] hipsUnpack(String path, int order, long npix, String ext, int z) throws Exception {
        return Util.hipsUnpack(path, order, npix, ext, z, 0);
    }

    static void checkMagicCode(byte[] t) throws Exception {
        if (t[t.length - 4] != BuilderPack.MC[0] || t[t.length - 3] != BuilderPack.MC[1] || t[t.length - 2] != BuilderPack.MC[2] || t[t.length - 1] != BuilderPack.MC[3]) {
            throw new Exception("Unsupported HiPS pack file [waiting magic code " + new String(BuilderPack.MC) + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] hipsUnpack(String path, int order, long npix, String ext, int z, int skip) throws Exception {
        byte[] buf;
        int ndir = (int)(npix / 10000L * 10000L);
        String bin = path + FS + "Norder" + order + FS + "Dir" + ndir + (z > 0 ? "_" + z : "") + "-" + ext + ".bin";
        byte[] bufLong = new byte[8];
        try (RandomAccessFile f = null;){
            long start;
            byte[] t = new byte[8];
            f = new RandomAccessFile(bin, "r");
            f.seek(f.length() - (long)t.length);
            f.read(t);
            Util.checkMagicCode(t);
            int firstIndex = BuilderPack.getLeShort(t, 0);
            int lastIndex = BuilderPack.getLeShort(t, 2);
            long posIndex = f.length() - 8L - (long)(lastIndex - firstIndex + 1) * 8L;
            int ind = (int)(npix - (long)ndir);
            if (ind < firstIndex || ind > lastIndex) {
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if ((ind -= firstIndex) > 0) {
                f.seek(posIndex + (long)((ind - 1) * 8));
                f.read(bufLong);
                start = BuilderPack.getLeLong(bufLong, 0);
            } else {
                start = 0L;
            }
            f.seek(posIndex + (long)(ind * 8));
            f.read(bufLong);
            long end = BuilderPack.getLeLong(bufLong, 0);
            int size = (int)(end - start);
            buf = new byte[size];
            if (size > 0) {
                f.seek(start);
                f.readFully(buf);
                if (skip > 0) {
                    int len = buf.length - skip;
                    byte[] tmp = new byte[len];
                    System.arraycopy(buf, skip, tmp, 0, len);
                    buf = tmp;
                }
            }
        }
        return buf;
    }

    private static void fillUp(int[] npix, int nsize, int[] pos) {
        int i;
        int size = nsize * nsize;
        int[][] fils = new int[4][size / 4];
        int[] nb = new int[4];
        for (i = 0; i < size; ++i) {
            int dg = i % nsize < nsize / 2 ? 0 : 1;
            int bh = i < size / 2 ? 1 : 0;
            int quad = dg << 1 | bh;
            int j = pos == null ? i : pos[i];
            npix[j] = npix[j] << 2 | quad;
            int n = quad;
            int n2 = nb[n];
            nb[n] = n2 + 1;
            fils[quad][n2] = j;
        }
        if (size > 4) {
            for (i = 0; i < 4; ++i) {
                Util.fillUp(npix, nsize / 2, fils[i]);
            }
        }
    }

    public static int[] createHpx2xy(int order) {
        int[] xy2hpx = null;
        int[] hpx2xy = null;
        if (order == 0) {
            hpx2xy = new int[]{0};
            return hpx2xy;
        }
        int nsize = (int)CDSHealpix.pow2(order);
        xy2hpx = new int[nsize * nsize];
        hpx2xy = new int[nsize * nsize];
        Util.fillUp(xy2hpx, nsize, null);
        for (int i = 0; i < xy2hpx.length; ++i) {
            hpx2xy[xy2hpx[i]] = i;
        }
        return hpx2xy;
    }

    public static int[] createXy2Hpx(int order) {
        int[] xy2hpx = null;
        if (order == 0) {
            xy2hpx = new int[]{0};
            return xy2hpx;
        }
        int nsize = (int)CDSHealpix.pow2(order);
        xy2hpx = new int[nsize * nsize];
        Util.fillUp(xy2hpx, nsize, null);
        return xy2hpx;
    }

    public static int[] hpx2XY(int n) {
        int[] xy = new int[2];
        xy[1] = HPX1024XY[n + 1] / 1024;
        xy[0] = HPX1024XY[n + 1] - xy[1] * 1024;
        return xy;
    }

    public static int[] hpx2XY(long n, int MAX_LEVEL) {
        double limLo = 0.0;
        double limHi = Math.pow(2.0, MAX_LEVEL) * Math.pow(2.0, MAX_LEVEL);
        int[] partX = new int[MAX_LEVEL];
        int[] partY = new int[MAX_LEVEL];
        for (int level = MAX_LEVEL - 1; level >= 0; --level) {
            limHi = Math.pow(2.0, level + 1) * Math.pow(2.0, level + 1);
            if ((double)n <= limLo + (limHi - limLo) / 4.0) {
                partX[level] = 0;
                partY[level] = 0;
                continue;
            }
            if ((double)n <= limLo + (limHi - limLo) / 2.0) {
                partX[level] = 1;
                partY[level] = 0;
                n -= (long)Math.pow(4.0, level);
                continue;
            }
            if ((double)n <= limLo + 3.0 * (limHi - limLo) / 4.0) {
                partX[level] = 0;
                partY[level] = 1;
                n -= 2L * (long)Math.pow(4.0, level);
                continue;
            }
            if (!((double)n <= limHi)) continue;
            partX[level] = 1;
            partY[level] = 1;
            n -= 3L * (long)Math.pow(4.0, level);
        }
        int[] xy = new int[]{0, 0};
        for (int level = 0; level < MAX_LEVEL; ++level) {
            xy[0] = (int)((long)xy[0] + (long)partX[level] * (long)Math.pow(2.0, level));
            xy[1] = (int)((long)xy[1] + (long)partY[level] * (long)Math.pow(2.0, level));
        }
        return xy;
    }

    public static long XY2Hpx(int x, int y, int MAX_LEVEL) {
        double limLox = 0.0;
        double limHix = Math.pow(2.0, MAX_LEVEL);
        double limLoy = 0.0;
        double limHiy = Math.pow(2.0, MAX_LEVEL);
        int[] N = new int[MAX_LEVEL];
        for (int level = MAX_LEVEL - 1; level >= 0; --level) {
            double limidx = (limLox + limHix) / 2.0;
            double limidy = (limLoy + limHiy) / 2.0;
            if ((double)x < limidx && (double)y < limidy) {
                N[level] = 0;
                limHix = limidx;
                limHiy = limidy;
                continue;
            }
            if ((double)x >= limidx && (double)y < limidy) {
                N[level] = 1;
                limLox = limidx;
                limHiy = limidy;
                continue;
            }
            if ((double)x < limidx && (double)y >= limidy) {
                N[level] = 2;
                limLoy = limidy;
                limHix = limidx;
                continue;
            }
            if (!((double)x >= limidx) || !((double)y >= limidy)) continue;
            N[level] = 3;
            limLox = limidx;
            limLoy = limidy;
        }
        long n = 0L;
        for (int level = 0; level < MAX_LEVEL; ++level) {
            n += (long)N[level] * (long)Math.pow(4.0, level);
        }
        return n;
    }

    public static final int nside(int order) {
        return 1 << order;
    }

    public static final int order(int nside) {
        int i = 0;
        while (nside >>> ++i > 0) {
        }
        return --i;
    }

    public static final long nbrPix(int nside) {
        return 12L * (long)nside * (long)nside;
    }

    public static final long idx(long idx, int orderFrom, int orderTo) {
        if (orderFrom < orderTo) {
            throw new IllegalArgumentException("'orderFrom' must be greatest than 'orderTo'!");
        }
        return idx >>> (orderFrom - orderTo << 1);
    }

    public static final int min(int idx, int orderFrom, int orderTo) {
        if (orderFrom > orderTo) {
            throw new IllegalArgumentException("'orderFrom' must be smaller than 'orderTo'!");
        }
        return idx << (orderTo - orderFrom << 1);
    }

    public static final int max(int idx, int orderFrom, int orderTo) {
        if (orderFrom > orderTo) {
            throw new IllegalArgumentException("'orderFrom' must be smaller than 'orderTo'!");
        }
        return (++idx << (orderTo - orderFrom << 1)) - 1;
    }

    public static long getHpxNestedNumber(int x, int y) {
        long mask = 1L;
        long res = 0L;
        for (int i = 0; i < 32; ++i) {
            res >>>= 1;
            if ((mask & (long)x) != 0L) {
                res |= Long.MIN_VALUE;
            }
            res >>>= 1;
            if ((mask & (long)y) != 0L) {
                res |= Long.MIN_VALUE;
            }
            mask <<= 1;
        }
        return res;
    }

    public static String bits(long a) {
        StringBuilder res = new StringBuilder();
        long mask = Long.MIN_VALUE;
        for (int i = 0; i < 64; ++i) {
            if ((mask & a) != 0L) {
                res.append('1');
            } else {
                res.append('0');
            }
            mask >>>= 1;
        }
        return res.toString();
    }

    public static final double pixRes(long nside) {
        double res = 0.0;
        double degrad = Math.toDegrees(1.0);
        double skyArea = Math.PI * 4 * degrad * degrad;
        double arcSecArea = skyArea * 3600.0 * 3600.0;
        long npixels = 12L * nside * nside;
        res = arcSecArea / (double)npixels;
        res = Math.sqrt(res);
        return res;
    }
}

