/*
 * Decompiled with CFR 0.152.
 */
package cds.tools.pixtools;

import cds.aladin.Coord;
import cds.aladin.Localisation;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.Tile;
import cds.aladin.ViewSimple;
import cds.moc.MocCell;
import cds.tools.pixtools.CDSHealpix;
import java.awt.Graphics;
import java.awt.Polygon;

public class Hpix
extends MocCell {
    private int frame;
    private long ovIZ;
    private PointD[] viewCorners;
    private Coord[] corners;
    private int nNull;
    private boolean computeCorners;
    private static final int[] ORDRE = new int[]{2, 3, 1, 0};
    private int borderMask = 15;

    public Hpix() {
    }

    public Hpix(String s) throws Exception {
        int i = s.indexOf(47);
        this.init(Integer.parseInt(s.substring(0, i)), Long.parseLong(s.substring(i + 1)), 3);
    }

    public Hpix(int order, long npix) {
        this.init(order, npix, 3);
    }

    public Hpix(int order, long npix, int frame) {
        this.init(order, npix, frame);
    }

    public int getFrame() {
        return this.frame;
    }

    public Coord[] getCorners() {
        if (!this.computeCorners) {
            this.computeCorners();
        }
        return this.corners;
    }

    public Hpix[] getFils() {
        Hpix[] fils = new Hpix[4];
        int orderFils = this.order + 1;
        long npixFils = this.start * 4L;
        for (int i = 0; i < 4; ++i) {
            fils[i] = new Hpix(orderFils, npixFils + (long)i, this.frame);
        }
        return fils;
    }

    public void fill(Graphics g, ViewSimple v) {
        this.fill(g, v, 0);
    }

    private void fill(Graphics g, ViewSimple v, int prof) {
        if (prof > 6) {
            return;
        }
        PointD[] b = this.getProjViewCorners(v);
        if (b == null) {
            return;
        }
        double maxSize = this.getMaxSize(v);
        Polygon pol = new Polygon();
        int d = -1;
        for (int i = 0; i < b.length; ++i) {
            int f = ORDRE[i];
            if (b[f] == null) continue;
            if (d >= 0) {
                double d2;
                double d1 = Tile.dist(b, d, f);
                if (d2 > maxSize * maxSize) {
                    Hpix[] fils;
                    if (!(d1 > 5.0)) continue;
                    for (Hpix f1 : fils = this.getFils()) {
                        f1.fill(g, v, prof + 1);
                    }
                    return;
                }
            }
            pol.addPoint((int)b[f].x, (int)b[f].y);
            d = f;
        }
        g.fillPolygon(pol);
    }

    public void setBorderMask(int borderMask) {
        this.borderMask = borderMask;
    }

    public void draw(Graphics g, ViewSimple v) {
        PointD[] b = this.getProjViewCorners(v);
        if (b == null) {
            return;
        }
        boolean drawnOk = true;
        double min = Double.MAX_VALUE;
        for (int i = 0; i < 4; ++i) {
            int d = ORDRE[i == 0 ? 3 : i - 1];
            int f = ORDRE[i];
            if (b[d] == null || b[f] == null) {
                drawnOk = false;
                continue;
            }
            double dist = Math.sqrt(Tile.dist(b, d, f));
            if (!(dist < min)) continue;
            min = dist;
        }
        if (min == Double.MAX_VALUE) {
            min = 0.0;
        }
        if (drawnOk) {
            int mask = 0;
            for (int i = 0; i < 4; ++i) {
                mask = i == 0 ? 1 : mask << 1;
                int d = ORDRE[i == 0 ? 3 : i - 1];
                int f = ORDRE[i];
                if (b[d] == null || b[f] == null) {
                    drawnOk = false;
                    continue;
                }
                double dist = Math.sqrt(Tile.dist(b, d, f));
                if (dist > 1.0 && min > 0.0 && dist > 6.0 * min) {
                    drawnOk = false;
                    continue;
                }
                if ((this.borderMask & mask) == 0) continue;
                g.drawLine((int)b[d].x, (int)b[d].y, (int)b[f].x, (int)b[f].y);
            }
        }
    }

    public boolean contains(ViewSimple v, int xview, int yview) {
        PointD[] b = this.getProjViewCorners(v);
        if (b == null) {
            return false;
        }
        Polygon pol = new Polygon();
        double min = Double.MAX_VALUE;
        for (int i = 0; i < b.length; ++i) {
            int f = ORDRE[i];
            pol.addPoint((int)b[f].x, (int)b[f].y);
            int d = ORDRE[i == 0 ? 3 : i - 1];
            if (b[d] == null || b[f] == null) {
                return false;
            }
            double dist = Math.sqrt(Tile.dist(b, d, f));
            if (dist > 1.0 && min > 0.0 && dist > 6.0 * min) {
                return false;
            }
            if (!(dist < min)) continue;
            min = dist;
        }
        return pol.contains(xview, yview);
    }

    public double getDiag2(ViewSimple v) {
        PointD[] b = this.getProjViewCorners(v);
        if (b == null) {
            return 0.0;
        }
        if (b[0] == null || b[1] == null || b[2] == null || b[3] == null) {
            return 0.0;
        }
        double d0 = Tile.dist(b, 3, 0);
        double d1 = Tile.dist(b, 2, 1);
        return Math.max(d0, d1);
    }

    public boolean isPoleCorner() {
        long n = CDSHealpix.pow2(this.order);
        n *= n;
        long max = 12L * n;
        for (int i = 1; i <= 4; ++i) {
            long m = n * (long)i;
            if (this.start != m - 1L && this.start != max - m) continue;
            return true;
        }
        return false;
    }

    public PointD[] getProjViewCorners(ViewSimple v) {
        int i;
        long vIZ = v.getIZ();
        if (this.ovIZ == vIZ) {
            if (this.nNull > 1) {
                return null;
            }
            return this.viewCorners;
        }
        Projection proj = v.getProj();
        Coord[] corners = this.getCorners();
        if (proj == null || corners == null) {
            return null;
        }
        this.nNull = 0;
        if (this.viewCorners == null) {
            this.viewCorners = new PointD[corners.length];
        }
        for (i = 0; i < corners.length; ++i) {
            Coord c = corners[i];
            proj.getXY(c);
            if (Double.isNaN(c.x)) {
                ++this.nNull;
                if (this.nNull > 1) {
                    return null;
                }
                this.viewCorners[i] = null;
                continue;
            }
            if (this.viewCorners[i] == null) {
                this.viewCorners[i] = new PointD(c.x, c.y);
                continue;
            }
            this.viewCorners[i].x = c.x;
            this.viewCorners[i].y = c.y;
        }
        for (i = 0; i < corners.length; ++i) {
            if (this.viewCorners[i] == null) continue;
            v.getViewCoordDble(this.viewCorners[i], this.viewCorners[i].x, this.viewCorners[i].y);
        }
        this.ovIZ = vIZ;
        return this.viewCorners;
    }

    public boolean isOutView(ViewSimple v) {
        return this.isOutView(v, null);
    }

    public boolean isOutView(ViewSimple v, PointD[] b) {
        double maxY;
        double maxX;
        if (v.isAllSky()) {
            return false;
        }
        int w = v.getWidth();
        int h = v.getHeight();
        if (b == null) {
            b = this.getProjViewCorners(v);
        }
        if (b == null) {
            return true;
        }
        if (b[0] == null || b[1] == null || b[2] == null || b[3] == null) {
            return false;
        }
        double minX = maxX = b[0].x;
        double minY = maxY = b[0].y;
        for (int i = 1; i < 4; ++i) {
            if (b[i].x < minX) {
                minX = b[i].x;
            } else if (b[i].x > maxX) {
                maxX = b[i].x;
            }
            if (b[i].y < minY) {
                minY = b[i].y;
                continue;
            }
            if (!(b[i].y > maxY)) continue;
            maxY = b[i].y;
        }
        if (minX < 0.0 && maxX < 0.0 || minX >= (double)w && maxX >= (double)w) {
            return true;
        }
        return minY < 0.0 && maxY < 0.0 || minY >= (double)h && maxY >= (double)h;
    }

    public String toString() {
        return this.order + "/" + this.start + (this.computeCorners ? ": " + this.corners[0] + " / " + this.corners[1] + " / " + this.corners[2] + " / " + this.corners[3] : "");
    }

    private void init(int order, long npix, int frame) {
        this.order = order;
        this.start = npix;
        this.frame = frame;
        this.computeCorners = false;
    }

    private void computeCorners() {
        try {
            double[][] x = CDSHealpix.corners(this.order, this.start);
            this.corners = new Coord[4];
            for (int i = 0; i < x.length; ++i) {
                this.corners[i] = new Coord(x[i][0], x[i][1]);
            }
            this.corners = this.computeCornersToICRS(this.corners);
            this.computeCorners = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Coord[] computeCornersToICRS(Coord[] corners) {
        if (this.frame == 0) {
            return corners;
        }
        for (int i = 0; i < 4; ++i) {
            corners[i] = Localisation.frameToFrame(corners[i], this.frame, 0);
        }
        return corners;
    }

    private double getMaxSize(ViewSimple v) {
        double maxSize = 150.0;
        if (!v.isAllSky()) {
            double pixRes = CDSHealpix.pixRes(this.order) / 3600.0;
            double pixelViewSize = v.getPixelSize();
            maxSize = pixRes / pixelViewSize * 4.0;
        }
        return maxSize;
    }
}

