/*
 * Decompiled with CFR 0.152.
 */
package cds.tools.parser;

import cds.astro.Unit;
import cds.tools.parser.Abs;
import cds.tools.parser.AbsOp;
import cds.tools.parser.AbstractOperateur;
import cds.tools.parser.AdditionOp;
import cds.tools.parser.Atan;
import cds.tools.parser.AtanOp;
import cds.tools.parser.BasicOperator;
import cds.tools.parser.ConstantValOp;
import cds.tools.parser.Cos;
import cds.tools.parser.CosOp;
import cds.tools.parser.Deg2Rad;
import cds.tools.parser.Deg2RadOp;
import cds.tools.parser.DivideOp;
import cds.tools.parser.Exp;
import cds.tools.parser.ExpOp;
import cds.tools.parser.Function;
import cds.tools.parser.Log;
import cds.tools.parser.LogOp;
import cds.tools.parser.MultOp;
import cds.tools.parser.NepLog;
import cds.tools.parser.NepLogOp;
import cds.tools.parser.Node;
import cds.tools.parser.Operator;
import cds.tools.parser.ParserException;
import cds.tools.parser.PowerOp;
import cds.tools.parser.Rad2Deg;
import cds.tools.parser.Rad2DegOp;
import cds.tools.parser.Sin;
import cds.tools.parser.SinOp;
import cds.tools.parser.Sqrt;
import cds.tools.parser.SqrtOp;
import cds.tools.parser.SubtractOp;
import cds.tools.parser.Tan;
import cds.tools.parser.TanOp;
import cds.tools.parser.VariableOp;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

public final class Parser {
    private static HashMap functions;
    private static HashMap operators;
    private static Function[] AVAIL_FUNC;
    private static Class[] AVAIL_OP_CLASSES;
    private static String[] OP_CLASSES_KW;
    private HashMap varsOp = new HashMap(5);
    private int state = 0;
    private static final int ADD = 43;
    private static final int SUBTRACT = 45;
    private static final int DIVIDE = 47;
    private static final int MULTIPLY = 42;
    private static final int POWER = 94;
    private static final int GRP = 40;
    private static final int ENDGRP = 41;
    private static final int UNDERSCORE = 95;
    private static final int OPSQBR = 91;
    private static final int CLSQBR = 93;
    private static final BasicOperator OP_ADD;
    private static final BasicOperator OP_MUL;
    private static final BasicOperator OP_DIV;
    private static final BasicOperator OP_SUB;
    private static final BasicOperator OP_GRP;
    private static final BasicOperator OP_ENDGRP;
    private static final BasicOperator OP_POW;
    private Node root = null;
    private String str;
    AbstractOperateur rootOperator;
    static Class[] FUNC_OPERATOR;

    public Parser() {
        this.str = "0";
    }

    public Parser(String s) {
        this.str = !s.equals("") ? new String(s) : "0";
    }

    private static void initFunc() {
        for (int i = 0; i < AVAIL_FUNC.length; ++i) {
            Parser.addFunc(AVAIL_FUNC[i]);
        }
    }

    private static void initOperators() {
        for (int i = 0; i < OP_CLASSES_KW.length; ++i) {
            operators.put(OP_CLASSES_KW[i], AVAIL_OP_CLASSES[i]);
        }
    }

    public void parseString(String s) {
        this.str = s;
        this.parseString();
    }

    protected static String encodeExpr(String myExpr, HashMap vars) {
        String tmp;
        String[] varNames = new String[vars.size()];
        Iterator itVar = vars.keySet().iterator();
        int k = 0;
        while (itVar.hasNext()) {
            varNames[k] = tmp = (String)itVar.next();
            ++k;
        }
        for (int i = 0; i < varNames.length; ++i) {
            tmp = varNames[i];
            for (int j = i + 1; j < varNames.length; ++j) {
                if (varNames[j].length() <= tmp.length()) continue;
                String tmp2 = tmp;
                tmp = varNames[j];
                varNames[j] = tmp2;
                varNames[i] = tmp;
            }
        }
        String[] encodedVarNames = new String[vars.size()];
        for (int i = 0; i < varNames.length; ++i) {
            encodedVarNames[i] = Parser.encodeVariable(varNames[i]);
        }
        return Parser.putEncodedVariables(myExpr, varNames, encodedVarNames);
    }

    private static String putEncodedVariables(String s, String[] vars, String[] encodedVars) {
        boolean oend = false;
        StringBuffer strBuf = new StringBuffer();
        String ret = new String(s);
        for (int k = 0; k < vars.length; ++k) {
            ret = Parser.replace(ret, vars[k], encodedVars[k], -1);
        }
        return ret;
    }

    public void parseString() {
        this.str = Parser.encodeExpr(this.str, this.varsOp);
        Stack st_ob = new Stack();
        Stack st_op = new Stack();
        StringReader sr = new StringReader(this.str);
        StreamTokenizer tokenizer = new StreamTokenizer(sr);
        tokenizer.parseNumbers();
        tokenizer.lowerCaseMode(false);
        tokenizer.ordinaryChar(43);
        tokenizer.ordinaryChar(45);
        tokenizer.ordinaryChar(42);
        tokenizer.ordinaryChar(47);
        tokenizer.ordinaryChar(94);
        tokenizer.wordChars(95, 95);
        tokenizer.wordChars(91, 93);
        tokenizer.wordChars(123, 123);
        tokenizer.wordChars(125, 125);
        tokenizer.wordChars(32, 32);
        tokenizer.wordChars(64, 64);
        tokenizer.wordChars(33, 33);
        tokenizer.wordChars(126, 126);
        tokenizer.wordChars(38, 38);
        tokenizer.wordChars(96, 96);
        tokenizer.wordChars(92, 92);
        tokenizer.wordChars(36, 36);
        tokenizer.wordChars(59, 59);
        tokenizer.wordChars(58, 58);
        try {
            int type;
            this.state = 0;
            block9: while ((type = tokenizer.nextToken()) != -1) {
                switch (this.state) {
                    case 0: {
                        this.parserState0(tokenizer, st_ob, st_op);
                        continue block9;
                    }
                    case 1: {
                        this.parserState1(tokenizer, st_ob, st_op);
                        continue block9;
                    }
                    case 2: {
                        this.parserState2(tokenizer, st_ob, st_op);
                        continue block9;
                    }
                    case 3: {
                        continue block9;
                    }
                }
            }
            this.parserState2(tokenizer, st_ob, st_op);
            this.root = (Node)st_ob.elementAt(0);
        }
        catch (IOException e) {
            System.err.println(e);
        }
        catch (EmptyStackException e2) {
            throw new ParserException();
        }
        this.buildOperator();
    }

    private void buildOperator() {
        this.rootOperator = this.buildOperator(this.root);
    }

    private AbstractOperateur buildOperator(Node node) {
        switch (node.type) {
            case 3: {
                return this.getOperateurForFunc(node.svalue, this.buildOperator(node.left));
            }
            case 0: {
                return this.getOperateurForOp(node.op, this.buildOperator(node.left), this.buildOperator(node.right));
            }
            case 2: {
                return this.findVarOp(Parser.decodeVariable(node.svalue));
            }
            case 1: {
                return new ConstantValOp(node.getValue());
            }
        }
        return null;
    }

    private AbstractOperateur getOperateurForFunc(String func, AbstractOperateur op) {
        AbstractOperateur returnOp;
        try {
            Class c = (Class)operators.get(func);
            Constructor ct = c.getConstructor(AbstractOperateur.class);
            returnOp = (AbstractOperateur)ct.newInstance(op);
        }
        catch (Exception e) {
            return null;
        }
        return returnOp;
    }

    private AbstractOperateur getOperateurForOp(int op, AbstractOperateur op1, AbstractOperateur op2) {
        switch (op) {
            case 43: {
                return new AdditionOp(op1, op2);
            }
            case 45: {
                return new SubtractOp(op1, op2);
            }
            case 47: {
                return new DivideOp(op1, op2);
            }
            case 42: {
                return new MultOp(op1, op2);
            }
            case 94: {
                return new PowerOp(op1, op2);
            }
        }
        return null;
    }

    public final double eval() {
        return this.rootOperator.compute();
    }

    public final double oldEval() {
        return this.eval(this.root);
    }

    public static void addFunc(Function f) {
        functions.put(f.keyword(), f);
    }

    public void addVar(String name) {
        this.varsOp.put(name, new VariableOp());
    }

    public boolean setVarUnit(String name, String unitStr) {
        VariableOp x = (VariableOp)this.varsOp.get(name);
        if (x == null) {
            throw new ParserException("method setVar : Unknown variable " + name + " !!!");
        }
        if (unitStr == null) {
            unitStr = "";
        }
        try {
            Unit u = new Unit(unitStr);
            u.setValue(x.getValue());
            x.setUnit(u);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public void setVar(String name, double value) {
        try {
            VariableOp xo = (VariableOp)this.varsOp.get(name);
            xo.setValue(value);
        }
        catch (NullPointerException e) {
            throw new ParserException("method setVar : Unknown variable " + name + " !!!");
        }
    }

    public Iterator getVariables() {
        return this.varsOp.keySet().iterator();
    }

    public boolean isConstant() {
        return !this.getVariables().hasNext();
    }

    private double getVar(String name) {
        VariableOp x = (VariableOp)this.varsOp.get(name);
        if (x == null) {
            throw new ParserException("methode getVar : La variable " + name + " est inconnue!!!");
        }
        return x.getValue();
    }

    private VariableOp findVarOp(String name) {
        return (VariableOp)this.varsOp.get(name);
    }

    private static BasicOperator getOp(int op) {
        switch (op) {
            case 43: {
                return OP_ADD;
            }
            case 45: {
                return OP_SUB;
            }
            case 42: {
                return OP_MUL;
            }
            case 47: {
                return OP_DIV;
            }
            case 94: {
                return OP_POW;
            }
            case 40: {
                return OP_GRP;
            }
            case 41: {
                return OP_ENDGRP;
            }
        }
        return null;
    }

    private double eval(Node node) {
        double value = 0.0;
        if (node == null) {
            throw new ParserException("methode eval : noeud null !!!");
        }
        switch (node.type) {
            case 0: {
                value = this.evalOp(node);
                break;
            }
            case 1: {
                value = node.getValue();
                break;
            }
            case 2: {
                value = this.evalVar(node);
                break;
            }
            case 3: {
                value = this.evalFunc(node);
                break;
            }
            default: {
                throw new ParserException("methode eval : Ce noeud est de type inconnu !!!");
            }
        }
        return value;
    }

    private double evalOp(Node node) {
        double value = 0.0;
        switch (node.op) {
            case 43: {
                if (node.left != null) {
                    value = this.eval(node.left);
                }
                value += this.eval(node.right);
                break;
            }
            case 45: {
                if (node.right != null) {
                    value = this.eval(node.right);
                }
                value = this.eval(node.left) - value;
                break;
            }
            case 47: {
                value = this.eval(node.left);
                value /= this.eval(node.right);
                break;
            }
            case 42: {
                value = this.eval(node.left);
                value *= this.eval(node.right);
                break;
            }
            case 94: {
                value = Math.pow(this.eval(node.left), this.eval(node.right));
                break;
            }
            default: {
                throw new ParserException("methode evalOp : Operateur inconnu !!!");
            }
        }
        return value;
    }

    private double evalFunc(Node node) {
        Function f = (Function)functions.get(node.svalue);
        if (f == null) {
            throw new ParserException("method evalFunc : la fonction " + node.svalue + " est inconnue !!!");
        }
        return f.eval(this.eval(node.left));
    }

    private double evalVar(Node node) {
        VariableOp v = (VariableOp)this.varsOp.get(Parser.decodeVariable(node.svalue));
        if (v == null) {
            throw new ParserException("methode evalVar : la variable " + node.svalue + " est inconnue !!!");
        }
        return v.getValue();
    }

    public Unit evalUnit() throws ParseException {
        return this.evalUnit(this.root);
    }

    private Unit evalUnit(Node node) throws ParseException {
        Unit unit = null;
        if (node == null) {
            throw new ParserException("methode eval : noeud null !!!");
        }
        switch (node.type) {
            case 0: {
                unit = this.evalOpUnit(node);
                break;
            }
            case 1: {
                try {
                    unit = new Unit(new Double(node.getValue()).toString());
                    break;
                }
                catch (ParseException e) {
                    System.out.println("Error for a VALUE node");
                    throw e;
                }
            }
            case 2: {
                unit = this.evalVarUnit(node);
                break;
            }
            case 3: {
                unit = this.evalFuncUnit(node);
                break;
            }
            default: {
                throw new ParserException("methode eval : Ce noeud est de type inconnu !!!");
            }
        }
        return unit;
    }

    private Unit evalFuncUnit(Node node) throws ParseException {
        Function f = (Function)functions.get(node.svalue);
        if (f == null) {
            throw new ParserException("method evalFunc : la fonction " + node.svalue + " est inconnue !!!");
        }
        return f.evalUnit(this.evalUnit(node.left));
    }

    private Unit evalVarUnit(Node node) throws ParseException {
        VariableOp x = (VariableOp)this.varsOp.get(Parser.decodeVariable(node.svalue));
        if (x == null) {
            throw new ParserException("methode evalVar : la variable " + node.svalue + " est inconnue !!!");
        }
        Unit unit = new Unit(x.getUnit());
        return unit;
    }

    private Unit evalOpUnit(Node node) throws ParseException {
        Unit unit = null;
        switch (node.op) {
            case 43: {
                if (node.left != null) {
                    unit = new Unit(this.evalUnit(node.left));
                }
                unit.plus(this.evalUnit(node.right));
                break;
            }
            case 45: {
                if (node.right != null) {
                    unit = new Unit(this.evalUnit(node.right));
                }
                if (!node.left.valueIsSet()) {
                    unit.setValue(-unit.value);
                    break;
                }
                Unit temp = this.evalUnit(node.left);
                temp.minus(unit);
                unit = temp;
                break;
            }
            case 47: {
                unit = new Unit(this.evalUnit(node.left));
                unit.div(this.evalUnit(node.right));
                break;
            }
            case 42: {
                unit = new Unit(this.evalUnit(node.left));
                unit.mult(this.evalUnit(node.right));
                break;
            }
            case 94: {
                if (node.right.type == 1) {
                    double power = this.eval(node.right);
                    int powerInt = (int)power;
                    if (Double.valueOf(powerInt + "") == power) {
                        unit = new Unit(this.evalUnit(node.left));
                        unit.power(powerInt);
                        break;
                    }
                    unit = new Unit(this.evalOp(node) + "(" + this.evalUnit((Node)node.left).symbol + ")" + this.eval(node.right));
                    break;
                }
                if (node.left.type == 1) {
                    unit = new Unit(this.evalUnit(node.left));
                    break;
                }
                unit = new Unit(this.evalUnit(node.left));
                break;
            }
            default: {
                throw new ParserException("methode evalOp : Operateur inconnu !!!");
            }
        }
        return unit;
    }

    private static int precedence(int op) {
        switch (op) {
            case 43: {
                return 1;
            }
            case 45: {
                return 2;
            }
            case 42: {
                return 3;
            }
            case 47: {
                return 3;
            }
            case 94: {
                return 5;
            }
        }
        return -1;
    }

    private void parserState0(StreamTokenizer tokenizer, Stack ob, Stack op) throws IOException {
        switch (tokenizer.ttype) {
            case -3: {
                VariableOp x = (VariableOp)this.varsOp.get(Parser.decodeVariable(tokenizer.sval));
                if (x != null) {
                    Node node = new Node();
                    node.type = 2;
                    node.svalue = tokenizer.sval;
                    ob.push(node);
                    this.state = 2;
                    break;
                }
                Function f = (Function)functions.get(tokenizer.sval);
                if (f != null) {
                    op.push(f);
                    this.state = 0;
                    break;
                }
                throw new ParserException("Le mot " + tokenizer.sval + " est inconnu !");
            }
            case -2: {
                Node node = new Node();
                node.type = 1;
                node.setValue(tokenizer.nval);
                ob.push(node);
                this.state = 2;
                break;
            }
            case 43: {
                op.push(Parser.getOp(43));
                Node node = new Node();
                node.type = 1;
                ob.push(node);
                this.state = 1;
                break;
            }
            case 45: {
                op.push(Parser.getOp(45));
                Node node = new Node();
                node.type = 1;
                ob.push(node);
                this.state = 1;
                break;
            }
            case 40: {
                op.push(Parser.getOp(40));
                this.state = 0;
                break;
            }
            default: {
                throw new ParserException("Le parsing a echoue !!");
            }
        }
    }

    private void parserState1(StreamTokenizer tokenizer, Stack ob, Stack op) throws IOException {
        switch (tokenizer.ttype) {
            case -3: {
                VariableOp x = (VariableOp)this.varsOp.get(Parser.decodeVariable(tokenizer.sval));
                if (x != null) {
                    Node node = new Node();
                    node.type = 2;
                    node.svalue = tokenizer.sval;
                    ob.push(node);
                    this.state = 2;
                    break;
                }
                Function f = (Function)functions.get(tokenizer.sval);
                if (f != null) {
                    op.push(f);
                    this.state = 0;
                    break;
                }
                throw new ParserException("Le mot " + tokenizer.sval + " est inconnu !");
            }
            case -2: {
                Node node = new Node();
                node.type = 1;
                node.setValue(tokenizer.nval);
                ob.push(node);
                this.state = 2;
                break;
            }
            case 40: {
                op.push(Parser.getOp(40));
                this.state = 0;
                break;
            }
            default: {
                throw new ParserException("Le parsing a echoue !!");
            }
        }
    }

    private void parserState2(StreamTokenizer tokenizer, Stack ob, Stack op) throws IOException {
        switch (tokenizer.ttype) {
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 94: {
                BasicOperator op_read = Parser.getOp(tokenizer.ttype);
                if (!op.empty()) {
                    Operator tmpi = (Operator)op.peek();
                    while (tmpi.precedence() >= op_read.precedence()) {
                        Operator tmp;
                        if (tmpi.type == 0) {
                            tmp = (BasicOperator)op.pop();
                            Node deux = (Node)ob.pop();
                            Node un = (Node)ob.pop();
                            Node node = new Node();
                            node.type = 0;
                            node.op = ((BasicOperator)tmp).op;
                            node.left = un;
                            node.right = deux;
                            ob.push(node);
                        } else if (tmpi.type == 1) {
                            tmp = (Function)op.pop();
                            Node un = (Node)ob.pop();
                            Node node = new Node();
                            node.type = 3;
                            node.svalue = tmp.keyword();
                            node.left = un;
                            node.right = null;
                            ob.push(node);
                        }
                        if (op.empty()) break;
                        tmpi = (Operator)op.peek();
                    }
                }
                op.push(op_read);
                this.state = 1;
                break;
            }
            case 41: {
                BasicOperator op_read = Parser.getOp(tokenizer.ttype);
                if (!op.empty()) {
                    Operator tmp = (Operator)op.pop();
                    while (!tmp.keyword().equals("(")) {
                        Operator tmpi;
                        if (tmp.type == 0) {
                            tmpi = (BasicOperator)tmp;
                            Node deux = (Node)ob.pop();
                            Node un = (Node)ob.pop();
                            Node node = new Node();
                            node.type = 0;
                            node.op = ((BasicOperator)tmpi).op;
                            node.left = un;
                            node.right = deux;
                            ob.push(node);
                        } else if (tmp.type == 1) {
                            tmpi = (Function)tmp;
                            Node un = (Node)ob.pop();
                            Node node = new Node();
                            node.type = 3;
                            node.svalue = tmpi.keyword();
                            node.left = un;
                            node.right = null;
                            ob.push(node);
                        }
                        if (op.empty()) break;
                        tmp = (Operator)op.pop();
                    }
                }
                this.state = 2;
                break;
            }
            case -1: {
                while (!op.empty()) {
                    Operator tmpi;
                    Operator tmp = (Operator)op.pop();
                    if (tmp.type == 0) {
                        tmpi = (BasicOperator)tmp;
                        Node deux = (Node)ob.pop();
                        Node un = (Node)ob.pop();
                        Node node = new Node();
                        node.type = 0;
                        node.op = ((BasicOperator)tmpi).op;
                        node.left = un;
                        node.right = deux;
                        ob.push(node);
                        continue;
                    }
                    if (tmp.type != 1) continue;
                    tmpi = (Function)tmp;
                    Node un = (Node)ob.pop();
                    Node node = new Node();
                    node.type = 3;
                    node.svalue = tmpi.keyword();
                    node.left = un;
                    node.right = null;
                    ob.push(node);
                }
                this.state = 0;
                break;
            }
            default: {
                throw new ParserException("Le parsing a echoue !!");
            }
        }
    }

    public static String[] getAvailFunc() {
        String[] func = new String[AVAIL_FUNC.length];
        for (int i = 0; i < AVAIL_FUNC.length; ++i) {
            func[i] = AVAIL_FUNC[i].keyword();
        }
        return func;
    }

    protected static final String encodeVariable(String s) {
        if (s == null) {
            return null;
        }
        String ret = new String(s);
        ret = ret.replace('+', '@');
        ret = ret.replace('-', '!');
        ret = ret.replace('*', '~');
        ret = ret.replace('/', '&');
        ret = ret.replace('.', '`');
        ret = ret.replace('(', '\\');
        ret = ret.replace(')', '^');
        return ret;
    }

    protected static String decodeVariable(String s) {
        if (s == null) {
            return null;
        }
        String ret = new String(s);
        ret = ret.replace('@', '+');
        ret = ret.replace('!', '-');
        ret = ret.replace('~', '*');
        ret = ret.replace('&', '/');
        ret = ret.replace('`', '.');
        ret = ret.replace('\\', '(');
        ret = ret.replace('^', ')');
        return ret;
    }

    public String getExpr() {
        return this.str;
    }

    public static String replace(String text, String repl, String with, int max) {
        if (text == null || repl == null || with == null || repl.length() == 0 || max == 0) {
            return text;
        }
        StringBuffer buf = new StringBuffer(text.length());
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
            if (--max != 0) continue;
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    static {
        AVAIL_FUNC = new Function[]{new Sin(), new Cos(), new Tan(), new Log(), new NepLog(), new Abs(), new Deg2Rad(), new Rad2Deg(), new Sqrt(), new Exp(), new Atan()};
        AVAIL_OP_CLASSES = new Class[]{SinOp.class, CosOp.class, TanOp.class, LogOp.class, NepLogOp.class, AbsOp.class, Deg2RadOp.class, Rad2DegOp.class, SqrtOp.class, ExpOp.class, AtanOp.class};
        OP_CLASSES_KW = new String[]{"sin", "cos", "tan", "log", "ln", "abs", "deg2rad", "rad2deg", "sqrt", "exp", "atan"};
        functions = new HashMap(10);
        operators = new HashMap(10);
        Parser.initFunc();
        Parser.initOperators();
        OP_ADD = new BasicOperator(Parser.precedence(43), 43);
        OP_MUL = new BasicOperator(Parser.precedence(42), 42);
        OP_DIV = new BasicOperator(Parser.precedence(47), 47);
        OP_SUB = new BasicOperator(Parser.precedence(45), 45);
        OP_GRP = new BasicOperator(0, 40);
        OP_ENDGRP = new BasicOperator(0, 41);
        OP_POW = new BasicOperator(Parser.precedence(94), 94);
        FUNC_OPERATOR = new Class[0];
    }
}

