/*
 * Decompiled with CFR 0.152.
 */
package cds.tools;

import cds.astro.Coo;
import cds.tools.Util;
import java.util.Stack;

public final class Computer {
    private static boolean DEBUG = false;
    static final String[] FCTSPARAM = new String[]{"atan2", "atan2d", "atan2Deg", "min", "max", "dist", "skydist", "skyDistDegrees", "dmsToDegrees", "dmsToDegrees"};
    static final int[] FCTNPARAM = new int[]{2, 2, 2, 2, 2, 4, 4, 4, 3, 3};
    static final String[] HELP = new String[]{"x,+,*,/,%,^: addition, subtraction, multiplication, division, modulo, power", "exp(x):   Euler's number 'e' raised to the power of x", "ln(x):    the natural logarithm (base 'e') of x", "log(x):   the base 10 logarithm of x", "sqrt(x):  the correctly rounded positive square root of x", "ceil(x):  the largest (closest to positive infinity) integer value", "floor(x): the smallest (closest to negative infinity) integer value", "round(x): the value of the argument rounded to the nearest integer", "abs(x):   the absolute value of the argument", "sin(x):   trigonometric sine of an angle (x in radians)", "cos(x):   trigonometric cosine of an angle (x in radians)", "tan(x):   trigonometric tangent of an angle (x in degrees)", "asin(x):  the arc sine of a value (result in radians)", "acos(x):  the arc cosine of a value (result in radians)", "atan(x):  the arc tangent of a value (result in radians)", "sinh(x):  the hyperbolic sine of x", "cosh(x):  the hyperbolic cosine of x", "tanh(x):  the hyperbolic tangent of x", "sind,cosd,tand:   trigonometric functions of an angle (x in degress)", "asind,acosd,atad: the arc trigonometric functions (result in degrees)", "rad2deg(a):  the measurement of the angle a in radians", "deg2rad(a):  the measurement of the angle a in degrees", "min(x,y):    the smaller of x and y", "max(x,y):    the larger of x and y", "atan2(x,y):  the angle (in radians) corresponding to x,y in cartesian coordinates", "atan2d(x,y): the angle (in degrees) corresponding to x,y in cartesian coordinates", "dist(x1,y1,x2,y2):        cartesian distance between x1,y1 and x2,y2", "skydist(ra1,de1,ra2,de2): spherical distance (coord in degrees or sexa with : as separator"};
    private static char SEP = (char)44;
    private int step = 0;

    private int getNbParam(String s) {
        int i = Util.indexInArrayOf(s, FCTSPARAM);
        return i < 0 ? 1 : FCTNPARAM[i];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean operate(Stack<Val> sV, Stack<Op> sO) throws Exception {
        Val v;
        if (sO.size() == 0 || sV.size() == 0) {
            return false;
        }
        Op op = sO.peek();
        ++this.step;
        if (op.nbParam == 1) {
            v = sV.peek();
            if (DEBUG) {
                System.out.print(this.step + ")\t" + op.op + "(" + v + ")");
            }
            if (op.op.equals("-")) {
                v.v = -v.v;
            } else if (op.op.equals("+")) {
                v.v = v.v;
            } else if (op.op.equals("exp")) {
                v.v = Math.exp(v.v);
            } else if (op.op.equals("sin")) {
                v.v = Math.sin(v.v);
            } else if (op.op.equals("sind") || op.op.equals("sinDeg")) {
                v.v = Math.sin(Math.toRadians(v.v));
            } else if (op.op.equals("cos")) {
                v.v = Math.cos(v.v);
            } else if (op.op.equals("cosd") || op.op.equals("cosDeg")) {
                v.v = Math.cos(Math.toRadians(v.v));
            } else if (op.op.equals("tan")) {
                v.v = Math.tan(v.v);
            } else if (op.op.equals("tand") || op.op.equals("tanDeg")) {
                v.v = Math.tan(Math.toRadians(v.v));
            } else if (op.op.equals("asin")) {
                v.v = Math.asin(v.v);
            } else if (op.op.equals("asind") || op.op.equals("asinDeg")) {
                v.v = Math.toDegrees(Math.asin(v.v));
            } else if (op.op.equals("acos")) {
                v.v = Math.acos(v.v);
            } else if (op.op.equals("acosd") || op.op.equals("acosDeg")) {
                v.v = Math.toDegrees(Math.acos(v.v));
            } else if (op.op.equals("atan")) {
                v.v = Math.atan(v.v);
            } else if (op.op.equals("atand") || op.op.equals("atanDeg")) {
                v.v = Math.toDegrees(Math.atan(v.v));
            } else if (op.op.equals("sinh")) {
                v.v = Math.sinh(v.v);
            } else if (op.op.equals("cosh")) {
                v.v = Math.cosh(v.v);
            } else if (op.op.equals("tanh")) {
                v.v = Math.tanh(v.v);
            } else if (op.op.equals("sqrt")) {
                v.v = Math.sqrt(v.v);
            } else if (op.op.equals("ln")) {
                v.v = Math.log(v.v);
            } else if (op.op.equals("log1p")) {
                v.v = Math.log1p(v.v);
            } else if (op.op.equals("log")) {
                v.v = Math.log10(v.v);
            } else if (op.op.equals("sqrt")) {
                v.v = Math.sqrt(v.v);
            } else if (op.op.equals("round")) {
                v.v = Math.round(v.v);
            } else if (op.op.equals("ceil")) {
                v.v = Math.ceil(v.v);
            } else if (op.op.equals("floor")) {
                v.v = Math.floor(v.v);
            } else if (op.op.equals("rint")) {
                v.v = Math.rint(v.v);
            } else if (op.op.equals("abs")) {
                v.v = Math.abs(v.v);
            } else if (op.op.equals("toRadians") || op.op.equals("deg2rad")) {
                v.v = Math.toRadians(v.v);
            } else {
                if (!op.op.equals("toDegrees") && !op.op.equals("rad2deg")) throw new Exception("Unknown function [" + op.op + "]");
                v.v = Math.toDegrees(v.v);
            }
        } else {
            if (sV.size() < op.nbParam) {
                return false;
            }
            Val[] vx = new Val[op.nbParam - 1];
            for (int i = vx.length - 1; i >= 0; --i) {
                vx[i] = sV.pop();
            }
            v = sV.peek();
            if (DEBUG) {
                if (this.isUniqCharOp(op.op.charAt(0))) {
                    System.out.print(this.step + ")\t" + v + " " + op.op + " " + vx[0]);
                } else {
                    System.out.print(this.step + ")\t" + op.op + "(" + v.v);
                    for (Val v1 : vx) {
                        System.out.print(", " + v1.v);
                    }
                    System.out.print(")");
                }
            }
            if (op.op.equals("-")) {
                v.v -= vx[0].v;
            } else if (op.op.equals("+")) {
                v.v += vx[0].v;
            } else if (op.op.equals("*")) {
                v.v *= vx[0].v;
            } else if (op.op.equals("/")) {
                v.v /= vx[0].v;
            } else if (op.op.equals("%")) {
                v.v %= vx[0].v;
            } else if (op.op.equals("^")) {
                v.v = Math.pow(v.v, vx[0].v);
            } else if (op.op.equals("max")) {
                v.v = Math.max(v.v, vx[0].v);
            } else if (op.op.equals("min")) {
                v.v = Math.min(v.v, vx[0].v);
            } else if (op.op.equals("atan2")) {
                v.v = Math.atan2(v.v, vx[0].v);
            } else if (op.op.equals("atan2d") || op.op.equals("atan2Deg")) {
                v.v = Math.atan2(Math.toRadians(v.v), Math.toRadians(vx[0].v));
            } else if (op.op.equals("dist")) {
                v.v = Math.hypot(v.v - vx[1].v, vx[0].v - vx[2].v);
            } else if (op.op.equals("skydist") || op.op.equals("skyDistDegrees")) {
                v.v = Coo.distance(v.v, vx[0].v, vx[1].v, vx[2].v);
            } else if (op.op.equals("hms2Degrees")) {
                v.v = 15.0 * (v.v + vx[0].v / 60.0 + vx[1].v / 3600.0);
            } else {
                if (!op.op.equals("dms2Degrees")) throw new Exception("Unknown function [" + op.op + "]");
                v.v = v.v + vx[0].v / 60.0 + vx[1].v / 3600.0;
            }
        }
        if (DEBUG) {
            System.out.println(" => " + v.v);
        }
        sO.pop();
        return true;
    }

    private boolean isNumber(Expr e, int deb) {
        char ch = e.ch();
        if (Character.isDigit(ch) || ch == '.') {
            return true;
        }
        if (e.pos > deb && ch == ':') {
            return true;
        }
        if (SEP != ',' && ch == ',') {
            return true;
        }
        if (e.pos > deb && !e.isEnd()) {
            char ch1;
            if (!(ch != 'E' && ch != 'e' || (ch1 = e.s[e.pos + 1]) != '+' && ch1 != '-' && !Character.isDigit(ch1))) {
                return true;
            }
            if (!(ch != '+' && ch != '-' && !Character.isDigit(ch) || (ch1 = e.s[e.pos - 1]) != 'E' && ch1 != 'e')) {
                return true;
            }
        }
        return false;
    }

    private boolean isInFctName(Expr e, int deb) {
        char ch = e.ch();
        return e.pos == deb && !Character.isDigit(ch) && ch != '(' && ch != ')' || e.pos > deb && Character.isJavaIdentifierPart(ch);
    }

    private boolean isUniqCharOp(char ch) {
        return ch == '+' || ch == '-' || ch == '*' || ch == '/' || ch == '^' || ch == '%';
    }

    private Op seeNextOp(Expr e) {
        int oPos = e.pos;
        Op op = this.getNextOp(e);
        e.pos = oPos;
        return op;
    }

    private Op getNextOp(Expr e) {
        e.skipBlank();
        if (e.ch() == '(') {
            return null;
        }
        int deb = e.pos++;
        if (e.isEnd() || !this.isUniqCharOp(e.ch())) {
            while (!e.isEnd() && this.isInFctName(e, deb)) {
                ++e.pos;
            }
        }
        if (deb == e.pos) {
            return null;
        }
        Op op = new Op(e.get(deb, e.pos - deb), 2);
        return op;
    }

    private Op getNextFct(Expr e) {
        Op op = this.getNextOp(e);
        if (op == null) {
            return null;
        }
        op.nbParam = this.getNbParam(op.op);
        return op;
    }

    private String getSubExpr(Expr e) throws Exception {
        int deb = e.pos;
        int par = 0;
        if (e.ch() != '(') {
            throw new Exception("Missing '(' : " + e.error());
        }
        while (!e.isEnd()) {
            char ch = e.ch();
            ++e.pos;
            if (ch == ')') {
                --par;
            } else if (ch == '(') {
                ++par;
            }
            if (par != 0) continue;
            break;
        }
        if (par > 0) {
            throw new Exception("Unbalanced parenthesis :" + e.error());
        }
        return e.get(deb + 1, e.pos - deb - 2);
    }

    private Val getNextVal(Expr e) throws Exception {
        e.skipBlank();
        if (!e.isEnd() && e.ch() == '(') {
            String s = this.getSubExpr(e);
            double x = this.computeInternal(s);
            return new Val(x);
        }
        int deb = e.pos;
        while (!e.isEnd() && this.isNumber(e, deb)) {
            ++e.pos;
        }
        if (deb == e.pos) {
            return null;
        }
        return new Val(e.get(deb, e.pos - deb));
    }

    private Val getNextParam(Expr e) throws Exception {
        e.skipBlank();
        int par = 0;
        int deb = e.pos;
        char ch = ' ';
        while (!e.isEnd()) {
            ch = e.ch();
            ++e.pos;
            if (ch == '(') {
                ++par;
            } else if (ch == ')') {
                --par;
            }
            if (par != 0 || ch != SEP) continue;
        }
        if (par > 0) {
            throw new Exception("Unbalanced parenthesis :" + e.error());
        }
        String s = e.get(deb, e.pos - deb - (ch == SEP ? 1 : 0));
        s = this.sexa2deg(s);
        return new Val(this.computeInternal(s));
    }

    private void stackAndComputeParam(Stack<Val> sV, Stack<Op> sF, Expr e) throws Exception {
        int n = sF.peek().nbParam;
        e.skipBlank();
        Expr e1 = new Expr(this.getSubExpr(e));
        for (int i = 0; i < n; ++i) {
            Val v = this.getNextParam(e1);
            if (v == null) {
                throw new Exception("Missing parameter :" + e.error());
            }
            sV.push(v);
        }
        if (!e1.isEnd()) {
            throw new Exception("Unknown parameter: " + e1.error());
        }
        this.operate(sV, sF);
    }

    private void read(Stack<Val> sV, Stack<Op> sO, Stack<Op> sF, Expr e) throws Exception {
        Op f;
        while ((f = this.getNextFct(e)) != null && this.isUniqCharOp(f.op.charAt(0))) {
            sF.push(f);
            f = null;
        }
        if (f != null) {
            sF.push(f);
            this.stackAndComputeParam(sV, sF, e);
        } else {
            Val val = this.getNextVal(e);
            if (val == null) {
                throw new Exception("Missing number :" + e.error());
            }
            sV.push(val);
        }
        while (this.operate(sV, sF)) {
        }
        Op op = this.seeNextOp(e);
        while (!sO.isEmpty() && (op == null || op.pri <= sO.peek().pri) && this.operate(sV, sO)) {
        }
    }

    private void readNext(Stack<Val> sV, Stack<Op> sO, Stack<Op> sF, Expr e) throws Exception {
        e.skipBlank();
        if (e.isEnd()) {
            return;
        }
        Op op = this.getNextOp(e);
        if (op == null) {
            throw new Exception("Missing operation :" + e.error());
        }
        sO.push(op);
        this.read(sV, sO, sF, e);
    }

    private void readFirst(Stack<Val> sV, Stack<Op> sO, Stack<Op> sF, Expr e) throws Exception {
        this.read(sV, sO, sF, e);
    }

    private String sexa2deg(String s) throws Exception {
        if (s.length() < 5 || s.indexOf(58) <= 0) {
            return s;
        }
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (Character.isDigit(ch) || ch == '+' || ch == '-' || ch == ':' || ch == '.') continue;
            return s;
        }
        int deb = 0;
        double f = 15.0;
        if (s.charAt(0) == '-') {
            f = -1.0;
            ++deb;
        } else if (s.charAt(0) == '+') {
            f = 1.0;
            ++deb;
        }
        int fin = s.indexOf(58, deb);
        double a1 = Double.parseDouble(s.substring(deb, fin));
        deb = fin + 1;
        fin = s.indexOf(58, deb);
        double a2 = Double.parseDouble(s.substring(deb, fin));
        deb = fin + 1;
        double a3 = Double.parseDouble(s.substring(deb));
        String d = f * (a1 + a2 / 60.0 + a3 / 3600.0) + "";
        if (DEBUG) {
            System.out.println(++this.step + ")\t" + s + " => " + d);
        }
        return d;
    }

    public double computeInternal(String expression) throws Exception {
        Stack<Val> sV = new Stack<Val>();
        Stack<Op> sO = new Stack<Op>();
        Stack<Op> sF = new Stack<Op>();
        Expr expr = new Expr(expression);
        this.readFirst(sV, sO, sF, expr);
        while (!expr.isEnd()) {
            this.readNext(sV, sO, sF, expr);
        }
        if (!expr.isEnd() || sV.size() > 1 || sO.size() > 0 || sF.size() > 0) {
            throw new Exception("Truncated expression :" + expr.error());
        }
        return sV.pop().v;
    }

    public static String help() {
        StringBuilder s = new StringBuilder();
        for (String s1 : HELP) {
            s.append(s1 + "\n");
        }
        return s.toString();
    }

    public static void setDebug(boolean flag) {
        DEBUG = flag;
    }

    public static void setSeparator(char sep) {
        SEP = sep;
    }

    public static double compute(String s) throws Exception {
        if (DEBUG) {
            System.out.println("Computing:\n" + s);
        }
        return new Computer().computeInternal(s);
    }

    public static void main(String[] argv) {
        try {
            String s = " -skydist(05:34:43.68,+21:59:28.1,184.50849,-05.79883)*-60 -sin ( -round( 100+1e-03)%(3*2) + -cos(32.2+8^(7-5*max(3,1/8.7) )  )) * -(6-2E+5)";
            Computer.setDebug(true);
            double x = Computer.compute(s);
            System.out.println(s + " = " + x);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class Op {
        String op;
        int nbParam;
        int pri;

        Op(String op, int nbParam) {
            this.op = op;
            this.nbParam = nbParam;
            this.pri = 0;
            char ch = op.charAt(0);
            if (ch == '*' || ch == '/' || ch == '%') {
                this.pri = 1;
            } else if (ch == '^') {
                this.pri = 2;
            }
        }
    }

    class Val {
        double v;

        Val(double v) {
            this.v = v;
        }

        Val(String v) {
            this.v = Double.parseDouble(v);
        }

        public String toString() {
            return this.v + "";
        }
    }

    class Expr {
        char[] s;
        int pos;

        Expr(String expr) {
            this.s = expr.toCharArray();
            this.pos = 0;
        }

        boolean isEnd() {
            return this.pos >= this.s.length;
        }

        char ch() {
            return this.isEnd() ? (char)'\u0000' : this.s[this.pos];
        }

        String get(int deb, int count) {
            return new String(this.s, deb, count);
        }

        String error() {
            return new String(this.s, 0, this.pos) + " ?? " + new String(this.s, this.pos, this.s.length - this.pos);
        }

        void skipBlank() {
            while (this.pos < this.s.length && Character.isSpaceChar(this.s[this.pos])) {
                ++this.pos;
            }
        }
    }
}

