/*
 * Decompiled with CFR 0.152.
 */
package cds.tools;

import cds.aladin.Aladin;
import cds.tools.Util;
import java.awt.FileDialog;
import java.io.File;
import javax.swing.JFileChooser;

public final class CDSFileDialog {
    private Aladin aladin;
    FileDialog fd;
    JFileChooser jfc;
    static final boolean isWin = Util.indexOfIgnoreCase(System.getProperty("os.name"), "win") >= 0;
    private static final String DEFAULT_FILENAME = "-";

    public CDSFileDialog(Aladin aladin) {
        this.aladin = aladin;
        if (isWin) {
            this.fd = new FileDialog(aladin.dialog);
        } else {
            this.jfc = new JFileChooser();
        }
    }

    public String getDirectory() {
        if (isWin) {
            return this.fd.getDirectory();
        }
        File f = this.jfc.getCurrentDirectory();
        return f == null ? null : f.toString();
    }

    public void setDirectory(String dir) {
        if (isWin) {
            this.fd.setDirectory(dir);
        } else {
            this.jfc.setCurrentDirectory(new File(dir));
        }
    }

    public String getFile() {
        if (isWin) {
            this.fd.setFile(DEFAULT_FILENAME);
            this.fd.setVisible(true);
            String directory = this.fd.getDirectory();
            String name = this.fd.getFile();
            if (name != null && name.equals(DEFAULT_FILENAME)) {
                return directory;
            }
            return name;
        }
        this.jfc.setVisible(true);
        File f = this.jfc.getSelectedFile();
        return f == null ? null : f.toString();
    }
}

