/*
 * Decompiled with CFR 0.152.
 */
package cds.tools;

import cds.aladin.Tok;
import cds.astro.Unit;
import cds.tools.Util;
import java.util.Locale;
import org.jastronomy.jsofa.JSOFA;

public class Astrodate {
    public static final int JD = 13;
    public static final int MJD = 14;
    public static final int ISOTIME = 15;
    public static final int YEARS = 16;
    public static final int DATE = 17;
    public static final int UNIX = 18;
    public static final int BES = 19;

    public static double JDToMJD(double JD) {
        return JD - 2400000.5;
    }

    public static double MJDToJD(double MJD) {
        return MJD + 2400000.5;
    }

    public static double ISOToJD(String date) throws Exception {
        int i = date.indexOf(45);
        if (i < 0) {
            throw new Exception("Not ISO date");
        }
        Tok tok = new Tok(date, "-T:");
        double A2 = Double.parseDouble(tok.nextToken());
        double M = Double.parseDouble(tok.nextToken());
        double J = Double.parseDouble(tok.nextToken());
        double HH = 0.0;
        double MM = 0.0;
        double SS = 0.0;
        if (tok.hasMoreTokens()) {
            HH = Double.parseDouble(tok.nextToken());
        }
        if (tok.hasMoreTokens()) {
            MM = Double.parseDouble(tok.nextToken());
        }
        if (tok.hasMoreTokens()) {
            SS = Double.parseDouble(tok.nextToken());
        }
        double res = Astrodate.dateToJD(A2, M, J, HH, MM, SS);
        return res;
    }

    public static double dateToJD(String date) {
        boolean slash = false;
        int i = date.indexOf(45);
        if (i < 0) {
            i = date.indexOf(47);
            slash = true;
        }
        if (i < 0) {
            i = date.indexOf(32);
        }
        if (i < 0) {
            String ss = null;
            String m = null;
            String hh = null;
            String dd = null;
            String mm = null;
            String yyyy = null;
            yyyy = date.substring(0, 4);
            mm = date.substring(4, 6);
            dd = date.substring(6, 8);
            int offsetT = date.indexOf(84);
            if (offsetT > 0) {
                hh = date.substring(9, 11);
                m = date.substring(11, 13);
                if (date.length() > 13) {
                    ss = date.substring(13);
                }
            }
            date = yyyy + "-" + mm + "-" + dd;
            if (hh != null) {
                date = date + "T" + hh + ":" + m;
                if (ss != null) {
                    date = date + ":" + ss;
                }
            }
        }
        int suffix = date.length();
        --suffix;
        while (suffix > 0) {
            if (Character.isDigit(date.charAt(suffix))) {
                ++suffix;
                break;
            }
            --suffix;
        }
        if (suffix > 0) {
            date = date.substring(0, suffix);
        }
        Tok tok = new Tok(date, "-/T: ");
        double A2 = Double.parseDouble(tok.nextToken());
        double M = Double.parseDouble(tok.nextToken());
        double J = Double.parseDouble(tok.nextToken());
        if (slash) {
            double x = A2;
            A2 = J;
            J = x;
        }
        double HH = 0.0;
        double MM = 0.0;
        double SS = 0.0;
        if (tok.hasMoreTokens()) {
            HH = Double.parseDouble(tok.nextToken());
        }
        if (tok.hasMoreTokens()) {
            MM = Double.parseDouble(tok.nextToken());
        }
        if (tok.hasMoreTokens()) {
            SS = Double.parseDouble(tok.nextToken());
        }
        if (A2 < 100.0) {
            A2 += 1900.0;
        }
        double res = Astrodate.dateToJD(A2, M, J, HH, MM, SS);
        return res;
    }

    public static double dateToJD(double A2, double M, double J, double HH, double MM, double SS) {
        long B;
        if (M < 3.0) {
            A2 -= 1.0;
            M += 12.0;
        }
        if (A2 > 1582.0 || A2 == 1582.0 && M > 10.0 || A2 == 1582.0 && M == 10.0 && J >= 15.0) {
            long C = (long)(A2 / 100.0);
            B = 2L - C + C / 4L;
        } else {
            B = 0L;
        }
        double T = HH / 24.0 + MM / 1440.0 + SS / 86400.0;
        return (double)((long)(365.25 * (A2 + 4716.0)) + (long)(30.6001 * (M + 1.0))) + J + T + (double)B - 1524.5;
    }

    public static String JDToRegularDate(double JD) {
        return Astrodate.JDToDate(JD, true, true, false);
    }

    public static String JDToDate(double JD) {
        return Astrodate.JDToDate(JD, true);
    }

    public static String JDToDate(double JD, boolean withTime) {
        return Astrodate.JDToDate(JD, withTime, true);
    }

    public static String JDToDate(double JD, boolean withTime, boolean flagDecimalSecond) {
        return Astrodate.JDToDate(JD, withTime, flagDecimalSecond, true);
    }

    private static String JDToDate(double JD, boolean withTime, boolean flagDecimalSecond, boolean flagISO) {
        long G;
        long Z = (long)(JD + 0.5);
        double F = JD + 0.5 - (double)Z;
        if (Z < 2299161L) {
            G = Z;
        } else {
            long a = (long)(((double)Z - 1867216.25) / 36524.25);
            G = Z + 1L + a - a / 4L;
        }
        long B = G + 1524L;
        long C = (long)(((double)B - 122.1) / 365.25);
        long D = (long)(365.25 * (double)C);
        long E = (long)((double)(B - D) / 30.6001);
        double j = (double)(B - D - (long)(30.6001 * (double)E)) + F;
        long J = (long)j;
        long M = (double)E < 13.5 ? E - 1L : E - 13L;
        long A2 = (double)M < 2.5 ? C - 4715L : C - 4716L;
        long s = (long)((j - (double)J) * 86400.0 + 0.5);
        double ss = (j - (double)J) * 86400.0;
        long HH = s / 3600L;
        long MM = (s - HH * 3600L) / 60L;
        long SS = s - HH * 3600L - MM * 60L;
        double SSf = ss - (double)(HH * 3600L) - (double)(MM * 60L);
        if (!withTime || !flagDecimalSecond || SSf - (double)((int)SSf) < 0.001) {
            return flagISO ? A2 + "-" + Astrodate.dd(M) + "-" + Astrodate.dd(J) + (withTime ? "T" + Astrodate.dd(HH) + ":" + Astrodate.dd(MM) + ":" + Astrodate.dd(SS) : "") : J + "/" + M + "/" + A2 + (withTime ? " " + Astrodate.dd(HH) + ":" + Astrodate.dd(MM) + ":" + Astrodate.dd(SS) : "");
        }
        String s1 = String.format(Locale.ROOT, "%02.3f", SSf);
        return flagISO ? A2 + "-" + Astrodate.dd(M) + "-" + Astrodate.dd(J) + "T" + Astrodate.dd(HH) + ":" + Astrodate.dd(MM) + ":" + s1 : J + "/" + M + "/" + A2 + " " + Astrodate.dd(HH) + ":" + Astrodate.dd(MM) + ":" + s1;
    }

    private static String dd(long x) {
        return x < 10L ? "0" + x : "" + x;
    }

    public static double YdToJD(double Yd) {
        return 2451545.0 + (Yd - 2000.0) * 365.25;
    }

    public static double JDToYd(double JD) {
        return (JD - 2451545.0) / 365.25 + 2000.0;
    }

    public static double UnixToJD(long time) {
        return (double)time / 86400.0 + 2440587.5;
    }

    public static long JDToUnix(double JD) {
        return (long)((JD - 2440587.5) * 86400.0 + 0.5);
    }

    public static String editTime(double jd, int timeMode) {
        try {
            if (timeMode == 13) {
                return jd + "";
            }
            if (timeMode == 14) {
                return Astrodate.JDToMJD(jd) + "";
            }
            if (timeMode == 15) {
                return Astrodate.JDToDate(jd);
            }
            if (timeMode == 16) {
                return Astrodate.JDToYd(jd) + "";
            }
            if (timeMode == 18) {
                return Astrodate.JDToUnix(jd) + "";
            }
            if (timeMode == 19) {
                return JSOFA.jauEpb(jd, 0.0) + "";
            }
            if (timeMode == 17) {
                return Astrodate.JDToRegularDate(jd);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static double parseTime(String date, int timeMode) {
        try {
            if (timeMode == 13) {
                return Double.parseDouble(date);
            }
            if (timeMode == 14) {
                return Astrodate.MJDToJD(Double.parseDouble(date));
            }
            if (timeMode == 15) {
                return Astrodate.dateToJD(date);
            }
            if (timeMode == 16) {
                return Astrodate.YdToJD(Double.parseDouble(date));
            }
            if (timeMode == 18) {
                return Astrodate.UnixToJD(Long.parseLong(date));
            }
            if (timeMode == 19) {
                return Astrodate.getSofaJD(JSOFA.jauEpb2jd(Double.parseDouble(date)));
            }
            return Astrodate.MJDToJD(Util.ISOToMJD(Util.parseDate(date)));
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    private static double getSofaJD(JSOFA.JulianDate jd) {
        return jd.djm0 + jd.djm1;
    }

    public static double getTCBTime(double jdTime, String timeScale, String refPosition) throws Exception {
        if (timeScale.equals("TCB") && refPosition.equals("BARYCENTER")) {
            return jdTime;
        }
        double deltaT = -1.0;
        double dtr = -1.0;
        if (timeScale.equals("UTC")) {
            jdTime = Astrodate.getSofaJD(JSOFA.jauUtctai(jdTime, 0.0));
            timeScale = "TAI";
        }
        if (timeScale.equals("TAI")) {
            jdTime = Astrodate.getSofaJD(JSOFA.jauTaitt(jdTime, 0.0));
            timeScale = "TT";
        }
        if (timeScale.equals("UT1")) {
            if (deltaT == -1.0) {
                throw new Exception("Astrodate convertion not possible - missing Solar ephemerids");
            }
            jdTime = Astrodate.getSofaJD(JSOFA.jauUt1tt(jdTime, 0.0, deltaT));
            timeScale = "TT";
        }
        if (timeScale.equals("TT")) {
            if (dtr == -1.0) {
                throw new Exception("Astrodate convertion not possible - missing Solar ephemerids");
            }
            jdTime = Astrodate.getSofaJD(JSOFA.jauTttdb(jdTime, 0.0, dtr));
            timeScale = "TDB";
        }
        if (timeScale.equals("TDB")) {
            jdTime = Astrodate.getSofaJD(JSOFA.jauTdbtcb(jdTime, 0.0));
            timeScale = "TCB";
        }
        if (timeScale.equals("TCB")) {
            return jdTime;
        }
        throw new Exception("Astrodate convertion error");
    }

    public static double convert(double val, String fromUnit, String toUnit) throws Exception {
        boolean flagMoins = fromUnit.startsWith("10-");
        if (flagMoins || fromUnit.startsWith("10+")) {
            int deb = 3;
            int fin = deb + 1;
            while (Character.isDigit(fromUnit.charAt(fin))) {
                ++fin;
            }
            int exp = Integer.parseInt(fromUnit.substring(deb, fin));
            double fct = Math.pow(10.0, exp);
            val = flagMoins ? val / fct : val * fct;
            fromUnit = fromUnit.substring(fin);
        }
        double fctOut = 1.0;
        flagMoins = toUnit.startsWith("10-");
        if (flagMoins || fromUnit.startsWith("10+")) {
            int deb = 3;
            int fin = deb + 1;
            while (Character.isDigit(toUnit.charAt(fin))) {
                ++fin;
            }
            int exp = Integer.parseInt(fromUnit.substring(deb, fin));
            fctOut = Math.pow(10.0, exp);
            toUnit = toUnit.substring(fin);
        }
        if (!fromUnit.equals(toUnit)) {
            Unit m1 = new Unit(val + " " + fromUnit);
            m1.convertTo(new Unit(toUnit));
            val = m1.getValue();
        }
        return flagMoins ? val * fctOut : val / fctOut;
    }
}

