/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.tools;

import cds.savot.model.FieldSet;
import cds.savot.model.ParamSet;
import cds.savot.model.ResourceSet;
import cds.savot.model.SavotField;
import cds.savot.model.SavotParam;
import cds.savot.model.SavotResource;
import cds.savot.model.SavotTR;
import cds.savot.model.SavotTable;
import cds.savot.model.SavotVOTable;
import cds.savot.model.TDSet;
import cds.savot.stax.SavotStaxParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;

public final class SimpleVoTableTransformer {
    private static final Logger logger = Logger.getLogger(SimpleVoTableTransformer.class.getName());
    private static final int LARGE_TABLE_THRESHOLD = 5000;
    private final char separator;

    public static SimpleVoTableTransformer newCSVTransformer() {
        return new SimpleVoTableTransformer(',');
    }

    public static SimpleVoTableTransformer newTSVTransformer() {
        return new SimpleVoTableTransformer('\t');
    }

    public static void main(String[] argv) {
        if (argv.length < 2) {
            logger.log(Level.SEVERE, "Missing args: {0} <inputFile> <outputFile> !", SimpleVoTableTransformer.class.getName());
            return;
        }
        String inputFile = argv[0];
        String outputFile = argv[1];
        logger.info(String.format("Transforming '%s' to '%s' ...", inputFile, outputFile));
        try {
            SimpleVoTableTransformer.newTSVTransformer().transform(inputFile, outputFile);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "fatal error", e);
        }
    }

    public SimpleVoTableTransformer(char separator) {
        this.separator = separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transform(String inFile, String outputFile) throws IOException, XMLStreamException {
        long start = System.nanoTime();
        SavotStaxParser parser = new SavotStaxParser(inFile, 2);
        SavotTR tr = parser.getNextTR();
        SavotVOTable savotVoTable = parser.getVOTable();
        ResourceSet resources = savotVoTable.getResources();
        SavotResource resource = null;
        SavotTable table = null;
        if (resources.getItemCount() == 1 && (resource = (SavotResource)resources.getItemAt(0)).getTables().getItemCount() == 1) {
            table = (SavotTable)resource.getTables().getItemAt(0);
        }
        if (resource == null || table == null) {
            throw new IllegalArgumentException("Incorrect VOTable format (1 mandatory table) !");
        }
        char sep = this.separator;
        FileOutputStream outputStream = new FileOutputStream(new File(outputFile));
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(outputStream), 65536);
        try {
            int step;
            bw.append("#TABLE: ").append(inFile).write("\n");
            this.writeDescription(bw, table.getDescription());
            this.writeParamSet(bw, table.getParams());
            FieldSet fields = table.getFields();
            this.writeFieldSet(bw, fields);
            int tableRows = table.getNrowsValue();
            int rowLen = fields.getItemCount();
            int nRow = 0;
            int n = step = tableRows > 5000 ? tableRows / 20 : Integer.MAX_VALUE;
            do {
                if (nRow % step == 0 && nRow != 0) {
                    logger.info(String.format("processing row: %d / %d ...", nRow, tableRows));
                }
                TDSet row = tr.getTDSet();
                int tdLen = row.getItemCount();
                for (int i = 0; i < rowLen; ++i) {
                    String value;
                    if (i != 0) {
                        bw.write(sep);
                    }
                    if (i >= tdLen || (value = row.getRawContent(i)) == null) continue;
                    bw.write(value);
                }
                bw.write(10);
                ++nRow;
            } while ((tr = parser.getNextTR()) != null);
            logger.info(String.format("transform: %d rows processed in %.3f ms.", nRow, 1.0E-6 * (double)(System.nanoTime() - start)));
        }
        finally {
            parser.close();
            bw.close();
        }
    }

    private void writeDescription(BufferedWriter bw, String description) throws IOException {
        if (description.length() != 0) {
            StringTokenizer t = new StringTokenizer(description, "\n");
            while (t.hasMoreTokens()) {
                bw.append("#  ").append(t.nextToken()).write(10);
            }
        }
    }

    private void writeParamSet(BufferedWriter bw, ParamSet paramSet) throws IOException {
        bw.write("#\n#PARAMS:\n");
        int len = paramSet.getItemCount();
        if (len == 0) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            SavotParam param = (SavotParam)paramSet.getItemAt(i);
            bw.append("# ").append(param.getName()).append(" = ").append(param.getValue()).write(10);
            this.writeDescription(bw, param.getDescription());
        }
    }

    private void writeFieldSet(BufferedWriter bw, FieldSet fieldSet) throws IOException {
        SavotField field;
        int i;
        bw.write("#\n#FIELDS:\n");
        int len = fieldSet.getItemCount();
        if (len == 0) {
            return;
        }
        char sep = this.separator;
        bw.write("# ");
        for (i = 0; i < len; ++i) {
            field = (SavotField)fieldSet.getItemAt(i);
            bw.append(field.getId()).write(sep);
        }
        bw.write(10);
        for (i = 0; i < len; ++i) {
            field = (SavotField)fieldSet.getItemAt(i);
            bw.append(field.getName()).write(sep);
        }
        bw.write(10);
        bw.write("# ");
        for (i = 0; i < len; ++i) {
            field = (SavotField)fieldSet.getItemAt(i);
            bw.append(field.getUcd()).write(sep);
        }
        bw.write(10);
        bw.write("# ");
        for (i = 0; i < len; ++i) {
            field = (SavotField)fieldSet.getItemAt(i);
            bw.append(field.getUnit()).write(sep);
        }
        bw.write(10);
    }
}

