/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.pull;

import cds.savot.common.SavotStatistics;
import cds.savot.model.SavotCoosys;
import cds.savot.model.SavotField;
import cds.savot.model.SavotInfo;
import cds.savot.model.SavotLink;
import cds.savot.model.SavotParam;
import cds.savot.model.SavotResource;
import cds.savot.model.SavotTR;
import cds.savot.model.SavotTable;
import cds.savot.model.SavotVOTable;
import cds.savot.model.SavotValues;
import cds.savot.pull.SavotPullEngine;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;

public final class SavotPullParser {
    private final SavotPullEngine engine;
    private final SavotStatistics stats = new SavotStatistics();

    public SavotPullParser(String file, int mode) {
        this(file, mode, false);
    }

    public SavotPullParser(String file, int mode, boolean debug) {
        this.engine = new SavotPullEngine((XmlPullParser)new KXmlParser(), file, mode, debug, this.stats);
    }

    public SavotPullParser(URL url, int mode, String enc) {
        this(url, mode, enc, false);
    }

    public SavotPullParser(URL url, int mode, String enc, boolean debug) {
        this.engine = new SavotPullEngine((XmlPullParser)new KXmlParser(), url, mode, enc, debug, this.stats);
    }

    public SavotPullParser(InputStream instream, int mode, String enc) {
        this(instream, mode, enc, false);
    }

    public SavotPullParser(InputStream instream, int mode, String enc, boolean debug) {
        this.engine = new SavotPullEngine((XmlPullParser)new KXmlParser(), instream, mode, enc, debug, this.stats);
    }

    public SavotPullParser(Reader reader, int mode) {
        this(reader, mode, false);
    }

    public SavotPullParser(Reader reader, int mode, boolean debug) {
        this.engine = new SavotPullEngine((XmlPullParser)new KXmlParser(), reader, mode, debug, this.stats);
    }

    public void close() {
        this.engine.close();
    }

    public SavotStatistics getStatistics() {
        return this.stats;
    }

    public SavotResource getNextResource() {
        return this.engine.getNextResource();
    }

    public SavotTR getNextTR() {
        return this.engine.getNextTR();
    }

    public SavotVOTable getVOTable() {
        return this.engine.getAllResources();
    }

    public int getResourceCount() {
        return this.engine.getResourceCount();
    }

    public int getTableCount() {
        return this.engine.getTableCount();
    }

    public int getTRCount() {
        return this.engine.getTRCount();
    }

    public int getDataCount() {
        return this.engine.getDataCount();
    }

    public Map<String, Object> getIdRefLinks() {
        return this.engine.getIdRefLinks();
    }

    public SavotResource getResourceFromRef(String ref) {
        return this.engine.getResourceFromRef(ref);
    }

    public SavotField getFieldFromRef(String ref) {
        return this.engine.getFieldFromRef(ref);
    }

    public SavotParam getParamFromRef(String ref) {
        return this.engine.getParamFromRef(ref);
    }

    public SavotTable getTableFromRef(String ref) {
        return this.engine.getTableFromRef(ref);
    }

    public SavotInfo getInfoFromRef(String ref) {
        return this.engine.getInfoFromRef(ref);
    }

    public SavotValues getValuesFromRef(String ref) {
        return this.engine.getValuesFromRef(ref);
    }

    public SavotLink getLinkFromRef(String ref) {
        return this.engine.getLinkFromRef(ref);
    }

    public SavotCoosys getCoosysFromRef(String ref) {
        return this.engine.getCoosysFromRef(ref);
    }

    public SavotVOTable getAllResources() {
        return this.engine.getAllResources();
    }

    public String getVersion() {
        return "4.0";
    }

    public void enableDebug(boolean debug) {
        this.engine.enableDebug(debug);
    }

    public void sequentialTester() {
        SavotResource currentResource = null;
        while ((currentResource = this.engine.getNextResource()) != null) {
        }
    }

    public static void main(String[] argv) throws IOException {
        if (argv.length == 0) {
            System.out.println("Usage: java SavotPullParser <xml document>");
        } else {
            new SavotPullParser(argv[0], 0);
        }
    }
}

