/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.model.interpreter;

import cds.savot.model.interpreter.BinaryFieldInterpreter;
import cds.savot.model.interpreter.BinaryInterpreterException;

public class UnsignedByteInterpreter
extends BinaryFieldInterpreter<Short> {
    public UnsignedByteInterpreter(int[] arraysizes) throws BinaryInterpreterException {
        super(arraysizes, "unsigned byte", 1);
    }

    @Override
    public Short decodePrimary(byte[] b, int offset) throws BinaryInterpreterException {
        return (short)(b[offset] & 0xFF);
    }

    @Override
    protected Class<Short[]> getArrayClass() {
        return Short[].class;
    }

    @Override
    protected Short convertPrimary(Object value) throws BinaryInterpreterException {
        if (value == null) {
            return null;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Byte) {
            return (short)((Byte)value);
        }
        if (value instanceof String) {
            try {
                return Short.parseShort((String)value);
            }
            catch (NumberFormatException nfe) {
                throw new BinaryInterpreterException("Impossible to convert \"" + value + "\" into an Unsigned Byte: " + nfe.getMessage() + " !");
            }
        }
        throw new BinaryInterpreterException("Impossible to convert a " + value.getClass().getName() + " into an Unsigned Byte !");
    }

    @Override
    public byte[] encodePrimary(Short value) throws BinaryInterpreterException {
        if (value == null) {
            return new byte[]{-1};
        }
        return new byte[]{(byte)(value & 0xFF)};
    }
}

