/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.model.interpreter;

import cds.savot.model.interpreter.BinaryFieldInterpreter;
import cds.savot.model.interpreter.BinaryInterpreterException;
import cds.savot.model.interpreter.IntegerInterpreter;

public class FloatInterpreter
extends BinaryFieldInterpreter<Float> {
    private final IntegerInterpreter intDecoder = new IntegerInterpreter();

    public FloatInterpreter() throws BinaryInterpreterException {
        this(new int[]{1});
    }

    public FloatInterpreter(int[] arraysizes) throws BinaryInterpreterException {
        super(arraysizes, "float complex", 4);
    }

    @Override
    public Float decodePrimary(byte[] bytes, int offset) throws BinaryInterpreterException {
        return Float.valueOf(Float.intBitsToFloat(this.intDecoder.decodePrimary(bytes, offset)));
    }

    @Override
    protected Class<Float[]> getArrayClass() {
        return Float[].class;
    }

    @Override
    protected Float convertPrimary(Object value) throws BinaryInterpreterException {
        if (value == null) {
            return Float.valueOf(Float.NaN);
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof String) {
            try {
                return Float.valueOf(Float.parseFloat((String)value));
            }
            catch (NumberFormatException nfe) {
                throw new BinaryInterpreterException("Impossible to convert \"" + value + "\" into a Float: " + nfe.getMessage() + " !");
            }
        }
        throw new BinaryInterpreterException("Impossible to convert a " + value.getClass().getName() + " into a Float !");
    }

    @Override
    public byte[] encodePrimary(Float value) throws BinaryInterpreterException {
        if (value == null) {
            value = Float.valueOf(Float.NaN);
        }
        return this.intDecoder.encodePrimary(Float.floatToRawIntBits(value.floatValue()));
    }
}

