/*
 * Decompiled with CFR 0.152.
 */
package cds.savot.binary;

import cds.savot.binary.Base64Exception;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public final class Base64 {
    static final int LINE_LENGTH = 76;
    static final String NEW_LINE = System.getProperty("line.separator");
    static final char[] base64code = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    static final char PADDING_CHAR = '=';
    static final int[] base64decode = new int[256];

    private Base64() {
    }

    public static String encodeStr(String string) {
        return Base64.encodeStr(string, null);
    }

    public static String encodeStr(String string, String charset) {
        byte[] byteArray;
        try {
            byteArray = charset == null ? string.getBytes() : string.getBytes(charset);
        }
        catch (UnsupportedEncodingException ignored) {
            byteArray = string.getBytes();
        }
        return Base64.encode(byteArray);
    }

    public static String encode(byte[] byteArray) {
        StringBuilder encoded = new StringBuilder();
        int nbRealBytes = byteArray.length;
        int paddingCount = (3 - nbRealBytes % 3) % 3;
        byte[] paddedByteArray = Base64.zeroPad(nbRealBytes + paddingCount, byteArray);
        for (int i = 0; i < paddedByteArray.length; i += 3) {
            int group = (paddedByteArray[i] & 0xFF) << 16;
            group |= (paddedByteArray[i + 1] & 0xFF) << 8;
            encoded.append(base64code[(group |= paddedByteArray[i + 2] & 0xFF) >> 18 & 0x3F]);
            encoded.append(base64code[group >> 12 & 0x3F]);
            encoded.append(i + 1 >= nbRealBytes ? (char)'=' : base64code[group >> 6 & 0x3F]);
            encoded.append(i + 2 >= nbRealBytes ? (char)'=' : base64code[group & 0x3F]);
        }
        return Base64.splitLines(encoded).toString();
    }

    static byte[] zeroPad(int length, byte[] bytes) {
        byte[] padded = new byte[length];
        System.arraycopy(bytes, 0, padded, 0, bytes.length);
        return padded;
    }

    static StringBuilder splitLines(StringBuilder encoded) {
        for (int i = 0; i < encoded.length(); i += 76 + NEW_LINE.length()) {
            if (i + 76 > encoded.length()) continue;
            encoded.insert(i + 76, NEW_LINE);
        }
        return encoded;
    }

    public static String decodeStr(String encoded) throws Base64Exception {
        return Base64.decodeStr(encoded, null);
    }

    public static String decodeStr(String encoded, String charset) throws Base64Exception {
        byte[] bytes = Base64.decode(encoded);
        if (bytes == null) {
            return null;
        }
        if (charset != null) {
            try {
                return new String(bytes, charset);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new String(bytes);
    }

    public static byte[] decode(String encoded) throws Base64Exception {
        return Base64.decode(encoded.toCharArray());
    }

    public static byte[] decode(char[] encoded) throws Base64Exception {
        int cLength = 0;
        int pad = 0;
        boolean eom = false;
        for (int i = 0; !eom && i < encoded.length; ++i) {
            if (base64decode[encoded[i]] > -1) {
                if (pad > 0 && encoded[i] != '=') {
                    throw new Base64Exception("Encoded message corrupted: \"" + encoded[i] + "\" has been encountered after a padding character (\"" + '=' + "\") !");
                }
                ++cLength;
                if (encoded[i] == '=') {
                    ++pad;
                }
            } else if (!Character.isWhitespace(encoded[i])) {
                System.err.println("Warning: encoded message may be corrupted: unknown base64 character: \"" + encoded[i] + "\" !");
            }
            if (pad > 0 && cLength % 4 == 0) {
                eom = true;
            }
            if (pad <= 2) continue;
            throw new Base64Exception("Encoded message corrupted: a message encoding in base64 can end with at most 2 padding characters (\"=\") !");
        }
        if (cLength % 4 != 0) {
            throw new Base64Exception("Encoded message corrupted (only " + cLength + " valid characters) !");
        }
        int bLength = cLength / 4 * 3 - pad;
        byte[] decoded = new byte[bLength];
        int nbChar = 0;
        int nbBytes = 0;
        int nbGroupedChars = 0;
        int group = 0;
        for (int i = 0; i < encoded.length && nbChar < cLength; ++i) {
            if (base64decode[encoded[i]] <= -1) continue;
            group |= (base64decode[encoded[i]] & 0x3F) << 6 * (3 - nbGroupedChars);
            if (++nbGroupedChars == 4) {
                decoded[nbBytes++] = (byte)(group >> 16 & 0xFF);
                if (nbBytes < bLength) {
                    decoded[nbBytes++] = (byte)(group >> 8 & 0xFF);
                    if (nbBytes < bLength) {
                        decoded[nbBytes++] = (byte)(group & 0xFF);
                    }
                }
                group = 0;
                nbGroupedChars = 0;
            }
            ++nbChar;
        }
        return decoded;
    }

    static {
        Arrays.fill(base64decode, -1);
        int iS = base64code.length;
        for (int i = 0; i < iS; ++i) {
            Base64.base64decode[Base64.base64code[i]] = i;
        }
        Base64.base64decode[61] = 0;
    }
}

