/*
 * Decompiled with CFR 0.152.
 */
package cds.mocmulti;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Unite {
    static final String ISO_FORMAT = "yyyy-MM-dd'T'HH:mm";
    static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
    public static final String[] unites;
    static DecimalFormat DF;

    public static String getTemps(long ms) {
        return Unite.getTemps(ms, false);
    }

    public static String getTemps(long ms, boolean round) {
        StringBuffer s = new StringBuffer();
        if (ms > 86400000L) {
            long j = ms / 86400000L;
            ms -= j * 86400000L;
            s.append(j + "j");
        }
        if (ms > 3600000L) {
            long h = ms / 3600000L;
            ms -= h * 3600000L;
            if (s.length() > 0) {
                s.append(' ');
            }
            s.append(h + "h");
        }
        if (ms > 60000L) {
            long m = ms / 60000L;
            ms -= m * 60000L;
            if (s.length() > 0) {
                s.append(' ');
            }
            s.append(m + "m");
        }
        if (s.length() > 0) {
            s.append(' ');
        }
        s.append((round ? "" + ms / 1000L : "" + (double)ms / 1000.0) + "s");
        return s.toString();
    }

    public static final String getDate(long ms) {
        return sdf.format(new Date(ms));
    }

    public static final String getUnitDisk(long val) {
        return Unite.getUnitDisk(val, 2);
    }

    public static final String getUnitDisk(long val, int format) {
        int unit = 0;
        long rest = 0L;
        boolean neg = false;
        if (val < 0L) {
            neg = true;
            val = -val;
        }
        while (val >= 1024L && unit < unites.length - 1) {
            ++unit;
            long div = val / 1024L;
            rest = val % 1024L;
            val = div;
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(format);
        double x = (double)val + (double)rest / 1024.0;
        return (neg ? "-" : "") + nf.format(x) + unites[unit];
    }

    public static final String myRound(double x) {
        int posV;
        String s = x + "";
        int posE = s.indexOf(69);
        if (posE > 0 && (posV = s.indexOf(46)) > 0) {
            if (posV + 4 > posE) {
                return s;
            }
            return s.substring(0, posV + 4) + s.substring(posE);
        }
        double y = Math.abs(x);
        if (y > 1000.0) {
            DF.setMaximumFractionDigits(0);
        } else if (y > 100.0) {
            DF.setMaximumFractionDigits(1);
        } else if (y > 10.0) {
            DF.setMaximumFractionDigits(2);
        } else if (y > 1.0) {
            DF.setMaximumFractionDigits(3);
        } else if (y > 0.1) {
            DF.setMaximumFractionDigits(4);
        } else if (y > 0.01) {
            DF.setMaximumFractionDigits(5);
        } else {
            DF.setMaximumFractionDigits(6);
        }
        return DF.format(x);
    }

    static {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        sdf.setTimeZone(utc);
        unites = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB", "ZB"};
        DF = new DecimalFormat();
        DF.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        DF.setGroupingSize(0);
    }
}

