/*
 * Decompiled with CFR 0.152.
 */
package cds.mocmulti;

import cds.aladin.MyProperties;
import cds.moc.Moc;
import cds.mocmulti.MultiMoc;

public class MocItem {
    public String mocId;
    public Moc moc;
    public MyProperties prop;
    public long dateMoc;
    public long dateProp;

    public MocItem(String id, Moc m, MyProperties p, long dMoc, long dProp) {
        this.mocId = id;
        this.moc = m;
        this.prop = p;
        this.dateMoc = dMoc;
        this.dateProp = dProp;
        if (this.prop != null) {
            this.prop.replaceValue(MultiMoc.KEY_TIMESTAMP, this.getPropTimeStamp() + "");
        }
    }

    public MocItem(String id, MyProperties p) {
        this.mocId = id;
        this.prop = p;
        this.moc = null;
        this.dateProp = 0L;
        this.dateMoc = 0L;
        String s = this.prop.getProperty(MultiMoc.KEY_TIMESTAMP);
        if (s != null) {
            try {
                this.dateProp = Long.parseLong(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public long getPropTimeStamp() {
        return this.dateProp != 0L ? this.dateProp : this.dateMoc;
    }

    public MocItem copy() {
        return new MocItem(this.mocId, this.moc, this.prop, this.dateMoc, this.dateProp);
    }

    public boolean equals(MocItem m) {
        if (this == m) {
            return true;
        }
        if (this.prop == null && m.prop != null || this.prop != null && m.prop == null) {
            return false;
        }
        return this.prop != null && this.prop.equals(m.prop);
    }
}

