/*
 * Decompiled with CFR 0.152.
 */
package cds.mocmulti;

import java.io.RandomAccessFile;

public final class BufWriter {
    private static final int MAX = 512;
    public byte[] buf = new byte[512];
    protected int offset = 0;
    private RandomAccessFile in;

    public BufWriter(RandomAccessFile in) {
        this.in = in;
    }

    public static int sizeOfString(String s) {
        return 2 + (s == null ? 0 : s.getBytes().length);
    }

    public void memoString(String s) throws Exception {
        if (s == null) {
            this.memoShort((short)-1);
            return;
        }
        byte[] a = s.getBytes("UTF-8");
        int len = a.length;
        if (len > Short.MAX_VALUE) {
            len = Short.MAX_VALUE;
        }
        this.memoShort((short)a.length);
        this.availability(a.length);
        System.arraycopy(a, 0, this.buf, this.offset, a.length);
        this.offset += a.length;
    }

    public void memoBoolean(boolean v) throws Exception {
        this.availability(1);
        this.buf[this.offset++] = (byte)(v ? 1 : 0);
    }

    public void memoByte(byte v) throws Exception {
        this.availability(1);
        this.buf[this.offset++] = (byte)(v & 0xFF);
    }

    public void memoShort(short v) throws Exception {
        this.availability(2);
        this.buf[this.offset++] = (byte)(v & 0xFF);
        this.buf[this.offset++] = (byte)(v >> 8 & 0xFF);
    }

    public void memoInteger(int v) throws Exception {
        this.availability(4);
        this.buf[this.offset++] = (byte)(v & 0xFF);
        this.buf[this.offset++] = (byte)(v >> 8 & 0xFF);
        this.buf[this.offset++] = (byte)(v >> 16 & 0xFF);
        this.buf[this.offset++] = (byte)(v >> 24 & 0xFF);
    }

    public void memoLong(long v) throws Exception {
        this.availability(8);
        this.buf[this.offset++] = (byte)(v & 0xFFL);
        this.buf[this.offset++] = (byte)(v >> 8 & 0xFFL);
        this.buf[this.offset++] = (byte)(v >> 16 & 0xFFL);
        this.buf[this.offset++] = (byte)(v >> 24 & 0xFFL);
        this.buf[this.offset++] = (byte)(v >> 32 & 0xFFL);
        this.buf[this.offset++] = (byte)(v >> 40 & 0xFFL);
        this.buf[this.offset++] = (byte)(v >> 48 & 0xFFL);
        this.buf[this.offset++] = (byte)(v >> 56 & 0xFFL);
    }

    public void flush() throws Exception {
        this.in.write(this.buf, 0, this.offset);
        this.offset = 0;
    }

    private void availability(int n) throws Exception {
        if (this.buf.length - this.offset >= n) {
            return;
        }
        this.flush();
        if (n > this.buf.length) {
            this.buf = new byte[n];
        }
    }
}

