/*
 * Decompiled with CFR 0.152.
 */
package cds.mocmulti;

import cds.aladin.MyProperties;
import cds.moc.Moc;
import cds.moc.Moc1D;
import cds.moc.Moc2D;
import cds.moc.SMoc;
import cds.moc.STMoc;
import cds.moc.TMoc;
import cds.mocmulti.BufReader;
import cds.mocmulti.BufWriter;
import cds.mocmulti.MocItem;
import cds.mocmulti.MultiMoc;
import cds.mocmulti.Unite;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.RandomAccessFile;

public final class BinaryDump {
    private static boolean debug = false;
    private static final byte[] BINVERSION = new byte[]{77, 67, 49, 50};
    private static final long MAGICODE = 2021042317L;
    private static final byte NOMOC = 0;
    private static final byte SMOC = 1;
    private static final byte TMOC = 2;
    private static final byte STMOC = 3;

    public MultiMoc load(String path) throws Exception {
        MultiMoc moc;
        long deb = System.currentTimeMillis();
        File f = new File(path);
        RandomAccessFile rf = new RandomAccessFile(f, "r");
        byte[] version = new byte[4];
        rf.readFully(version);
        String va = new String(version);
        String vb = new String(BINVERSION);
        if (!va.equals(vb)) {
            rf.close();
            throw new Exception("MultiMoc binary dump not compatible (found [" + va + "], required [" + vb + "]");
        }
        BufReader buf = new BufReader(rf);
        try {
            moc = this.parseDump(buf);
            rf.close();
            rf = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (rf != null) {
                rf.close();
            }
        }
        long fin = System.currentTimeMillis();
        long duree = fin - deb;
        if (debug) {
            System.out.println("MultiMoc binary dump read in " + (double)duree / 1000.0 + "s => " + Unite.getUnitDisk(moc.getMem(), 0));
        }
        return moc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(MultiMoc mMoc, String path) throws Exception {
        long deb = System.currentTimeMillis();
        File tmp = null;
        long size = 0L;
        try {
            tmp = new File(path + ".tmp" + System.currentTimeMillis() % 1000L);
            RandomAccessFile rf = new RandomAccessFile(tmp, "rw");
            rf.write(BINVERSION);
            this.createDump(mMoc, rf);
            rf.close();
            File f = new File(path);
            f.delete();
            tmp.renameTo(f);
            size = f.length();
            tmp = null;
        }
        finally {
            if (tmp != null) {
                tmp.delete();
            }
        }
        long fin = System.currentTimeMillis();
        long duree = fin - deb;
        if (debug) {
            System.out.println("MultiMoc binary dump written in " + (double)duree / 1000.0 + "s => RAM=" + Unite.getUnitDisk(mMoc.getMem(), 0) + " Dump=" + Unite.getUnitDisk(size, 0));
        }
    }

    public MultiMoc parseDump(BufReader buf) throws Exception {
        boolean b = false;
        MultiMoc mMoc = new MultiMoc();
        mMoc.clear();
        buf.readString();
        int nbMoc = buf.readInteger();
        for (int i = 0; i < nbMoc; ++i) {
            long dateMoc = buf.readLong();
            String mocId = buf.readString();
            Moc moc = null;
            byte typeMoc = buf.readByte();
            if (typeMoc != 0) {
                if (typeMoc == 1) {
                    moc = new SMoc();
                } else if (typeMoc == 2) {
                    moc = new TMoc();
                } else if (typeMoc == 3) {
                    moc = new STMoc();
                } else {
                    throw new Exception("Unknown MOC type => [" + typeMoc + "]");
                }
                if (moc instanceof Moc1D) {
                    ((Moc1D)moc).setMocOrder(buf.readInteger());
                } else {
                    ((Moc2D)moc).setMocOrder1(buf.readInteger());
                    ((Moc2D)moc).setMocOrder2(buf.readInteger());
                }
                int nbBytes = buf.readInteger();
                byte[] a = new byte[nbBytes];
                for (int j = 0; j < a.length; ++j) {
                    a[j] = buf.readByte();
                }
                moc.readSpecificDataRange(nbBytes / 8, a, 8, 1);
            }
            long dateProp = buf.readLong();
            int n = buf.readInteger();
            MyProperties prop = n > 0 ? new MyProperties() : null;
            for (int j = 0; j < n; ++j) {
                String key = buf.readString();
                String value = buf.readString();
                prop.put(key, value);
            }
            mMoc.add(mocId, moc, prop, dateMoc, dateProp);
        }
        long mc = buf.readLong();
        if (mc != 2021042317L) {
            throw new Exception("Multimoc dump error. Bad end MAGIC CODE");
        }
        return mMoc;
    }

    public void createDump(MultiMoc mMoc, RandomAccessFile rf) throws Exception {
        BufWriter buf = new BufWriter(rf);
        buf.memoString(mMoc.getCoordSys());
        buf.memoInteger(mMoc.size());
        for (MocItem mi : mMoc) {
            buf.memoLong(mi.dateMoc);
            Moc moc = mi.moc;
            String mocId = mi.mocId;
            buf.memoString(mocId);
            if (moc == null) {
                buf.memoByte((byte)0);
            } else {
                int nbCoding = -1;
                if (moc instanceof SMoc) {
                    buf.memoByte((byte)1);
                    buf.memoInteger(((Moc1D)moc).getMocOrder());
                    nbCoding = ((Moc1D)moc).seeRangeList().sz;
                } else if (moc instanceof TMoc) {
                    buf.memoByte((byte)2);
                    buf.memoInteger(((Moc1D)moc).getMocOrder());
                } else {
                    buf.memoByte((byte)3);
                    buf.memoInteger(((Moc2D)moc).getMocOrder1());
                    buf.memoInteger(((Moc2D)moc).getMocOrder2());
                }
                if (nbCoding == -1) {
                    nbCoding = moc.getNbCoding();
                }
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream(nbCoding * 8);
                int nbBytes = moc.writeSpecificDataRange(byteStream, 1);
                buf.memoInteger(nbBytes);
                byte[] a = byteStream.toByteArray();
                for (int i = 0; i < nbBytes; ++i) {
                    buf.memoByte(a[i]);
                }
            }
            buf.memoLong(mi.dateProp);
            MyProperties prop = mi.prop;
            if (prop == null) {
                buf.memoInteger(0);
            } else {
                int n = prop.size();
                buf.memoInteger(n);
                for (String key : prop.getKeys()) {
                    buf.memoString(key);
                    String val = prop.get(key);
                    buf.memoString(val);
                }
            }
            buf.flush();
        }
        buf.memoLong(2021042317L);
        buf.flush();
    }
}

