/*
 * Decompiled with CFR 0.152.
 */
package cds.moc.misc;

import cds.moc.Healpix;
import cds.moc.Moc;
import cds.moc.SMoc;
import cds.moc.STMoc;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;

public class MocExample {
    public static void main(String[] args) throws Exception {
        try {
            String u = "http://alasky.cds.unistra.fr/MocServer/query?ID=CDS/II/311/wise&get=moc";
            System.out.println("Loading this remote MOC: " + u + "...");
            URL url = new URL(u);
            BufferedInputStream bis = new BufferedInputStream(url.openStream(), 32768);
            SMoc mocA = new SMoc();
            mocA.read(bis);
            System.out.println("Moc sky coverage : " + MocExample.pourcent(mocA.getCoverage()));
            System.out.println("Moc order        : " + mocA.getMocOrder());
            System.out.println("Number of cells  : " + mocA.getNbCells());
            System.out.println("Number of ranges : " + mocA.getNbRanges());
            System.out.println("In memory        :~" + mocA.getMem() + " bytes");
            System.out.println("Information      : MOCTOOL=" + mocA.getProperty("MOCTOOL") + " MOCTYPE=" + mocA.getProperty("MOCTYPE") + " MOCID=" + mocA.getProperty("MOCID") + " DATE=" + mocA.getProperty("DATE") + " ORIGIN=" + mocA.getProperty("ORIGIN") + " EXTNAME=" + mocA.getProperty("EXTNAME"));
            System.out.print("Contents         : ");
            MocExample.display("MocA", mocA);
            SMoc mocB = new SMoc();
            mocB.add("3/2 53 55 4/20-22 25 28 30 50 60 5/456 567 836 9/123456");
            mocB.setProperty("MOCID", "ivo://CDS/0001");
            mocB.write("Moc.fits");
            mocB.read("Moc.fits");
            System.out.print("\nAnother Moc created by string: ");
            MocExample.display("MocB", mocB);
            SMoc mocD = new SMoc();
            mocD.setMocOrder(13);
            mocD.bufferOn();
            Healpix hpx = new Healpix();
            for (int i = 0; i < 100000; ++i) {
                double lon = Math.random() * 360.0;
                double lat = Math.random() * 180.0 - 90.0;
                mocD.add(hpx, lon, lat);
            }
            mocD.bufferOff();
            System.out.print("\nAnother Moc created by spherical positions: ");
            MocExample.display("MocD", mocD);
            Moc.setMocOrderLogic(1);
            SMoc clone = mocA.clone();
            SMoc union = clone.union(mocB);
            SMoc inter = mocA.intersection(mocB);
            System.out.println("\nMocA coverage      : " + MocExample.pourcent(mocA.getCoverage()));
            System.out.println("MocB coverage        : " + MocExample.pourcent(mocB.getCoverage()));
            System.out.println("Moc union coverage   : " + MocExample.pourcent(union.getCoverage()));
            System.out.println("Moc inter coverage   : " + MocExample.pourcent(inter.getCoverage()));
            File f = new File("Moc.fits");
            System.out.println("\nWriting MocA in FITS file " + f.getAbsolutePath());
            FileOutputStream outFits = new FileOutputStream(f);
            mocA.writeFITS(outFits);
            ((OutputStream)outFits).close();
            f = new File("Moc.txt");
            System.out.println("Writing MocA in ASCII file " + f.getAbsolutePath());
            FileOutputStream outAscii = new FileOutputStream(f);
            mocA.writeASCII(outAscii);
            ((OutputStream)outAscii).close();
            int order = 5;
            long npix = 849L;
            System.out.println("\nHEALPix cell " + order + "/" + npix + " => inside mocA : " + mocA.isIncluding(order, npix));
            order = 7;
            npix = 14103L;
            System.out.println("HEALPix cell " + order + "/" + npix + " => inside mocA : " + mocA.isIncluding(order, npix));
            System.out.println("MocA => intersects mocB : " + mocA.isIntersecting(mocB));
            hpx = new Healpix();
            double al = 95.73267;
            double del = 69.55885;
            System.out.println("Coordinate (" + al + "," + del + ") => inside MocA : " + mocA.contains(hpx, al, del));
            al = 95.60671;
            del = 69.57092;
            System.out.println("Coordinate (" + al + "," + del + ") => inside MocA : " + mocA.contains(hpx, al, del));
            mocA.setMocOrder(13);
            al = 282.81215;
            del = -70.20608;
            double radius = 0.5;
            SMoc circle = mocA.queryDisc(hpx, al, del, radius);
            MocExample.display("MocA intersection with circle(" + al + "," + del + "," + radius + ")", circle);
            circle.setMocOrder(6);
            MocExample.display("Same result for limit order 6", circle);
            STMoc moc = new STMoc(31, 13);
            double jdmin = -1.0;
            double jdmax = -1.0;
            for (int i = 0; i < 1000; ++i) {
                if (i % 10 == 0) {
                    jdmin = Math.random() * 10000.0 + 2400000.5;
                    jdmax = jdmin + Math.random() * 10.0;
                }
                double lon = Math.random() * 360.0;
                double lat = Math.random() * 180.0 - 90.0;
                moc.add(hpx, lon, lat, jdmin, jdmax);
            }
            MocExample.display("STMoc built randomly", moc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static String pourcent(double d) {
        return (double)((int)(1000.0 * d)) / 100.0 + "%";
    }

    public static void display(String title, Moc moc) throws Exception {
        String asciiMoc = moc.toString();
        if (asciiMoc.length() > 1000) {
            asciiMoc = asciiMoc.substring(0, 1000) + "...";
        }
        System.out.println(title + ":" + asciiMoc);
    }
}

