/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.Moc;
import cds.moc.Moc1D;
import cds.moc.STMoc;
import java.io.InputStream;
import java.io.OutputStream;

public class TMoc
extends Moc1D {
    public static final double DAYMICROSEC = 8.64E10;
    public static final int MAXORD_T = 61;
    public static final int FACT_T = 2;
    public static final char DIM_T = 't';
    public static final long NBVAL_T = TMoc.pow2(61L);
    public static final String SYS_T = "TCB";
    public static final double TIME_MIN = TMoc.getTime(0L);
    public static final double TIME_MAX = TMoc.getTime(NBVAL_T);

    @Override
    public final int maxOrder() {
        return 61;
    }

    @Override
    public final int shiftOrder() {
        return 1;
    }

    @Override
    public final char cDim() {
        return 't';
    }

    @Override
    public final long maxVal() {
        return NBVAL_T;
    }

    @Override
    public final String sys() {
        return SYS_T;
    }

    public TMoc() {
    }

    public TMoc(int mocOrder) {
        super(mocOrder);
    }

    public TMoc(String s) throws Exception {
        super(s);
    }

    public TMoc(TMoc moc) throws Exception {
        super(moc);
    }

    public TMoc(InputStream in) throws Exception {
        super(in);
    }

    @Override
    public TMoc clone() throws CloneNotSupportedException {
        TMoc moc = this.dup();
        this.clone1(moc);
        return moc;
    }

    @Override
    protected void clone1(Moc moc) throws CloneNotSupportedException {
        if (!(moc instanceof TMoc)) {
            throw new CloneNotSupportedException("Uncompatible type of MOC for clone. Must be TMoc");
        }
        super.clone1(moc);
    }

    @Override
    public TMoc dup() {
        TMoc moc = new TMoc();
        moc.sys = this.sys;
        return moc;
    }

    @Override
    public int sizeOfCoding() {
        return 8;
    }

    @Override
    public int getNbCoding() {
        return this.range.sz;
    }

    @Override
    public void add(Moc moc) throws Exception {
        if (!(moc instanceof TMoc)) {
            throw new Exception("Uncompatible Moc for adding");
        }
        super.add(moc);
    }

    @Override
    public String getTimeSys() {
        return SYS_T;
    }

    @Override
    protected long getNpixWithLimit(double jd) {
        if (jd < TIME_MIN) {
            return 0L;
        }
        if (jd > TIME_MAX) {
            return NBVAL_T;
        }
        return TMoc.getNpix(jd);
    }

    public static long getNpix(double jd) {
        return TMoc.getMicrosec(jd, 0L);
    }

    public static final double getTime(long npix) {
        if (npix < 0L || npix > NBVAL_T) {
            return Double.NaN;
        }
        return (double)npix / 8.64E10;
    }

    public static long getMicrosec(double jd, long offset) {
        long micron = (long)(jd * 8.64E10);
        if ((double)micron < TIME_MIN || (double)micron > TIME_MAX) {
            return -1L;
        }
        return micron + offset * 86400000000L;
    }

    public void add(double jdmin, double jdmax) throws Exception {
        long min = Double.isNaN(jdmin) ? 0L : TMoc.getNpix(jdmin);
        long max = Double.isNaN(jdmax) ? NBVAL_T : TMoc.getNpix(jdmax);
        this.add(61, min, max);
    }

    public boolean contains(double jd) {
        long val = (long)(jd * 8.64E10);
        return this.range.contains(val);
    }

    public double getTimeMin() {
        if (this.isEmpty()) {
            return -1.0;
        }
        return TMoc.getTime(this.range.begins(0));
    }

    public double getTimeMax() {
        if (this.isEmpty()) {
            return -1.0;
        }
        return TMoc.getTime(this.range.ends(this.range.nranges() - 1) - 1L);
    }

    public static double getTime(int order, long val) {
        int shift = 61 - order;
        long t = val << shift;
        return TMoc.getTime(t);
    }

    public static long getDuration(int order) {
        int shift = 1 * (61 - order);
        return 1L << shift;
    }

    @Override
    public boolean isIncluding(Moc moc) throws Exception {
        if (moc instanceof STMoc) {
            moc = ((STMoc)moc).getTimeMoc();
        } else if (!(moc instanceof TMoc)) {
            throw new Exception("Uncompatible Moc type for TMoc isIncluding test");
        }
        this.flush();
        return this.range.contains(((TMoc)moc).range);
    }

    @Override
    public boolean isIntersecting(Moc moc) throws Exception {
        if (moc instanceof STMoc) {
            moc = ((STMoc)moc).getTimeMoc();
        } else if (!(moc instanceof TMoc)) {
            throw new Exception("Uncompatible Moc type for TMoc isIntersecting test");
        }
        this.flush();
        return this.range.overlaps(((TMoc)moc).range);
    }

    @Override
    public TMoc union(Moc moc) throws Exception {
        if (moc instanceof STMoc) {
            moc = ((STMoc)moc).getTimeMoc();
        } else if (!(moc instanceof TMoc)) {
            throw new Exception("Uncompatible Moc type for TMoc union");
        }
        return (TMoc)super.union(moc);
    }

    @Override
    public TMoc intersection(Moc moc) throws Exception {
        if (moc instanceof STMoc) {
            moc = ((STMoc)moc).getTimeMoc();
        } else if (!(moc instanceof TMoc)) {
            throw new Exception("Uncompatible Moc type for TMoc subtraction");
        }
        return (TMoc)super.subtraction(moc);
    }

    @Override
    public TMoc subtraction(Moc moc) throws Exception {
        if (moc instanceof STMoc) {
            moc = ((STMoc)moc).getTimeMoc();
        } else if (!(moc instanceof TMoc)) {
            throw new Exception("Uncompatible Moc type for TMoc subtraction");
        }
        return (TMoc)super.subtraction(moc);
    }

    @Override
    public TMoc complement() throws Exception {
        return (TMoc)super.complement();
    }

    @Override
    protected void readSpecificData(InputStream in, int naxis1, int naxis2, int nbyte, Moc.HeaderFits header) throws Exception {
        String type;
        boolean protoTMoc = false;
        int mocOrder = -1;
        try {
            mocOrder = header.getIntFromHeader("MOCORD_T");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mocOrder == -1) {
            try {
                mocOrder = header.getIntFromHeader("MOCORDER") * 2 + 3;
                protoTMoc = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((type = header.getStringFromHeader("ORDERING")) != null && type.equals("RANGE")) {
            this.readSpecificDataRange(in, naxis1, naxis2, nbyte);
        } else {
            byte[] buf = new byte[naxis1 * naxis2];
            TMoc.readFully(in, buf);
            this.createMocByUniqUnsorted(naxis1 * naxis2 / nbyte, nbyte, buf, protoTMoc);
        }
        if (mocOrder == -1) {
            throw new Exception("Missing MOC order in FITS header (MOCORD_T)");
        }
        this.setMocOrder(mocOrder);
    }

    @Override
    protected int writeSpecificFitsProp(OutputStream out) throws Exception {
        int n = 0;
        out.write(TMoc.getFitsLine("MOCDIM", "TIME", "Physical dimension"));
        n += 80;
        out.write(TMoc.getFitsLine("ORDERING", "RANGE", "Coding method"));
        n += 80;
        out.write(TMoc.getFitsLine("MOCORD_T", "" + this.getMocOrder(), "Time MOC resolution (best order)"));
        n += 80;
        out.write(TMoc.getFitsLine("TIMESYS", this.getTimeSys(), "Time ref system"));
        return n += 80;
    }
}

