/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.FMoc;
import cds.moc.HealpixImpl;
import cds.moc.Moc;
import cds.moc.Moc2D;
import cds.moc.Range;
import cds.moc.SMoc;
import java.io.InputStream;
import java.io.OutputStream;

public class SFMoc
extends Moc2D {
    private boolean PROTOSFMOC = false;
    public static long MASK_F = -4611686018427387904L;
    public static long UNMASK_F = MASK_F ^ 0xFFFFFFFFFFFFFFFFL;

    public SFMoc() {
        super(new FMoc(), new SMoc());
    }

    public SFMoc(int freqOrder, int spaceOrder) throws Exception {
        this();
        this.setMocOrder(freqOrder, spaceOrder);
    }

    public SFMoc(String s) throws Exception {
        this();
        this.add(s);
    }

    public SFMoc(InputStream in) throws Exception {
        this();
        this.read(in);
    }

    public SFMoc(FMoc fmoc, SMoc smoc) throws Exception {
        this();
        this.init(fmoc, smoc);
    }

    public SFMoc(SMoc moc, int freqOrder) throws Exception {
        this(freqOrder, moc.getMocOrder());
        this.initDim2(moc);
    }

    private SFMoc(FMoc moc, int spaceOrder) throws Exception {
        this(moc.getMocOrder(), spaceOrder);
        this.initDim1(moc);
    }

    protected static SFMoc asSFMoc(Moc moc) throws Exception {
        moc.flush();
        if (moc instanceof SFMoc) {
            return (SFMoc)moc;
        }
        if (moc instanceof FMoc) {
            return new SFMoc((FMoc)moc, moc.getSpaceOrder());
        }
        if (moc instanceof SMoc) {
            return new SFMoc((SMoc)moc, moc.getFreqOrder());
        }
        throw new Exception("No frequency or space dimension");
    }

    @Override
    public SFMoc clone() throws CloneNotSupportedException {
        SFMoc moc = this.dup();
        this.clone1(moc);
        return moc;
    }

    @Override
    protected void clone1(Moc moc) throws CloneNotSupportedException {
        if (!(moc instanceof SFMoc)) {
            throw new CloneNotSupportedException("Uncompatible type of MOC for clone. Must be SFMoc");
        }
        super.clone1(moc);
    }

    @Override
    public SFMoc dup() {
        SFMoc moc = new SFMoc();
        moc.protoDim1.sys = this.protoDim1.sys;
        moc.protoDim2.sys = this.protoDim2.sys;
        return moc;
    }

    public void add(HealpixImpl healpix, double alpha, double delta, double freqMin, double freqMax) throws Exception {
        long smin = healpix.ang2pix(29, alpha, delta);
        long fmin = Double.isNaN(freqMin) ? 0L : FMoc.getNpix(freqMin);
        long fmax = Double.isNaN(freqMax) ? FMoc.NBVAL_F : FMoc.getNpix(freqMax);
        this.add(fmin, fmax, smin, smin);
    }

    public void add(int order, long npix, double freqMin, double freqMax) throws Exception {
        long smin = this.getStart2(order, npix);
        long smax = this.getEnd2(order, npix) - 1L;
        long fmin = Double.isNaN(freqMin) ? 0L : FMoc.getNpix(freqMin);
        long fmax = Double.isNaN(freqMax) ? FMoc.NBVAL_F : FMoc.getNpix(freqMax);
        this.add(fmin, fmax, smin, smax);
    }

    public void add(long fmin, long fmax, long smin, long smax) throws Exception {
        this.add(51, fmin, fmax, 29, smin, smax);
    }

    public void add(double freqMin, double freqMax, SMoc smoc) throws Exception {
        long fmin = Double.isNaN(freqMin) ? 0L : FMoc.getNpix(freqMin);
        long fmax = Double.isNaN(freqMax) ? FMoc.NBVAL_F : FMoc.getNpix(freqMax);
        this.add(fmin, fmax, new Range(smoc.seeRangeList()));
    }

    @Override
    public void setFreqOrder(int freqOrder) throws Exception {
        this.setMocOrder1(freqOrder);
    }

    @Override
    public void setSpaceOrder(int spaceOrder) throws Exception {
        this.setMocOrder2(spaceOrder);
    }

    @Override
    public int getFreqOrder() {
        return this.getMocOrder1();
    }

    @Override
    public int getSpaceOrder() {
        return this.getMocOrder2();
    }

    @Override
    public void setSpaceSys(String coosys) {
        this.protoDim2.setSys(coosys);
    }

    @Override
    public String getSpaceSys() {
        return this.protoDim2.getSys();
    }

    public double getFreqMin() throws Exception {
        if (this.isEmpty()) {
            return -1.0;
        }
        return FMoc.getFreq(this.range.begins(0));
    }

    public double getFreqMax() throws Exception {
        if (this.isEmpty()) {
            return -1.0;
        }
        return FMoc.getFreq(this.range.ends(this.range.nranges() - 1));
    }

    public int getFreqRanges() {
        return this.getNbRanges();
    }

    @Override
    public FMoc getFreqMoc() throws Exception {
        FMoc moc = new FMoc(this.getFreqOrder());
        moc.setRangeList(new Range(this.range));
        return moc;
    }

    public FMoc getFreqMoc(SMoc spaceMoc) throws Exception {
        if (spaceMoc == null || spaceMoc.isEmpty()) {
            return this.getFreqMoc();
        }
        FMoc moc = new FMoc(this.getFreqOrder());
        Range r1 = new Range();
        for (int i = 0; i < this.range.sz; i += 2) {
            Range m = this.range.rr[i >>> 1];
            if (!spaceMoc.range.overlaps(m)) continue;
            r1.append(this.range.r[i], this.range.r[i + 1]);
        }
        moc.range = r1;
        return moc;
    }

    @Override
    public SMoc getSpaceMoc() throws Exception {
        return this.getSpaceMoc(-1L, Long.MAX_VALUE);
    }

    public SMoc getSpaceMoc(long fmin, long fmax) throws Exception {
        int pos;
        boolean isSFull;
        if (fmin > fmax) {
            throw new Exception("bad frequency range");
        }
        if (this.range.sz == 0) {
            SMoc moc = new SMoc(this.getSpaceOrder());
            moc.setSpaceSys(this.getSpaceSys());
            return moc;
        }
        boolean bl = isSFull = fmin <= this.range.r[0] && fmax >= this.range.r[this.range.sz - 1];
        if (isSFull) {
            if (this.range.sz == 2) {
                SMoc moc = new SMoc(this.getSpaceOrder());
                moc.setSpaceSys(this.getSpaceSys());
                moc.setRangeList(this.range.rr[0]);
                return moc;
            }
            if (this.cacheDim2Full != null) {
                return (SMoc)this.cacheDim2Full;
            }
        }
        if (((pos = this.range.indexOf(fmin)) & 1) == 1) {
            pos = pos < 0 ? ++pos : --pos;
        }
        SMoc moc = new SMoc(this.getSpaceOrder());
        moc.setSpaceSys(this.getSpaceSys());
        moc.bufferOn(2000000);
        for (int i = pos; i < this.range.sz && this.range.r[i] <= fmax; i += 2) {
            Range m = this.range.rr[i >>> 1];
            for (int j = 0; j < m.sz; j += 2) {
                moc.add(29, m.r[j], m.r[j + 1] - 1L);
            }
        }
        moc.bufferOff();
        if (isSFull) {
            this.cacheDim2Full = moc;
        }
        return moc;
    }

    public boolean contains(long npix, double freq) throws Exception {
        long hash = FMoc.getNpix(freq);
        int i = this.range.indexOf(hash);
        if ((i & 1) != 0) {
            return false;
        }
        return this.range.rr[i / 2].contains(npix);
    }

    @Override
    public boolean isIncluding(Moc moc) throws Exception {
        if (moc instanceof SMoc) {
            return this.getSpaceMoc().isIncluding(moc);
        }
        if (moc instanceof FMoc) {
            return this.getFreqMoc().isIncluding(moc);
        }
        if (!(moc instanceof SFMoc)) {
            throw new Exception("no frequency or space dimension");
        }
        this.flush();
        return this.range.contains(moc.seeRangeList());
    }

    @Override
    public boolean isIntersecting(Moc moc) throws Exception {
        if (moc instanceof SMoc) {
            return this.getSpaceMoc().isIntersecting(moc);
        }
        if (moc instanceof FMoc) {
            return this.getFreqMoc().isIntersecting(moc);
        }
        if (!(moc instanceof SFMoc)) {
            throw new Exception("no frequency or space dimension");
        }
        this.flush();
        return this.range.overlaps(moc.seeRangeList());
    }

    @Override
    public SFMoc union(Moc moc) throws Exception {
        return (SFMoc)super.union(SFMoc.asSFMoc(moc));
    }

    @Override
    public SFMoc subtraction(Moc moc) throws Exception {
        return (SFMoc)super.subtraction(SFMoc.asSFMoc(moc));
    }

    @Override
    public SFMoc intersection(Moc moc) throws Exception {
        return (SFMoc)super.intersection(SFMoc.asSFMoc(moc));
    }

    @Override
    public SFMoc complement() throws Exception {
        SFMoc moc = new SFMoc(this.getFreqOrder(), this.getSpaceOrder());
        moc.add("f0/0 s0/0-11");
        return moc.subtraction(this);
    }

    @Override
    protected int writeSpecificFitsProp(OutputStream out) throws Exception {
        int n = 0;
        out.write(SFMoc.getFitsLine("MOCDIM", "FREQUENCY.SPACE", "SFMOC: Frequency dimension first, "));
        n += 80;
        out.write(SFMoc.getFitsLine("ORDERING", "RANGE", "Range coding"));
        n += 80;
        out.write(SFMoc.getFitsLine("MOCORD_F", "" + this.getFreqOrder(), "Frequency MOC resolution"));
        n += 80;
        out.write(SFMoc.getFitsLine("MOCORD_S", "" + this.getSpaceOrder(), "Space MOC resolution"));
        n += 80;
        out.write(SFMoc.getFitsLine("COORDSYS", this.getSpaceSys(), "Space reference frame"));
        return n += 80;
    }

    @Override
    protected void readSpecificData(InputStream in, int naxis1, int naxis2, int nbyte, Moc.HeaderFits header) throws Exception {
        String version = header.getStringFromHeader("MOCTOOL");
        if (version.indexOf("CDSjavaAPI-7.3") >= 0) {
            this.PROTOSFMOC = true;
        }
        int freqOrder = -1;
        int spaceOrder = -1;
        String type = header.getStringFromHeader("MOCDIM");
        if (type != null) {
            freqOrder = header.getIntFromHeader("MOCORD_F");
            spaceOrder = header.getIntFromHeader("MOCORD_S");
        }
        this.setFreqOrder(freqOrder);
        this.setSpaceOrder(spaceOrder);
        byte[] buf = new byte[naxis1 * naxis2];
        SFMoc.readFully(in, buf);
        this.readSpecificDataRange(naxis1 * naxis2 / nbyte, buf, nbyte, 0);
    }

    @Override
    protected long decodeDim1(long a) {
        if (this.PROTOSFMOC) {
            return a & UNMASK_F;
        }
        return super.decodeDim1(a);
    }
}

