/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.Range;

public class Range2
extends Range {
    public Range[] rr;
    private static final int REMOVE = 0;
    private static final int UNION = 1;
    private static final int INTER = 2;
    private static final int SUBTR = 3;

    public Range2() {
        this(4);
    }

    public Range2(int cap) {
        super(cap);
        this.rr = new Range[cap];
    }

    public Range2(Range2 other) {
        super(other);
        int n = other.sz >>> 1;
        this.rr = new Range[n];
        for (int i = 0; i < n; ++i) {
            this.rr[i] = new Range(other.rr[i]);
        }
    }

    @Override
    public void resize(int newsize) {
        if (newsize == this.r.length) {
            return;
        }
        super.resize(newsize);
        Range[] nSpaceRangeArray = new Range[newsize];
        System.arraycopy(this.rr, 0, nSpaceRangeArray, 0, this.sz / 2);
        this.rr = nSpaceRangeArray;
    }

    @Override
    public void trimSize() {
        int n = this.sz / 2;
        for (int i = 0; i < n; ++i) {
            if (i > 0 && this.rr[i].equals(this.rr[i - 1])) {
                this.rr[i] = this.rr[i - 1];
                continue;
            }
            this.rr[i].trimSize();
        }
        super.trimSize();
    }

    public Range2 degrade(int shift1, int shift2) {
        if (shift1 == 0 && shift2 == 0) {
            return new Range2(this);
        }
        Range2 r1 = new Range2(this.sz);
        long mask = -1L << shift1;
        for (int i = 0; i < this.sz; i += 2) {
            long a = this.r[i] & mask;
            long b = (this.r[i + 1] - 1L >>> shift1) + 1L << shift1;
            Range r = this.rr[i >>> 1].degrade(shift2);
            r1.add(a, b, r);
        }
        r1.trimSize();
        return r1;
    }

    @Override
    public Range2 degrade(int shift) {
        return this.degrade(shift, 0);
    }

    public void append(long a, long b, Range m) {
        if (a >= b) {
            return;
        }
        if (this.sz > 0 && a <= this.r[this.sz - 1]) {
            if (a < this.r[this.sz - 2]) {
                throw new IllegalArgumentException("bad append operation");
            }
            if (b > this.r[this.sz - 1] && (this.sz < 2 || this.sz >= 2 && Range2.mocEquals(this.rr[(this.sz >>> 1) - 1], m))) {
                this.r[this.sz - 1] = b;
                return;
            }
        }
        this.ensureCapacity(this.sz + 2);
        this.rr[this.sz >>> 1] = m;
        this.r[this.sz++] = a;
        this.r[this.sz++] = b;
    }

    public void append(Range2 other) {
        for (int i = 0; i < other.sz; i += 2) {
            this.append(other.r[i], other.r[i + 1], other.rr[i >>> 1]);
        }
    }

    public void push(long min, long max, Range m) {
        if (this.sz >= 2 && this.r[this.sz - 2] == min && this.r[this.sz - 1] == max) {
            this.rr[this.sz - 2 >>> 1].add(m);
        } else {
            this.ensureCapacity(this.sz + 2);
            this.r[this.sz] = min;
            this.r[this.sz + 1] = max;
            if (m != null) {
                this.rr[this.sz >>> 1] = m;
            }
            this.sz += 2;
        }
    }

    private void push(long v, Range m) {
        this.ensureCapacity(this.sz + 1);
        this.r[this.sz] = v;
        if (m != null) {
            this.rr[this.sz >>> 1] = m;
        }
        ++this.sz;
    }

    @Override
    public void sortAndFix() {
        System.err.println("No yet implemented");
    }

    private static Range2 operation(Range2 a, Range2 b, int op) {
        boolean inb;
        boolean ina;
        int ib;
        int ia;
        Range2 res = new Range2();
        Range oldm = null;
        if (op == 2 && a.sz > 0 && b.sz > 0) {
            for (ia = a.indexOf(b.r[0]); ia > 0 && a.r[ia] == a.r[ia - 1]; --ia) {
            }
            if (ia < 0) {
                ia = 0;
            }
            for (ib = b.indexOf(a.r[0]); ib > 0 && b.r[ib] == b.r[ib - 1]; --ib) {
            }
            if (ib < 0) {
                ib = 0;
            }
            ina = (ia & 1) != 0 || ia >= a.sz;
            inb = (ib & 1) != 0 || ib >= b.sz;
        } else {
            ib = 0;
            ia = 0;
            inb = false;
            ina = false;
        }
        boolean runa = ia != a.sz;
        boolean runb = ib != b.sz;
        boolean outRun = false;
        while (runa || runb) {
            boolean adv_b;
            long va = runa ? a.r[ia] : 0L;
            long vb = runb ? b.r[ib] : 0L;
            Range ma = runa ? a.rr[ia >>> 1] : null;
            Range mb = runb ? b.rr[ib >>> 1] : null;
            boolean adv_a = runa && (!runb || va <= vb);
            boolean bl = adv_b = runb && (!runa || vb <= va);
            if (adv_a) {
                if ((ia & 1) == 1 && ia < a.sz - 1 && a.r[ia] == a.r[ia + 1]) {
                    ina = !ina;
                    ma = a.rr[++ia >>> 1];
                }
                ina = !ina;
                boolean bl2 = runa = ++ia != a.sz;
            }
            if (adv_b) {
                if ((ib & 1) == 1 && ib < b.sz - 1 && b.r[ib] == b.r[ib + 1]) {
                    inb = !inb;
                    mb = b.rr[++ib >>> 1];
                }
                inb = !inb;
                runb = ++ib != b.sz;
            }
            boolean testEqual = ia != 0 && ib != 0 || (!runa || !runb) && outRun;
            outRun = !runa || !runb;
            Range m = null;
            switch (op) {
                case 1: {
                    m = ina && !inb ? ma : (ina && inb ? ma.union(mb) : (!ina && inb ? mb : null));
                    break;
                }
                case 2: {
                    m = ina && inb ? ma.intersection(mb) : null;
                    break;
                }
                case 3: {
                    Range range = ina && !inb ? ma : (m = ina && inb ? ma.difference(mb) : null);
                }
            }
            if (!testEqual || !Range2.mocEquals(m, oldm)) {
                if ((res.sz & 1) != 0) {
                    res.push(adv_a ? va : vb, null);
                }
                if (m != null && !m.isEmpty()) {
                    res.push(adv_a ? va : vb, m);
                }
                oldm = m;
            }
            if (op != 2 || !outRun) continue;
            break;
        }
        return res;
    }

    private static boolean mocEquals(Range m1, Range m2) {
        if (m1 == m2) {
            return true;
        }
        if (m1 == null && m2 != null) {
            return m2.equals(m1);
        }
        return m1.equals(m2);
    }

    public Range2 union(Range2 other) {
        if (this.isEmpty()) {
            return new Range2(other);
        }
        if (other.isEmpty()) {
            return new Range2(this);
        }
        return Range2.operation(this, other, 1);
    }

    public Range2 intersection(Range2 other) {
        if (this.isEmpty() || other.isEmpty()) {
            return new Range2();
        }
        return Range2.operation(this, other, 2);
    }

    public Range2 difference(Range2 other) {
        if (this.isEmpty()) {
            return new Range2();
        }
        if (other.isEmpty()) {
            return new Range2(this);
        }
        return Range2.operation(this, other, 3);
    }

    @Override
    public int indexOf(long val) {
        int n = super.indexOf(val);
        if (n < this.sz - 1 && this.r[n + 1] == val) {
            ++n;
        }
        return n;
    }

    private void add1(long a, long b, Range m1) {
        int j;
        boolean runb;
        int pos;
        int op = 1;
        Range2 ajout = new Range2(10);
        Range oldm = null;
        boolean ina = false;
        boolean inb = false;
        long[] inter = new long[]{a, b};
        for (pos = this.indexOf(a); pos >= 0 && this.r[pos] == a; --pos) {
        }
        if (pos < 0) {
            pos = 0;
        }
        if (pos > 0 && (pos & 1) == 1) {
            ++pos;
        }
        int ia = pos;
        int ib = 0;
        boolean runa = ia != this.sz;
        boolean bl = runb = ib != inter.length;
        while (runa || runb) {
            long v;
            boolean adv_b;
            long va = runa ? this.r[ia] : 0L;
            long vb = runb ? inter[ib] : 0L;
            Range ma = runa ? this.rr[ia >>> 1] : null;
            Range mb = m1;
            boolean adv_a = runa && (!runb || va <= vb);
            boolean bl2 = adv_b = runb && (!runa || vb <= va);
            if (adv_a) {
                if ((ia & 1) == 1 && ia < this.sz - 1 && this.r[ia] == this.r[ia + 1]) {
                    ina = !ina;
                    ma = this.rr[++ia >>> 1];
                }
                ina = !ina;
                boolean bl3 = runa = ++ia < this.sz && (this.r[ia] <= b || this.r[ia] > b && (ia & 1) == 1);
            }
            if (adv_b) {
                inb = !inb;
                runb = ++ib != inter.length;
            }
            Range m = null;
            switch (op) {
                case 1: {
                    m = ina && !inb ? ma : (ina && inb ? ma.union(mb) : (!ina && inb ? mb : null));
                    break;
                }
                case 2: {
                    m = ina && inb ? ma.intersection(mb) : null;
                    break;
                }
                case 3: {
                    Range range = ina && !inb ? ma : (m = ina && inb ? ma.difference(mb) : null);
                }
            }
            if (Range2.mocEquals(m, oldm)) continue;
            long l = v = adv_a ? va : vb;
            if ((ajout.sz & 1) != 0) {
                ajout.push(v, null);
            }
            if (m != null && !m.isEmpty()) {
                ajout.push(v, m);
            }
            oldm = m;
        }
        int diff = ajout.sz - (ia - pos);
        if (diff > 0) {
            this.ensureCapacity(this.sz + diff);
            for (j = this.sz - 1; j >= pos; --j) {
                this.r[j + diff] = this.r[j];
                if ((j & 1) != 1) continue;
                this.rr[j + diff >>> 1] = this.rr[j >>> 1];
            }
        }
        for (j = 0; j < ajout.sz; ++j) {
            this.r[pos + j] = ajout.r[j];
            if ((j & 1) != 0) continue;
            this.rr[pos + j >>> 1] = ajout.rr[j >>> 1];
        }
        if (diff < 0) {
            for (j = pos + ajout.sz; j < this.sz + diff; ++j) {
                this.r[j] = this.r[j - diff];
                if ((j & 1) != 0) continue;
                this.rr[j >>> 1] = this.rr[j - diff >>> 1];
            }
            while (j < this.sz) {
                this.rr[j >>> 1] = null;
                j += 2;
            }
        }
        this.sz += diff;
    }

    @Override
    public boolean overlaps(Range other) {
        if (this.isEmpty() || other.isEmpty()) {
            return false;
        }
        boolean flip = this.sz > other.sz;
        Range2 a = flip ? (Range2)other : this;
        Range2 b = flip ? this : (Range2)other;
        return this.overlaps1(a, b);
    }

    private boolean overlaps1(Range2 a, Range2 b) {
        if (b.r[b.sz - 1] <= a.r[0] || b.r[0] >= a.r[a.sz - 1]) {
            return false;
        }
        for (int ib = 0; ib < b.sz; ib += 2) {
            int ia1 = a.indexOf(b.r[ib]);
            int ia2 = a.indexOf(b.r[ib + 1]);
            if ((ia1 & 1) != 0 && (ia2 & 1) != 0 && ia1 == ia2) continue;
            for (int i = ia1; i <= ia2; ++i) {
                if ((i & 1) == 1 || !a.rr[i >>> 1].overlaps(b.rr[ib >>> 1])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean contains(Range other) {
        if (this.isEmpty() || other.isEmpty()) {
            return false;
        }
        return this.contains(this, (Range2)other);
    }

    private boolean contains(Range2 a, Range2 b) {
        if (b.r[b.sz - 1] <= a.r[0] || b.r[0] >= a.r[a.sz - 1]) {
            return false;
        }
        for (int ib = 0; ib < b.sz; ib += 2) {
            int ia = a.indexOf(b.r[ib]);
            if (b.r[ib + 1] <= a.r[ia + 1] && a.rr[ia >>> 1].contains(b.rr[ib >>> 1])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Range2)) {
            return false;
        }
        Range2 other = (Range2)obj;
        if (other.sz != this.sz) {
            return false;
        }
        for (int i = 0; i < this.sz; ++i) {
            if (other.r[i] != this.r[i]) {
                return false;
            }
            int i2 = i >>> 1;
            if ((i & 1) != 0 || other.rr[i2] == null || other.rr[i2].equals(this.rr[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.sz == 0) {
            return 0;
        }
        int result = 1;
        for (int i = 0; i < this.sz; ++i) {
            long element = this.r[i];
            result = 31 * result + (int)(element ^ element >>> 32);
            if (i % 2 != 0) continue;
            result = 31 * result + this.rr[i >>> 1].hashCode();
        }
        return result;
    }

    @Override
    public void checkConsistency() {
        int i;
        if ((this.sz & 1) != 0) {
            throw new IllegalArgumentException("invalid number of entries");
        }
        for (i = 0; i < this.sz; i += 2) {
            if (this.r[i] >= this.r[i + 1]) {
                throw new IllegalArgumentException("inconsistent entry in one first dimension range [index=" + i + "]");
            }
            if (i <= 0 || this.r[i] >= this.r[i - 1]) continue;
            throw new IllegalArgumentException("inconsistent entries in first dimension range list [index=" + i + "]");
        }
        for (i = 0; i < this.sz / 2; ++i) {
            try {
                this.rr[i].checkConsistency();
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("inconsisistent second dimension range index [" + i + "] => " + e.getLocalizedMessage());
            }
        }
    }

    public boolean check() {
        Range oldm = null;
        for (int i = 0; i < this.sz - 1; i += 2) {
            if (this.r[i] >= this.r[i + 1]) {
                System.out.println("J'ai un probl\u00e8me i=" + i + " tmin=" + this.r[i] + ">=tmax=" + this.r[i + 1]);
                return false;
            }
            if (i > 1 && this.r[i] < this.r[i - 1]) {
                System.out.println("J'ai un probl\u00e8me i=" + i + " r[i]=" + this.r[i] + " < r[i-1]=" + this.r[i - 1]);
                return false;
            }
            if (this.rr[i >>> 1] == null) {
                System.out.println("J'ai un probl\u00e8me i=" + i + " smoc=null");
                return false;
            }
            if (i > 0 && this.r[i] == this.r[i - 1] && Range2.mocEquals(this.rr[i >>> 1], oldm)) {
                System.out.println("J'ai un probl\u00e8me i=" + i + " smoc[" + (i >>> 1) + "]=oldm=" + this.rr[i >>> 1]);
                return false;
            }
            oldm = this.rr[i >>> 1];
        }
        return true;
    }

    @Override
    public long getMem() {
        if (this.r == null) {
            return 0L;
        }
        long mem = super.getMem();
        int n = this.sz / 2;
        for (int i = 0; i < n; ++i) {
            if (i < n - 1 && this.rr[i] == this.rr[i + 1]) continue;
            mem += this.rr[i].getMem();
        }
        return mem;
    }

    public void add(long a, long b, Range m) {
        if (this.sz == 0 || a > this.r[this.sz - 1]) {
            this.append(a, b, m);
        } else {
            this.add1(a, b, m);
        }
    }

    @Override
    public void add(long a) {
        this.add(a, a + 1L, null);
    }

    @Override
    public void remove(long a, long b) {
        throw new IllegalArgumentException("not implemented yet");
    }

    @Override
    public void remove(long a) {
        this.remove(a, a + 1L);
    }
}

