/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.Moc;
import cds.moc.MocCell;
import cds.moc.Range;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class Moc1D
extends Moc {
    protected Range range;
    protected int mocOrder;
    protected String sys;
    protected int biggestOrder;
    private int currentOrder;
    private long[] buf = null;
    private int bufSz = 0;

    protected Moc1D() {
        this(-1);
    }

    protected Moc1D(int mocOrder) {
        this.clear();
        this.mocOrder = mocOrder;
    }

    protected Moc1D(String s) throws Exception {
        this();
        this.add(s);
    }

    protected Moc1D(InputStream in) throws Exception {
        this();
        this.read(in);
    }

    protected Moc1D(Moc1D moc) throws Exception {
        this();
        moc.clone1(this);
    }

    @Override
    public String toDebug() {
        String so = "" + this.getMocOrder();
        if (this.mocOrder == -1) {
            so = "(" + so + ")";
        }
        char c = Character.toUpperCase(this.cDim());
        return c + "" + "MOC mocOrder=" + so + " deepestOrder=" + this.getDeepestOrder() + " nbRanges=" + this.getNbRanges() + " nbCells=" + this.getNbCells() + " mem=" + Moc1D.getUnitDisk(this.getMem()) + " => " + this.lowAscii(5);
    }

    protected String lowAscii(int n) {
        int i;
        StringBuilder s = new StringBuilder();
        n *= 2;
        for (i = 0; i < this.range.sz && i < n; i += 2) {
            if (s.length() > 0) {
                s.append(' ');
            }
            if (this.range.r[i + 1] - 1L == this.range.r[i]) {
                s.append(this.range.r[i]);
                continue;
            }
            s.append(this.range.r[i] + "-" + (this.range.r[i + 1] - 1L));
        }
        if (i != this.range.sz) {
            s.append("...");
        }
        return s.toString();
    }

    @Override
    public void clear() {
        super.clear();
        this.range = new Range();
        this.bufSz = 0;
        this.currentOrder = -1;
        this.biggestOrder = -1;
        this.sys = null;
    }

    @Override
    protected void clone1(Moc moc) throws CloneNotSupportedException {
        super.clone1(moc);
        Moc1D m = (Moc1D)moc;
        m.range = this.range == null ? null : new Range(this.range);
        m.mocOrder = this.mocOrder;
        m.currentOrder = this.currentOrder;
        m.sys = this.sys;
    }

    @Override
    public boolean reduction(long maxSize) throws Exception {
        boolean rep = false;
        if (maxSize <= 0L) {
            throw new Exception("negative or null size not allowed");
        }
        while (this.getMem() > maxSize && this.getMocOrder() > 0) {
            this.setMocOrder(this.getMocOrder() - 1);
            rep = true;
        }
        return rep;
    }

    public abstract int maxOrder();

    public abstract int shiftOrder();

    public abstract char cDim();

    public abstract long maxVal();

    public abstract String sys();

    @Override
    protected void computeHierarchy() {
        int deep = -1;
        int size = 0;
        if (this.range != null) {
            Iterator<MocCell> it = this.cellIterator(true);
            while (it.hasNext()) {
                MocCell cell = it.next();
                size = (int)((long)size + (cell.end - cell.start));
                if (cell.order <= deep) continue;
                deep = cell.order;
            }
        }
        this.cacheDeepestOrder = deep;
        this.cacheNbCells = size;
    }

    @Override
    public long getNbValues() {
        this.flush();
        int shift = (this.maxOrder() - this.getMocOrder()) * this.shiftOrder();
        return this.range.nval() >>> shift;
    }

    @Override
    public void setRangeList(Range range) {
        this.range = range;
        this.resetCache();
    }

    @Override
    public boolean isEmpty() {
        this.flush();
        return this.range.sz == 0;
    }

    @Override
    public boolean isFull() {
        this.flush();
        return this.range.sz == 2 && this.range.r[0] == 0L && this.range.r[1] == this.maxVal();
    }

    @Override
    public double getCoverage() {
        this.flush();
        return (double)this.range.nval() / (double)this.maxVal();
    }

    @Override
    public int getNbRanges() {
        this.flush();
        return this.range.sz / 2;
    }

    @Override
    public long getMem() {
        this.flush();
        return this.range.getMem() + (this.buf == null ? 0L : (long)this.buf.length * 8L);
    }

    @Override
    public boolean isCompatible(Moc moc) {
        if (!this.getClass().equals(moc.getClass())) {
            return false;
        }
        String a = this.getSys();
        String b = ((Moc1D)moc).getSys();
        return a == null && b == null || a.equals(b);
    }

    @Override
    protected Moc1D operation(Moc moc, int op) throws Exception {
        if (!this.isCompatible(moc)) {
            throw new Exception("Uncompatible MOC");
        }
        Moc1D m = (Moc1D)moc;
        m.flush();
        Moc1D res = (Moc1D)this.dup();
        this.flush();
        switch (op) {
            case 0: {
                res.range = this.range.union(m.range);
                break;
            }
            case 1: {
                res.range = this.range.intersection(m.range);
                break;
            }
            case 2: {
                res.range = this.range.difference(m.range);
            }
        }
        res.setMinOrder(Math.min(this.getMinOrder(), m.getMinOrder()));
        int newOrder = this.getMocOrder4op(this.getMocOrder(), m.getMocOrder());
        boolean force = newOrder < Math.min(this.getMocOrder(), m.getMocOrder());
        res.setMocOrder(newOrder, force);
        res.range.trimIfTooLarge();
        return res;
    }

    @Override
    public Moc1D complement() throws Exception {
        Moc1D res = (Moc1D)this.dup();
        this.flush();
        res.range = this.range.complement(0L, this.maxVal());
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Moc1D)) {
            return false;
        }
        Moc1D moc = (Moc1D)o;
        if (this.cDim() != moc.cDim()) {
            return false;
        }
        this.flush();
        moc.flush();
        return this.range.equals(moc.range);
    }

    public int hashCode() {
        if (this.cacheHashCode == -1) {
            this.flush();
            this.cacheHashCode = this.range.hashCode();
        }
        return this.cacheHashCode;
    }

    public boolean isIncluding(int order, long val) {
        long start = this.getStart(order, val);
        long end = this.getEnd(order, val);
        this.flush();
        return this.range.contains(start, end);
    }

    public boolean isIntersecting(int order, long val) {
        long start = this.getStart(order, val);
        long end = this.getEnd(order, val);
        this.flush();
        return this.range.overlaps(start, end);
    }

    public void setMocOrder(int mocOrder) throws Exception {
        this.setMocOrder(mocOrder, false);
    }

    private void setMocOrder(int mocOrder, boolean force) throws Exception {
        if (mocOrder < -1 || mocOrder > this.maxOrder()) {
            throw new Exception("MocOrder error (" + mocOrder + " not in [0.." + this.maxOrder() + "])");
        }
        if (mocOrder != -1) {
            if (this.mocOrder == -1) {
                this.mocOrder = this.maxOrder();
            }
            if (force || mocOrder < this.mocOrder) {
                int diff = this.maxOrder() - mocOrder;
                this.flush();
                this.range = this.range.degrade(diff * this.shiftOrder());
                this.resetCache();
            }
        }
        this.mocOrder = mocOrder;
    }

    public int getMocOrder() {
        if (this.mocOrder == -1) {
            if (this.biggestOrder != -1) {
                return this.biggestOrder;
            }
            int o = this.getDeepestOrder();
            return o < 0 ? 0 : o;
        }
        return this.mocOrder;
    }

    public void setSys(String sys) {
        if (this.sys().equals(sys)) {
            sys = null;
        }
        this.sys = sys;
    }

    public String getSys() {
        return this.sys != null ? this.sys : this.sys();
    }

    public void setMinOrder(int minOrder) throws Exception {
    }

    public int getMinOrder() {
        return 0;
    }

    public void add(int order, long val) throws Exception {
        this.add(order, val, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int order, long firstVal, long lastVal) throws Exception {
        int shift;
        if (this.mocOrder != -1 && this.mocOrder < order) {
            shift = (order - this.mocOrder) * this.shiftOrder();
            firstVal = firstVal >>> shift << shift;
            lastVal = ((lastVal >>> shift) + 1L << shift) - 1L;
        }
        if (order > this.biggestOrder) {
            this.biggestOrder = order;
        }
        shift = (this.maxOrder() - order) * this.shiftOrder();
        long start = firstVal << shift;
        long end = lastVal + 1L << shift;
        if (this.buf != null) {
            if (this.bufSz > 2 && this.buf[this.bufSz - 2] == start && this.buf[this.bufSz - 1] == end) {
                return;
            }
            Moc1D moc1D = this;
            synchronized (moc1D) {
                this.buf[this.bufSz++] = start;
                this.buf[this.bufSz++] = end;
            }
            if (this.bufSz == this.buf.length) {
                this.flush();
            }
        } else {
            this.range.add(start, end);
        }
        this.resetCache();
    }

    public long getStart(int order, long val) {
        return val << (this.maxOrder() - order) * this.shiftOrder();
    }

    public long getEnd(int order, long val) {
        return this.getStart(order, val + 1L);
    }

    public void bufferOn() {
        this.bufferOn(20000);
    }

    public void bufferOn(int size) {
        this.flush();
        if (size % 1 == 1) {
            ++size;
        }
        this.buf = new long[size];
        this.bufSz = 0;
    }

    public void bufferOff() {
        if (this.buf != null) {
            this.flush();
            this.range.trimSize();
        }
        this.buf = null;
        this.bufSz = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        if (this.bufSz == 0) {
            return;
        }
        Moc1D moc1D = this;
        synchronized (moc1D) {
            this.add(this.buf, this.bufSz);
            this.bufSz = 0;
        }
    }

    @Override
    public int bufferSize() {
        return this.bufSz;
    }

    public void add(long[] valList, int size) {
        if (size <= 0) {
            return;
        }
        Range r = new Range(valList, size);
        r.sortAndFix();
        this.range = this.range.union(r);
        this.resetCache();
    }

    public void add(int order, long[] singletons, int size) {
        Arrays.sort(singletons, 0, size);
        int shift = (this.maxOrder() - order) * this.shiftOrder();
        Range r = new Range(size);
        for (int i = 0; i < size; ++i) {
            int j;
            for (j = i; j < size - 1 && singletons[j + 1] - singletons[j] <= 1L; ++j) {
            }
            long start = singletons[i] << shift;
            long end = singletons[j] + 1L << shift;
            r.append(start, end);
        }
        this.range = this.range.union(r);
        this.resetCache();
    }

    public void add(Moc moc) throws Exception {
        this.flush();
        this.range = this.range.union(moc.seeRangeList());
        this.resetCache();
    }

    @Override
    public Range seeRangeList() {
        this.flush();
        return this.range;
    }

    @Override
    public Iterator<MocCell> cellIterator(boolean flagRange) {
        return new CellIterator(flagRange);
    }

    public Iterator<Long> valIterator() {
        long gap = 1L << (this.maxOrder() - this.getMocOrder()) * this.shiftOrder();
        return new ValIterator(gap);
    }

    protected long getNpixWithLimit(double v) {
        return -1L;
    }

    public Iterator<long[]> rangeIterator(double start, double stop) {
        if (start > stop) {
            double x = start;
            start = stop;
            stop = x;
        }
        return new RangeIterator(this.getNpixWithLimit(start), this.getNpixWithLimit(stop));
    }

    @Override
    protected void addToken(String token) throws Exception {
        int j;
        if (token == null) {
            return;
        }
        int i = token.indexOf(47);
        if (i > 0) {
            String s1 = token.substring(0, i);
            if (!Character.isDigit(s1.charAt(0))) {
                if (s1.charAt(0) != this.cDim()) {
                    throw new Exception("MOC syntax error. Unknown prefix order. Must be " + this.cDim() + "[" + s1.charAt(0) + "]");
                }
                s1 = s1.substring(1);
            }
            try {
                this.currentOrder = Integer.parseInt(s1);
            }
            catch (NumberFormatException e) {
                throw new Exception("MOC syntax error. Order must be an integer value");
            }
        }
        if ((j = token.indexOf(45, i + 1)) < 0) {
            long val;
            String s1 = token.substring(i + 1);
            if (s1.trim().length() == 0) {
                if (this.biggestOrder < this.currentOrder) {
                    this.biggestOrder = this.currentOrder;
                }
                return;
            }
            try {
                val = Long.parseLong(s1);
            }
            catch (NumberFormatException e) {
                throw new Exception("MOC syntax error. Value must be an integer long value [" + s1 + "]");
            }
            this.add(this.currentOrder, val);
        } else {
            long endVal;
            long starVal;
            try {
                starVal = Long.parseLong(token.substring(i + 1, j));
                endVal = Long.parseLong(token.substring(j + 1));
            }
            catch (NumberFormatException e) {
                throw new Exception("MOC syntax error. Range must be two integer long values separated by a dash [" + token.substring(i + 1) + "]");
            }
            if (starVal >= endVal) {
                throw new Exception("MOC syntax error. Range must be expressed by 2 increasing ordered long integers [" + token + "]");
            }
            this.add(this.currentOrder, starVal, endVal);
        }
    }

    protected void readSpecificDataUniq(InputStream in, int naxis1, int naxis2, int nbyte) throws Exception {
        byte[] buf = new byte[naxis1 * naxis2];
        Moc1D.readFully(in, buf);
        try {
            this.createMocByUniq(naxis1 * naxis2 / nbyte, nbyte, buf);
        }
        catch (Exception e) {
            if ("bad append operation".equals(e.getMessage())) {
                this.createMocByUniqUnsorted(naxis1 * naxis2 / nbyte, nbyte, buf, false);
            }
            throw e;
        }
    }

    protected void createMocByUniqUnsorted(int nval, int nbyte, byte[] t, boolean protoTMoc) throws Exception {
        this.bufferOn();
        int i = 0;
        long[] hpix = null;
        for (int k = 0; k < nval; ++k) {
            long val;
            int a = t[i++] << 24 | (t[i++] & 0xFF) << 16 | (t[i++] & 0xFF) << 8 | t[i++] & 0xFF;
            if (nbyte == 4) {
                val = a;
            } else {
                int b = t[i++] << 24 | (t[i++] & 0xFF) << 16 | (t[i++] & 0xFF) << 8 | t[i++] & 0xFF;
                val = (long)a << 32 | (long)b & 0xFFFFFFFFL;
            }
            hpix = Moc1D.uniq2hpix(val, hpix);
            int order = (int)hpix[0];
            if (protoTMoc) {
                order = order * 2 + 3;
            }
            this.add(order, hpix[1]);
        }
        this.bufferOff();
    }

    protected void createMocByUniq(int nval, int nbyte, byte[] t) throws Exception {
        long[] buf = new long[nval];
        Signet[] signet = new Signet[this.maxOrder() + 1];
        int order = -1;
        int pos = 0;
        int maxOrder = this.maxOrder();
        int shiftOrder = this.shiftOrder();
        int minOrd = maxOrder + 1;
        int maxOrd = -1;
        this.range = new Range(nval);
        int i = 0;
        long[] hpix = null;
        for (int k = 0; k < nval; ++k) {
            long val;
            int a = t[i++] << 24 | (t[i++] & 0xFF) << 16 | (t[i++] & 0xFF) << 8 | t[i++] & 0xFF;
            if (nbyte == 4) {
                val = a;
            } else {
                int b = t[i++] << 24 | (t[i++] & 0xFF) << 16 | (t[i++] & 0xFF) << 8 | t[i++] & 0xFF;
                val = (long)a << 32 | (long)b & 0xFFFFFFFFL;
            }
            hpix = Moc1D.uniq2hpix(val, hpix);
            int shift = (maxOrder - (int)hpix[0]) * shiftOrder;
            buf[k] = hpix[1] << shift;
            if (hpix[0] == (long)order) continue;
            if (order != -1) {
                signet[order] = new Signet(pos, k);
            }
            if ((order = (int)hpix[0]) > maxOrd) {
                maxOrd = order;
            }
            if (order < minOrd) {
                minOrd = order;
            }
            pos = k;
        }
        if (signet[order] == null) {
            signet[order] = new Signet(pos, nval);
        }
        int head = minOrd;
        for (int k = 0; k < nval; ++k) {
            long min = Long.MAX_VALUE;
            for (order = minOrd; order <= maxOrd; ++order) {
                Signet s = signet[order];
                if (s == null) continue;
                if (s.pos == s.max) {
                    if (order == maxOrd) {
                        --maxOrd;
                        continue;
                    }
                    if (order != minOrd) continue;
                    ++minOrd;
                    continue;
                }
                if (buf[s.pos] >= min) continue;
                min = buf[s.pos];
                head = order;
            }
            int shift = (maxOrder - head) * shiftOrder;
            this.range.append(min, (min >>> shift) + 1L << shift);
            ++signet[head].pos;
        }
        this.range.trimSize();
    }

    protected void readSpecificDataRange(InputStream in, int naxis1, int naxis2, int nbyte) throws Exception {
        byte[] buf = new byte[naxis1 * naxis2];
        Moc1D.readFully(in, buf);
        this.readSpecificDataRange(naxis1 * naxis2 / nbyte, buf, nbyte, 0);
    }

    @Override
    public void readSpecificDataRange(int nval, byte[] t, int nbyte, int mode) throws Exception {
        int k;
        int i = 0;
        long[] r = new long[nval];
        if (nbyte == 4) {
            k = 0;
            while (k < nval) {
                r[k] = (0xFFFFFFFFL & (long)Moc1D.readInt(t, i)) << 32;
                ++k;
                i += 4;
            }
        } else {
            k = 0;
            while (k < nval) {
                r[k] = Moc1D.readLong(t, i);
                ++k;
                i += 8;
            }
        }
        if (mode == 1) {
            long unit = 1L << (this.maxOrder() - this.getMocOrder()) * this.shiftOrder();
            this.range = this.uncompressRange(r, unit);
        } else {
            this.range = new Range(r);
        }
        this.resetCache();
    }

    @Override
    public int writeSpecificDataRange(OutputStream out, int mode) throws Exception {
        this.flush();
        long[] r = this.range.r;
        int sz = this.range.sz;
        if (mode == 1) {
            long unit = 1L << (this.maxOrder() - this.getMocOrder()) * this.shiftOrder();
            r = this.compressRange(this.range, unit);
            sz = r.length;
        }
        byte[] buf = new byte[8];
        int size = 0;
        for (int i = 0; i < sz; ++i) {
            size += Moc1D.writeVal(out, r[i], buf);
        }
        return size;
    }

    @Override
    public void writeASCII(OutputStream out) throws Exception {
        this.flush();
        boolean flagNL = this.getNbCells() > 20;
        int order = Moc1D.writeASCII(out, this, flagNL, true);
        StringBuilder res = new StringBuilder(10);
        int mocOrder = this.getMocOrder();
        if (order < mocOrder) {
            if (flagNL) {
                res.append(CR);
            } else {
                res.append(' ');
            }
            res.append(mocOrder + "/");
        }
        if (flagNL) {
            res.append(CR);
        }
        Moc1D.writeASCIIFlush(out, res, false);
    }

    @Override
    public void writeJSON(OutputStream out) throws Exception {
        this.flush();
        boolean flagNL = this.getNbCells() > 20;
        flagNL = true;
        this.writeJSON(out, flagNL);
    }

    protected int writeJSON(OutputStream out, boolean flagNL) throws Exception {
        int mocOrder;
        StringBuilder s = new StringBuilder(2048);
        int order = -1;
        boolean first = true;
        int j = 0;
        s.append("{");
        s.append(flagNL ? CR : " ");
        Iterator<MocCell> it = this.cellIterator(false);
        while (it.hasNext()) {
            boolean flagNewOrder;
            MocCell cell = it.next();
            boolean bl = flagNewOrder = cell.order != order;
            if (flagNewOrder) {
                if (!first) {
                    s.append("]," + (flagNL ? CR : ""));
                }
                first = false;
                s.append((flagNL ? "  " : "") + "\"" + cell.order + "\":[");
                order = cell.order;
                j = 0;
            }
            s.append((flagNewOrder ? "" : ",") + cell.start);
            if (++j != 15) continue;
            Moc1D.writeASCIIFlush(out, s, flagNL);
            j = 0;
        }
        if (!first) {
            s.append("]");
        }
        if (order < (mocOrder = this.getMocOrder())) {
            if (!first) {
                s.append(',' + (flagNL ? CR : ""));
            }
            s.append((flagNL ? "  " : "") + "\"" + mocOrder + "\":[]");
        }
        s.append("}");
        Moc1D.writeASCIIFlush(out, s, flagNL);
        return order;
    }

    private class CellIterator
    implements Iterator<MocCell> {
        Range r2;
        Range r3;
        long a;
        long b;
        int o;
        int i;
        int shift;
        long ofs;
        boolean flagEnd;
        boolean took;
        boolean flagRange;
        char cdim;

        CellIterator(boolean flagRange) {
            Moc1D.this.flush();
            this.flagRange = flagRange;
            this.r2 = new Range(Moc1D.this.seeRangeList());
            this.r3 = new Range();
            this.o = Moc1D.this.getMinOrder();
            this.i = -2;
            this.shift = Moc1D.this.shiftOrder() * (Moc1D.this.maxOrder() - this.o);
            this.ofs = (1L << this.shift) - 1L;
            this.flagEnd = false;
            this.took = true;
            this.cdim = Moc1D.this.cDim();
        }

        @Override
        public boolean hasNext() {
            this.goNext();
            return !this.flagEnd;
        }

        @Override
        public MocCell next() {
            if (!this.hasNext()) {
                return null;
            }
            this.took = true;
            MocCell cell = new MocCell();
            cell.dim = this.cdim;
            cell.order = this.o;
            cell.start = this.a;
            this.a = cell.end = this.flagRange ? this.b : this.a + 1L;
            return cell;
        }

        @Override
        public void remove() {
        }

        private void goNext() {
            if (this.flagEnd || !this.took) {
                return;
            }
            if (this.i >= 0 && this.a < this.b) {
                return;
            }
            while (true) {
                this.i += 2;
                while (this.i < this.r2.sz) {
                    this.a = this.r2.r[this.i] + this.ofs >>> this.shift;
                    this.b = this.r2.r[this.i + 1] >>> this.shift;
                    if (this.a < this.b) {
                        this.r3.append(this.a << this.shift, this.b << this.shift);
                        this.took = false;
                        return;
                    }
                    this.i += 2;
                }
                if (!this.r3.isEmpty()) {
                    this.r2 = this.r2.difference(this.r3);
                }
                if (this.o == Moc1D.this.maxOrder() || this.r2.isEmpty()) break;
                ++this.o;
                this.shift = Moc1D.this.shiftOrder() * (Moc1D.this.maxOrder() - this.o);
                this.ofs = (1L << this.shift) - 1L;
                this.r3.clear();
                this.i = -2;
            }
            this.flagEnd = true;
        }
    }

    class ValIterator
    implements Iterator<Long> {
        int pos;
        long value;
        long gap;

        ValIterator(long gap) {
            Moc1D.this.flush();
            this.gap = gap;
            this.pos = 0;
            this.value = Moc1D.this.range.sz > 0 ? Moc1D.this.range.r[0] : 0L;
        }

        @Override
        public boolean hasNext() {
            return this.pos < Moc1D.this.range.sz;
        }

        @Override
        public Long next() {
            if (this.pos > Moc1D.this.range.sz) {
                throw new NoSuchElementException();
            }
            long ret = this.value;
            this.value += this.gap;
            if (this.value >= Moc1D.this.range.r[this.pos + 1]) {
                this.pos += 2;
                if (this.pos < Moc1D.this.range.sz) {
                    this.value = Moc1D.this.range.r[this.pos];
                }
            }
            return ret / this.gap;
        }
    }

    class RangeIterator
    implements Iterator<long[]> {
        int pos;
        int endpos;

        RangeIterator(long start, long end) {
            this.pos = Moc1D.this.range.indexOf(start) / 2;
            if (this.pos < 0) {
                this.pos = 0;
            }
            this.endpos = Moc1D.this.range.indexOf(end) / 2 + 1;
        }

        @Override
        public boolean hasNext() {
            return Moc1D.this.range.sz > 0 && this.pos < this.endpos;
        }

        @Override
        public long[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long[] ret = new long[]{Moc1D.this.range.begins(this.pos), Moc1D.this.range.ends(this.pos)};
            ++this.pos;
            return ret;
        }

        @Override
        public void remove() {
        }
    }

    class Signet {
        int pos;
        int max;

        Signet(int pos, int max) {
            this.pos = pos;
            this.max = max;
        }
    }
}

