/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.FMoc;
import cds.moc.Moc;
import cds.moc.Moc2D;
import cds.moc.Range;
import cds.moc.TMoc;
import java.io.InputStream;
import java.io.OutputStream;

public class FTMoc
extends Moc2D {
    public FTMoc() {
        super(new TMoc(), new FMoc());
    }

    public FTMoc(int timeOrder, int freqOrder) throws Exception {
        this();
        this.setMocOrder(timeOrder, freqOrder);
    }

    public FTMoc(String s) throws Exception {
        this();
        this.add(s);
    }

    public FTMoc(InputStream in) throws Exception {
        this();
        this.read(in);
    }

    public FTMoc(TMoc tmoc, FMoc fmoc) throws Exception {
        this();
        this.init(tmoc, fmoc);
    }

    private FTMoc(FMoc moc, int timeOrder) throws Exception {
        this(timeOrder, moc.getMocOrder());
        this.initDim2(moc);
    }

    private FTMoc(TMoc moc, int freqOrder) throws Exception {
        this(moc.getMocOrder(), freqOrder);
        this.initDim1(moc);
    }

    protected static FTMoc asFTMoc(Moc moc) throws Exception {
        moc.flush();
        if (moc instanceof FTMoc) {
            return (FTMoc)moc;
        }
        if (moc instanceof FMoc) {
            return new FTMoc((FMoc)moc, moc.getTimeOrder());
        }
        if (moc instanceof TMoc) {
            return new FTMoc((TMoc)moc, moc.getFreqOrder());
        }
        throw new Exception("No frequency or time dimension");
    }

    @Override
    public FTMoc clone() throws CloneNotSupportedException {
        FTMoc moc = this.dup();
        this.clone1(moc);
        return moc;
    }

    @Override
    protected void clone1(Moc moc) throws CloneNotSupportedException {
        if (!(moc instanceof FTMoc)) {
            throw new CloneNotSupportedException("Uncompatible type of MOC for clone. Must be FTMoc");
        }
        super.clone1(moc);
    }

    @Override
    public FTMoc dup() {
        FTMoc moc = new FTMoc();
        moc.protoDim1.sys = this.protoDim1.sys;
        moc.protoDim2.sys = this.protoDim2.sys;
        return moc;
    }

    public void add(double jdmin, double jdmax, double freqMin, double freqMax) throws Exception {
        long tmin = Double.isNaN(jdmin) ? 0L : TMoc.getNpix(jdmin);
        long tmax = Double.isNaN(jdmax) ? TMoc.NBVAL_T : TMoc.getNpix(jdmax);
        long fmin = Double.isNaN(freqMin) ? 0L : FMoc.getNpix(freqMin);
        long fmax = Double.isNaN(freqMax) ? FMoc.NBVAL_F : FMoc.getNpix(freqMax);
        this.add(tmin, tmax, fmin, fmax);
    }

    public void add(long tmin, long tmax, long fmin, long fmax) throws Exception {
        this.add(61, tmin, tmax, 51, fmin, fmax);
    }

    public void add(double jdmin, double jdmax, FMoc fmoc) throws Exception {
        long tmin = Double.isNaN(jdmin) ? 0L : TMoc.getNpix(jdmin);
        long tmax = Double.isNaN(jdmax) ? TMoc.NBVAL_T : TMoc.getNpix(jdmax);
        this.add(tmin, tmax, new Range(fmoc.seeRangeList()));
    }

    @Override
    public void setTimeOrder(int timeOrder) throws Exception {
        this.setMocOrder1(timeOrder);
    }

    @Override
    public void setFreqOrder(int freqOrder) throws Exception {
        this.setMocOrder1(freqOrder);
    }

    @Override
    public int getTimeOrder() {
        return this.getMocOrder1();
    }

    @Override
    public int getFreqOrder() {
        return this.getMocOrder2();
    }

    @Override
    public void setTimeSys(String timesys) {
        this.protoDim1.setSys(timesys);
    }

    @Override
    public String getTimeSys() {
        return this.protoDim1.getSys();
    }

    public double getTimeMin() {
        if (this.isEmpty()) {
            return -1.0;
        }
        return TMoc.getTime(this.range.begins(0));
    }

    public double getTimeMax() {
        if (this.isEmpty()) {
            return -1.0;
        }
        return TMoc.getTime(this.range.ends(this.range.nranges() - 1));
    }

    public int getTimeRanges() {
        return this.getNbRanges();
    }

    @Override
    public TMoc getTimeMoc() throws Exception {
        TMoc moc = new TMoc(this.getTimeOrder());
        moc.setRangeList(new Range(this.range));
        return moc;
    }

    public TMoc getTimeMoc(FMoc freqMoc) throws Exception {
        if (freqMoc == null || freqMoc.isEmpty()) {
            return this.getTimeMoc();
        }
        TMoc moc = new TMoc(this.getTimeOrder());
        Range r1 = new Range();
        for (int i = 0; i < this.range.sz; i += 2) {
            Range m = this.range.rr[i >>> 1];
            if (!freqMoc.range.overlaps(m)) continue;
            r1.append(this.range.r[i], this.range.r[i + 1]);
        }
        moc.range = r1;
        return moc;
    }

    @Override
    public FMoc getFreqMoc() throws Exception {
        return this.getFreqMoc(-1L, Long.MAX_VALUE);
    }

    public FMoc getFreqMoc(long tmin, long tmax) throws Exception {
        int pos;
        boolean isSFull;
        if (tmin > tmax) {
            throw new Exception("bad time range");
        }
        if (this.range.sz == 0) {
            FMoc moc = new FMoc(this.getFreqOrder());
            return moc;
        }
        boolean bl = isSFull = tmin <= this.range.r[0] && tmax >= this.range.r[this.range.sz - 1];
        if (isSFull) {
            if (this.range.sz == 2) {
                FMoc moc = new FMoc(this.getFreqOrder());
                moc.setRangeList(this.range.rr[0]);
                return moc;
            }
            if (this.cacheDim2Full != null) {
                return (FMoc)this.cacheDim2Full;
            }
        }
        if (((pos = this.range.indexOf(tmin)) & 1) == 1) {
            pos = pos < 0 ? ++pos : --pos;
        }
        FMoc moc = new FMoc(this.getFreqOrder());
        moc.bufferOn(2000000);
        for (int i = pos; i < this.range.sz && this.range.r[i] <= tmax; i += 2) {
            Range m = this.range.rr[i >>> 1];
            for (int j = 0; j < m.sz; j += 2) {
                moc.add(51, m.r[j], m.r[j + 1] - 1L);
            }
        }
        moc.bufferOff();
        if (isSFull) {
            this.cacheDim2Full = moc;
        }
        return moc;
    }

    public boolean contains(double jd, double freq) throws Exception {
        long t = TMoc.getNpix(jd);
        int i = this.range.indexOf(t);
        if ((i & 1) != 0) {
            return false;
        }
        long f = FMoc.getNpix(freq);
        return this.range.rr[i / 2].contains(f);
    }

    @Override
    public boolean isIncluding(Moc moc) throws Exception {
        if (moc instanceof FMoc) {
            return this.getFreqMoc().isIncluding(moc);
        }
        if (moc instanceof TMoc) {
            return this.getTimeMoc().isIncluding(moc);
        }
        if (!(moc instanceof FTMoc)) {
            throw new Exception("no frequency or time dimension");
        }
        this.flush();
        return this.range.contains(moc.seeRangeList());
    }

    @Override
    public boolean isIntersecting(Moc moc) throws Exception {
        if (moc instanceof FMoc) {
            return this.getFreqMoc().isIntersecting(moc);
        }
        if (moc instanceof TMoc) {
            return this.getTimeMoc().isIntersecting(moc);
        }
        if (!(moc instanceof FTMoc)) {
            throw new Exception("no frequency or time dimension");
        }
        this.flush();
        return this.range.overlaps(moc.seeRangeList());
    }

    @Override
    public FTMoc union(Moc moc) throws Exception {
        return (FTMoc)super.union(FTMoc.asFTMoc(moc));
    }

    @Override
    public FTMoc subtraction(Moc moc) throws Exception {
        return (FTMoc)super.subtraction(FTMoc.asFTMoc(moc));
    }

    @Override
    public FTMoc intersection(Moc moc) throws Exception {
        return (FTMoc)super.intersection(FTMoc.asFTMoc(moc));
    }

    @Override
    public FTMoc complement() throws Exception {
        FTMoc moc = new FTMoc(this.getTimeOrder(), this.getFreqOrder());
        moc.add("t0/0 f0/0");
        return moc.subtraction(this);
    }

    @Override
    protected int writeSpecificFitsProp(OutputStream out) throws Exception {
        int n = 0;
        out.write(FTMoc.getFitsLine("MOCDIM", "TIME.FREQUENCY", "FTMOC: Time dimension first, "));
        n += 80;
        out.write(FTMoc.getFitsLine("ORDERING", "RANGE", "Range coding"));
        n += 80;
        out.write(FTMoc.getFitsLine("MOCORD_T", "" + this.getTimeOrder(), "Time MOC resolution"));
        n += 80;
        out.write(FTMoc.getFitsLine("MOCORD_F", "" + this.getFreqOrder(), "Frequency MOC resolution"));
        n += 80;
        out.write(FTMoc.getFitsLine("TIMESYS", this.getTimeSys(), "Time ref system"));
        return n += 80;
    }

    @Override
    protected void readSpecificData(InputStream in, int naxis1, int naxis2, int nbyte, Moc.HeaderFits header) throws Exception {
        int timeOrder = -1;
        int freqOrder = -1;
        String type = header.getStringFromHeader("MOCDIM");
        if (type != null) {
            timeOrder = header.getIntFromHeader("MOCORD_T");
            freqOrder = header.getIntFromHeader("MOCORD_F");
        }
        this.setTimeOrder(timeOrder);
        this.setFreqOrder(freqOrder);
        byte[] buf = new byte[naxis1 * naxis2];
        FTMoc.readFully(in, buf);
        this.readSpecificDataRange(naxis1 * naxis2 / nbyte, buf, nbyte, 0);
    }
}

