/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.Moc;
import cds.moc.Moc1D;
import java.io.InputStream;
import java.io.OutputStream;

public class FMoc
extends Moc1D {
    public static final double FREQ_MIN = 1.0E-18;
    public static final double FREQ_MAX = 1.0E38;
    public static final int MAXORD_F = 51;
    public static final double CTE = Math.log10(9.999999999999999E55);
    public static final double POW2MAX = 4.503599627370496E15;
    public static final long LMIN = FMoc.getNpix(1.0E-18);
    public static final long LMAX;
    public static final int FACT_F = 2;
    public static final char DIM_F = 'f';
    public static final long NBVAL_F;
    public static final String SYS_F = "FREQUENCY";

    @Override
    public final int maxOrder() {
        return 51;
    }

    @Override
    public final int shiftOrder() {
        return 1;
    }

    @Override
    public final char cDim() {
        return 'f';
    }

    @Override
    public final long maxVal() {
        return NBVAL_F;
    }

    @Override
    public final String sys() {
        return SYS_F;
    }

    public FMoc() {
    }

    public FMoc(int mocOrder) {
        super(mocOrder);
    }

    public FMoc(String s) throws Exception {
        super(s);
    }

    public FMoc(FMoc moc) throws Exception {
        super(moc);
    }

    public FMoc(InputStream in) throws Exception {
        super(in);
    }

    @Override
    public FMoc clone() throws CloneNotSupportedException {
        FMoc moc = this.dup();
        this.clone1(moc);
        return moc;
    }

    @Override
    protected void clone1(Moc moc) throws CloneNotSupportedException {
        if (!(moc instanceof FMoc)) {
            throw new CloneNotSupportedException("Uncompatible type of MOC for clone. Must be TMoc");
        }
        super.clone1(moc);
    }

    @Override
    public FMoc dup() {
        FMoc moc = new FMoc();
        moc.sys = this.sys;
        return moc;
    }

    @Override
    public int sizeOfCoding() {
        return 8;
    }

    @Override
    public int getNbCoding() {
        return this.range.sz;
    }

    @Override
    public void add(Moc moc) throws Exception {
        if (!(moc instanceof FMoc)) {
            throw new Exception("Uncompatible Moc for adding");
        }
        super.add(moc);
    }

    @Override
    public String getTimeSys() {
        return SYS_F;
    }

    @Override
    protected long getNpixWithLimit(double freq) {
        if (freq < 1.0E-18) {
            return LMIN;
        }
        if (freq > 1.0E38) {
            return LMAX;
        }
        return FMoc.getNpix(freq);
    }

    public static final long getNpix(double freq) {
        if (freq < 1.0E-18 || freq > 1.0E38) {
            return -1L;
        }
        return (long)(Math.log10(freq / 1.0E-18) / CTE * 4.503599627370496E15);
    }

    public static final double getFreq(long hash) {
        if (hash < LMIN || hash > LMAX) {
            return Double.NaN;
        }
        return 1.0E-18 * Math.pow(10.0, CTE * (double)hash / 4.503599627370496E15);
    }

    public void add(double freqMin, double freqMax) throws Exception {
        this.add(51, FMoc.getNpix(freqMin), FMoc.getNpix(freqMax));
    }

    public boolean contains(double freq) {
        return this.range.contains(FMoc.getNpix(freq));
    }

    public double getFreqMin() {
        if (this.isEmpty()) {
            return -1.0;
        }
        return FMoc.getFreq(this.range.begins(0));
    }

    public double getFreqMax() {
        if (this.isEmpty()) {
            return -1.0;
        }
        return FMoc.getFreq(this.range.ends(this.range.nranges() - 1) - 1L);
    }

    public static double getFreq(int order, long val) {
        int shift = 51 - order;
        long t = val << shift;
        return FMoc.getFreq(t);
    }

    public static double getFreqCoverage(int order, double freq) {
        try {
            int shift = 51 - order;
            long h = FMoc.getNpix(freq) >>> shift;
            double fq1 = FMoc.getFreq(order, h);
            double fq2 = FMoc.getFreq(order, h + 1L);
            return Math.abs(fq2 - fq1);
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    @Override
    public boolean isIncluding(Moc moc) throws Exception {
        if (!(moc instanceof FMoc)) {
            throw new Exception("Uncompatible Moc type for FMoc isIncluding test");
        }
        this.flush();
        return this.range.contains(((FMoc)moc).range);
    }

    @Override
    public boolean isIntersecting(Moc moc) throws Exception {
        if (!(moc instanceof FMoc)) {
            throw new Exception("Uncompatible Moc type for FMoc isIntersecting test");
        }
        this.flush();
        return this.range.overlaps(((FMoc)moc).range);
    }

    @Override
    public FMoc union(Moc moc) throws Exception {
        if (!(moc instanceof FMoc)) {
            throw new Exception("Uncompatible Moc type for FMoc union");
        }
        return (FMoc)super.union(moc);
    }

    @Override
    public FMoc intersection(Moc moc) throws Exception {
        if (!(moc instanceof FMoc)) {
            throw new Exception("Uncompatible Moc type for FMoc subtraction");
        }
        return (FMoc)super.subtraction(moc);
    }

    @Override
    public FMoc subtraction(Moc moc) throws Exception {
        if (!(moc instanceof FMoc)) {
            throw new Exception("Uncompatible Moc type for FMoc subtraction");
        }
        return (FMoc)super.subtraction(moc);
    }

    @Override
    public FMoc complement() throws Exception {
        return (FMoc)super.complement();
    }

    @Override
    protected void readSpecificData(InputStream in, int naxis1, int naxis2, int nbyte, Moc.HeaderFits header) throws Exception {
        int mocOrder = -1;
        try {
            mocOrder = header.getIntFromHeader("MOCORD_F");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mocOrder == -1) {
            throw new Exception("Missing MOC order in FITS header (MOCORD_F)");
        }
        this.readSpecificDataRange(in, naxis1, naxis2, nbyte);
        this.setMocOrder(mocOrder);
    }

    @Override
    protected int writeSpecificFitsProp(OutputStream out) throws Exception {
        int n = 0;
        out.write(FMoc.getFitsLine("MOCDIM", SYS_F, "Physical dimension"));
        n += 80;
        out.write(FMoc.getFitsLine("ORDERING", "RANGE", "Coding method"));
        n += 80;
        out.write(FMoc.getFitsLine("MOCORD_F", "" + this.getMocOrder(), "Frequence MOC resolution (best order)"));
        return n += 80;
    }

    static {
        NBVAL_F = LMAX = FMoc.getNpix(1.0E38);
    }
}

