/*
 * Decompiled with CFR 0.152.
 */
package cds.image;

import cds.aladin.Aladin;
import cds.aladin.MyInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.zip.CRC32;

public class OutputStreamAPNG
extends OutputStream {
    private static final boolean DEBUG = false;
    private static final int MAGICCODE = -1;
    private static final int SIZECHUNK = 0;
    private static final int NAMECHUNK = 1;
    private static final int DATAANDCRC = 2;
    private static final int FFHEAD = 0;
    private static final int FFIDAT = 1;
    private static final int FFTAIL = 2;
    private static final int NFRAM = 3;
    static final String[] MODEWRITE = new String[]{"FFHEAD", "FFIDAT ", "FFTAIL", "NFRAM"};
    private OutputStream out;
    private int nbFrames;
    private int modeRead = -1;
    private int modeWrite = 0;
    private int sequenceNumber = 0;
    private boolean flagFctl;
    private int nb = 0;
    private int width;
    private int height;
    private int sizeMagicCode = 0;
    private byte[] magicCode = new byte[8];
    private int sizeChunkN = 0;
    private int sizeChunk = 0;
    private int nameChunkN = 0;
    private byte[] nameChunk = new byte[4];
    int bufferPos = 0;
    byte[] bufferChunk = null;

    static String mw(int i) {
        return MODEWRITE[i];
    }

    public OutputStreamAPNG(OutputStream out, int nbFrames) {
        this.out = out;
        this.nbFrames = nbFrames;
    }

    public OutputStreamAPNG() {
    }

    @Override
    public void close() throws IOException {
        if (this.nb != this.nbFrames) {
            throw new IOException("Missing frames (" + (this.nbFrames - this.nb) + "/" + this.nbFrames + ")");
        }
        this.out.close();
    }

    @Override
    public void write(int b) throws IOException {
        switch (this.modeRead) {
            case -1: {
                this.modeRead = this.magicCode(b, this.modeRead);
                break;
            }
            case 0: {
                this.modeRead = this.sizeChunk(b, this.modeRead);
                break;
            }
            case 1: {
                this.modeRead = this.nameChunk(b, this.modeRead);
                break;
            }
            case 2: {
                this.modeRead = this.bufferChunk(b, this.modeRead);
            }
        }
    }

    private int magicCode(int b, int mode) {
        this.magicCode[this.sizeMagicCode++] = (byte)(0xFF & b);
        if (this.sizeMagicCode == 8) {
            this.sizeMagicCode = 0;
            return mode + 1;
        }
        return mode;
    }

    private int sizeChunk(int b, int mode) {
        if (this.sizeChunkN == 4) {
            this.sizeChunkN = 0;
            this.sizeChunk = 0;
        }
        this.sizeChunk = this.sizeChunk << 8 | 0xFF & b;
        ++this.sizeChunkN;
        if (this.sizeChunkN == 4) {
            return mode + 1;
        }
        return mode;
    }

    private int nameChunk(int b, int mode) {
        this.nameChunk[this.nameChunkN++] = (byte)b;
        if (this.nameChunkN == 4) {
            this.bufferPos = 0;
            this.nameChunkN = 0;
            this.bufferChunk = new byte[this.sizeChunk + 4];
            return mode + 1;
        }
        return mode;
    }

    private int bufferChunk(int b, int mode) throws IOException {
        this.bufferChunk[this.bufferPos++] = (byte)(0xFF & b);
        if (this.bufferPos == this.bufferChunk.length) {
            this.processChunk();
            if (new String(this.nameChunk).equals("IEND")) {
                return -1;
            }
            return 0;
        }
        return mode;
    }

    private void processChunk() throws IOException {
        switch (this.modeWrite) {
            case 0: {
                this.outWriteBytes(this.magicCode);
                this.outWriteChunk(this.sizeChunk, this.nameChunk, this.bufferChunk);
                this.width = this.getInt(this.bufferChunk, 0);
                this.height = this.getInt(this.bufferChunk, 4);
                this.outWriteActl();
                this.modeWrite = 1;
                break;
            }
            case 1: {
                String s = new String(this.nameChunk);
                if (s.equals("IDAT")) {
                    this.outWriteFctl();
                    this.flagFctl = false;
                    this.outWriteChunk(this.sizeChunk, this.nameChunk, this.bufferChunk);
                    this.modeWrite = 2;
                    break;
                }
                this.outWriteChunk(this.sizeChunk, this.nameChunk, this.bufferChunk);
                break;
            }
            case 2: {
                String s = new String(this.nameChunk);
                if (s.equals("IEND")) {
                    this.flagFctl = true;
                    this.modeWrite = 3;
                    ++this.nb;
                    if (this.nb != this.nbFrames) break;
                    this.outWriteChunk(this.sizeChunk, this.nameChunk, this.bufferChunk);
                    break;
                }
                if (s.equals("IDAT")) {
                    this.outWriteChunk(this.sizeChunk, this.nameChunk, this.bufferChunk);
                    break;
                }
                this.outWriteChunk(this.sizeChunk, this.nameChunk, this.bufferChunk);
                break;
            }
            case 3: {
                String s = new String(this.nameChunk);
                if (s.equals("IEND")) {
                    ++this.nb;
                    if (this.nb == this.nbFrames) {
                        this.outWriteChunk(this.sizeChunk, this.nameChunk, this.bufferChunk);
                    }
                    this.flagFctl = true;
                    break;
                }
                if (!s.equals("IDAT")) break;
                if (this.flagFctl) {
                    this.outWriteFctl();
                    this.flagFctl = false;
                }
                this.outWriteFdat(this.bufferChunk);
            }
        }
    }

    private int getInt(byte[] buf, int i) {
        return (0xFF & buf[i]) << 24 | (0xFF & buf[i + 1]) << 16 | (0xFF & buf[i + 2]) << 8 | 0xFF & buf[i + 3];
    }

    private void outWriteFdat(byte[] datacrc) throws IOException {
        int i = 0;
        byte[] buf = new byte[datacrc.length + 4];
        this.outWriteInt(buf.length - 4);
        i = this.addBufName(buf, i, "fdAT");
        i = this.addBufInt(buf, i, this.sequenceNumber++);
        System.arraycopy(datacrc, 0, buf, i, datacrc.length - 4);
        i += datacrc.length - 4;
        this.outWriteBytes(buf);
        this.outWriteCrc(buf);
    }

    private void outWriteFctl() throws IOException {
        int i = 0;
        byte[] buf = new byte[30];
        this.outWriteInt(buf.length - 4);
        i = this.addBufName(buf, i, "fcTL");
        i = this.addBufInt(buf, i, this.sequenceNumber++);
        i = this.addBufInt(buf, i, this.width);
        i = this.addBufInt(buf, i, this.height);
        i = this.addBufInt(buf, i, 0);
        i = this.addBufInt(buf, i, 0);
        i = this.addBufShort(buf, i, 1);
        i = this.addBufShort(buf, i, 10);
        buf[i++] = 0;
        buf[i++] = 0;
        this.outWriteBytes(buf);
        this.outWriteCrc(buf);
    }

    private void outWriteActl() throws IOException {
        int i = 0;
        byte[] buf = new byte[12];
        this.outWriteInt(buf.length - 4);
        i = this.addBufName(buf, i, "acTL");
        i = this.addBufInt(buf, i, this.nbFrames);
        i = this.addBufInt(buf, i, 0);
        this.outWriteBytes(buf);
        this.outWriteCrc(buf);
    }

    private void outWriteCrc(byte[] buf) throws IOException {
        CRC32 crc = new CRC32();
        crc.update(buf);
        long c = crc.getValue();
        this.out.write((int)(c >> 24 & 0xFFL));
        this.out.write((int)(c >> 16 & 0xFFL));
        this.out.write((int)(c >> 8 & 0xFFL));
        this.out.write((int)(c & 0xFFL));
    }

    private void outWriteChunk(int sz, byte[] name, byte[] datacrc) throws IOException {
        this.outWriteInt(sz);
        this.outWriteBytes(name);
        this.outWriteBytes(datacrc);
    }

    private int addBufName(byte[] buf, int i, String name) {
        int j = 0;
        buf[i++] = (byte)name.charAt(j++);
        buf[i++] = (byte)name.charAt(j++);
        buf[i++] = (byte)name.charAt(j++);
        buf[i++] = (byte)name.charAt(j++);
        return i;
    }

    private int addBufInt(byte[] buf, int i, int a) {
        buf[i++] = (byte)(0xFF & a >> 24);
        buf[i++] = (byte)(0xFF & a >> 16);
        buf[i++] = (byte)(0xFF & a >> 8);
        buf[i++] = (byte)(0xFF & a);
        return i;
    }

    private int addBufShort(byte[] buf, int i, int a) {
        buf[i++] = (byte)(0xFF & a >> 8);
        buf[i++] = (byte)(0xFF & a);
        return i;
    }

    private void outWriteInt(int a) throws IOException {
        this.out.write(0xFF & a >> 24);
        this.out.write(0xFF & a >> 16);
        this.out.write(0xFF & a >> 8);
        this.out.write(0xFF & a);
    }

    private void outWriteBytes(byte[] b) throws IOException {
        this.out.write(b);
    }

    public static void analysePNG(InputStream in) throws Exception {
        OutputStreamAPNG outputStreamAPNG = new OutputStreamAPNG();
        Objects.requireNonNull(outputStreamAPNG);
        DebugPNG debugPng = outputStreamAPNG.new DebugPNG(in);
        debugPng.analysePNG();
    }

    public static void main(String[] argv) {
        try {
            int b;
            FileOutputStream out = new FileOutputStream("/Data/Apng/out.png");
            OutputStreamAPNG apng = new OutputStreamAPNG(out, 3);
            System.out.println("Frame 1...");
            FileInputStream in = new FileInputStream("/Data/Apng/frame1.png");
            while ((b = in.read()) != -1) {
                apng.write(b);
            }
            in.close();
            System.out.println("Frame 2...");
            in = new FileInputStream("/Data/Apng/frame2.png");
            while ((b = in.read()) != -1) {
                apng.write(b);
            }
            in.close();
            System.out.println("Frame 3...");
            in = new FileInputStream("/Data/Apng/frame3.png");
            while ((b = in.read()) != -1) {
                apng.write(b);
            }
            in.close();
            apng.close();
            System.out.println("\nVERIF");
            in = new FileInputStream("/Data/Apng/out.png");
            OutputStreamAPNG.analysePNG(in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class DebugPNG {
        int offTampon = 0;
        byte[] tampon;
        int frame = 0;

        DebugPNG(InputStream in) throws Exception {
            MyInputStream bin = new MyInputStream(in);
            this.tampon = bin.readFully();
            bin.close();
        }

        private int getValAt(int pos) throws Exception {
            return this.tampon[pos] & 0xFF;
        }

        private boolean analysePNG() {
            block8: {
                boolean encore = true;
                int i = 8;
                try {
                    while (encore) {
                        int size = this.getValAt(i) << 24 | this.getValAt(i + 1) << 16 | this.getValAt(i + 2) << 8 | this.getValAt(i + 3);
                        String chunk = new String(new char[]{(char)this.getValAt(i + 4), (char)this.getValAt(i + 5), (char)this.getValAt(i + 6), (char)this.getValAt(i + 7)});
                        if (chunk.equals("fcTL")) {
                            ++this.frame;
                        }
                        int j = i + 8 + size;
                        long crcIn = 0xFFFFFFFFL & (long)(this.getValAt(j) << 24 | this.getValAt(j + 1) << 16 | this.getValAt(j + 2) << 8 | this.getValAt(j + 3));
                        CRC32 crc = new CRC32();
                        crc.update(this.tampon, i + 4, size + 4);
                        long c = crc.getValue();
                        String crcs = crcIn == c ? " - crc Ok" : "- bad crc";
                        int sequenceNumber = -1;
                        if (chunk.equals("fcTL")) {
                            sequenceNumber = this.analyseFctl(i + 8);
                        } else if (chunk.equals("fdAT")) {
                            sequenceNumber = this.analyseFdat(i + 8);
                        }
                        String seqs = sequenceNumber >= 0 ? " seqNumber=" + sequenceNumber : "";
                        System.out.println("(" + i + ") Segment [" + chunk + "] frame=" + this.frame + seqs + " dataSize=" + size + crcs);
                        if (chunk.equals("IEND")) {
                            encore = false;
                        }
                        i += size + 12;
                    }
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) break block8;
                    e.printStackTrace();
                }
            }
            return false;
        }

        private void analyseActl(int i) throws Exception {
            int numFrames = this.getValAt(i) << 24 | this.getValAt(i + 1) << 16 | this.getValAt(i + 2) << 8 | this.getValAt(i + 3);
            int numPlays = this.getValAt(i += 4) << 24 | this.getValAt(i + 1) << 16 | this.getValAt(i + 2) << 8 | this.getValAt(i + 3);
            i += 4;
        }

        private int analyseFctl(int i) throws Exception {
            int sequenceNumber = this.getValAt(i) << 24 | this.getValAt(i + 1) << 16 | this.getValAt(i + 2) << 8 | this.getValAt(i + 3);
            int width = this.getValAt(i += 4) << 24 | this.getValAt(i + 1) << 16 | this.getValAt(i + 2) << 8 | this.getValAt(i + 3);
            int height = this.getValAt(i += 4) << 24 | this.getValAt(i + 1) << 16 | this.getValAt(i + 2) << 8 | this.getValAt(i + 3);
            int xOffset = this.getValAt(i += 4) << 24 | this.getValAt(i + 1) << 16 | this.getValAt(i + 2) << 8 | this.getValAt(i + 3);
            int yOffset = this.getValAt(i += 4) << 24 | this.getValAt(i + 1) << 16 | this.getValAt(i + 2) << 8 | this.getValAt(i + 3);
            int delayNum = this.getValAt(i += 4) << 8 | this.getValAt(i + 1);
            int delayDen = this.getValAt(i += 2) << 8 | this.getValAt(i + 1);
            int disposeOp = this.getValAt(i += 2);
            int blendOp = this.getValAt(++i);
            ++i;
            return sequenceNumber;
        }

        private int analyseFdat(int i) throws Exception {
            int sequenceNumber = this.getValAt(i) << 24 | this.getValAt(i + 1) << 16 | this.getValAt(i + 2) << 8 | this.getValAt(i + 3);
            i += 4;
            return sequenceNumber;
        }
    }
}

