/*
 * Decompiled with CFR 0.152.
 */
package cds.image;

import cds.image.OutputStreamAPNG;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.CRC32;

public class InputStreamAPNG
extends InputStream {
    private static final int MAGICCODE = 0;
    private static final int SIZECHUNK = 1;
    private static final int NAMECHUNK = 2;
    private static final int DATAANDCRC = 3;
    private static final int ENDCHUNK = 4;
    private static final int END = 5;
    private static final int MAGIC = 0;
    private static final int FIRSTFRAME = 1;
    private static final int STARTFRAME = 2;
    private static final int NEXTFRAME = 3;
    private static final int ENDFRAME = 4;
    private InputStream in;
    private int nbFrames = -1;
    private int modeRead = 0;
    private int modeWrite = 0;
    private int sequenceNumber = 0;
    private ArrayList<Buffer> bufs;
    private Buffer buffer;
    private int sizeMagicCode = 0;
    private byte[] magicCode = new byte[8];
    private int sizeChunkN = 0;
    private int sizeChunk = 0;
    private int nameChunkN = 0;
    private byte[] nameChunk = new byte[4];
    int bufferPos = 0;
    byte[] bufferChunk = null;

    public InputStreamAPNG(InputStream in) {
        this.in = in;
        this.bufs = new ArrayList();
        this.buffer = null;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public boolean hasNextInputStream() {
        return this.modeRead != 5;
    }

    public InputStream nextInputStream() {
        return this;
    }

    public int getNbFrames() throws Exception {
        if (this.nbFrames < 0) {
            throw new Exception("Nb Frames still unknown. Read the firt frame before");
        }
        return this.nbFrames;
    }

    @Override
    public int read() throws IOException {
        if (this.buffer != null && this.buffer.hasNext()) {
            return this.buffer.next();
        }
        if (this.modeWrite == 4) {
            this.modeWrite = 2;
            return -1;
        }
        if (this.modeRead == 5) {
            return -1;
        }
        int b = -1;
        while (this.modeRead != 4) {
            b = this.in.read();
            switch (this.modeRead) {
                case 0: {
                    this.modeRead = this.magicCode(b, this.modeRead);
                    break;
                }
                case 1: {
                    this.modeRead = this.sizeChunk(b, this.modeRead);
                    break;
                }
                case 2: {
                    this.modeRead = this.nameChunk(b, this.modeRead);
                    break;
                }
                case 3: {
                    this.modeRead = this.bufferChunk(b, this.modeRead);
                }
            }
        }
        this.modeRead = 1;
        String name = new String(this.nameChunk);
        switch (this.modeWrite) {
            case 0: {
                this.buffer = new Buffer(this.magicCode);
                this.modeWrite = 1;
                break;
            }
            case 1: {
                if (name.equals("acTL")) {
                    this.nbFrames = this.getInt(this.bufferChunk, 0);
                    break;
                }
                if (name.equals("fcTL")) {
                    this.sequenceNumber = this.getInt(this.bufferChunk, 0);
                    if (this.sequenceNumber <= 0) break;
                    this.buffer = this.createEnd();
                    this.modeWrite = 4;
                    break;
                }
                this.buffer = new Buffer(this.sizeChunk, this.nameChunk, this.bufferChunk);
                if (name.equals("IDAT") || name.equals("fdAT")) break;
                this.bufs.add(this.buffer);
                break;
            }
            case 2: {
                if (!name.equals("fdAT")) break;
                if (this.getInt(this.bufferChunk, 0) < this.sequenceNumber) {
                    throw new IOException("Chunck sequenceNumber unsorted");
                }
                this.buffer = this.createNextFrame(this.bufferChunk);
                this.modeWrite = 3;
                break;
            }
            case 3: {
                if (name.equals("fcTL")) {
                    this.buffer = this.createEnd();
                    this.modeWrite = 4;
                    break;
                }
                if (name.equals("fdAT")) {
                    if (this.getInt(this.bufferChunk, 0) < this.sequenceNumber) {
                        throw new IOException("Chunck sequenceNumber unsorted");
                    }
                    this.buffer = this.createAddIdatFrame(this.bufferChunk);
                    break;
                }
                if (!name.equals("IEND")) break;
                this.buffer = new Buffer(this.sizeChunk, this.nameChunk, this.bufferChunk);
                this.modeRead = 5;
            }
        }
        if (this.buffer != null && this.buffer.hasNext()) {
            return this.buffer.next();
        }
        return this.read();
    }

    private Buffer createEnd() {
        byte[] buf = new byte[12];
        int pos = this.addBufInt(buf, 0, 0);
        pos = this.addBufName(buf, pos, "IEND");
        pos = this.addBufCrc(buf, pos, buf, pos - 4, 4);
        return new Buffer(buf);
    }

    private Buffer createNextFrame(byte[] fdatcrc) {
        int size = this.magicCode.length;
        for (Buffer b : this.bufs) {
            size += b.buf.length;
        }
        byte[] buf = new byte[size += 4 + fdatcrc.length];
        int pos = 0;
        System.arraycopy(this.magicCode, 0, buf, pos, this.magicCode.length);
        pos += this.magicCode.length;
        for (Buffer b : this.bufs) {
            System.arraycopy(b.buf, 0, buf, pos, b.buf.length);
            pos += b.buf.length;
        }
        int sizeData = fdatcrc.length - 8;
        pos = this.addBufInt(buf, pos, sizeData);
        pos = this.addBufName(buf, pos, "IDAT");
        System.arraycopy(fdatcrc, 4, buf, pos, sizeData);
        pos += sizeData;
        pos = this.addBufCrc(buf, pos, buf, pos - sizeData - 4, sizeData + 4);
        return new Buffer(buf);
    }

    private Buffer createAddIdatFrame(byte[] fdatcrc) {
        int sizeData = fdatcrc.length - 8;
        int size = 8 + sizeData + 4;
        byte[] buf = new byte[size];
        int pos = this.addBufInt(buf, 0, sizeData);
        pos = this.addBufName(buf, pos, "IDAT");
        System.arraycopy(fdatcrc, 4, buf, pos, sizeData);
        pos += sizeData;
        pos = this.addBufCrc(buf, pos, buf, pos - sizeData - 4, sizeData + 4);
        return new Buffer(buf);
    }

    private int magicCode(int b, int mode) {
        this.magicCode[this.sizeMagicCode++] = (byte)(0xFF & b);
        if (this.sizeMagicCode == 8) {
            this.sizeMagicCode = 0;
            return 4;
        }
        return mode;
    }

    private int sizeChunk(int b, int mode) {
        if (this.sizeChunkN == 4) {
            this.sizeChunkN = 0;
            this.sizeChunk = 0;
        }
        this.sizeChunk = this.sizeChunk << 8 | 0xFF & b;
        ++this.sizeChunkN;
        if (this.sizeChunkN == 4) {
            return mode + 1;
        }
        return mode;
    }

    private int nameChunk(int b, int mode) {
        this.nameChunk[this.nameChunkN++] = (byte)b;
        if (this.nameChunkN == 4) {
            this.bufferPos = 0;
            this.nameChunkN = 0;
            this.bufferChunk = new byte[this.sizeChunk + 4];
            return mode + 1;
        }
        return mode;
    }

    private int bufferChunk(int b, int mode) {
        this.bufferChunk[this.bufferPos++] = (byte)(0xFF & b);
        if (this.bufferPos == this.bufferChunk.length) {
            return mode + 1;
        }
        return mode;
    }

    private int getInt(byte[] buf, int i) {
        return (0xFF & buf[i]) << 24 | (0xFF & buf[i + 1]) << 16 | (0xFF & buf[i + 2]) << 8 | 0xFF & buf[i + 3];
    }

    private int addBufName(byte[] buf, int i, String name) {
        int j = 0;
        buf[i++] = (byte)name.charAt(j++);
        buf[i++] = (byte)name.charAt(j++);
        buf[i++] = (byte)name.charAt(j++);
        buf[i++] = (byte)name.charAt(j++);
        return i;
    }

    private int addBufCrc(byte[] buf, int i, byte[] data, int offset, int len) {
        CRC32 crc = new CRC32();
        crc.update(data, offset, len);
        long c = crc.getValue();
        buf[i++] = (byte)(0xFFL & c >> 24);
        buf[i++] = (byte)(0xFFL & c >> 16);
        buf[i++] = (byte)(0xFFL & c >> 8);
        buf[i++] = (byte)(0xFFL & c);
        return i;
    }

    private int addBufInt(byte[] buf, int i, int a) {
        buf[i++] = (byte)(0xFF & a >> 24);
        buf[i++] = (byte)(0xFF & a >> 16);
        buf[i++] = (byte)(0xFF & a >> 8);
        buf[i++] = (byte)(0xFF & a);
        return i;
    }

    public static void main(String[] argv) {
        try {
            String file = "/Data/Apng/outbis.png";
            System.out.println("\n\nVERIF INIT");
            OutputStreamAPNG.analysePNG(new FileInputStream(file));
            System.out.println("----");
            FileInputStream in = new FileInputStream(file);
            InputStreamAPNG apng = new InputStreamAPNG(in);
            int n = 1;
            while (apng.hasNextInputStream()) {
                int b;
                String s = "/Data/Apng/frame-outbis" + n + ".png";
                System.out.println("Ecriture de la frame " + s);
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(s));
                InputStream in1 = apng.nextInputStream();
                while ((b = in1.read()) != -1) {
                    out.write(b);
                }
                if (n == 1) {
                    System.out.println("J'aurai " + apng.getNbFrames() + " au total");
                }
                ++n;
                out.close();
            }
            apng.close();
            System.out.println("\n\nVERIF2");
            OutputStreamAPNG.analysePNG(new FileInputStream("/Data/Apng/frame-outbis2.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class Buffer {
        byte[] buf;
        int pos;

        Buffer(byte[] buf) {
            this.buf = buf;
            this.pos = 0;
        }

        Buffer(int sz, byte[] name, byte[] datacrc) {
            int size = 4 + name.length + datacrc.length;
            this.buf = new byte[size];
            this.pos = InputStreamAPNG.this.addBufInt(this.buf, 0, sz);
            System.arraycopy(name, 0, this.buf, this.pos, name.length);
            this.pos += name.length;
            System.arraycopy(datacrc, 0, this.buf, this.pos, datacrc.length);
            this.pos = 0;
        }

        boolean hasNext() {
            return this.pos < this.buf.length;
        }

        int next() {
            return 0xFF & this.buf[this.pos++];
        }

        public String toString() {
            return this.pos + "/" + this.buf.length;
        }
    }
}

