/*
 * Decompiled with CFR 0.152.
 */
package cds.image;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class Hdecomp {
    private static int SIZEBUF = 8192;
    private static byte[] buf = new byte[SIZEBUF];
    private static int ptBuf = 0;
    private static int maxBuf = 0;
    private static InputStream dis;
    private static double log2;
    private static int[] code_magic;
    private static int nx;
    private static int ny;
    private static int nel;
    private static int scale;
    private static int[] a;
    private static int buffer;
    private static int bits_to_go;
    private static int[] nbitplanes;

    public static byte[] decomp(InputStream fdis) throws Exception {
        dis = fdis;
        Hdecomp.decode();
        Hdecomp.undigitize();
        Hdecomp.hinv();
        return Hdecomp.getPixels();
    }

    private static byte[] getPixels() {
        byte[] pixels = new byte[nel * 2];
        int j = 0;
        for (int i = 0; i < pixels.length; i += 2) {
            pixels[i] = (byte)(a[j] >> 8 & 0xFF);
            pixels[i + 1] = (byte)(a[j++] & 0xFF);
        }
        return pixels;
    }

    private static int getc() throws Exception {
        while (ptBuf == maxBuf) {
            ptBuf = 0;
            maxBuf = dis.read(buf, 0, buf.length);
            if (maxBuf != -1) continue;
            throw new EOFException();
        }
        return buf[ptBuf++] & 0xFF;
    }

    private static int getint() throws Exception {
        return Hdecomp.getc() << 24 | Hdecomp.getc() << 16 | Hdecomp.getc() << 8 | Hdecomp.getc();
    }

    private static void start_inputing_bits() {
        bits_to_go = 0;
    }

    private static int input_bit() throws Exception {
        if (bits_to_go == 0) {
            buffer = Hdecomp.getc();
            bits_to_go = 8;
        }
        return buffer >> --bits_to_go & 1;
    }

    private static int input_nbits(int n) throws Exception {
        if (bits_to_go < n) {
            buffer <<= 8;
            buffer |= Hdecomp.getc();
            bits_to_go += 8;
        }
        return buffer >> (bits_to_go -= n) & (1 << n) - 1;
    }

    private static int input_huffman() throws Exception {
        int c = Hdecomp.input_nbits(3);
        if (c < 4) {
            return 1 << c;
        }
        c = Hdecomp.input_bit() | c << 1;
        if (c < 13) {
            switch (c) {
                case 8: {
                    return 3;
                }
                case 9: {
                    return 5;
                }
                case 10: {
                    return 10;
                }
                case 11: {
                    return 12;
                }
                case 12: {
                    return 15;
                }
            }
        }
        if ((c = Hdecomp.input_bit() | c << 1) < 31) {
            switch (c) {
                case 26: {
                    return 6;
                }
                case 27: {
                    return 7;
                }
                case 28: {
                    return 9;
                }
                case 29: {
                    return 11;
                }
                case 30: {
                    return 13;
                }
            }
        }
        if ((c = Hdecomp.input_bit() | c << 1) == 62) {
            return 0;
        }
        return 14;
    }

    private static void qtree_bitins(byte[] d, int nx, int ny, int off, int n, int bit) {
        byte dc;
        int j;
        int s00;
        int i;
        int nxN = nx - 1;
        int nyN = ny - 1;
        int c = 0;
        for (i = 0; i < nxN; i += 2) {
            s00 = off + n * i;
            int s10 = s00 + n;
            for (j = 0; j < nyN; j += 2) {
                dc = d[c];
                int n2 = s10 + 1;
                a[n2] = a[n2] | (dc & 1) << bit;
                int n3 = s10;
                a[n3] = a[n3] | (dc >> 1 & 1) << bit;
                int n4 = s00 + 1;
                a[n4] = a[n4] | (dc >> 2 & 1) << bit;
                int n5 = s00;
                a[n5] = a[n5] | (dc >> 3 & 1) << bit;
                s00 += 2;
                s10 += 2;
                ++c;
            }
            if (j >= ny) continue;
            dc = d[c];
            int n6 = s10;
            a[n6] = a[n6] | (dc >> 1 & 1) << bit;
            int n7 = s00;
            a[n7] = a[n7] | (dc >> 3 & 1) << bit;
            ++c;
        }
        if (i < nx) {
            s00 = off + n * i;
            for (j = 0; j < nyN; j += 2) {
                dc = d[c];
                int n8 = s00 + 1;
                a[n8] = a[n8] | (dc >> 2 & 1) << bit;
                int n9 = s00;
                a[n9] = a[n9] | (dc >> 3 & 1) << bit;
                s00 += 2;
                ++c;
            }
            if (j < ny) {
                int n10 = s00;
                a[n10] = a[n10] | (d[c] >> 3 & 1) << bit;
                ++c;
            }
        }
    }

    private static void read_bdirect(int off, int n, int nqx, int nqy, byte[] scratch, int bit) throws Exception {
        int j = (nqx + 1) / 2 * ((nqy + 1) / 2);
        for (int i = 0; i < j; ++i) {
            scratch[i] = (byte)Hdecomp.input_nbits(4);
        }
        Hdecomp.qtree_bitins(scratch, nqx, nqy, off, n, bit);
    }

    private static void qtree_copy(byte[] d, int nx, int ny, byte[] b, int n) {
        byte bs00;
        int j;
        int s00;
        int i;
        int nxN = nx - 1;
        int nyN = ny - 1;
        int nx2 = (nx + 1) / 2;
        int ny2 = (ny + 1) / 2;
        int k = ny2 * (nx2 - 1) + ny2 - 1;
        for (i = nx2 - 1; i >= 0; --i) {
            s00 = n * i + ny2 - 1 << 1;
            for (j = ny2 - 1; j >= 0; --j) {
                b[s00] = d[k--];
                s00 -= 2;
            }
        }
        for (i = 0; i < nxN; i += 2) {
            s00 = n * i;
            int s10 = s00 + n;
            for (j = 0; j < nyN; j += 2) {
                bs00 = b[s00];
                b[s10 + 1] = (byte)(bs00 & 1);
                b[s10] = (byte)(bs00 >> 1 & 1);
                b[s00 + 1] = (byte)(bs00 >> 2 & 1);
                b[s00] = (byte)(bs00 >> 3 & 1);
                s00 += 2;
                s10 += 2;
            }
            if (j >= ny) continue;
            bs00 = b[s00];
            b[s10] = (byte)(bs00 >> 1 & 1);
            b[s00] = (byte)(bs00 >> 3 & 1);
        }
        if (i < nx) {
            s00 = n * i;
            for (j = 0; j < nyN; j += 2) {
                bs00 = b[s00];
                b[s00 + 1] = (byte)(bs00 >> 2 & 1);
                b[s00] = (byte)(bs00 >> 3 & 1);
                s00 += 2;
            }
            if (j < ny) {
                b[s00] = (byte)(b[s00] >> 3 & 1);
            }
        }
    }

    private static void qtree_expand(byte[] d, int nx, int ny, byte[] b) throws Exception {
        Hdecomp.qtree_copy(d, nx, ny, b, ny);
        for (int i = nx * ny - 1; i >= 0; --i) {
            if (b[i] == 0) continue;
            b[i] = (byte)Hdecomp.input_huffman();
        }
    }

    private static void qtree_decode(int off, int n, int nqx, int nqy, int nbitplanes) throws Exception {
        int log2n;
        int nqmax = nqx > nqy ? nqx : nqy;
        if (nqmax > 1 << (log2n = (int)(Math.log(nqmax) / log2 + 0.5))) {
            ++log2n;
        }
        int nqx2 = (nqx + 1) / 2;
        int nqy2 = (nqy + 1) / 2;
        byte[] scratch = new byte[nqx2 * nqy2];
        for (int bit = nbitplanes - 1; bit >= 0; --bit) {
            int b = Hdecomp.input_nbits(4);
            if (b == 0) {
                Hdecomp.read_bdirect(off, n, nqx, nqy, scratch, bit);
                continue;
            }
            if (b != 15) {
                throw new Exception("qtree_decode: bad format code " + b);
            }
            scratch[0] = (byte)Hdecomp.input_huffman();
            int nx = 1;
            int ny = 1;
            int nfx = nqx;
            int nfy = nqy;
            int c = 1 << log2n;
            for (int k = 1; k < log2n; ++k) {
                nx <<= 1;
                ny <<= 1;
                if (nfx <= (c >>= 1)) {
                    --nx;
                } else {
                    nfx -= c;
                }
                if (nfy <= c) {
                    --ny;
                } else {
                    nfy -= c;
                }
                Hdecomp.qtree_expand(scratch, nx, ny, scratch);
            }
            Hdecomp.qtree_bitins(scratch, nqx, nqy, off, n, bit);
        }
        scratch = null;
    }

    private static void dodecode() throws Exception {
        int nx2 = (nx + 1) / 2;
        int ny2 = (ny + 1) / 2;
        Hdecomp.start_inputing_bits();
        Hdecomp.qtree_decode(0, ny, nx2, ny2, nbitplanes[0]);
        Hdecomp.qtree_decode(ny2, ny, nx2, ny / 2, nbitplanes[1]);
        Hdecomp.qtree_decode(ny * nx2, ny, nx / 2, ny2, nbitplanes[1]);
        Hdecomp.qtree_decode(ny * nx2 + ny2, ny, nx / 2, ny / 2, nbitplanes[2]);
        if (Hdecomp.input_nbits(4) != 0) {
            throw new IOException("dodecode: bad bit plane values\n");
        }
        Hdecomp.start_inputing_bits();
        for (int i = 0; i < nel; ++i) {
            int aa = a[i];
            if (aa == 0 || Hdecomp.input_bit() == 0) continue;
            Hdecomp.a[i] = -aa;
        }
    }

    private static void decode() throws Exception {
        int q = 0;
        int w = 0;
        maxBuf = 0;
        ptBuf = 0;
        q = Hdecomp.getc();
        if (q != code_magic[0] || (w = Hdecomp.getc()) != code_magic[1]) {
            throw new Exception("Bad magic number");
        }
        nx = Hdecomp.getint();
        ny = Hdecomp.getint();
        nel = nx * ny;
        scale = Hdecomp.getint();
        a = new int[nel];
        int sumall = Hdecomp.getint();
        Hdecomp.nbitplanes[0] = Hdecomp.getc();
        Hdecomp.nbitplanes[1] = Hdecomp.getc();
        Hdecomp.nbitplanes[2] = Hdecomp.getc();
        Hdecomp.dodecode();
        Hdecomp.a[0] = sumall;
    }

    private static void undigitize() {
        if (scale <= 1) {
            return;
        }
        int i = nel - 1;
        while (i >= 0) {
            int n = i--;
            a[n] = a[n] * scale;
        }
    }

    private static void unshuffle(int off, int n, int n2, int[] tmp) {
        int i;
        int n22 = n2 << 1;
        int nhalf = n + 1 >> 1;
        int pt = 0;
        int p1 = off + n2 * nhalf;
        for (i = nhalf; i < n; ++i) {
            tmp[pt++] = a[p1];
            p1 += n2;
        }
        int p2 = off + n2 * (nhalf - 1);
        p1 = off + (n2 * (nhalf - 1) << 1);
        for (i = nhalf - 1; i >= 0; --i) {
            Hdecomp.a[p1] = a[p2];
            p2 -= n2;
            p1 -= n22;
        }
        pt = 0;
        p1 = off + n2;
        for (i = 1; i < n; i += 2) {
            Hdecomp.a[p1] = tmp[pt++];
            p1 += n22;
        }
    }

    private static void hinv() {
        int log2n;
        int hc = 0;
        int hy = 0;
        int hx = 0;
        int h0 = 0;
        int lowbit0 = 0;
        int nmax = nx > ny ? nx : ny;
        if (nmax > 1 << (log2n = (int)(Math.log(nmax) / log2 + 0.5))) {
            ++log2n;
        }
        int[] tmp = new int[(nmax + 1) / 2];
        int shift = 1;
        int bit0 = 1 << log2n - 1;
        int bit1 = bit0 << 1;
        int bit2 = bit0 << 2;
        int mask0 = -bit0;
        int mask1 = mask0 << 1;
        int mask2 = mask0 << 2;
        int prnd0 = bit0 >> 1;
        int prnd1 = bit1 >> 1;
        int prnd2 = bit2 >> 1;
        int nrnd0 = prnd0 - 1;
        int nrnd1 = prnd1 - 1;
        int nrnd2 = prnd2 - 1;
        Hdecomp.a[0] = a[0] + (a[0] >= 0 ? prnd2 : nrnd2) & mask2;
        int nxtop = 1;
        int nytop = 1;
        int nxf = nx;
        int nyf = ny;
        int c = 1 << log2n;
        for (int k = log2n - 1; k >= 0; --k) {
            int lowbit1;
            int s00;
            int j;
            int i;
            nxtop <<= 1;
            nytop <<= 1;
            if (nxf <= (c >>= 1)) {
                --nxtop;
            } else {
                nxf -= c;
            }
            if (nyf <= c) {
                --nytop;
            } else {
                nyf -= c;
            }
            if (k == 0) {
                nrnd0 = 0;
                shift = 2;
            }
            for (i = 0; i < nxtop; ++i) {
                Hdecomp.unshuffle(ny * i, nytop, 1, tmp);
            }
            for (j = 0; j < nytop; ++j) {
                Hdecomp.unshuffle(j, nxtop, ny, tmp);
            }
            int oddx = nxtop % 2;
            int oddy = nytop % 2;
            for (i = 0; i < nxtop - oddx; i += 2) {
                s00 = ny * i;
                int s10 = s00 + ny;
                for (j = 0; j < nytop - oddy; j += 2) {
                    h0 = a[s00];
                    hx = a[s10];
                    hy = a[s00 + 1];
                    hc = a[s10 + 1];
                    hx = hx + (hx >= 0 ? prnd1 : nrnd1) & mask1;
                    hy = hy + (hy >= 0 ? prnd1 : nrnd1) & mask1;
                    hc = hc + (hc >= 0 ? prnd0 : nrnd0) & mask0;
                    lowbit0 = hc & bit0;
                    hx = hx >= 0 ? hx - lowbit0 : hx + lowbit0;
                    hy = hy >= 0 ? hy - lowbit0 : hy + lowbit0;
                    lowbit1 = (hc ^ hx ^ hy) & bit1;
                    h0 = h0 >= 0 ? h0 + lowbit0 - lowbit1 : h0 + (lowbit0 == 0 ? lowbit1 : lowbit0 - lowbit1);
                    Hdecomp.a[s10 + 1] = h0 + hx + hy + hc >> shift;
                    Hdecomp.a[s10] = h0 + hx - hy - hc >> shift;
                    Hdecomp.a[s00 + 1] = h0 - hx + hy - hc >> shift;
                    Hdecomp.a[s00] = h0 - hx - hy + hc >> shift;
                    s00 += 2;
                    s10 += 2;
                }
                if (oddy == 0) continue;
                h0 = a[s00];
                hx = a[s10];
                hx = (hx >= 0 ? hx + prnd1 : hx + nrnd1) & mask1;
                lowbit1 = hx & bit1;
                h0 = h0 >= 0 ? h0 - lowbit1 : h0 + lowbit1;
                Hdecomp.a[s10] = h0 + hx >> shift;
                Hdecomp.a[s00] = h0 - hx >> shift;
            }
            if (oddx != 0) {
                s00 = ny * i;
                for (j = 0; j < nytop - oddy; j += 2) {
                    h0 = a[s00];
                    hy = a[s00 + 1];
                    hy = (hy >= 0 ? hy + prnd1 : hy + nrnd1) & mask1;
                    lowbit1 = hy & bit1;
                    h0 = h0 >= 0 ? h0 - lowbit1 : h0 + lowbit1;
                    Hdecomp.a[s00 + 1] = h0 + hy >> shift;
                    Hdecomp.a[s00] = h0 - hy >> shift;
                    s00 += 2;
                }
                if (oddy != 0) {
                    h0 = a[s00];
                    Hdecomp.a[s00] = h0 >> shift;
                }
            }
            bit2 = bit1;
            bit1 = bit0;
            bit0 >>= 1;
            mask1 = mask0;
            mask0 >>= 1;
            prnd1 = prnd0;
            nrnd1 = nrnd0;
            nrnd0 = (prnd0 >>= 1) - 1;
        }
        tmp = null;
    }

    static {
        log2 = Math.log(2.0);
        code_magic = new int[]{221, 153};
        nbitplanes = new int[3];
    }
}

