/*
 * Decompiled with CFR 0.152.
 */
package cds.hipsgen;

import cds.aladin.Coord;
import cds.fits.Fits;
import cds.healpix.Healpix;
import cds.healpix.HealpixNestedFast;
import cds.hipsgen.BuilderRunner;
import cds.hipsgen.Context;
import cds.hipsgen.ModeOverlay;
import cds.hipsgen.ThreadBuilderTile;

public class ThreadBuilderTileCube
extends ThreadBuilderTile {
    public ThreadBuilderTileCube(Context context, BuilderRunner builder) {
        super(context, builder);
    }

    @Override
    Fits buildHealpix1(BuilderRunner bt, BuilderRunner.AddrThread cell, ThreadBuilderTile.SrcFile[] downFiles, int deb, int fin, double[] tileWeight, double maxExpTime) throws Exception {
        double dataMax;
        double dataMin;
        double bZero;
        double bScale;
        Fits out;
        boolean empty;
        long t0;
        block35: {
            int d;
            t0 = System.currentTimeMillis();
            empty = true;
            double[] radec = new double[2];
            Coord coo = new Coord();
            ThreadBuilderTile.SrcFile file = null;
            out = null;
            int bitpix = this.bitpix;
            double blank = this.blank;
            bScale = this.bScale;
            bZero = this.bZero;
            dataMin = Double.NaN;
            dataMax = Double.NaN;
            int tileSide = this.context.getTileSide();
            int tileDepth = this.context.getTileDepth();
            if (cell.z + tileDepth > (d = this.context.getDepth())) {
                tileDepth = d - cell.z;
            }
            try {
                long min = cell.npix * (long)tileSide * (long)tileSide;
                boolean flagModifBitpix = this.modifBitPix();
                if (flagModifBitpix && tileWeight != null) {
                    bitpix = this.context.getBitpixOrig();
                    blank = bitpix < 0 ? Double.NaN : this.blankOrig;
                    flagModifBitpix = false;
                }
                out = new Fits(tileSide, tileSide, tileDepth, bitpix);
                int xa = out.width;
                int ya = out.height;
                int za = out.depth;
                int xb = -1;
                int yb = -1;
                int zb = -1;
                out.setBlank(blank);
                out.setBzero(bZero);
                out.setBscale(bScale);
                int overlay = fin - deb;
                Object pixvalG = null;
                Object pixvalB = null;
                double[][] pixval = new double[overlay][tileDepth];
                double[] pixcoef = new double[overlay];
                int orderPix = cell.order + this.context.getTileOrder();
                boolean gal2ICRS = this.context.getFrame() != 0;
                HealpixNestedFast hn = Healpix.getNestedFast(orderPix);
                for (int y = 0; y < out.height; ++y) {
                    for (int x = 0; x < out.width; ++x) {
                        int nbPix = 0;
                        double totalCoef = 0.0;
                        int removed = 0;
                        long index = min + (long)this.context.xy2hpx[y * out.width + x];
                        this.computeCoo(coo, hn, index, radec, gal2ICRS);
                        for (int i = deb; i < fin; ++i) {
                            try {
                                file = downFiles[i];
                                if (file.flagRemoved) continue;
                                if (!this.open(file, 0)) {
                                    if (++removed < fin - deb) continue;
                                    return null;
                                }
                                try {
                                    file.fitsfile.getCalib().GetXY(coo, false);
                                }
                                catch (Exception e) {
                                    System.err.println("Problem on calib: " + file.name + " => exception " + e.getMessage() + " tile=" + cell);
                                    ThreadBuilderTileCube threadBuilderTileCube = this;
                                    if (threadBuilderTileCube.context.getVerbose() < 3) continue;
                                    e.printStackTrace();
                                    continue;
                                }
                                coo.y = (double)file.fitsfile.height - coo.y - 1.0;
                                coo.x -= 1.0;
                                if (!this.isIn(file, coo) || !this.getBilinearPixel(pixval[nbPix], file, coo, cell.z, file.blank)) continue;
                                pixcoef[nbPix] = this.getCoef(file, coo, this.modeCoadd, maxExpTime);
                                totalCoef += pixcoef[nbPix];
                                if (!this.reachMaxProgenitors(++nbPix)) continue;
                                break;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        for (int z = 0; z < tileDepth; ++z) {
                            double pixelFinal;
                            if (nbPix == 0) {
                                pixelFinal = blank;
                            } else {
                                pixelFinal = 0.0;
                                if (this.modeCoadd == ModeOverlay.overlayAdd) {
                                    empty = false;
                                    for (int i = 0; i < nbPix; ++i) {
                                        double d2;
                                        double a = pixval[i][z] * pixcoef[i];
                                        if (pixelFinal / 2.0 + d2 / 2.0 > this.maxDemi) {
                                            pixelFinal = this.max;
                                            break;
                                        }
                                        pixelFinal += a;
                                    }
                                } else if (totalCoef == 0.0) {
                                    empty = false;
                                    pixelFinal = pixval[0][z];
                                } else {
                                    empty = false;
                                    for (int i = 0; i < nbPix; ++i) {
                                        if (out.isBlankPixel(pixval[i][z])) continue;
                                        pixelFinal += pixval[i][z] * pixcoef[i] / totalCoef;
                                    }
                                }
                                pixelFinal = this.modifBitpix(pixelFinal, flagModifBitpix);
                            }
                            if (this.context.trim && !out.isBlankPixel(pixelFinal)) {
                                if (x < xa) {
                                    xa = x;
                                }
                                if (x > xb) {
                                    xb = x;
                                }
                                if (y < ya) {
                                    ya = y;
                                }
                                if (y > yb) {
                                    yb = y;
                                }
                                if (z < za) {
                                    za = z;
                                }
                                if (z > zb) {
                                    zb = z;
                                }
                            }
                            out.setPixelDouble(x, y, z, pixelFinal);
                            if (tileWeight != null) {
                                tileWeight[z * tileSide * tileSide + y * tileSide + x] = totalCoef;
                            }
                            if (Double.isNaN(dataMin) || pixelFinal < dataMin) {
                                dataMin = pixelFinal;
                            }
                            if (!Double.isNaN(dataMax) && !(pixelFinal > dataMax)) continue;
                            dataMax = pixelFinal;
                        }
                    }
                }
                if (!this.context.trim || empty) break block35;
                out.setBorder(new int[]{xa, xb, ya, yb, za, zb});
            }
            catch (Exception e) {
                e.printStackTrace();
                empty = true;
                if (tileWeight == null) break block35;
                for (int i = 0; i < tileWeight.length; ++i) {
                    tileWeight[i] = 0.0;
                }
            }
        }
        if (!empty && !Double.isNaN(dataMin)) {
            out.setDataMinMax(dataMin * bScale + bZero, dataMax * bScale + bZero);
        }
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        tleaf += System.currentTimeMillis() - t0;
        return !empty ? out : null;
    }

    private final boolean getBilinearPixel(double[] res, ThreadBuilderTile.SrcFile srcFile, Coord coo, int z1, double myBlank) {
        Fits f = srcFile.fitsfile;
        double x = coo.x;
        double y = coo.y;
        int x1 = (int)x;
        int y1 = (int)y;
        int x2 = x1 + 1;
        int y2 = y1 + 1;
        int ox1 = x1;
        int oy1 = y1;
        int ox2 = x2;
        int oy2 = y2;
        if (x2 < f.xCell || y2 < f.yCell || x1 >= f.xCell + f.widthCell || y1 >= f.yCell + f.heightCell) {
            return false;
        }
        if (ox1 == f.xCell - 1) {
            ++ox1;
        }
        if (oy1 == f.yCell - 1) {
            ++oy1;
        }
        if (ox2 == f.xCell + f.widthCell) {
            --ox2;
        }
        if (oy2 == f.yCell + f.heightCell) {
            --oy2;
        }
        int z = 0;
        while (z < res.length) {
            boolean b3;
            double a0 = f.getPixelDouble(ox1, oy1, z1);
            double a1 = f.getPixelDouble(ox2, oy1, z1);
            double a2 = f.getPixelDouble(ox1, oy2, z1);
            double a3 = f.getPixelDouble(ox2, oy2, z1);
            boolean b0 = Double.isNaN(a0) || a0 == myBlank;
            boolean b1 = Double.isNaN(a1) || a1 == myBlank;
            boolean b2 = Double.isNaN(a2) || a2 == myBlank;
            boolean bl = b3 = Double.isNaN(a3) || a3 == myBlank;
            if (b0 && b1 && b2 && b3) {
                return false;
            }
            if (b0 || b1 || b2 || b3) {
                double a;
                double d = !b0 ? a0 : (!b1 ? a1 : (a = !b2 ? a2 : a3));
                if (b0) {
                    a0 = a;
                }
                if (b1) {
                    a1 = a;
                }
                if (b2) {
                    a2 = a;
                }
                if (b3) {
                    a3 = a;
                }
            }
            res[z] = this.bilineaire(x1, y1, x2, y2, x, y, a0, a1, a2, a3);
            ++z;
            ++z1;
        }
        return true;
    }
}

